/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.filters;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;

public class FileLinksFilterUtil {
    @NonNls
    private static final String a = "exe";
    public static final int LENGTH_THRESHOLD = 255;
    private static final long b = c.a(9216484153376739754L, 7346382338635361645L, MethodHandles.lookup().lookupClass()).a(140516973708636L);

    private FileLinksFilterUtil() {
    }

    @Nullable
    public static File getFileByRubyLink(@NotNull String filePath) {
        if (filePath == null) {
            FileLinksFilterUtil.a(0);
        }
        return FileLinksFilterUtil.getFileByRubyLink(filePath, Collections.emptyList());
    }

    @Nullable
    public static File getFileByRubyLink(@NotNull String filePath, @NotNull List<String> workingDirs) {
        if (filePath == null) {
            FileLinksFilterUtil.a(1);
        }
        if (workingDirs == null) {
            FileLinksFilterUtil.a(2);
        }
        if (StringUtil.isEmpty((String)filePath)) {
            return null;
        }
        File file = FileLinksFilterUtil.a(filePath);
        if (file != null) {
            return file;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : workingDirs) {
            if (string == null) continue;
            stringBuilder.setLength(0);
            File file2 = FileLinksFilterUtil.a(string + (filePath.charAt(0) == '/' || filePath.charAt(0) == '\\' ? "" : Character.valueOf('/')) + filePath);
            if (file2 == null) continue;
            return file2;
        }
        return file;
    }

    private static File a(String string) {
        String string2 = FileUtil.toSystemDependentName((String)string);
        File file = new File(string2);
        try {
            if (!file.exists() || file.isDirectory()) {
                String string3 = "." + RubyFileType.RUBY.getDefaultExtension();
                if (!StringUtil.toLowerCase((String)string2).endsWith(string3)) {
                    File file2 = new File(string2 + string3);
                    if (!file.exists() || file.isDirectory() && file2.exists()) {
                        file = file2;
                    }
                }
            }
            if (file.exists() && !file.isDirectory()) {
                return file;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static boolean hasExeExtension(@NotNull File srcFile) {
        long l2 = b ^ 0x3756F3A95A03L;
        if (srcFile == null) {
            FileLinksFilterUtil.a(3);
        }
        return FileUtilRt.extensionEquals((String)srcFile.getName(), (String)a);
    }

    public static String cutLineIfLong(String line2) {
        if (line2.length() <= 255) {
            return line2;
        }
        return line2.substring(0, 256);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x630726FF5F5L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/filters/FileLinksFilterUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileByRubyLink";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasExeExtension";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

