/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.utils;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.actions.generate.RPropertyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Children;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class RubyPropertiesUtil {
    private static final long a = c.a(4364424069020308278L, -9143094854798604602L, MethodHandles.lookup().lookupClass()).a(29913208749430L);

    @Nullable
    public static RCall findFirstPropertyDeclaration(RClass rClass, RPropertyType type) {
        Symbol symbol = SymbolUtil.getSymbolByContainer(rClass);
        if (symbol == null) {
            return null;
        }
        switch (type) {
            case READER: {
                for (Symbol symbol2 : RubyPropertiesUtil.getReaders(rClass)) {
                    if (!RubyPropertiesUtil.isReader(symbol2)) continue;
                    return RubyPropertiesUtil.a(symbol2);
                }
                return null;
            }
            case WRITER: {
                for (Symbol symbol3 : RubyPropertiesUtil.getWriters(rClass)) {
                    if (!RubyPropertiesUtil.isWriter(symbol3)) continue;
                    return RubyPropertiesUtil.a(symbol3);
                }
                return null;
            }
            case ACCESSOR: {
                ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
                arrayList.addAll(RubyPropertiesUtil.getReaders(rClass));
                arrayList.addAll(RubyPropertiesUtil.getWriters(rClass));
                for (Symbol symbol4 : arrayList) {
                    if (!RubyPropertiesUtil.isAccessor(symbol4)) continue;
                    return RubyPropertiesUtil.a(symbol4);
                }
                break;
            }
        }
        return null;
    }

    public static boolean isReader(@NotNull Symbol symbol) {
        if (symbol == null) {
            RubyPropertiesUtil.a(0);
        }
        return RubyPropertiesUtil.a(symbol, RPropertyType.READER);
    }

    public static boolean isWriter(@NotNull Symbol symbol) {
        if (symbol == null) {
            RubyPropertiesUtil.a(1);
        }
        return RubyPropertiesUtil.a(symbol, RPropertyType.WRITER);
    }

    public static boolean isAccessor(@NotNull Symbol symbol) {
        if (symbol == null) {
            RubyPropertiesUtil.a(2);
        }
        return RubyPropertiesUtil.a(symbol, RPropertyType.ACCESSOR);
    }

    private static boolean a(@NotNull Symbol symbol, @NotNull RPropertyType rPropertyType) {
        RCall rCall;
        if (symbol == null) {
            RubyPropertiesUtil.a(3);
        }
        if (rPropertyType == null) {
            RubyPropertiesUtil.a(4);
        }
        return (rCall = RubyPropertiesUtil.a(symbol)) != null && rPropertyType.toString().equals(rCall.getCallType().getCommandName());
    }

    public static List<Symbol> getWriters(RClass rClass) {
        return RubyPropertiesUtil.getSymbolsByType(rClass, Type.FIELD_WRITER);
    }

    public static List<Symbol> getReaders(RClass rClass) {
        return RubyPropertiesUtil.getSymbolsByType(rClass, Type.FIELD_READER);
    }

    public static List<Symbol> getAccessors(RClass rClass) {
        Symbol symbol = SymbolUtil.getSymbolByContainer(rClass);
        if (symbol == null) {
            return Collections.emptyList();
        }
        Children children2 = symbol.getChildren();
        HashSet hashSet = new HashSet();
        hashSet.addAll(children2.getSymbolsOfType(Type.FIELD_READER, (PsiElement)rClass));
        hashSet.addAll(children2.getSymbolsOfType(Type.FIELD_WRITER, (PsiElement)rClass));
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        for (Symbol symbol2 : hashSet) {
            if (!RubyPropertiesUtil.isAccessor(symbol2)) continue;
            arrayList.add(symbol2);
        }
        return arrayList;
    }

    public static List<Symbol> getSymbolsByType(RClass rClass, Type type) {
        Symbol symbol = SymbolUtil.getSymbolByContainer(rClass);
        if (symbol == null) {
            return Collections.emptyList();
        }
        return symbol.getChildren().getSymbolsOfType(type, (PsiElement)rClass);
    }

    public static boolean removeProperty(String name, RClass rClass, RPropertyType type) {
        long l2 = a ^ 0x4797EEF634C4L;
        boolean bl2 = false;
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        arrayList.addAll(RubyPropertiesUtil.getReaders(rClass));
        arrayList.addAll(RubyPropertiesUtil.getWriters(rClass));
        ArrayList<RCall> arrayList2 = new ArrayList<RCall>();
        for (Symbol object : arrayList) {
            if (!name.equals(RubyPropertiesUtil.getPropertyName(object)) || !RubyPropertiesUtil.a(object, type)) continue;
            arrayList2.add(RubyPropertiesUtil.a(object));
        }
        if (!arrayList2.isEmpty()) {
            bl2 = true;
            for (RCall rCall : arrayList2) {
                RPsiElement rPsiElement2;
                ArrayList<String> arrayList3 = new ArrayList<String>();
                for (RPsiElement rPsiElement2 : rCall.getCallArguments().getElements()) {
                    if (rPsiElement2.getText().trim().equals(":" + name)) continue;
                    arrayList3.add(rPsiElement2.getText());
                }
                if (arrayList3.isEmpty()) {
                    rCall.delete();
                    continue;
                }
                String string = rCall.getCommand() + " " + StringUtil.join(arrayList3, (String)", ");
                rPsiElement2 = RubyElementFactory.createExpressionFromText((PsiElement)rClass, string);
                rCall.replace((PsiElement)rPsiElement2);
            }
        }
        return bl2;
    }

    @Nullable
    public static String getPropertyName(@NotNull Symbol symbol) {
        String string;
        if (symbol == null) {
            RubyPropertiesUtil.a(5);
        }
        return (string = symbol.getName()) == null || !string.endsWith("=") ? string : string.substring(0, string.length() - 1);
    }

    @Nullable
    private static RCall a(@NotNull Symbol symbol) {
        if (symbol == null) {
            RubyPropertiesUtil.a(6);
        }
        return (RCall)PsiTreeUtil.getParentOfType((PsiElement)symbol.getPsiElement(), RCall.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x5AF7337DCBA5L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/utils/RubyPropertiesUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isReader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isWriter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAccessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isPropertyOfType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAccessorDeclarationCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

