/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.BackspaceHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.formatter.YAMLCodeStyleSettings;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLSequenceItem;

public class YAMLEnterAtIndentHandler
extends EnterHandlerDelegateAdapter {
    private static final long a = c.a(-8290315196427361913L, 936929908643675926L, MethodHandles.lookup().lookupClass()).a(194730517025506L);

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        PsiElement psiElement;
        if (file == null) {
            YAMLEnterAtIndentHandler.a(0);
        }
        if (editor2 == null) {
            YAMLEnterAtIndentHandler.a(1);
        }
        if (caretOffset == null) {
            YAMLEnterAtIndentHandler.a(2);
        }
        if (caretAdvance == null) {
            YAMLEnterAtIndentHandler.a(3);
        }
        if (dataContext == null) {
            YAMLEnterAtIndentHandler.a(4);
        }
        if (!(file instanceof YAMLFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if ((Integer)caretOffset.get() > 0 && YAMLEnterAtIndentHandler.a(file) && PsiUtilCore.getElementType((PsiElement)(psiElement = file.findElementAt((Integer)caretOffset.get() - 1))) == TokenType.WHITE_SPACE && psiElement.getTextLength() == 1 && PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.prevLeaf((PsiElement)psiElement)) == YAMLTokenTypes.SEQUENCE_MARKER) {
            int n2 = Objects.requireNonNull(CodeStyle.getLanguageSettings((PsiFile)file, (Language)YAMLLanguage.INSTANCE).getIndentOptions()).INDENT_SIZE;
            editor2.getDocument().replaceString((Integer)caretOffset.get() - 2, ((Integer)caretOffset.get()).intValue(), (CharSequence)StringUtil.repeat((String)" ", (int)n2));
            return EnterHandlerDelegate.Result.Stop;
        }
        if (BackspaceHandler.isWhitespaceBeforeCaret((Editor)editor2)) {
            return EnterHandlerDelegate.Result.DefaultSkipIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull DataContext dataContext) {
        long l2 = a ^ 0x4CD824BDEE49L;
        if (file == null) {
            YAMLEnterAtIndentHandler.a(5);
        }
        if (editor2 == null) {
            YAMLEnterAtIndentHandler.a(6);
        }
        if (dataContext == null) {
            YAMLEnterAtIndentHandler.a(7);
        }
        if (!(file instanceof YAMLFile) || !file.isValid()) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!YAMLEnterAtIndentHandler.a(file)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int n2 = editor2.getCaretModel().getOffset();
        if (n2 <= 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement psiElement = file.findElementAt(n2 - 1);
        if (!YAMLElementTypes.BLANK_ELEMENTS.contains(PsiUtilCore.getElementType((PsiElement)psiElement))) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement psiElement2 = psiElement.getParent();
        IElementType iElementType = PsiUtilCore.getElementType((PsiElement)psiElement2);
        if (iElementType != YAMLElementTypes.SEQUENCE) {
            if (iElementType != YAMLElementTypes.MAPPING) {
                return EnterHandlerDelegate.Result.Continue;
            }
            PsiElement psiElement3 = psiElement.getPrevSibling();
            while (YAMLElementTypes.BLANK_ELEMENTS.contains(PsiUtilCore.getElementType((PsiElement)psiElement3))) {
                psiElement3 = psiElement3.getPrevSibling();
            }
            if (PsiUtilCore.getElementType((PsiElement)psiElement3) != YAMLElementTypes.KEY_VALUE_PAIR) {
                return EnterHandlerDelegate.Result.Continue;
            }
            if (PsiUtilCore.getElementType((PsiElement)psiElement3.getLastChild()) != YAMLElementTypes.SEQUENCE) {
                return EnterHandlerDelegate.Result.Continue;
            }
            if (YAMLUtil.getIndentToThisElement(psiElement3.getLastChild()) != YAMLUtil.getIndentToThisElement(psiElement2)) {
                return EnterHandlerDelegate.Result.Continue;
            }
        } else if (YAMLEnterAtIndentHandler.a(psiElement.getPrevSibling())) {
            return EnterHandlerDelegate.Result.Continue;
        }
        editor2.getDocument().insertString(n2, (CharSequence)"- ");
        editor2.getCaretModel().moveToOffset(n2 + 2);
        return EnterHandlerDelegate.Result.Stop;
    }

    @Contract(value="null -> false")
    private static boolean a(@Nullable PsiElement psiElement) {
        return psiElement instanceof YAMLSequenceItem && "-".equals(psiElement.getText());
    }

    private static boolean a(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            YAMLEnterAtIndentHandler.a(8);
        }
        return ((YAMLCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)psiFile, YAMLCodeStyleSettings.class)).AUTOINSERT_SEQUENCE_MARKER;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x2B51B69E38D9L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/yaml/formatter/YAMLEnterAtIndentHandler";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessEnter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldInsertAutomaticHyphen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

