/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.schema.YamlEmptyObjectAdapter;
import org.jetbrains.yaml.schema.YamlObjectAdapter;
import org.jetbrains.yaml.schema.YamlPropertyAdapter;

public class YamlJsonPsiWalker
implements JsonLikePsiWalker {
    public static final YamlJsonPsiWalker INSTANCE;
    private static final long a;

    private YamlJsonPsiWalker() {
    }

    public ThreeState isName(PsiElement element) {
        PsiElement psiElement = element.getParent();
        if (psiElement instanceof YAMLDocument || psiElement instanceof YAMLMapping) {
            return ThreeState.YES;
        }
        if (psiElement instanceof YAMLKeyValue && YamlJsonPsiWalker.a(element, psiElement)) {
            ASTNode aSTNode = element.getNode().getTreePrev();
            return aSTNode.getElementType() == YAMLTokenTypes.INDENT ? ThreeState.YES : ThreeState.NO;
        }
        if (psiElement instanceof YAMLSequenceItem && YamlJsonPsiWalker.a(element, psiElement)) {
            return ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }

    private static boolean a(PsiElement psiElement, PsiElement psiElement2) {
        PsiElement[] psiElementArray = psiElement2.getChildren();
        return psiElementArray.length != 0 && psiElementArray[0] == psiElement;
    }

    public boolean isPropertyWithValue(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.a(0);
        }
        return element instanceof YAMLKeyValue && ((YAMLKeyValue)element).getValue() != null;
    }

    public boolean isTopJsonElement(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.a(1);
        }
        return element instanceof YAMLFile || element instanceof YAMLDocument;
    }

    public boolean acceptsEmptyRoot() {
        return true;
    }

    public PsiElement findElementToCheck(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.a(2);
        }
        for (PsiElement psiElement = element; psiElement != null && !(psiElement instanceof PsiFile); psiElement = psiElement.getParent()) {
            if (!(psiElement instanceof YAMLValue) && !(psiElement instanceof YAMLKeyValue)) continue;
            return psiElement;
        }
        return null;
    }

    public boolean requiresNameQuotes() {
        return false;
    }

    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.a(3);
        }
        return element instanceof YAMLValue ? YamlPropertyAdapter.createValueAdapterByType((YAMLValue)element) : (element instanceof YAMLDocument ? new YamlEmptyObjectAdapter(element) : null);
    }

    public boolean allowsSingleQuotes() {
        return true;
    }

    public boolean hasMissingCommaAfter(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.a(4);
        }
        return false;
    }

    @Nullable
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement element) {
        YAMLMapping yAMLMapping;
        if (element == null) {
            YamlJsonPsiWalker.a(5);
        }
        if ((yAMLMapping = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLMapping.class, (boolean)true, (Class[])new Class[]{YAMLKeyValue.class})) != null) {
            return new YamlPropertyAdapter(element.getParent());
        }
        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class, (boolean)false);
        if (yAMLKeyValue == null) {
            return null;
        }
        YAMLValue yAMLValue = yAMLKeyValue.getValue();
        if (yAMLValue == null || !PsiTreeUtil.isAncestor((PsiElement)yAMLValue, (PsiElement)element, (boolean)true)) {
            return null;
        }
        return new YamlPropertyAdapter((PsiElement)yAMLKeyValue);
    }

    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement originalPosition, PsiElement computedPosition) {
        if (originalPosition == null) {
            YamlJsonPsiWalker.a(6);
        }
        YAMLMapping yAMLMapping = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, YAMLMapping.class);
        YAMLMapping yAMLMapping2 = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)computedPosition, YAMLMapping.class);
        if (yAMLMapping == null || yAMLMapping2 != null && PsiTreeUtil.isAncestor((PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)yAMLMapping), (PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)yAMLMapping2), (boolean)true)) {
            yAMLMapping = yAMLMapping2;
        }
        if (yAMLMapping == null) {
            return Collections.emptySet();
        }
        return new YamlObjectAdapter(yAMLMapping).getPropertyList().stream().map(jsonPropertyAdapter -> jsonPropertyAdapter.getName()).collect(Collectors.toSet());
    }

    @Nullable
    public JsonPointerPosition findPosition(@NotNull PsiElement element, boolean forceLastTransition) {
        long l2 = a ^ 0x661FEF6A1077L;
        if (element == null) {
            YamlJsonPsiWalker.a(7);
        }
        JsonPointerPosition jsonPointerPosition = new JsonPointerPosition();
        PsiElement psiElement = element;
        while (!YamlJsonPsiWalker.a(psiElement)) {
            List<YAMLPsiElement> list2;
            PsiElement psiElement2 = psiElement;
            if ((psiElement = psiElement.getParent()) instanceof YAMLSequence) {
                list2 = (YAMLSequence)psiElement;
                List<YAMLSequenceItem> list3 = list2.getItems();
                int n2 = -1;
                for (int i10 = 0; i10 < list3.size(); ++i10) {
                    YAMLSequenceItem yAMLSequenceItem = list3.get(i10);
                    if (!psiElement2.equals(yAMLSequenceItem)) continue;
                    n2 = i10;
                    break;
                }
                if (n2 == -1) continue;
                jsonPointerPosition.addPrecedingStep(n2);
                continue;
            }
            if (psiElement instanceof YAMLSequenceItem) continue;
            if (psiElement instanceof YAMLKeyValue) {
                list2 = StringUtil.notNullize((String)((YAMLKeyValue)psiElement).getName());
                if (!((psiElement = psiElement.getParent()) instanceof YAMLMapping)) {
                    return null;
                }
                jsonPointerPosition.addPrecedingStep(list2);
                continue;
            }
            if (psiElement instanceof YAMLMapping && psiElement2 instanceof YAMLKeyValue) {
                list2 = StringUtil.notNullize((String)((YAMLKeyValue)psiElement2).getName());
                if (((String)((Object)list2)).contains("IntellijIdeaRulezzz")) continue;
                jsonPointerPosition.addPrecedingStep(list2);
                continue;
            }
            if (YamlJsonPsiWalker.a(psiElement)) break;
            if (psiElement instanceof YAMLMapping) {
                list2 = ((YAMLMapping)psiElement).getYAMLElements();
                if (list2.size() == 0) {
                    return null;
                }
                if (psiElement2 instanceof YAMLPsiElement && list2.contains(psiElement2)) continue;
            }
            return null;
        }
        return jsonPointerPosition;
    }

    private static boolean a(PsiElement psiElement) {
        return psiElement instanceof PsiFile || psiElement instanceof YAMLDocument || psiElement instanceof YAMLBlockMappingImpl && psiElement.getParent() instanceof YAMLDocument;
    }

    public boolean requiresValueQuotes() {
        return false;
    }

    public String getDefaultObjectValue() {
        return "";
    }

    public String getDefaultArrayValue() {
        long l2 = a ^ 0x29099607E68EL;
        return "- ";
    }

    public boolean hasWhitespaceDelimitedCodeBlocks() {
        return true;
    }

    public String getNodeTextForValidation(PsiElement element) {
        long l2 = a ^ 0x5FFE43B819FCL;
        String string = element.getText();
        if (!StringUtil.startsWith((CharSequence)string, (CharSequence)"!!") && !StringUtil.startsWithChar((CharSequence)string, (char)'&')) {
            return string;
        }
        int n2 = string.indexOf(32);
        return n2 > 0 ? string.substring(n2 + 1) : string;
    }

    public TextRange adjustErrorHighlightingRange(@NotNull PsiElement element) {
        YAMLAnchor[] yAMLAnchorArray;
        if (element == null) {
            YamlJsonPsiWalker.a(8);
        }
        if ((yAMLAnchorArray = (YAMLAnchor[])PsiTreeUtil.getChildrenOfType((PsiElement)element, YAMLAnchor.class)) == null || yAMLAnchorArray.length == 0) {
            return element.getTextRange();
        }
        YAMLAnchor yAMLAnchor = yAMLAnchorArray[yAMLAnchorArray.length - 1];
        PsiElement psiElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)yAMLAnchor);
        return psiElement == null ? element.getTextRange() : psiElement.getTextRange();
    }

    public JsonLikeSyntaxAdapter getSyntaxAdapter(final Project project) {
        return new JsonLikeSyntaxAdapter(){
            private final YAMLElementGenerator a;
            private static final long b = c.a(1238878004316939278L, -5832247106189926877L, MethodHandles.lookup().lookupClass()).a(159022077508748L);
            {
                this.a = YAMLElementGenerator.getInstance(project);
            }

            @Nullable
            public PsiElement getPropertyValue(PsiElement property) {
                assert (property instanceof YAMLKeyValue);
                YAMLValue yAMLValue = ((YAMLKeyValue)property).getValue();
                if (yAMLValue == null) {
                    return null;
                }
                return this.adjustValue((PsiElement)yAMLValue);
            }

            @NotNull
            public PsiElement adjustValue(@NotNull PsiElement value) {
                if (value == null) {
                    1.a(0);
                }
                if (!(value instanceof YAMLValue)) {
                    PsiElement psiElement = value;
                    if (psiElement == null) {
                        1.a(1);
                    }
                    return psiElement;
                }
                YAMLAnchor[] yAMLAnchorArray = (YAMLAnchor[])PsiTreeUtil.getChildrenOfType((PsiElement)value, YAMLAnchor.class);
                if (yAMLAnchorArray == null || yAMLAnchorArray.length == 0) {
                    PsiElement psiElement = value;
                    if (psiElement == null) {
                        1.a(2);
                    }
                    return psiElement;
                }
                PsiElement psiElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)yAMLAnchorArray[yAMLAnchorArray.length - 1]);
                PsiElement psiElement2 = psiElement == null ? value : psiElement;
                if (psiElement2 == null) {
                    1.a(3);
                }
                return psiElement2;
            }

            @Nullable
            public String getPropertyName(PsiElement property) {
                assert (property instanceof YAMLKeyValue);
                return ((YAMLKeyValue)property).getName();
            }

            private YAMLKeyValue a(PsiElement psiElement) {
                if (PsiUtilCore.getElementType((PsiElement)psiElement) == YAMLTokenTypes.INDENT) {
                    PsiElement psiElement2 = psiElement.getPrevSibling();
                    PsiElement psiElement3 = psiElement2 = psiElement2 == null ? null : psiElement2.getPrevSibling();
                    if (psiElement2 instanceof YAMLKeyValue && ((YAMLKeyValue)psiElement2).getValue() == null) {
                        return (YAMLKeyValue)psiElement2;
                    }
                }
                return null;
            }

            @NotNull
            public PsiElement createProperty(@NotNull String name, @NotNull String value, PsiElement element) {
                if (name == null) {
                    1.a(4);
                }
                if (value == null) {
                    1.a(5);
                }
                YAMLKeyValue yAMLKeyValue = this.a.createYamlKeyValue(name, StringUtil.unquoteString((String)value));
                YAMLKeyValue yAMLKeyValue2 = element instanceof YAMLDocument || this.a(element) != null ? this.a.createDummyYamlWithText(yAMLKeyValue.getText()).getDocuments().get(0).getFirstChild() : yAMLKeyValue;
                if (yAMLKeyValue2 == null) {
                    1.a(6);
                }
                return yAMLKeyValue2;
            }

            public boolean ensureComma(PsiElement self, PsiElement newElement) {
                if (newElement instanceof YAMLKeyValue && self instanceof YAMLKeyValue) {
                    self.getParent().addAfter(this.a.createEol(), self);
                }
                return false;
            }

            public void removeIfComma(PsiElement forward) {
                if (forward instanceof LeafPsiElement && ((LeafPsiElement)forward).getElementType() == YAMLTokenTypes.EOL) {
                    PsiElement psiElement;
                    while ((psiElement = forward.getNextSibling()) instanceof LeafPsiElement && ((LeafPsiElement)psiElement).getElementType() == YAMLTokenTypes.INDENT) {
                        psiElement.delete();
                    }
                    forward.delete();
                }
            }

            public boolean fixWhitespaceBefore(PsiElement initialElement, PsiElement element) {
                return initialElement instanceof YAMLValue && initialElement != element;
            }

            @NotNull
            public String getDefaultValueFromType(@Nullable JsonSchemaType type) {
                long l2 = b ^ 0x41A8B6C4944L;
                if (type == null) {
                    if ("" == null) {
                        1.a(7);
                    }
                    return "";
                }
                if (type == JsonSchemaType._object) {
                    if (" " == null) {
                        1.a(8);
                    }
                    return " ";
                }
                if (type == JsonSchemaType._array) {
                    if (" - " == null) {
                        1.a(9);
                    }
                    return " - ";
                }
                String string = type.getDefaultValue();
                if (string == null) {
                    1.a(10);
                }
                return string;
            }

            public PsiElement adjustNewProperty(PsiElement element) {
                if (element instanceof YAMLMapping) {
                    return element.getFirstChild();
                }
                return element;
            }

            public PsiElement adjustPropertyAnchor(LeafPsiElement element) {
                long l2 = b ^ 0x90C934F7225L;
                YAMLKeyValue yAMLKeyValue = this.a((PsiElement)element);
                assert (yAMLKeyValue != null) : "Should come here only for YAMLKeyValue with no value and a following indent";
                yAMLKeyValue.addBefore(this.a.createEol(), null);
                yAMLKeyValue.addBefore(this.a.createIndent(element.getTextLength()), null);
                PsiElement psiElement = element.getPrevSibling();
                if (psiElement != null) {
                    psiElement.delete();
                }
                element.delete();
                return yAMLKeyValue;
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                long l2 = b ^ 0x6DFD671BE442L;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/yaml/schema/YamlJsonPsiWalker$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/yaml/schema/YamlJsonPsiWalker$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "adjustValue";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createProperty";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultValueFromType";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "adjustValue";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createProperty";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public PsiElement getParentContainer(PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class), (Class[])new Class[]{YAMLMapping.class, YAMLSequence.class});
    }

    @NotNull
    public Collection<PsiElement> getRoots(@NotNull PsiFile file) {
        if (file == null) {
            YamlJsonPsiWalker.a(9);
        }
        if (!(file instanceof YAMLFile)) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                YamlJsonPsiWalker.a(10);
            }
            return list2;
        }
        HashSet<PsiElement> hashSet = new HashSet<PsiElement>();
        for (YAMLDocument yAMLDocument : ((YAMLFile)file).getDocuments()) {
            YAMLValue yAMLValue = yAMLDocument.getTopLevelValue();
            hashSet.add((PsiElement)(yAMLValue == null ? yAMLDocument : yAMLValue));
        }
        HashSet<PsiElement> hashSet2 = hashSet;
        if (hashSet2 == null) {
            YamlJsonPsiWalker.a(11);
        }
        return hashSet2;
    }

    @Nullable
    public PsiElement getPropertyNameElement(PsiElement property) {
        return property instanceof YAMLKeyValue ? ((YAMLKeyValue)property).getKey() : null;
    }

    static {
        a = c.a(1461655166032577823L, -7442429414003399902L, MethodHandles.lookup().lookupClass()).a(122550645245506L);
        INSTANCE = new YamlJsonPsiWalker();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x385ADE5999A6L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 10: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPosition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/schema/YamlJsonPsiWalker";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/schema/YamlJsonPsiWalker";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyWithValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTopJsonElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findElementToCheck";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createValueAdapter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasMissingCommaAfter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParentPropertyAdapter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNamesOfParentObject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPosition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "adjustErrorHighlightingRange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

