/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.SortableColumnModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.RowSorter;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public abstract class PluginTableModel
extends AbstractTableModel
implements SortableColumnModel {
    protected static final String NAME = "Name";
    protected ColumnInfo[] columns;
    protected final List<IdeaPluginDescriptor> view = new ArrayList<IdeaPluginDescriptor>();
    protected final List<IdeaPluginDescriptor> filtered = new ArrayList<IdeaPluginDescriptor>();
    private RowSorter.SortKey myDefaultSortKey;
    private boolean mySortByStatus;
    private boolean mySortByRating;
    private boolean mySortByDownloads;
    private boolean mySortByUpdated;

    protected PluginTableModel() {
    }

    public void setSortKey(RowSorter.SortKey sortKey) {
        this.myDefaultSortKey = sortKey;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    public ColumnInfo[] getColumnInfos() {
        return this.columns;
    }

    public boolean isSortable() {
        return true;
    }

    public void setSortable(boolean aBoolean) {
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column].getName();
    }

    public IdeaPluginDescriptor getObjectAt(int row) {
        return this.view.get(row);
    }

    public Object getRowValue(int row) {
        return this.getObjectAt(row);
    }

    public RowSorter.SortKey getDefaultSortKey() {
        return this.myDefaultSortKey;
    }

    @Override
    public int getRowCount() {
        return this.view.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.columns[columnIndex].valueOf((Object)this.getObjectAt(rowIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columns[columnIndex].isCellEditable((Object)this.getObjectAt(rowIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.columns[columnIndex].setValue((Object)this.getObjectAt(rowIndex), aValue);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @NotNull
    public List<IdeaPluginDescriptorImpl> dependent(@NotNull IdeaPluginDescriptorImpl plugin) {
        if (plugin == null) {
            PluginTableModel.$$$reportNull$$$0(0);
        }
        ArrayList<IdeaPluginDescriptorImpl> list2 = new ArrayList<IdeaPluginDescriptorImpl>();
        block0: for (IdeaPluginDescriptor any : this.getAllPlugins()) {
            PluginId[] dep;
            if (!(any instanceof IdeaPluginDescriptorImpl)) continue;
            for (PluginId id : dep = any.getDependentPluginIds()) {
                if (id != plugin.getPluginId()) continue;
                list2.add((IdeaPluginDescriptorImpl)any);
                continue block0;
            }
        }
        ArrayList<IdeaPluginDescriptorImpl> arrayList = list2;
        if (arrayList == null) {
            PluginTableModel.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public abstract void updatePluginsList(List<? extends IdeaPluginDescriptor> var1);

    protected void filter(String filter) {
        Set search2 = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter);
        List<IdeaPluginDescriptor> allPlugins = this.getAllPlugins();
        this.view.clear();
        this.filtered.clear();
        for (IdeaPluginDescriptor descriptor2 : allPlugins) {
            if (this.isPluginDescriptorAccepted(descriptor2) && PluginManagerMain.isAccepted(filter, search2, descriptor2)) {
                this.view.add(descriptor2);
                continue;
            }
            this.filtered.add(descriptor2);
        }
        this.fireTableDataChanged();
    }

    public abstract int getNameColumn();

    public abstract boolean isPluginDescriptorAccepted(IdeaPluginDescriptor var1);

    public void sort() {
        try {
            Collections.sort(this.view, this.columns[this.getNameColumn()].getComparator());
            this.fireTableDataChanged();
        }
        catch (IllegalArgumentException e) {
            String message = e.getMessage();
            if (message != null && e.getMessage().contains("Comparison method violates its general contract")) {
                ColumnInfo column = this.columns[this.getNameColumn()];
                e = new IllegalArgumentException("model=" + this + " col=" + column + " cmp=" + column.getComparator(), e);
            }
            throw e;
        }
    }

    public boolean isSortByStatus() {
        return this.mySortByStatus;
    }

    public void setSortByStatus(boolean sortByStatus) {
        this.mySortByStatus = sortByStatus;
    }

    public boolean isSortByRating() {
        return this.mySortByRating;
    }

    public void setSortByRating(boolean sortByRating) {
        this.mySortByRating = sortByRating;
    }

    public boolean isSortByDownloads() {
        return this.mySortByDownloads;
    }

    public void setSortByDownloads(boolean sortByDownloads) {
        this.mySortByDownloads = sortByDownloads;
    }

    public boolean isSortByUpdated() {
        return this.mySortByUpdated;
    }

    public void setSortByUpdated(boolean sortByUpdated) {
        this.mySortByUpdated = sortByUpdated;
    }

    public List<IdeaPluginDescriptor> getAllPlugins() {
        ArrayList<IdeaPluginDescriptor> list2 = new ArrayList<IdeaPluginDescriptor>(this.view.size() + this.filtered.size());
        list2.addAll(this.view);
        list2.addAll(this.filtered);
        return list2;
    }

    public List<IdeaPluginDescriptor> getAllRepoPlugins() {
        try {
            List<IdeaPluginDescriptor> list2 = RepositoryHelper.loadCachedPlugins();
            if (list2 != null) {
                return list2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginTableModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "dependent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "dependent";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

