/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.impl.DisplayedFoldingAnchor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.containers.hash.HashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class FoldingAnchorsOverlayStrategy {
    private final EditorImpl myEditor;

    FoldingAnchorsOverlayStrategy(EditorImpl editor) {
        this.myEditor = editor;
    }

    @NotNull
    Collection<DisplayedFoldingAnchor> getAnchorsToDisplay(int firstVisibleOffset, int lastVisibleOffset, @NotNull List<FoldRegion> activeFoldRegions) {
        if (activeFoldRegions == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(0);
        }
        HashMap result2 = new HashMap();
        FoldRegion[] visibleFoldRegions = this.myEditor.getFoldingModel().fetchVisible();
        if (visibleFoldRegions != null) {
            for (FoldRegion region : visibleFoldRegions) {
                int endLogicalLine;
                int endOffset;
                int startOffset;
                if (!region.isValid() || (startOffset = region.getStartOffset()) > lastVisibleOffset || (endOffset = region.getEndOffset()) < firstVisibleOffset) continue;
                boolean singleLine = false;
                int startLogicalLine = this.myEditor.getDocument().getLineNumber(startOffset);
                if (startLogicalLine == (endLogicalLine = this.myEditor.getDocument().getLineNumber(endOffset))) {
                    singleLine = true;
                    if (!region.isGutterMarkEnabledForSingleLine() && (!this.myEditor.getSettings().isAllowSingleLogicalLineFolding() || endOffset - startOffset <= 1 || this.myEditor.getSoftWrapModel().getSoftWrapsForRange(startOffset + 1, endOffset - 1).isEmpty())) continue;
                }
                int foldStart = this.myEditor.offsetToVisualLine(startOffset);
                if (!region.isExpanded()) {
                    FoldingAnchorsOverlayStrategy.tryAdding((Map<Integer, DisplayedFoldingAnchor>)result2, region, foldStart, 0, singleLine ? DisplayedFoldingAnchor.Type.COLLAPSED_SINGLE_LINE : DisplayedFoldingAnchor.Type.COLLAPSED, activeFoldRegions);
                    continue;
                }
                int foldEnd = this.myEditor.offsetToVisualLine(endOffset);
                if (foldStart == foldEnd) {
                    FoldingAnchorsOverlayStrategy.tryAdding((Map<Integer, DisplayedFoldingAnchor>)result2, region, foldStart, 0, DisplayedFoldingAnchor.Type.EXPANDED_SINGLE_LINE, activeFoldRegions);
                    continue;
                }
                FoldingAnchorsOverlayStrategy.tryAdding((Map<Integer, DisplayedFoldingAnchor>)result2, region, foldStart, foldEnd - foldStart, DisplayedFoldingAnchor.Type.EXPANDED_TOP, activeFoldRegions);
                FoldingAnchorsOverlayStrategy.tryAdding((Map<Integer, DisplayedFoldingAnchor>)result2, region, foldEnd, foldEnd - foldStart, DisplayedFoldingAnchor.Type.EXPANDED_BOTTOM, activeFoldRegions);
            }
        }
        Collection<DisplayedFoldingAnchor> collection = result2.values();
        if (collection == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(1);
        }
        return collection;
    }

    private static void tryAdding(@NotNull Map<Integer, DisplayedFoldingAnchor> resultsMap, @NotNull FoldRegion region, int visualLine, int visualHeight, @NotNull DisplayedFoldingAnchor.Type type, @NotNull List<FoldRegion> activeRegions) {
        DisplayedFoldingAnchor prev;
        if (resultsMap == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(2);
        }
        if (region == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(3);
        }
        if (type == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(4);
        }
        if (activeRegions == null) {
            FoldingAnchorsOverlayStrategy.$$$reportNull$$$0(5);
        }
        if ((prev = resultsMap.get(visualLine)) != null && !prev.type.singleLine) {
            if (type.singleLine) {
                return;
            }
            if (region.getGroup() != null && region.getGroup() == prev.foldRegion.getGroup() && type != DisplayedFoldingAnchor.Type.COLLAPSED && type != prev.type) {
                resultsMap.remove(visualLine);
                return;
            }
            if (activeRegions.contains(prev.foldRegion)) {
                return;
            }
            if (!activeRegions.contains(region) && prev.foldRegionVisualLines < visualHeight) {
                return;
            }
        }
        resultsMap.put(visualLine, new DisplayedFoldingAnchor(region, visualLine, visualHeight, type));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeFoldRegions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FoldingAnchorsOverlayStrategy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultsMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FoldingAnchorsOverlayStrategy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchorsToDisplay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorsToDisplay";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryAdding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

