/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.actions.ShowContentAction;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ComboContentLayout;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.SelectContentStep;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.ui.content.tabs.TabbedContentAction;
import com.intellij.util.Alarm;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LocationOnDragTracker;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowContentUi
extends JPanel
implements ContentUI,
PropertyChangeListener,
DataProvider {
    public static final String POPUP_PLACE = "ToolwindowPopup";
    public static final String HIDE_ID_LABEL = "HideIdLabel";
    ContentManager myManager;
    final JPanel myContent = new JPanel(new BorderLayout());
    ToolWindowImpl myWindow;
    TabbedContentAction.CloseAllAction myCloseAllAction;
    TabbedContentAction.MyNextTabAction myNextTabAction;
    TabbedContentAction.MyPreviousTabAction myPreviousTabAction;
    ShowContentAction myShowContent;
    TabContentLayout myTabsLayout = new TabContentLayout(this);
    ContentLayout myComboLayout = new ComboContentLayout(this);
    private ToolWindowContentUiType myType = ToolWindowContentUiType.TABBED;
    public Predicate<Point> isResizableArea = p -> true;

    public ToolWindowContentUi(ToolWindowImpl window) {
        this.myWindow = window;
        this.myContent.setOpaque(false);
        this.myContent.setFocusable(false);
        this.setOpaque(false);
        this.setBorder((Border)JBUI.Borders.emptyRight((int)2));
        UIUtil.putClientProperty((JComponent)this.myContent, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)new Iterable<JComponent>(){

            @Override
            public Iterator<JComponent> iterator() {
                if (ToolWindowContentUi.this.myManager == null || ToolWindowContentUi.this.myManager.getContentCount() == 0) {
                    return EmptyIterator.getInstance();
                }
                return JBIterable.of((Object[])ToolWindowContentUi.this.myManager.getContents()).map(content2 -> {
                    JComponent last = null;
                    for (Component c2 : UIUtil.uiParents((Component)content2.getComponent(), (boolean)false)) {
                        if (c2 == ToolWindowContentUi.this.myManager.getComponent() || !(c2 instanceof JComponent)) {
                            return null;
                        }
                        last = (JComponent)c2;
                    }
                    return last;
                }).filter(Conditions.notNull()).iterator();
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(UISettingsListener.TOPIC, uiSettings -> {
            this.revalidate();
            this.repaint();
        });
    }

    private boolean isResizeable() {
        if (this.myWindow.getType() == ToolWindowType.FLOATING || this.myWindow.getType() == ToolWindowType.WINDOWED) {
            return false;
        }
        if (this.myWindow.getAnchor() == ToolWindowAnchor.BOTTOM) {
            return true;
        }
        if (this.myWindow.getAnchor() == ToolWindowAnchor.TOP) {
            return false;
        }
        if (!this.myWindow.isSplitMode()) {
            return false;
        }
        ToolWindowManagerImpl manager = this.myWindow.getToolWindowManager();
        List<String> ids = manager.getIdsOn(this.myWindow.getAnchor());
        for (String id : ids) {
            ToolWindow window;
            if (id.equals(this.myWindow.getId()) || (window = manager.getToolWindow(id)) == null || !window.isVisible() || window.getType() != ToolWindowType.DOCKED && window.getType() != ToolWindowType.SLIDING) continue;
            return true;
        }
        return false;
    }

    private boolean isResizeable(@NotNull Point point) {
        if (point == null) {
            ToolWindowContentUi.$$$reportNull$$$0(0);
        }
        return this.isResizableArea.apply((Object)point);
    }

    public void setType(@NotNull ToolWindowContentUiType type) {
        if (type == null) {
            ToolWindowContentUi.$$$reportNull$$$0(1);
        }
        if (this.myType != type) {
            if (this.myType != null) {
                this.getCurrentLayout().reset();
            }
            this.myType = type;
            this.getCurrentLayout().init();
            this.rebuild();
        }
    }

    private ContentLayout getCurrentLayout() {
        assert (this.myManager != null);
        return this.myType == ToolWindowContentUiType.TABBED ? this.myTabsLayout : this.myComboLayout;
    }

    public JComponent getComponent() {
        return this.myContent;
    }

    public JComponent getTabComponent() {
        return this;
    }

    public void setManager(@NotNull ContentManager manager) {
        if (manager == null) {
            ToolWindowContentUi.$$$reportNull$$$0(2);
        }
        if (this.myManager != null) {
            this.getCurrentLayout().reset();
        }
        this.myManager = manager;
        this.getCurrentLayout().init();
        this.myManager.addContentManagerListener(new ContentManagerListener(){

            public void contentAdded(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ToolWindowContentUi.this.getCurrentLayout().contentAdded(event);
                event.getContent().addPropertyChangeListener((PropertyChangeListener)ToolWindowContentUi.this);
                ToolWindowContentUi.this.rebuild();
            }

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                event.getContent().removePropertyChangeListener((PropertyChangeListener)ToolWindowContentUi.this);
                ToolWindowContentUi.this.getCurrentLayout().contentRemoved(event);
                ToolWindowContentUi.this.ensureSelectedContentVisible();
                ToolWindowContentUi.this.rebuild();
            }

            public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(3);
                }
                ToolWindowContentUi.this.ensureSelectedContentVisible();
                ToolWindowContentUi.this.update();
                ToolWindowContentUi.this.myContent.revalidate();
                ToolWindowContentUi.this.myContent.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentRemoveQuery";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ToolWindowContentUi.initMouseListeners(this, this, true);
        this.rebuild();
        this.myCloseAllAction = new TabbedContentAction.CloseAllAction(this.myManager);
        this.myNextTabAction = new TabbedContentAction.MyNextTabAction(this.myManager);
        this.myPreviousTabAction = new TabbedContentAction.MyPreviousTabAction(this.myManager);
        this.myShowContent = new ShowContentAction(this.myWindow, this.myContent, (Disposable)this.myManager);
    }

    private void ensureSelectedContentVisible() {
        Component visible;
        Content selected2 = this.myManager.getSelectedContent();
        if (selected2 == null) {
            this.myContent.removeAll();
            return;
        }
        if (this.myContent.getComponentCount() == 1 && (visible = this.myContent.getComponent(0)) == selected2.getComponent()) {
            return;
        }
        this.myContent.removeAll();
        this.myContent.add((Component)selected2.getComponent(), "Center");
        this.myContent.revalidate();
        this.myContent.repaint();
    }

    private void rebuild() {
        this.getCurrentLayout().rebuild();
        this.getCurrentLayout().update();
        this.revalidate();
        this.repaint();
        if (this.myManager.getContentCount() == 0 && this.myWindow.isToHideOnEmptyContent()) {
            this.myWindow.hide(null);
        }
    }

    @Override
    public void doLayout() {
        this.getCurrentLayout().layout();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.getCurrentLayout().paintComponent(g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.getCurrentLayout().paintChildren(g);
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        return new Dimension(insets.left + insets.right + this.getCurrentLayout().getMinimumWidth(), super.getMinimumSize().height);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = new Dimension();
        size.height = 0;
        size.width = 4 + this.getInsets().left + this.getInsets().right;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component each = this.getComponent(i);
            size.height = Math.max(each.getPreferredSize().height, size.height);
            size.width += each.getPreferredSize().width;
        }
        size.width = Math.max(size.width, this.getMinimumSize().width);
        return size;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }

    private void update() {
        this.getCurrentLayout().update();
        this.revalidate();
        this.repaint();
    }

    public boolean isSingleSelection() {
        return true;
    }

    public boolean isToSelectAddedContent() {
        return false;
    }

    public boolean canBeEmptySelection() {
        return false;
    }

    public void beforeDispose() {
    }

    public boolean canChangeSelectionTo(@NotNull Content content2, boolean implicit) {
        if (content2 == null) {
            ToolWindowContentUi.$$$reportNull$$$0(3);
        }
        return true;
    }

    @NotNull
    public String getCloseActionName() {
        String string = this.getCurrentLayout().getCloseActionName();
        if (string == null) {
            ToolWindowContentUi.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string = this.getCurrentLayout().getCloseAllButThisActionName();
        if (string == null) {
            ToolWindowContentUi.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getPreviousContentActionName() {
        String string = this.getCurrentLayout().getPreviousContentActionName();
        if (string == null) {
            ToolWindowContentUi.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getNextContentActionName() {
        String string = this.getCurrentLayout().getNextContentActionName();
        if (string == null) {
            ToolWindowContentUi.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void setTabDoubleClickActions(AnAction ... actions) {
        if (actions == null) {
            ToolWindowContentUi.$$$reportNull$$$0(8);
        }
        this.myTabsLayout.setTabDoubleClickActions(actions);
    }

    public static void initMouseListeners(final JComponent c2, final ToolWindowContentUi ui, final boolean allowResize) {
        if (c2.getClientProperty(ui) != null) {
            return;
        }
        MouseAdapter mouseAdapter2 = new MouseAdapter(){
            final Ref<Point> myLastPoint = Ref.create();
            final Ref<Point> myPressPoint = Ref.create();
            final Ref<Integer> myInitialHeight = Ref.create((Object)0);
            final Ref<Boolean> myIsLastComponent = Ref.create();
            final Ref<LocationOnDragTracker> myDragTracker = Ref.create();

            private Component getActualSplitter() {
                if (!allowResize || !ui.isResizeable()) {
                    return null;
                }
                Container component = c2;
                for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
                    if (parent instanceof ThreeComponentsSplitter && ((ThreeComponentsSplitter)parent).getOrientation() && component != ((ThreeComponentsSplitter)parent).getFirstComponent()) {
                        return parent;
                    }
                    if (parent instanceof Splitter && ((Splitter)parent).isVertical() && ((Splitter)parent).getSecondComponent() == component && ((Splitter)parent).getFirstComponent() != null) {
                        return parent;
                    }
                    component = parent;
                }
                return null;
            }

            private void arm(Component c22) {
                Component component;
                Component component2 = component = c22 != null ? this.getActualSplitter() : null;
                if (component instanceof ThreeComponentsSplitter) {
                    ThreeComponentsSplitter splitter = (ThreeComponentsSplitter)component;
                    this.myIsLastComponent.set((Object)SwingUtilities.isDescendingFrom(c22, splitter.getLastComponent()));
                    this.myInitialHeight.set((Object)((Boolean)this.myIsLastComponent.get() != false ? splitter.getLastSize() : splitter.getFirstSize()));
                    return;
                }
                if (component instanceof Splitter) {
                    Splitter splitter = (Splitter)component;
                    this.myIsLastComponent.set((Object)true);
                    this.myInitialHeight.set((Object)splitter.getSecondComponent().getHeight());
                    return;
                }
                this.myIsLastComponent.set(null);
                this.myInitialHeight.set(null);
                this.myPressPoint.set(null);
                this.myDragTracker.set(null);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PointerInfo info = MouseInfo.getPointerInfo();
                if (!e.isPopupTrigger() && !UIUtil.isCloseClick((MouseEvent)e)) {
                    this.myLastPoint.set((Object)(info != null ? info.getLocation() : e.getLocationOnScreen()));
                    this.myPressPoint.set(this.myLastPoint.get());
                    this.myDragTracker.set((Object)LocationOnDragTracker.startDrag((MouseEvent)e));
                    if (allowResize && ui.isResizeable()) {
                        this.arm(c2.getComponentAt(e.getPoint()) == c2 && ui.isResizeable(e.getPoint()) ? c2 : null);
                    }
                    ui.myWindow.fireActivated();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    if (UIUtil.isCloseClick((MouseEvent)e, (int)502)) {
                        ui.processHide(e);
                    }
                    this.arm(null);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                c2.setCursor(allowResize && ui.isResizeable() && this.getActualSplitter() != null && c2.getComponentAt(e.getPoint()) == c2 && ui.isResizeable(e.getPoint()) ? Cursor.getPredefinedCursor(8) : Cursor.getDefaultCursor());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                c2.setCursor(null);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ThreeComponentsSplitter splitter;
                if (this.myLastPoint.isNull() || this.myPressPoint.isNull() || this.myDragTracker.isNull()) {
                    return;
                }
                PointerInfo info = MouseInfo.getPointerInfo();
                if (info == null) {
                    return;
                }
                Point newMouseLocation = info.getLocation();
                Window window = SwingUtilities.windowForComponent(c2);
                if (!(window instanceof IdeFrame)) {
                    ((LocationOnDragTracker)this.myDragTracker.get()).updateLocationOnDrag((Component)window);
                }
                this.myLastPoint.set((Object)newMouseLocation);
                Component component = this.getActualSplitter();
                if (component instanceof ThreeComponentsSplitter) {
                    splitter = (ThreeComponentsSplitter)component;
                    if (this.myIsLastComponent.get() == Boolean.TRUE) {
                        splitter.setLastSize((Integer)this.myInitialHeight.get() + ((Point)this.myPressPoint.get()).y - ((Point)this.myLastPoint.get()).y);
                    } else {
                        splitter.setFirstSize((Integer)this.myInitialHeight.get() + ((Point)this.myLastPoint.get()).y - ((Point)this.myPressPoint.get()).y);
                    }
                }
                if (component instanceof Splitter) {
                    splitter = (Splitter)component;
                    splitter.setProportion(Math.max(0.0f, Math.min(1.0f, 1.0f - (float)((Integer)this.myInitialHeight.get() + ((Point)this.myPressPoint.get()).y - ((Point)this.myLastPoint.get()).y) / (float)splitter.getHeight())));
                }
            }
        };
        c2.addMouseMotionListener(mouseAdapter2);
        c2.addMouseListener(mouseAdapter2);
        c2.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                Content content2 = c2 instanceof BaseLabel ? ((BaseLabel)c2).getContent() : null;
                ui.showContextMenu(comp, x, y, ui.myWindow.getPopupGroup(), content2);
            }
        });
        c2.putClientProperty(ui, Boolean.TRUE);
    }

    private void initActionGroup(DefaultActionGroup group, Content content2) {
        String groupName;
        if (content2 == null) {
            return;
        }
        group.addSeparator();
        group.add((AnAction)new TabbedContentAction.CloseAction(content2));
        group.add((AnAction)this.myCloseAllAction);
        group.add((AnAction)new TabbedContentAction.CloseAllButThisAction(content2));
        group.addSeparator();
        if (content2.isPinnable()) {
            group.add(PinToolwindowTabAction.getPinAction());
            group.addSeparator();
        }
        group.add((AnAction)this.myNextTabAction);
        group.add((AnAction)this.myPreviousTabAction);
        group.add((AnAction)this.myShowContent);
        if (content2 instanceof TabbedContent && ((TabbedContent)content2).hasMultipleTabs()) {
            group.addAction(ToolWindowContentUi.createSplitTabsAction((TabbedContent)content2));
        }
        if (Boolean.TRUE == content2.getUserData(Content.TABBED_CONTENT_KEY) && (groupName = (String)content2.getUserData(Content.TAB_GROUP_NAME_KEY)) != null) {
            group.addAction(ToolWindowContentUi.createMergeTabsAction(this.myManager, groupName));
        }
        group.addSeparator();
    }

    public void showContextMenu(Component comp, int x, int y, ActionGroup toolWindowGroup, @Nullable Content selectedContent) {
        if (selectedContent == null && toolWindowGroup == null) {
            return;
        }
        DefaultActionGroup configuredGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("ToolWindowContextMenu");
        DefaultActionGroup group = new DefaultActionGroup();
        group.copyFromGroup(configuredGroup);
        if (selectedContent != null) {
            this.initActionGroup(group, selectedContent);
        }
        if (toolWindowGroup != null) {
            group.addAll(toolWindowGroup);
        }
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu(POPUP_PLACE, (ActionGroup)group);
        popupMenu.getComponent().show(comp, x, y);
    }

    private static AnAction createSplitTabsAction(final TabbedContent content2) {
        return new DumbAwareAction("Split '" + content2.getTitlePrefix() + "' group"){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                content2.split();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$5", "actionPerformed"));
            }
        };
    }

    private static AnAction createMergeTabsAction(final ContentManager manager, final String tabPrefix) {
        return new DumbAwareAction("Merge tabs to '" + tabPrefix + "' group"){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                Content selectedContent = manager.getSelectedContent();
                ArrayList<Pair> tabs = new ArrayList<Pair>();
                int selectedTab = -1;
                ArrayList<Content> mergedContent = new ArrayList<Content>();
                for (Content content2 : manager.getContents()) {
                    if (!tabPrefix.equals(content2.getUserData(Content.TAB_GROUP_NAME_KEY))) continue;
                    String label2 = content2.getTabName().substring(tabPrefix.length() + 2);
                    JComponent component = content2.getComponent();
                    if (content2 == selectedContent) {
                        selectedTab = tabs.size();
                    }
                    tabs.add(Pair.create((Object)label2, (Object)component));
                    manager.removeContent(content2, false);
                    content2.setComponent(null);
                    content2.setShouldDisposeContent(false);
                    mergedContent.add(content2);
                }
                PropertiesComponent.getInstance().unsetValue("tabbed.toolwindow.expanded." + tabPrefix);
                for (int i = 0; i < tabs.size(); ++i) {
                    Pair tab = (Pair)tabs.get(i);
                    ContentUtilEx.addTabbedContent(manager, (JComponent)tab.second, tabPrefix, (String)tab.first, i == selectedTab);
                }
                mergedContent.forEach(Disposer::dispose);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$6", "actionPerformed"));
            }
        };
    }

    private void processHide(MouseEvent e) {
        IdeEventQueue.getInstance().blockNextEvents(e);
        Component c2 = e.getComponent();
        if (c2 instanceof BaseLabel) {
            BaseLabel tab = (BaseLabel)c2;
            if (tab.getContent() != null) {
                if (this.myManager.canCloseContents() && tab.getContent().isCloseable()) {
                    this.myManager.removeContent(tab.getContent(), true, true, true);
                } else if (this.myManager.getContentCount() == 1) {
                    this.hideWindow(e);
                }
            } else {
                this.hideWindow(e);
            }
        } else {
            this.hideWindow(e);
        }
    }

    private void hideWindow(MouseEvent e) {
        if (e.isControlDown()) {
            this.myWindow.fireHiddenSide();
        } else {
            this.myWindow.fireHidden();
        }
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            ToolWindowContentUi.$$$reportNull$$$0(9);
        }
        if (PlatformDataKeys.TOOL_WINDOW.is(dataId)) {
            return this.myWindow;
        }
        if (CloseAction.CloseTarget.KEY.is(dataId)) {
            return this.computeCloseTarget();
        }
        return null;
    }

    private CloseAction.CloseTarget computeCloseTarget() {
        Content selected2;
        if (this.myManager.canCloseContents() && (selected2 = this.myManager.getSelectedContent()) != null && selected2.isCloseable()) {
            return new CloseContentTarget(selected2);
        }
        return new HideToolwindowTarget();
    }

    public void dispose() {
        this.myContent.removeAll();
    }

    boolean isCurrent(ContentLayout layout) {
        return this.getCurrentLayout() == layout;
    }

    public void toggleContentPopup() {
        Content[] contents = this.myManager.getContents();
        Content selectedContent = this.myManager.getSelectedContent();
        SelectContentStep step = new SelectContentStep(contents);
        if (selectedContent != null) {
            step.setDefaultOptionIndex(this.myManager.getIndexOfContent(selectedContent));
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        this.getCurrentLayout().showContentPopup(popup2);
        if (selectedContent instanceof TabbedContent) {
            new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)popup2).addRequest(() -> popup2.handleSelect(false), 50);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/content/ToolWindowContentUi";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/ToolWindowContentUi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseActionName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseAllButThisActionName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousContentActionName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextContentActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isResizeable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setManager";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canChangeSelectionTo";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTabDoubleClickActions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CloseContentTarget
    implements CloseAction.CloseTarget {
        private final Content myContent;

        private CloseContentTarget(Content content2) {
            this.myContent = content2;
        }

        @Override
        public void close() {
            ToolWindowContentUi.this.myManager.removeContent(this.myContent, true, true, true);
        }
    }

    private class HideToolwindowTarget
    implements CloseAction.CloseTarget {
        private HideToolwindowTarget() {
        }

        @Override
        public void close() {
            ToolWindowContentUi.this.myWindow.fireHidden();
        }
    }
}

