/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.async;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.NextStepHandler;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.async.AsyncPopupStep;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncPopupImpl
extends WizardPopup
implements Runnable {
    private final Future<PopupStep> myFuture;
    private final Object myParentValue;
    private final NextStepHandler myCallBackParent;
    private final Alarm myAlarm;
    private JPanel myPanel;

    public AsyncPopupImpl(@Nullable Project project, @Nullable WizardPopup parent, @NotNull AsyncPopupStep<Object> step, @Nullable Object parentValue) {
        if (step == null) {
            AsyncPopupImpl.$$$reportNull$$$0(0);
        }
        super(project, parent, step);
        if (!(parent instanceof NextStepHandler)) {
            throw new IllegalArgumentException("parent must be NextStepHandler");
        }
        this.myCallBackParent = (NextStepHandler)((Object)parent);
        this.myParentValue = parentValue;
        this.myFuture = ApplicationManager.getApplication().executeOnPooledThread(step);
        this.myAlarm = new Alarm((Disposable)this);
        this.myAlarm.addRequest((Runnable)this, 200);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                if (!AsyncPopupImpl.this.myFuture.isCancelled() && !AsyncPopupImpl.this.myFuture.isDone()) {
                    AsyncPopupImpl.this.myFuture.cancel(false);
                }
            }
        });
    }

    @Override
    public void run() {
        if (this.myFuture.isCancelled()) {
            return;
        }
        if (this.myFuture.isDone()) {
            this.goBack();
            try {
                this.myCallBackParent.handleNextStep(this.myFuture.get(), this.myParentValue);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            return;
        }
        this.myAlarm.addRequest((Runnable)this, 200);
    }

    @Override
    protected JComponent createContent() {
        if (this.myPanel != null) {
            return this.myPanel;
        }
        this.myPanel = new JPanel(new BorderLayout());
        JBLabel label2 = new JBLabel("Loading...");
        label2.setForeground(UIUtil.getLabelDisabledForeground());
        this.myPanel.add((Component)label2, "Center");
        this.myPanel.setBorder(new EmptyBorder(UIUtil.getListCellPadding()));
        this.myPanel.setBackground(UIUtil.getListBackground());
        this.myPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AsyncPopupImpl.this.goBack();
            }
        }, KeyStroke.getKeyStroke(37, 0), 0);
        return this.myPanel;
    }

    @Override
    protected JComponent getPreferredFocusableComponent() {
        return this.createContent();
    }

    @Override
    protected InputMap getInputMap() {
        return null;
    }

    @Override
    protected ActionMap getActionMap() {
        return null;
    }

    @Override
    protected void onChildSelectedFor(Object value) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/intellij/ui/popup/async/AsyncPopupImpl", "<init>"));
    }
}

