/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.EventsCmd;
import com.github.dockerjava.api.model.Event;
import com.github.dockerjava.core.command.AbstrAsyncDockerCmd;
import com.github.dockerjava.core.util.FiltersBuilder;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;

public class EventsCmdImpl
extends AbstrAsyncDockerCmd<EventsCmd, Event>
implements EventsCmd {
    private String since;
    private String until;
    private FiltersBuilder filters = new FiltersBuilder();

    public EventsCmdImpl(EventsCmd.Exec exec) {
        super(exec);
    }

    @Override
    public EventsCmd withSince(String since) {
        this.since = since;
        return this;
    }

    @Override
    public EventsCmd withUntil(String until) {
        this.until = until;
        return this;
    }

    @Override
    public EventsCmd withContainerFilter(String ... container) {
        Preconditions.checkNotNull((Object)container, (Object)"container have not been specified");
        this.filters.withContainers(container);
        return this;
    }

    @Override
    public EventsCmd withImageFilter(String ... image) {
        Preconditions.checkNotNull((Object)image, (Object)"image have not been specified");
        this.filters.withImages(image);
        return this;
    }

    @Override
    public EventsCmd withEventFilter(String ... event) {
        Preconditions.checkNotNull((Object)event, (Object)"event have not been specified");
        this.filters.withFilter("event", event);
        return this;
    }

    @Override
    public EventsCmd withLabelFilter(String ... label) {
        Preconditions.checkNotNull((Object)label, (Object)"label have not been specified");
        this.filters.withLabels(label);
        return this;
    }

    @Override
    public EventsCmd withLabelFilter(Map<String, String> labels) {
        Preconditions.checkNotNull(labels, (Object)"labels have not been specified");
        this.filters.withLabels(labels);
        return this;
    }

    @Override
    public String getSince() {
        return this.since;
    }

    @Override
    public String getUntil() {
        return this.until;
    }

    @Override
    public Map<String, List<String>> getFilters() {
        return this.filters.build();
    }
}

