/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.config;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterDescriptor;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.TslintUtil;
import com.intellij.lang.javascript.linter.tslint.codestyle.TsLintCodeStyleImporter;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class TsLintDescriptor
extends JSLinterDescriptor {
    public static final String PACKAGE_NAME = "tslint";

    @NotNull
    public String getDisplayName() {
        String string = TsLintBundle.message("settings.javascript.linters.tslint.configurable.name", new Object[0]);
        if (string == null) {
            TsLintDescriptor.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String packageName() {
        return PACKAGE_NAME;
    }

    public boolean supportsMultipleRoots() {
        return true;
    }

    public boolean hasConfigFiles(@NotNull Project project) {
        if (project == null) {
            TsLintDescriptor.$$$reportNull$$$0(1);
        }
        return TslintUtil.hasConfigFiles(project);
    }

    public boolean enable(@NotNull Project project, Collection<PackageJsonData> packageJsonFiles) {
        if (project == null) {
            TsLintDescriptor.$$$reportNull$$$0(2);
        }
        if (ContainerUtil.or(packageJsonFiles, data -> data.isDependencyOfAnyType("tslint-language-service") || data.isDependencyOfAnyType("typescript-tslint-plugin"))) {
            return false;
        }
        return super.enable(project, packageJsonFiles);
    }

    public void importSettings(@NotNull Project project, @NotNull JSLinterGuesser.EnableCase enableCase) {
        if (project == null) {
            TsLintDescriptor.$$$reportNull$$$0(3);
        }
        if (enableCase == null) {
            TsLintDescriptor.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        VirtualFile config = JSLinterConfigFileUtil.findDistinctConfigInContentRoots((Project)project, Arrays.asList(TslintUtil.CONFIG_FILE_NAMES));
        if (config == null) {
            return;
        }
        PsiFile file = PsiManager.getInstance((Project)project).findFile(config);
        if (file == null) {
            return;
        }
        new TsLintCodeStyleImporter(true).importConfigFileWhenToolInstalled(file);
    }

    @NotNull
    public Class<? extends JSLinterConfiguration> getConfigurationClass() {
        if (TsLintConfiguration.class == null) {
            TsLintDescriptor.$$$reportNull$$$0(5);
        }
        return TsLintConfiguration.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/config/TsLintDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/config/TsLintDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFiles";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "enable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

