/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker;

import com.google.common.base.Joiner;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.configuration.beans.common.RestartPolicy;
import com.intellij.docker.compose.remote.process.DockerComposeProcessUtil;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.plugins.remotesdk.RemoteProcessUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.docker.PyDockerProcessUtil;
import com.jetbrains.python.docker.PyDockerSkeletonGeneratorBase;
import com.jetbrains.python.docker.compose.PyDockerComposeProcessConnectionData;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDockerComposeSkeletonGenerator
extends PyDockerSkeletonGeneratorBase {
    private static final String ROOT_USER_ID = "0";
    private static final String IDLE_SCRIPT = "idle.py";
    private static final String IDLE_SCRIPT_STARTED_MESSAGE = "Idle script started";

    public PyDockerComposeSkeletonGenerator(@Nullable Project project, @NotNull String skeletonsPath, @NotNull Sdk sdk) {
        if (skeletonsPath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(1);
        }
        super(project, skeletonsPath, sdk);
    }

    @NotNull
    protected ProcessOutput getProcessOutput(@NotNull String homePath, @NotNull String[] commandLine, @Nullable Map<String, String> extraEnv, int timeout) throws InvalidSdkException {
        ProcessOutput processOutput;
        if (homePath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(2);
        }
        if (commandLine == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(3);
        }
        Object[] extendedCommandLine = PyDockerComposeSkeletonGenerator.addUnbuffered((String)homePath, (String[])commandLine);
        try {
            ComposeServiceRunCmd serviceRunCmd = this.buildDockerComposeRunCmd(extraEnv, (String[])extendedCommandLine).withRemove(true);
            processOutput = new CapturingProcessRunner((BaseProcessHandler)serviceRunCmd.execute()).runProcess(timeout);
        }
        catch (ProcessNotCreatedException e) {
            LOG.debug("Unable to execute command ", new Object[]{Joiner.on((String)" ").join(extendedCommandLine), e});
            DockerComposeCliUtil.notifyDockerComposeExecutionFailed((Project)this.getProject(), (ProcessNotCreatedException)e);
            throw PyDockerComposeSkeletonGenerator.propagateRecoverableException((Exception)((Object)e));
        }
        catch (ExecutionException | ServerRuntimeException | IOException e) {
            LOG.debug("Unable to execute command ", new Object[]{Joiner.on((String)" ").join(extendedCommandLine), e});
            throw PyDockerComposeSkeletonGenerator.propagateRecoverableException((Exception)e);
        }
        if (processOutput == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(4);
        }
        return processOutput;
    }

    @NotNull
    private ComposeServiceRunCmd buildDockerComposeRunCmd(@Nullable Map<String, String> extraEnv, @NotNull String[] extendedCommandLine) throws ServerRuntimeException, RemoteSdkException, IOException {
        if (extendedCommandLine == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(5);
        }
        PyDockerComposeProcessConnectionData data = this.getProcessConnectionData();
        PyRemotePathMapper pathMapper = this.createPathMappings(this.getProject(), (PyRemoteSdkAdditionalDataBase)this.getRemoteSdkAdditionalData());
        Pair commandWithWorkingDir = RemoteProcessUtil.buildRemoteCommandLine((AbstractPathMapper)pathMapper, (String[])extendedCommandLine, null, (String)data.getInterpreterPath());
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)this.getProject());
        SharedVolume helpersSharedVolume = PyDockerProcessUtil.getPyCharmHelpersSharedVolume(dockerRuntime);
        String skeletonsVolume = this.prepareSkeletonsVolume();
        VolumesBuilder volumesBinds = VolumesBuilder.builder();
        volumesBinds.addBoundVolume(this.getRemoteSkeletonsPath(), skeletonsVolume);
        ComposeServiceRunCmd composeServiceRunCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime).runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withServiceName(data.getComposeServiceName())).withCommand((String[])commandWithWorkingDir.getFirst())).withWorkingDir((String)commandWithWorkingDir.getSecond())).withEnvironment(extraEnv)).withSharedVolume(helpersSharedVolume)).withVolumes(volumesBinds.build())).withRestartPolicy((RestartPolicy)RestartPolicy.noRestart());
        if (composeServiceRunCmd == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(6);
        }
        return composeServiceRunCmd;
    }

    @NotNull
    private RemoteDockerApplicationRuntime createIdleContainer(@NotNull String binaryPath) throws ServerRuntimeException, ExecutionException, IOException {
        String containerName;
        RemoteDockerRuntime dockerRuntime;
        RemoteDockerApplicationRuntime obsoleteContainer;
        if (binaryPath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(7);
        }
        if ((obsoleteContainer = (dockerRuntime = this.createDockerRuntime()).findContainerByName(containerName = "skeleton_generator_" + FileUtil.toSystemIndependentName((String)this.getSdk().getHomePath()).hashCode())) != null) {
            LOG.debug("Obsolete skeleton generation container " + containerName + " found and it will be removed");
            obsoleteContainer.removeContainer();
        }
        LOG.debug("Preparing idle container " + containerName + " for skeleton generation");
        String[] commandLine = new String[]{binaryPath, PythonHelpersLocator.getHelperPath((String)IDLE_SCRIPT), IDLE_SCRIPT_STARTED_MESSAGE};
        String parentDir = new File(binaryPath).getParent();
        String[] extendedCommandLine = PyDockerComposeSkeletonGenerator.addUnbuffered((String)parentDir, (String[])commandLine);
        Map env = PythonEnvUtil.setPythonUnbuffered(new HashMap());
        ComposeServiceRunCmd serviceRunCmd = this.buildDockerComposeRunCmd(env, extendedCommandLine).withName(containerName).withRemove(true);
        KillableColoredProcessHandler processHandler = serviceRunCmd.execute();
        final CountDownLatch latch = new CountDownLatch(1);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                latch.countDown();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/docker/PyDockerComposeSkeletonGenerator$1", "processTerminated"));
            }
        });
        processHandler.addColoredTextListener((text, attributes) -> {
            if (text.contains(IDLE_SCRIPT_STARTED_MESSAGE)) {
                latch.countDown();
            }
        });
        processHandler.startNotify();
        try {
            LOG.debug("Waiting for the Idle script started message from the container " + containerName);
            latch.await();
        }
        catch (InterruptedException e) {
            throw new ExecutionException((Throwable)e);
        }
        if (processHandler.isProcessTerminated()) {
            throw new ExecutionException("The docker-compose process terminated unexpectedly: " + processHandler.getCommandLine());
        }
        RemoteDockerApplicationRuntime container = dockerRuntime.findContainerByName(containerName);
        if (container == null) {
            throw new ExecutionException("Skeleton generation container " + containerName + " could not be found");
        }
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = container;
        if (remoteDockerApplicationRuntime == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(8);
        }
        return remoteDockerApplicationRuntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessOutput runSkeletonGeneration(@NotNull String modname, @Nullable String modfilename, @Nullable List<String> assemblyRefs, @NotNull String binaryPath, @Nullable String extraSyspath) throws InvalidSdkException {
        if (modname == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(9);
        }
        if (binaryPath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(10);
        }
        PyDockerComposeProcessConnectionData data = this.getProcessConnectionData();
        try {
            RemoteDockerApplicationRuntime skeletonGenerationContainer;
            Object object = this.getSkeletonGenerationContainerLock();
            synchronized (object) {
                skeletonGenerationContainer = this.getSkeletonGenerationContainer();
                if (skeletonGenerationContainer == null) {
                    skeletonGenerationContainer = this.createIdleContainer(binaryPath);
                    this.setSkeletonGenerationContainer(skeletonGenerationContainer);
                }
            }
            String parentDir = new File(binaryPath).getParent();
            List commandLine = this.buildSkeletonGeneratorCommandLine(modname, modfilename, assemblyRefs, binaryPath, extraSyspath);
            String[] extendedCommandLine = PyDockerComposeSkeletonGenerator.addUnbuffered((String)parentDir, (String[])ArrayUtilRt.toStringArray((Collection)commandLine));
            PyRemotePathMapper pathMapper = this.createPathMappings(this.getProject(), (PyRemoteSdkAdditionalDataBase)this.getRemoteSdkAdditionalData());
            Pair commandWithWorkingDir = RemoteProcessUtil.buildRemoteCommandLine((AbstractPathMapper)pathMapper, (String[])extendedCommandLine, null, (String)data.getInterpreterPath());
            return skeletonGenerationContainer.exec((String[])commandWithWorkingDir.first);
        }
        catch (ProcessNotCreatedException e) {
            LOG.debug("Skeleton generation for " + modname + " failed", (Throwable)e);
            DockerComposeCliUtil.notifyDockerComposeExecutionFailed((Project)this.getProject(), (ProcessNotCreatedException)e);
            throw PyDockerComposeSkeletonGenerator.propagateRecoverableException((Exception)((Object)e));
        }
        catch (ExecutionException | ServerRuntimeException | IOException e) {
            LOG.debug("Skeleton generation for " + modname + " failed", e);
            throw PyDockerComposeSkeletonGenerator.propagateRecoverableException((Exception)e);
        }
    }

    @Override
    @NotNull
    protected String setupSkeletonsVolume() throws ExecutionException, ServerRuntimeException {
        String volumeName = this.getSkeletonsVolumeName();
        PyDockerComposeProcessConnectionData data = this.getProcessConnectionData();
        String serviceName = data.getComposeServiceName();
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)this.getProject());
        String user = PyDockerComposeSkeletonGenerator.getServiceUser(dockerRuntime, data, serviceName);
        if (StringUtil.isNotEmpty((String)user)) {
            LOG.debug("User for service \"" + serviceName + "\" is " + user + ", permissions setup for skeletons volume \"" + volumeName + "\" required");
            this.changeOwnerForVolume(dockerRuntime, data, user, volumeName);
        } else {
            LOG.debug("User for service \"" + serviceName + "\" is default (root)");
        }
        String string = volumeName;
        if (string == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(11);
        }
        return string;
    }

    private void changeOwnerForVolume(@NotNull RemoteDockerRuntime dockerComposeClient, @NotNull PyDockerComposeProcessConnectionData data, @NotNull String user, @NotNull String volumeName) throws RemoteSdkException {
        if (dockerComposeClient == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(12);
        }
        if (data == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(13);
        }
        if (user == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(14);
        }
        if (volumeName == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(15);
        }
        try {
            String serviceName = data.getComposeServiceName();
            VolumesBuilder volumesBinds = VolumesBuilder.builder();
            volumesBinds.addBoundVolume(this.getRemoteSkeletonsPath(), volumeName);
            DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerComposeClient);
            ComposeServiceRunCmd runServiceCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withUser("root")).withRemove(true).withServiceName(serviceName)).withCommand(new String[]{"chown", "-R", user, this.getRemoteSkeletonsPath()})).withVolumes(volumesBinds.build())).withRestartPolicy((RestartPolicy)RestartPolicy.noRestart());
            ProcessOutput serviceOutput = new CapturingProcessRunner((BaseProcessHandler)runServiceCmd.execute()).runProcess();
            if (!serviceOutput.checkSuccess(LOG)) {
                throw new RemoteSdkException("Failed to change permissions for skeletons volume");
            }
        }
        catch (ExecutionException | IOException e) {
            throw PyDockerComposeSkeletonGenerator.propagateRemoteSdkException("Failed to change owner of skeletons volume", e);
        }
    }

    @NotNull
    private static String getServiceUser(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull PyDockerComposeProcessConnectionData data, @NotNull String serviceName) throws ExecutionException {
        String string;
        if (dockerRuntime == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(16);
        }
        if (data == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(17);
        }
        if (serviceName == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(18);
        }
        try {
            DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
            ComposeServiceRunCmd runServiceCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withRemove(true).withServiceName(serviceName)).withCommand(new String[]{"id", "--user"});
            ProcessOutput processOutput = new CapturingProcessRunner((BaseProcessHandler)runServiceCmd.execute()).runProcess();
            string = PyDockerComposeSkeletonGenerator.extractServiceUserId(processOutput);
        }
        catch (IOException e) {
            throw PyDockerComposeSkeletonGenerator.propagateRemoteSdkException("Failed to get effective user for docker-compose service", e);
        }
        if (string == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Contract(value="_, _ -> fail")
    @NotNull
    private static RemoteSdkException propagateRemoteSdkException(@NotNull String message, @NotNull Throwable t) throws RemoteSdkException {
        if (message == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(20);
        }
        if (t == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(21);
        }
        StringBuilder builder = new StringBuilder(message);
        String localizedMessageOfCause = t.getLocalizedMessage();
        if (StringUtil.isNotEmpty((String)localizedMessageOfCause)) {
            builder.append(":\n").append(localizedMessageOfCause);
        }
        throw new RemoteSdkException(builder.toString(), t);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    static String extractServiceUserId(@NotNull ProcessOutput processOutput) {
        String string;
        Throwable throwable;
        Scanner scanner;
        block20: {
            if (processOutput == null) {
                PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(22);
            }
            if (!processOutput.checkSuccess(LOG)) return ROOT_USER_ID;
            String stdout = processOutput.getStdout().trim();
            scanner = new Scanner(stdout);
            throwable = null;
            try {
                String lastLine = null;
                while (scanner.hasNextLine()) {
                    lastLine = scanner.nextLine();
                }
                if (lastLine != null) {
                    try {
                        String string2 = String.valueOf(Long.parseLong(lastLine));
                        string = string2;
                        break block20;
                    }
                    catch (NumberFormatException e) {
                        LOG.debug("The last line of Docker Compose stdout does not contain effective user ID: " + lastLine);
                        return ROOT_USER_ID;
                    }
                }
                LOG.debug("Docker Compose stdout of the command to get effective user ID is empty");
                return ROOT_USER_ID;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        if (string != null) return string;
        PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(23);
        return string;
        finally {
            if (scanner != null) {
                if (throwable != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    scanner.close();
                }
            }
        }
    }

    @NotNull
    private PyDockerComposeProcessConnectionData getProcessConnectionData() {
        PyRemoteSdkAdditionalData sdkAdditionalData = this.getRemoteSdkAdditionalData();
        PyDockerComposeProcessConnectionData pyDockerComposeProcessConnectionData = PyDockerProcessUtil.getPyDockerComposeProcessConnectionData((PyRemoteSdkAdditionalDataBase)sdkAdditionalData);
        if (pyDockerComposeProcessConnectionData == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(25);
        }
        return pyDockerComposeProcessConnectionData;
    }

    @Override
    @NotNull
    protected RemoteDockerRuntime createDockerRuntime() throws ServerRuntimeException, RemoteSdkException {
        RemoteDockerRuntime remoteDockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)this.getProcessConnectionData().getAccount(), (Project)this.getProject());
        if (remoteDockerRuntime == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(26);
        }
        return remoteDockerRuntime;
    }

    @Override
    protected void doDownloadSources(@NotNull String srcRemotePath, @NotNull File targetLocalDir, @NotNull VolumesBuilder volumesBinds, @Nullable Map<String, String> map) throws IOException, RemoteSdkException, ServerRuntimeException {
        RemoteDockerApplicationRuntime serviceApplicationRuntime;
        if (srcRemotePath == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(27);
        }
        if (targetLocalDir == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(28);
        }
        if (volumesBinds == null) {
            PyDockerComposeSkeletonGenerator.$$$reportNull$$$0(29);
        }
        PyDockerComposeProcessConnectionData data = this.getProcessConnectionData();
        RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)this.getProject());
        DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
        ComposeServiceRunCmd runServiceCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withServiceName(data.getComposeServiceName())).withCommand(new String[]{"/bin/true"})).withVolumes(volumesBinds.build())).withRestartPolicy((RestartPolicy)RestartPolicy.noRestart());
        try {
            String containerName = runServiceCmd.execDetached();
            serviceApplicationRuntime = DockerComposeProcessUtil.getDockerComposeContainer((RemoteDockerRuntime)dockerRuntime, (String)containerName);
        }
        catch (RemoteSdkException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw new RemoteSdkException("Download failed");
        }
        serviceApplicationRuntime.downloadDirectoryAndRemove(srcRemotePath, targetLocalDir, map, data.getAccount().getMachine());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skeletonsPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/docker/PyDockerComposeSkeletonGenerator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendedCommandLine";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modname";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeClient";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumeName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutput";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcRemotePath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLocalDir";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumesBinds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/docker/PyDockerComposeSkeletonGenerator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDockerComposeRunCmd";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createIdleContainer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setupSkeletonsVolume";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceUser";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "extractServiceUserId";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessConnectionData";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createDockerRuntime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildDockerComposeRunCmd";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createIdleContainer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runSkeletonGeneration";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "changeOwnerForVolume";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getServiceUser";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "propagateRemoteSdkException";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extractServiceUserId";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doDownloadSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

