/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker.compose.console;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposePort;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.runtime.WrappedInternalServerErrorException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathMapper;
import com.jetbrains.plugins.remotesdk.RemoteProcessUtil;
import com.jetbrains.python.docker.PyDockerProcessUtil;
import com.jetbrains.python.docker.compose.PyDockerComposeProcessConnectionData;
import com.jetbrains.python.docker.compose.PyDockerComposeProcessUtil;
import com.jetbrains.python.remote.PyCommandLineStateUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PySshCommandLineStateUtil;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006\r"}, d2={"startDockerComposeProcess", "Lcom/intellij/execution/process/BaseOSProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "sdkAdditionalData", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "portBindings", "", "Lcom/intellij/docker/compose/configuration/beans/common/DockerComposePort;", "intellij.python.docker"})
public final class PythonConsoleDockerComposeProcessCreatorKt {
    private static final BaseOSProcessHandler startDockerComposeProcess(Project project, GeneralCommandLine commandLine, PyRemoteSdkAdditionalDataBase sdkAdditionalData, PyRemotePathMapper pathMapper, List<DockerComposePort> portBindings) {
        String string;
        ParamsGroup coverageParams;
        ParamsGroup profileParams;
        PyDockerComposeProcessConnectionData pyDockerComposeProcessConnectionData = PyDockerProcessUtil.getPyDockerComposeProcessConnectionData(sdkAdditionalData);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyDockerComposeProcessConnectionData), (String)"PyDockerProcessUtil.getP\u2026onData(sdkAdditionalData)");
        PyDockerComposeProcessConnectionData data = pyDockerComposeProcessConnectionData;
        ParamsGroup exeGroup = commandLine.getParametersList().getParamsGroup("Exe Options");
        if (exeGroup != null) {
            PythonRemoteInterpreterManager.addUnbuffered((ParamsGroup)exeGroup);
        }
        PyRemoteSocketToLocalHostProvider pyRemoteSocketToLocalHostProvider = data.getPyRemoteSocketToLocalHostProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)pyRemoteSocketToLocalHostProvider, (String)"data.pyRemoteSocketToLocalHostProvider");
        PyRemoteSocketToLocalHostProvider dockerSocketProvider = pyRemoteSocketToLocalHostProvider;
        ParamsGroup debugParams = commandLine.getParametersList().getParamsGroup("Debugger");
        if (debugParams != null && debugParams.getParameters().size() > 0) {
            PySshCommandLineStateUtil.patchDebugParams((String)data.getHelpersPath(), (PyRemoteSocketToLocalHostProvider)dockerSocketProvider, (ParamsGroup)debugParams);
        }
        if ((profileParams = commandLine.getParametersList().getParamsGroup("Profiler")) != null && profileParams.getParameters().size() > 0) {
            PySshCommandLineStateUtil.patchProfileParams((String)data.getInterpreterPath(), (PyRemoteSocketToLocalHostProvider)dockerSocketProvider, (ParamsGroup)profileParams, (File)commandLine.getWorkDirectory(), (PathMapper)((PathMapper)pathMapper));
        }
        if ((coverageParams = commandLine.getParametersList().getParamsGroup("Coverage")) != null && coverageParams.getParameters().size() > 0) {
            PySshCommandLineStateUtil.patchCoverageParams((String)data.getInterpreterPath(), (ParamsGroup)coverageParams, (File)commandLine.getWorkDirectory(), (PathMapper)((PathMapper)pathMapper));
        }
        PyCommandLineStateUtil.remap((String)data.getInterpreterPath(), (GeneralCommandLine)commandLine, (PathMapper)((PathMapper)pathMapper));
        if (commandLine.getWorkDirectory() != null) {
            File file = commandLine.getWorkDirectory();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"commandLine.workDirectory");
            commandLine.setWorkDirectory(pathMapper.convertToRemote(file.getPath()));
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)commandLine.getCommandLineList(null));
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"ArrayUtil.toStringArray(\u2026getCommandLineList(null))");
        String[] command = stringArray;
        if (commandLine.getWorkDirectory() != null) {
            File file = commandLine.getWorkDirectory();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"commandLine.workDirectory");
            string = file.getPath();
        } else {
            string = null;
        }
        String workingDir = string;
        VolumesBuilder volumesBuilder = PyDockerComposeProcessUtil.setupVolumeBinds(project, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)volumesBuilder, (String)"setupVolumeBinds(project, null)");
        VolumesBuilder volumesBinds = volumesBuilder;
        Pair commandWithWorkingDir = RemoteProcessUtil.buildRemoteCommandLine((AbstractPathMapper)((AbstractPathMapper)pathMapper), (String[])command, (String)workingDir, (String)data.getInterpreterPath());
        Map map = commandLine.getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"commandLine.environment");
        Map env = MapsKt.toMutableMap((Map)map);
        PythonEnvUtil.setPythonUnbuffered((Map)env);
        try {
            RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)project);
            SharedVolume sharedVolume = PyDockerProcessUtil.getPyCharmHelpersSharedVolume(dockerRuntime);
            Intrinsics.checkExpressionValueIsNotNull((Object)sharedVolume, (String)"PyDockerProcessUtil.getP\u2026aredVolume(dockerRuntime)");
            SharedVolume helpersSharedVolume = sharedVolume;
            DockerComposeServiceClient dockerComposeServiceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
            Intrinsics.checkExpressionValueIsNotNull((Object)dockerComposeServiceClient, (String)"DockerComposeServiceClie\u2026etInstance(dockerRuntime)");
            DockerComposeServiceClient serviceClient = dockerComposeServiceClient;
            String[] stringArray2 = (String[])commandWithWorkingDir.getFirst();
            ComposeServiceRunCmd composeServiceRunCmd = ((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withServiceName(data.getComposeServiceName())).withEnvironment(env)).withCommand(Arrays.copyOf(stringArray2, stringArray2.length))).withWorkingDir((String)commandWithWorkingDir.getSecond())).withSharedVolume(helpersSharedVolume)).withPublishPorts(portBindings).withVolumes(PyDockerComposeProcessUtil.removeRepeatedContainerPaths(volumesBinds.build()))).withNoDeps(false).withRemove(true);
            Intrinsics.checkExpressionValueIsNotNull((Object)composeServiceRunCmd, (String)"serviceClient.runService\u2026)\n      .withRemove(true)");
            ComposeServiceRunCmd runServiceCmd = composeServiceRunCmd;
            KillableColoredProcessHandler killableColoredProcessHandler = runServiceCmd.execute();
            Intrinsics.checkExpressionValueIsNotNull((Object)killableColoredProcessHandler, (String)"runServiceCmd.execute()");
            return (BaseOSProcessHandler)killableColoredProcessHandler;
        }
        catch (WrappedInternalServerErrorException e) {
            RemoteSdkException remoteSdkException = DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((ServerRuntimeException)((Object)e)));
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)remoteSdkException), (String)"DockerUtil.propagateInte\u2026alServerErrorException(e)");
            throw (Throwable)remoteSdkException;
        }
        catch (ServerRuntimeException e) {
            RemoteSdkException remoteSdkException = DockerUtil.propagateRemoteSdkException((Throwable)e);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)remoteSdkException), (String)"DockerUtil.propagateRemoteSdkException(e)");
            throw (Throwable)remoteSdkException;
        }
        catch (IOException e) {
            RemoteSdkException remoteSdkException = DockerUtil.propagateRemoteSdkException((Throwable)e);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)remoteSdkException), (String)"DockerUtil.propagateRemoteSdkException(e)");
            throw (Throwable)remoteSdkException;
        }
    }

    public static final /* synthetic */ BaseOSProcessHandler access$startDockerComposeProcess(Project project, GeneralCommandLine commandLine, PyRemoteSdkAdditionalDataBase sdkAdditionalData, PyRemotePathMapper pathMapper, List portBindings) {
        return PythonConsoleDockerComposeProcessCreatorKt.startDockerComposeProcess(project, commandLine, sdkAdditionalData, pathMapper, portBindings);
    }
}

