/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker.run;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerInterpreterContainerSettingsEditorDialog;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.docker.run.PyRunConfigurationDockerSettingsEditorExtension;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerContainerCliSettingsEditor
extends SettingsEditor<AbstractPythonRunConfiguration> {
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myCliField;
    @NotNull
    private final Project myProject;
    private DockerContainerSettings myCurrentSettings;
    private RemoteServer<?> myCurrentServer;

    public DockerContainerCliSettingsEditor(@NotNull Project project) {
        if (project == null) {
            DockerContainerCliSettingsEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCurrentSettings = DockerContainerSettings.defaultSettings((Project)project);
        this.myCliField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerContainerCliSettingsEditor.this.showContainerSettingsEditor();
            }
        });
    }

    private void showContainerSettingsEditor() {
        DockerInterpreterContainerSettingsEditorDialog myDialog = new DockerInterpreterContainerSettingsEditorDialog(this.myProject, this.myCurrentServer, this.myCurrentSettings);
        if (myDialog.showAndGet()) {
            this.myCliField.setText(DockerContainerSettings.settingsToCli((DockerContainerSettings)this.myCurrentSettings));
        }
    }

    protected void resetEditorFrom(@NotNull AbstractPythonRunConfiguration s) {
        DockerContainerSettings data;
        if (s == null) {
            DockerContainerCliSettingsEditor.$$$reportNull$$$0(1);
        }
        this.myCurrentSettings = (data = (DockerContainerSettings)s.getCopyableUserData(DockerContainerSettings.KEY)) == null ? DockerContainerSettings.defaultSettings((Project)this.myProject) : data.clone();
        this.myCurrentServer = DockerContainerCliSettingsEditor.tryGetServer(s);
        this.myCliField.setText(DockerContainerSettings.settingsToCli((DockerContainerSettings)this.myCurrentSettings));
    }

    @Nullable
    private static RemoteServer<?> tryGetServer(AbstractPythonRunConfiguration s) {
        String accountName;
        DockerCredentialsHolder credentials = PyRunConfigurationDockerSettingsEditorExtension.tryGetDockerCredentials(s);
        if (credentials != null && StringUtil.isNotEmpty((String)(accountName = credentials.getAccountName()))) {
            return RemoteServersManager.getInstance().findByName(accountName, (ServerType)DockerCloudType.getInstance());
        }
        return null;
    }

    protected void applyEditorTo(@NotNull AbstractPythonRunConfiguration s) throws ConfigurationException {
        if (s == null) {
            DockerContainerCliSettingsEditor.$$$reportNull$$$0(2);
        }
        s.putCopyableUserData(DockerContainerSettings.KEY, (Object)this.myCurrentSettings);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DockerContainerCliSettingsEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/docker/run/DockerContainerCliSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/docker/run/DockerContainerCliSettingsEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Docker container settings:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCliField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEditable(false);
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

