/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Vm;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.WipVmKt;
import org.jetbrains.wip.WipWorkerCommandProcessor;
import org.jetbrains.wip.WipWorkerVm;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.runtime.RuntimeKt;
import org.jetbrains.wip.protocol.serviceworker.ServiceWorkerKt;
import org.jetbrains.wip.protocol.target.AttachedToTargetEventData;
import org.jetbrains.wip.protocol.target.DetachedFromTargetEventData;
import org.jetbrains.wip.protocol.target.ReceivedMessageFromTargetEventData;
import org.jetbrains.wip.protocol.target.TargetKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000bJ\u0016\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R*\u0010\u0007\u001a\u001e\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/wip/WipWorkerManager;", "", "vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "getVm", "()Lorg/jetbrains/wip/WipVm;", "workers", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/wip/WipWorkerVm;", "enableWorkers", "", "prepareWorkerForDebugging", "worker", "registerWorkerEvents", "eventMap", "Lorg/jetbrains/jsonProtocol/EventMap;", "Lorg/jetbrains/wip/protocol/ProtocolResponseReader;", "workerCreated", "workerVm", "workerMessageReceived", "workerId", "message", "workerTerminated", "id", "intellij.javascript.wip.backend"})
public class WipWorkerManager {
    private final ConcurrentMap<String, WipWorkerVm> workers;
    @NotNull
    private final WipVm vm;

    public void enableWorkers() {
        this.vm.getCommandProcessor().send((Request)TargetKt.SetAutoAttach(true, true));
        this.vm.getCommandProcessor().send((Request)ServiceWorkerKt.Enable());
    }

    public final void workerCreated(@NotNull WipWorkerVm workerVm2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)workerVm2), (String)"workerVm");
        String id = workerVm2.getId();
        WipWorkerVm wipWorkerVm = (WipWorkerVm)((Object)this.workers.remove(id));
        if (wipWorkerVm != null) {
            wipWorkerVm.terminate();
        }
        ((Map)this.workers).put(id, workerVm2);
        this.prepareWorkerForDebugging(workerVm2);
        this.vm.getChildVMs().add(workerVm2);
    }

    private final void prepareWorkerForDebugging(WipWorkerVm worker) {
        WipVmKt.enableConsole(worker.getCommandProcessor());
        worker.getCommandProcessor().send((Request)DebuggerKt.Enable());
        worker.enableWorkers();
        this.vm.getDebugListener().childVmAdded((Vm)worker);
        worker.getCommandProcessor().send((Request)RuntimeKt.RunIfWaitingForDebugger());
    }

    public final void workerTerminated(@NotNull String id) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            WipWorkerVm wipWorkerVm = (WipWorkerVm)((Object)this.workers.remove(id));
            if (wipWorkerVm == null) break block0;
            WipWorkerVm wipWorkerVm2 = wipWorkerVm;
            boolean bl = false;
            boolean bl2 = false;
            WipWorkerVm it = wipWorkerVm2;
            boolean bl3 = false;
            this.vm.getChildVMs().remove((Object)it);
            it.terminate();
        }
    }

    public final void workerMessageReceived(@NotNull String workerId, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)workerId, (String)"workerId");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Object object = (WipWorkerVm)((Object)this.workers.get(workerId));
        if (object == null || (object = object.getCommandProcessor()) == null) {
            return;
        }
        WipWorkerVm processor = object;
        ((WipCommandProcessor)((Object)processor)).processIncomingJson(new JsonReaderEx((CharSequence)message));
    }

    public void registerWorkerEvents(@NotNull EventMap<ProtocolResponseReader> eventMap) {
        Intrinsics.checkParameterIsNotNull(eventMap, (String)"eventMap");
        eventMap.add((EventType)AttachedToTargetEventData.TYPE, (Function1)new Function1<AttachedToTargetEventData, Unit>(this){
            final /* synthetic */ WipWorkerManager this$0;

            public final void invoke(@NotNull AttachedToTargetEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.workerCreated(new WipWorkerVm(it.sessionId(), it.targetInfo().url(), this.this$0.getVm().getDebugListener(), new WipWorkerCommandProcessor(it.sessionId(), this.this$0.getVm().getCommandProcessor()), null, 16, null));
            }
            {
                this.this$0 = wipWorkerManager;
                super(1);
            }
        });
        eventMap.add((EventType)DetachedFromTargetEventData.TYPE, (Function1)new Function1<DetachedFromTargetEventData, Unit>(this){
            final /* synthetic */ WipWorkerManager this$0;

            public final void invoke(@NotNull DetachedFromTargetEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.workerTerminated(it.sessionId());
            }
            {
                this.this$0 = wipWorkerManager;
                super(1);
            }
        });
        eventMap.add((EventType)ReceivedMessageFromTargetEventData.TYPE, (Function1)new Function1<ReceivedMessageFromTargetEventData, Unit>(this){
            final /* synthetic */ WipWorkerManager this$0;

            public final void invoke(@NotNull ReceivedMessageFromTargetEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.workerMessageReceived(it.sessionId(), it.message());
            }
            {
                this.this$0 = wipWorkerManager;
                super(1);
            }
        });
    }

    @NotNull
    protected final WipVm getVm() {
        return this.vm;
    }

    public WipWorkerManager(@NotNull WipVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurr\u2026ap<String, WipWorkerVm>()");
        this.workers = concurrentMap;
    }
}

