/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.command.TopContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.StreamType;
import com.github.dockerjava.core.command.AttachContainerResultCallback;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.github.dockerjava.core.command.WaitContainerResultCallback;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.AuthConfigEx;
import com.intellij.docker.agent.CreateContainerCmdConfig;
import com.intellij.docker.agent.CreateContainerCmdInspection;
import com.intellij.docker.agent.CreateContainerCmdValueTransfers;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentContainerConfigImpl;
import com.intellij.docker.agent.DockerAgentContainerImpl;
import com.intellij.docker.agent.DockerAgentContainerInspectionImpl;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.OngoingProcessBase;
import com.intellij.docker.agent.PushImageResultCallbackImpl;
import com.intellij.docker.agent.StreamCallbackBase;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import com.intellij.docker.agent.tty.ResizeContainerCmd;
import com.intellij.docker.agent.tty.ResizeDockerCmd;
import com.intellij.docker.agent.tty.ResizeExecCmd;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.log.LogPipe;
import com.intellij.remoteServer.agent.util.log.LogPipeBase;
import com.intellij.remoteServer.agent.util.log.LogPipeProvider;
import com.intellij.remoteServer.agent.util.log.TerminalListener;
import com.intellij.remoteServer.agent.util.log.TerminalPipe;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerAgentApplicationBase
implements DockerAgentApplication {
    private static final Logger LOG = Logger.getLogger((String)"#com.intellij.docker.DockerServerRuntimeInstance");
    private final DockerAgentContext myContext;
    private String myContainerId;
    private Map<String, String> myContainerLabels;

    public DockerAgentApplicationBase(DockerAgentContext context) {
        this.myContext = context;
    }

    protected final DockerClient getClient() {
        return this.myContext.getClient();
    }

    protected final CloudAgentErrorHandler getErrorHandler() {
        return this.myContext.getErrorHandler();
    }

    protected final CloudAgentLogger getLogger() {
        return this.myContext.getLogger();
    }

    protected final DockerAgent getAgent() {
        return this.myContext.getAgent();
    }

    public String getContainerId() {
        return this.myContainerId;
    }

    protected void setContainerId(String containerId) {
        this.myContainerId = containerId;
    }

    public final Map<String, String> getContainerLabels() {
        return this.myContainerLabels;
    }

    protected void setContainerLabels(@Nullable Map<String, String> containerLabels) {
        this.myContainerLabels = containerLabels == null ? null : new HashMap<String, String>(containerLabels);
    }

    public void startContainer() {
        new StateChangeTaskBase(this.getErrorHandler()){

            @Override
            protected void doPerformStateChange() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().startContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
            }
        }.perform();
    }

    public void stopContainer() {
        this.stopContainerImmediate(this.getErrorHandler());
    }

    public void stopContainerImmediate(CloudAgentErrorHandler errorHandler) {
        new StateChangeTaskBase(errorHandler){

            @Override
            protected void doPerformStateChange() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().stopContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
            }
        }.perform();
    }

    public void killContainer(CloudAgentErrorHandler errorHandler) {
        new StateChangeTaskBase(errorHandler){

            @Override
            protected void doPerformStateChange() {
                DockerAgentApplicationBase.this.getClient().killContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
            }
        }.perform();
    }

    public void deleteContainer() {
        new ApiTaskBase<Void>(this.getErrorHandler()){

            @Override
            protected Void doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().removeContainerCmd(DockerAgentApplicationBase.this.getContainerId()).withForce(Boolean.valueOf(true)).exec();
                return null;
            }
        }.perform();
    }

    public void deleteContainerWithVolumes() {
        new ApiTaskBase<Void>(this.getErrorHandler()){

            @Override
            protected Void doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().removeContainerCmd(DockerAgentApplicationBase.this.getContainerId()).withForce(Boolean.valueOf(true)).withRemoveVolumes(Boolean.valueOf(true)).exec();
                return null;
            }
        }.perform();
    }

    public void deleteImage() {
        new ApiTaskBase<Void>(this.getErrorHandler()){

            @Override
            protected Void doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().removeImageCmd(DockerAgentApplicationBase.this.getImageId()).withForce(Boolean.valueOf(true)).exec();
                return null;
            }
        }.perform();
    }

    public String createContainer() {
        return (String)new ApiTaskBase<String>(this.getErrorHandler()){

            @Override
            protected String doPerform() throws IOException, ApiTaskException {
                CreateContainerCmd createContainerCmd = DockerAgentApplicationBase.this.getClient().createContainerCmd(DockerAgentApplicationBase.this.getImageId());
                CreateContainerResponse createContainerResponse = createContainerCmd.exec();
                String containerId = createContainerResponse.getId();
                StartContainerCmd startContainerCmd = DockerAgentApplicationBase.this.getClient().startContainerCmd(containerId);
                startContainerCmd.exec();
                return containerId;
            }
        }.perform();
    }

    public String getWebUrl() {
        throw new UnsupportedOperationException();
    }

    public void showLog(final CloudAgentLoggingHandler loggingHandler) {
        new ApiTaskBase<Object>(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.doShowLog(DockerAgentApplicationBase.this.getContainerId(), loggingHandler);
                return null;
            }
        }.perform();
    }

    protected void doShowLog(String containerId, CloudAgentLoggingHandler loggingHandler) throws IOException, ApiTaskException {
        if (!this.myContext.getAgent().isConnected()) {
            return;
        }
        final DockerLogPipe logPipe = new DockerLogPipe(this.myContext, containerId, loggingHandler);
        this.myContext.getLogManager().startListeningLog(containerId, new LogPipeProvider(){

            public List<? extends LogPipe> createLogPipes(String deploymentName) {
                return Collections.singletonList(logPipe);
            }
        });
    }

    public String computeInspectJson() {
        return (String)new ApiTaskBase<String>(this.getErrorHandler()){

            @Override
            protected String doPerform() throws IOException, ApiTaskException {
                InspectContainerResponse response;
                if (DockerAgentApplicationBase.this.getContainerId() != null) {
                    response = DockerAgentApplicationBase.this.getClient().inspectContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                } else if (DockerAgentApplicationBase.this.getImageId() != null) {
                    response = DockerAgentApplicationBase.this.getClient().inspectImageCmd(DockerAgentApplicationBase.this.getImageId()).exec();
                } else {
                    throw new ApiTaskException(new IllegalStateException("Can't inspect, neither image nor container"));
                }
                ObjectMapper objectMapper = new ObjectMapper();
                String responseJson = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)response);
                assert (responseJson != null);
                return responseJson;
            }
        }.perform();
    }

    public DockerAgentContainerInspection inspect() {
        return (DockerAgentContainerInspection)new ApiTaskBase<DockerAgentContainerInspection>(this.getErrorHandler()){

            @Override
            protected DockerAgentContainerInspection doPerform() throws IOException, ApiTaskException {
                InspectContainerResponse inspectResponse = DockerAgentApplicationBase.this.getClient().inspectContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                CreateContainerCmdInspection inspection = new CreateContainerCmdInspection(inspectResponse);
                CreateContainerCmdConfig cmdConfig = new CreateContainerCmdConfig();
                String containerName = inspectResponse.getName();
                if (containerName != null) {
                    cmdConfig.withName(containerName);
                }
                CreateContainerCmdValueTransfers.createContainerCmdValueTransfer(binds -> DockerAgentApplicationBase.this.prepareBinds((Bind[])binds)).transferFromTo(inspection, (CreateContainerCmd)cmdConfig);
                return new DockerAgentContainerInspectionImpl((CreateContainerCmd)cmdConfig, inspectResponse.getState());
            }
        }.perform();
    }

    public String computeProcessesJson() {
        return (String)new ApiTaskBase<String>(this.getErrorHandler()){

            @Override
            protected String doPerform() throws IOException, ApiTaskException {
                TopContainerResponse response = DockerAgentApplicationBase.this.getClient().topContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                ObjectMapper objectMapper = new ObjectMapper();
                return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)response);
            }
        }.perform();
    }

    public void attach(final CloudAgentLoggingHandler loggingHandler) {
        new ApiTaskBase<Object>(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.doAttach(DockerAgentApplicationBase.this.getContainerId(), loggingHandler);
                return null;
            }
        }.perform();
    }

    protected void doAttach(String containerId, CloudAgentLoggingHandler loggingHandler) throws IOException, ApiTaskException {
        this.doAttachPipe(containerId, (LogPipeBase)new DockerAttachPipe(containerId, loggingHandler));
    }

    private void doAttachPipe(String containerId, final LogPipeBase attachPipe) throws IOException, ApiTaskException {
        if (!this.myContext.isConnected()) {
            return;
        }
        this.myContext.getLogManager().startListeningLog(containerId + " attach", new LogPipeProvider(){

            public List<? extends LogPipeBase> createLogPipes(String deploymentName) {
                return Collections.singletonList(attachPipe);
            }
        });
    }

    public OngoingProcess exec(final CloudAgentLoggingHandler loggingHandler, final String[] command, final String logName) {
        return (OngoingProcess)new ApiTaskBase<OngoingProcess>(this.getErrorHandler()){

            @Override
            protected OngoingProcess doPerform() throws IOException, ApiTaskException {
                return DockerAgentApplicationBase.this.doExec(loggingHandler, command, logName);
            }
        }.perform();
    }

    protected OngoingProcess doExec(CloudAgentLoggingHandler loggingHandler, String[] command, String logName) throws IOException, ApiTaskException {
        final DockerExecPipe execPipe = new DockerExecPipe(loggingHandler, command, logName);
        String pipeId = execPipe.getUniquePipeId();
        this.myContext.getLogManager().startListeningLog(pipeId, new LogPipeProvider(){

            public List<? extends LogPipeBase> createLogPipes(String deploymentName) {
                return Collections.singletonList(execPipe);
            }
        });
        return new OngoingProcessBase(this.getLogger()){

            public void cancel() {
                DockerAgentApplicationBase.this.stopContainerImmediate(this.getErrorHandler());
            }

            public void await() {
                DockerAgentApplicationBase.this.waitForExitImmediate(this.getErrorHandler());
            }
        };
    }

    public CompletableFuture<byte[]> captureExecOutput(String[] command, boolean includeErr) {
        String newExecId = this.createExec(false, command);
        try (ExecStartCmd execStartCmd = this.myContext.getClientExt().jerseyExecStartCmd(newExecId);){
            final ByteArrayOutputStream capturedOut = new ByteArrayOutputStream();
            ByteArrayOutputStream capturedErr = includeErr ? capturedOut : new ByteArrayOutputStream();
            final CompletableFuture<byte[]> promise = new CompletableFuture<byte[]>();
            execStartCmd.withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ExecStartResultCallback(capturedOut, capturedErr){

                public void onError(Throwable throwable) {
                    promise.completeExceptionally(throwable);
                    super.onError(throwable);
                }

                public void onComplete() {
                    if (!promise.isDone()) {
                        promise.complete(capturedOut.toByteArray());
                    }
                    super.onComplete();
                }
            });
            CompletableFuture<byte[]> completableFuture = promise;
            return completableFuture;
        }
    }

    public OngoingProcess pushImage(final DockerAgentRepositoryConfig repositoryConfig, final DockerAgentProgressCallback progressCallback) {
        return (OngoingProcess)new ApiTaskBase<OngoingProcess>(this.getErrorHandler()){

            @Override
            protected OngoingProcess doPerform() throws IOException, ApiTaskException {
                String repository = repositoryConfig.getQualifiedRepository();
                String tag = repositoryConfig.getTag();
                if (!this.hasImageTag()) {
                    TagImageCmd tagImageCmd = DockerAgentApplicationBase.this.getClient().tagImageCmd(DockerAgentApplicationBase.this.getImageId(), repository, tag);
                    tagImageCmd.exec();
                }
                PushImageCmd pushImageCmd = DockerAgentApplicationBase.this.getClient().pushImageCmd(repository);
                DockerAuthConfig customAuthConfig = repositoryConfig.getAuthConfig();
                if (customAuthConfig != null) {
                    pushImageCmd.withAuthConfig((AuthConfig)new AuthConfigEx(customAuthConfig));
                }
                if (tag != null) {
                    pushImageCmd.withTag(tag);
                }
                return (OngoingProcess)pushImageCmd.exec((ResultCallback)new PushImageResultCallbackImpl(progressCallback, DockerAgentApplicationBase.this.getLogger(), repositoryConfig.getQualifiedTag()));
            }

            private boolean hasImageTag() {
                return Arrays.asList(DockerAgentApplicationBase.this.getImageRepoTags()).contains(repositoryConfig.getQualifiedTag());
            }
        }.perform();
    }

    public DockerAgentApplication.ContainerUpdateResult updateContainer(final DockerAgentContainerConfig config) {
        return (DockerAgentApplication.ContainerUpdateResult)new ApiTaskBase<DockerAgentApplication.ContainerUpdateResult>(this.getErrorHandler()){

            @Override
            protected DockerAgentApplication.ContainerUpdateResult doPerform() throws IOException, ApiTaskException {
                DockerAgentApplication newAgentApplication;
                InspectContainerResponse inspectResponse = DockerAgentApplicationBase.this.getClient().inspectContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                ContainerUpdateResultImpl result = new ContainerUpdateResultImpl(DockerAgentApplicationBase.this.getImageId());
                String oldContainerId = DockerAgentApplicationBase.this.getContainerId();
                result.setRemovedContainerId(oldContainerId);
                DockerAgentApplicationBase.this.getClient().removeContainerCmd(oldContainerId).withForce(Boolean.TRUE).exec();
                CreateContainerCmdInspection inspection = new CreateContainerCmdInspection(inspectResponse);
                CreateContainerCmd createContainerCmd = DockerAgentApplicationBase.this.getClient().createContainerCmd(DockerAgentApplicationBase.this.getImageId());
                String containerName = inspectResponse.getName();
                if (containerName != null) {
                    createContainerCmd.withName(containerName);
                }
                CreateContainerCmdValueTransfers.createMergeForUpdate(binds -> DockerAgentApplicationBase.this.prepareBinds((Bind[])binds)).mergeWithPriority(new DockerAgentContainerConfigImpl(config), inspection, createContainerCmd);
                DockerAgentApplicationBase.this.setupContainerConfig(createContainerCmd);
                this.removeUnboundExposedPorts(createContainerCmd);
                CreateContainerResponse createContainerResponse = createContainerCmd.exec();
                String containerId = createContainerResponse.getId();
                DockerAgentApplicationBase.this.setContainerId(containerId);
                if (!DockerUtil.isStoppedStatus((String)DockerAgentApplicationBase.this.getContainerStatus())) {
                    DockerAgentApplicationBase.this.getClient().startContainerCmd(containerId).exec();
                }
                if ((newAgentApplication = DockerAgentApplicationBase.this.findContainer(containerId)) != null) {
                    result.setNewAgentApplication(newAgentApplication);
                }
                return result;
            }

            private void removeUnboundExposedPorts(CreateContainerCmd createContainerCmd) {
                Ports oldPorts = createContainerCmd.getHostConfig().getPortBindings();
                Ports newPorts = new Ports();
                for (Map.Entry next : oldPorts.getBindings().entrySet()) {
                    if (next.getValue() == null) continue;
                    for (Ports.Binding nextBinding : (Ports.Binding[])next.getValue()) {
                        newPorts.bind((ExposedPort)next.getKey(), nextBinding);
                    }
                }
                createContainerCmd.getHostConfig().withPortBindings(newPorts);
            }
        }.perform();
    }

    protected void setupContainerConfig(CreateContainerCmd target) {
        if (target.getHostConfig() != null && target.getHostConfig().getOomScoreAdj() != null) {
            target.getHostConfig().withOomScoreAdj(null);
        }
        DockerAgentApplicationBase.exposeAllBoundPorts(target);
    }

    protected Bind[] prepareBinds(Bind[] binds) {
        return binds;
    }

    public String getImageUser() {
        return (String)new ApiTaskBase<String>(this.getErrorHandler()){

            @Override
            protected String doPerform() throws IOException, ApiTaskException {
                return DockerAgentApplicationBase.this.getClient().inspectImageCmd(DockerAgentApplicationBase.this.getImageId()).exec().getConfig().getUser();
            }
        }.perform();
    }

    public InputStream copyArchiveFromContainer(final String sourceDirPath) {
        return (InputStream)new ApiTaskBase<InputStream>(this.getErrorHandler()){

            @Override
            protected InputStream doPerform() throws IOException, ApiTaskException {
                return DockerAgentApplicationBase.this.getClient().copyArchiveFromContainerCmd(DockerAgentApplicationBase.this.getContainerId(), sourceDirPath).exec();
            }
        }.perform();
    }

    public void copyArchiveToContainer(final String remoteDirPath, final String localDirPath) {
        new ApiTaskBase<Void>(this.getErrorHandler()){

            @Override
            protected Void doPerform() throws IOException, ApiTaskException {
                return DockerAgentApplicationBase.this.getClient().copyArchiveToContainerCmd(DockerAgentApplicationBase.this.getContainerId()).withHostResource(localDirPath).withRemotePath(remoteDirPath).exec();
            }
        }.perform();
    }

    public int waitForExit() {
        return this.waitForExitImmediate(this.getErrorHandler());
    }

    protected final DockerAgentApplication findContainer(@NotNull String containerId) {
        List containers;
        if (containerId == null) {
            DockerAgentApplicationBase.$$$reportNull$$$0(0);
        }
        return (containers = (List)this.getClient().listContainersCmd().withIdFilter(Collections.singletonList(containerId)).exec()).isEmpty() ? null : new DockerAgentContainerImpl(this.myContext, (Container)containers.get(0));
    }

    public int waitForExitImmediate(CloudAgentErrorHandler errorHandler) {
        return (Integer)new ApiTaskBase<Integer>(errorHandler){

            @Override
            protected Integer doPerform() throws IOException, ApiTaskException {
                return ((WaitContainerResultCallback)DockerAgentApplicationBase.this.getClient().waitContainerCmd(DockerAgentApplicationBase.this.myContainerId).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
            }
        }.perform();
    }

    protected static void exposeAllBoundPorts(CreateContainerCmd cmd) {
        ExposedPort[] allExposed = Optional.ofNullable(cmd.getExposedPorts()).orElseGet(() -> new ExposedPort[0]);
        Map exposedByPort = Stream.of(allExposed).collect(Collectors.toMap(p -> p.getPort(), Function.identity(), (oldValue, newValue) -> newValue, LinkedHashMap::new));
        List notExposedWithBindings = Optional.ofNullable(cmd.getHostConfig()).map(HostConfig::getPortBindings).map(Ports::getBindings).orElse(Collections.emptyMap()).keySet().stream().filter(ep -> !exposedByPort.containsKey(ep.getPort())).collect(Collectors.toList());
        if (notExposedWithBindings.isEmpty()) {
            return;
        }
        ArrayList<Object> fixedExposed = new ArrayList<Object>();
        fixedExposed.addAll(exposedByPort.values());
        fixedExposed.addAll(notExposedWithBindings);
        cmd.withExposedPorts(fixedExposed);
    }

    private String createExec(boolean withStdIn, String[] command) {
        Supplier<ExecCreateCmd> commandSupplier = withStdIn ? () -> this.myContext.getClient().execCreateCmd(this.getContainerId()) : () -> this.myContext.getClientExt().jerseyExecCreateCmd(this.getContainerId());
        try (ExecCreateCmd execCreateCmd = commandSupplier.get();){
            execCreateCmd.withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(withStdIn)).withTty(Boolean.valueOf(withStdIn)).withCmd(command);
            String string = ((ExecCreateCmdResponse)execCreateCmd.exec()).getId();
            return string;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerId", "com/intellij/docker/agent/DockerAgentApplicationBase", "findContainer"));
    }

    protected static class ContainerUpdateResultImpl
    implements DockerAgentApplication.ContainerUpdateResult {
        private final String myImageId;
        private String myNewId;
        private String myOldId;
        private DockerAgentApplication myNewAgentApplication;

        ContainerUpdateResultImpl(@NotNull String imageId) {
            if (imageId == null) {
                ContainerUpdateResultImpl.$$$reportNull$$$0(0);
            }
            this.myImageId = imageId;
        }

        void setNewAgentApplication(@NotNull DockerAgentApplication newContainer) {
            if (newContainer == null) {
                ContainerUpdateResultImpl.$$$reportNull$$$0(1);
            }
            this.myNewAgentApplication = newContainer;
            this.myNewId = newContainer.getContainerId();
        }

        void setRemovedContainerId(@NotNull String oldContainerId) {
            if (oldContainerId == null) {
                ContainerUpdateResultImpl.$$$reportNull$$$0(2);
            }
            this.myOldId = oldContainerId;
        }

        @NotNull
        public String getImageId() {
            String string = this.myImageId;
            if (string == null) {
                ContainerUpdateResultImpl.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public String getCreatedContainerId() {
            return this.myNewId;
        }

        @Nullable
        public DockerAgentApplication getCreatedAgentApplication() {
            return this.myNewAgentApplication;
        }

        @Nullable
        public String getRemovedContainerId() {
            return this.myOldId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "imageId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newContainer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldContainerId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/agent/DockerAgentApplicationBase$ContainerUpdateResultImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/agent/DockerAgentApplicationBase$ContainerUpdateResultImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImageId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setNewAgentApplication";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setRemovedContainerId";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyPipedOutputStream
    extends PipedOutputStream {
        MyPipedOutputStream(PipedInputStream snk) throws IOException {
            super(snk);
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            this.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.flush();
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            if (b == null) {
                MyPipedOutputStream.$$$reportNull$$$0(0);
            }
            this.write(b, 0, b.length);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/docker/agent/DockerAgentApplicationBase$MyPipedOutputStream", "write"));
        }
    }

    private static class MyPipedInputStream
    extends PipedInputStream {
        MyPipedInputStream() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            try {
                int n = super.read(b, off, len);
                return n;
            }
            finally {
                this.notifyAll();
            }
        }
    }

    private abstract class DockerResizableTerminalPipe
    extends TerminalPipeBase {
        private volatile boolean myIsClosed;

        protected DockerResizableTerminalPipe(String logPipeName, CloudAgentLoggingHandler loggingHandler) throws IOException {
            super(logPipeName, loggingHandler);
        }

        protected final TerminalListener.TtyResizeHandler getTtyResizeHandler() {
            return this::onTtyResize;
        }

        private void onTtyResize(int ttyWidth, int ttyHeight) {
            if (this.myIsClosed) {
                return;
            }
            try (ResizeDockerCmd<?> resizeCmd = this.createResizeCommand();){
                if (resizeCmd != null) {
                    try {
                        resizeCmd.withTtySize(ttyWidth, ttyHeight).exec();
                    }
                    catch (NotFoundException e) {
                        LOG.debug((Object)e);
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Pipe: " + (Object)((Object)this) + " resized to: " + ttyWidth + ", " + ttyHeight));
            }
        }

        @Override
        public void close() {
            super.close();
            this.myIsClosed = true;
        }

        @Nullable
        protected abstract ResizeDockerCmd<?> createResizeCommand();
    }

    private abstract class TerminalPipeBase
    extends TerminalPipe {
        private final PipedInputStream myInputStream;
        private final PipedOutputStream myReversedInputStream;
        private final OutputStream myOutputStream;
        private final PipedInputStream myReversedOutputStream;
        private final PipedInputStream myStderr;
        private final PipedOutputStream myReversedStderr;

        TerminalPipeBase(String logPipeName, CloudAgentLoggingHandler loggingHandler) throws IOException {
            super(logPipeName, loggingHandler);
            this.myReversedOutputStream = new MyPipedInputStream();
            this.myOutputStream = new MyPipedOutputStream(this.myReversedOutputStream);
            this.myInputStream = new MyPipedInputStream();
            this.myReversedInputStream = new MyPipedOutputStream(this.myInputStream);
            this.myStderr = new MyPipedInputStream();
            this.myReversedStderr = new MyPipedOutputStream(this.myStderr);
        }

        protected PipedOutputStream getReversedInputStream() {
            return this.myReversedInputStream;
        }

        protected PipedInputStream getReversedOutputStream() {
            return this.myReversedOutputStream;
        }

        protected PipedOutputStream getReversedStderr() {
            return this.myReversedStderr;
        }

        public void close() {
            try {
                this.myOutputStream.close();
                this.myReversedInputStream.close();
                this.myReversedStderr.close();
            }
            catch (IOException e) {
                DockerAgentApplicationBase.this.getLogger().debugEx((Exception)e);
            }
            super.close();
        }

        protected OutputStream getOutputStream() {
            return this.myOutputStream;
        }

        protected InputStream getInputStream() {
            return this.myInputStream;
        }

        protected InputStream getStderr() {
            return this.myStderr;
        }
    }

    private class DockerExecPipe
    extends DockerResizableTerminalPipe {
        private final String myExecId;

        DockerExecPipe(CloudAgentLoggingHandler loggingHandler, String[] command, String logName) throws IOException, ApiTaskException {
            super(logName, loggingHandler);
            this.myExecId = DockerAgentApplicationBase.this.createExec(true, command);
            try (ExecStartCmd execStartCmd = DockerAgentApplicationBase.this.getClient().execStartCmd(this.myExecId).withDetach(Boolean.valueOf(false));){
                execStartCmd.withStdIn((InputStream)this.getReversedOutputStream()).withTty(Boolean.valueOf(true));
                execStartCmd.exec((ResultCallback)new ExecStartResultCallback(this.getReversedInputStream(), this.getReversedStderr()){

                    public void close() throws IOException {
                        DockerExecPipe.this.close();
                        super.close();
                    }
                });
            }
        }

        String getUniquePipeId() {
            return DockerUtil.shortedId((String)DockerAgentApplicationBase.this.getContainerId()) + ":exec:" + DockerUtil.shortedId((String)this.myExecId);
        }

        @Override
        @NotNull
        protected ResizeDockerCmd<?> createResizeCommand() {
            ResizeExecCmd resizeExecCmd = DockerAgentApplicationBase.this.myContext.getClientExt().resizeExecCmd().withExecId(this.myExecId);
            if (resizeExecCmd == null) {
                DockerExecPipe.$$$reportNull$$$0(0);
            }
            return resizeExecCmd;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/agent/DockerAgentApplicationBase$DockerExecPipe", "createResizeCommand"));
        }
    }

    private static abstract class StateChangeTaskBase
    extends ApiTaskBase<Void> {
        StateChangeTaskBase(CloudAgentErrorHandler errorHandler) {
            super(errorHandler);
        }

        @Override
        protected Void doPerform() throws IOException, ApiTaskException {
            try {
                this.doPerformStateChange();
            }
            catch (NotModifiedException e) {
                String message = e.getMessage();
                throw new NotModifiedException(message == null ? "Possibly, container is in the target state already" : message, (Throwable)e);
            }
            return null;
        }

        protected abstract void doPerformStateChange() throws IOException, ApiTaskException;
    }

    private class DockerAttachPipe
    extends DockerResizableTerminalPipe {
        private final String myContainerId;

        DockerAttachPipe(String containerId, CloudAgentLoggingHandler loggingHandler) throws IOException, ApiTaskException {
            super("Attached console", loggingHandler);
            this.myContainerId = containerId;
            AttachContainerCmd attachContainerCmd = DockerAgentApplicationBase.this.getClient().attachContainerCmd(containerId).withFollowStream(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withStdIn((InputStream)this.getReversedOutputStream());
            attachContainerCmd.exec((ResultCallback)new AttachContainerResultCallback(){

                public void close() throws IOException {
                    DockerAttachPipe.this.close();
                    super.close();
                }

                public void onNext(Frame item) {
                    try {
                        PipedOutputStream stream = item.getStreamType() == StreamType.STDERR ? DockerAttachPipe.this.getReversedStderr() : DockerAttachPipe.this.getReversedInputStream();
                        stream.write(item.getPayload());
                    }
                    catch (IOException e) {
                        DockerAgentApplicationBase.this.getLogger().debugEx((Exception)e);
                    }
                }
            });
        }

        @Override
        @NotNull
        protected ResizeDockerCmd<?> createResizeCommand() {
            ResizeContainerCmd resizeContainerCmd = DockerAgentApplicationBase.this.myContext.getClientExt().resizeContainerCmd().withContainerId(this.myContainerId);
            if (resizeContainerCmd == null) {
                DockerAttachPipe.$$$reportNull$$$0(0);
            }
            return resizeContainerCmd;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/agent/DockerAgentApplicationBase$DockerAttachPipe", "createResizeCommand"));
        }
    }

    private static class DockerLogPipe
    extends LogPipe {
        private final StreamCallbackBase<Frame> myStreamCallback;
        private final LogContainerCmd myLogContainerCmd;

        DockerLogPipe(DockerAgentContext context, String containerId, CloudAgentLoggingHandler loggingHandler) throws IOException {
            super(containerId, "Log", context.getLogger(), loggingHandler);
            this.setLogDebugEnabled(LOG.isDebugEnabled());
            this.myLogContainerCmd = context.getClient().logContainerCmd(containerId).withFollowStream(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withTimestamps(Boolean.valueOf(false));
            this.myStreamCallback = new StreamCallbackBase<Frame>(context.getLogger()){

                @Override
                protected void onNextWrite(Frame packet) throws IOException {
                    if (this.isLogDebugEnabled()) {
                        this.debug(this + ": onNextWrite: " + this.getDebugPacketContents(packet));
                    }
                    if (this.isClosed()) {
                        this.requestCloseChannel();
                        return;
                    }
                    PipedOutputStream reverseOfInputStream = this.getReverseOfInputStream();
                    reverseOfInputStream.write(packet.getPayload());
                    reverseOfInputStream.flush();
                }

                @Override
                public void onComplete() {
                    if (this.isLogDebugEnabled()) {
                        this.debug(this + ": onComplete: has closeable " + this.hasChannelCloseable());
                    }
                    super.onComplete();
                }

                @Override
                public void onStart(Closeable closeable) {
                    if (this.isLogDebugEnabled()) {
                        this.debug(this + ": onStart: closeable " + closeable);
                    }
                    super.onStart(closeable);
                    if (!this.isClosed()) {
                        this.startPipeThread();
                        try {
                            this.getReverseOfInputStream().write(10);
                        }
                        catch (IOException e) {
                            this.onError(e);
                        }
                    }
                }

                @Override
                public void close() throws IOException {
                    if (this.isLogDebugEnabled()) {
                        this.debug(this + ": close: requested");
                    }
                    super.close();
                    DockerLogPipe pipe = this;
                    if (!pipe.isClosed()) {
                        if (this.isLogDebugEnabled()) {
                            this.debug(this + ": additionally closing the pipe");
                        }
                        pipe.close();
                    }
                }

                @Override
                public boolean requestCloseChannel() {
                    boolean result = super.requestCloseChannel();
                    if (this.isLogDebugEnabled()) {
                        this.debug(this + ": requestCloseChannel: requested: " + result);
                    }
                    return result;
                }

                public String toString() {
                    return "StreamCallbackBase@" + Integer.toHexString(System.identityHashCode(this));
                }

                private String getDebugPacketContents(Frame packet) {
                    byte[] payload = packet.getPayload();
                    if (payload == null) {
                        return "<null>";
                    }
                    String contents = new String(payload, StandardCharsets.UTF_8);
                    String[] lines = contents.split("[\\r\\n]");
                    int DUMP_THRESHOLD = 25;
                    if (lines.length >= 2) {
                        String firstLine = lines[0];
                        String lastLine = lines[lines.length - 1];
                        return "[" + lines.length + " lines]: " + firstLine.substring(0, Math.min(firstLine.length(), DUMP_THRESHOLD)) + " .... " + lastLine.substring(Math.max(0, lastLine.length() - DUMP_THRESHOLD));
                    }
                    String theOnlyLine = contents.length() < 2 * DUMP_THRESHOLD ? contents : contents.substring(0, DUMP_THRESHOLD) + " .... " + contents.substring(contents.length() - DUMP_THRESHOLD);
                    return "[1 line]: " + theOnlyLine;
                }
            };
        }

        public void close() {
            this.debug("about to be closed, thread will quit soon, requesting netty channel close");
            this.myStreamCallback.requestCloseChannel();
            super.close();
        }

        protected InputStream createInputStream(String containerId) {
            return this.myStreamCallback.getInputStream();
        }

        public void open() {
            this.myLogContainerCmd.exec(this.myStreamCallback);
        }

        protected void startPipeThread() {
            super.open();
        }
    }
}

