/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.InternetProtocol;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLabel;
import com.intellij.docker.agent.settings.DockerLabelImpl;
import com.intellij.docker.agent.settings.DockerLink;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerAgentContainerConfigImpl
implements DockerAgentContainerConfig {
    private static final Bind[] NO_BINDS = new Bind[0];
    private static final Volume[] NO_VOLUMES = new Volume[0];
    private final String[] myCommand;
    private final String[] myEntrypoint;
    private final Boolean myPublishAllPorts;
    private final DockerPortBinding[] myPortBindings;
    private final Integer[] myExposedPorts;
    private final DockerLink[] myLinks;
    private final DockerVolumeBinding[] myVolumeBindings;
    private final DockerEnvVar[] myEnvVars;
    private final String myWorkingDir;
    private final DockerVolumesFrom[] myVolumesFrom;
    private final Boolean myNetworkDisabled;
    private final String myNetworkMode;
    private final String[] myExtraHosts;
    private final String myContainerName;
    private final String myUser;
    private final DockerLabel[] myLabels;
    private final Boolean myStdinOnce;

    public DockerAgentContainerConfigImpl(DockerAgentContainerConfig source) {
        this.myCommand = source.getCommand();
        this.myEntrypoint = source.getEntrypoint();
        this.myPortBindings = source.getPortBindings();
        this.myPublishAllPorts = source.getPublishAllPorts();
        this.myExposedPorts = source.getExposedPorts();
        this.myLinks = source.getLinks();
        this.myVolumeBindings = source.getVolumeBindings();
        this.myEnvVars = source.getEnvVars();
        this.myWorkingDir = source.getWorkingDir();
        this.myVolumesFrom = source.getVolumesFrom();
        this.myNetworkDisabled = source.getNetworkDisabled();
        this.myNetworkMode = source.getNetworkMode();
        this.myExtraHosts = source.getExtraHosts();
        this.myContainerName = source.getContainerName();
        this.myUser = source.getUser();
        this.myLabels = source.getLabels();
        this.myStdinOnce = source.getStdinOnce();
    }

    public DockerAgentContainerConfigImpl(CreateContainerCmd cmd) {
        this.myCommand = cmd.getCmd();
        Optional<HostConfig> hostConfig = Optional.ofNullable(cmd.getHostConfig());
        this.myEntrypoint = cmd.getEntrypoint();
        this.myPublishAllPorts = hostConfig.map(HostConfig::getPublishAllPorts).orElse(null);
        this.myPortBindings = DockerAgentContainerConfigImpl.createAgentPortBindings(hostConfig.map(HostConfig::getPortBindings).orElse(null));
        this.myExposedPorts = DockerAgentContainerConfigImpl.createAgentExposedPorts(cmd.getExposedPorts());
        this.myLinks = DockerAgentContainerConfigImpl.createAgentLinks(hostConfig.map(HostConfig::getLinks).orElse(null));
        this.myVolumeBindings = DockerAgentContainerConfigImpl.createAgentVolumeBindings(hostConfig.map(HostConfig::getBinds).orElse(null), cmd.getVolumes());
        this.myEnvVars = DockerAgentContainerConfigImpl.createAgentEnvVars(cmd.getEnv());
        this.myWorkingDir = cmd.getWorkingDir();
        this.myVolumesFrom = DockerAgentContainerConfigImpl.createAgentVolumesFrom(hostConfig.map(HostConfig::getVolumesFrom).orElse(null));
        this.myNetworkDisabled = cmd.isNetworkDisabled();
        this.myNetworkMode = hostConfig.map(HostConfig::getNetworkMode).orElse(null);
        this.myExtraHosts = hostConfig.map(HostConfig::getExtraHosts).orElse(null);
        this.myContainerName = cmd.getName();
        this.myUser = cmd.getUser();
        this.myLabels = DockerAgentContainerConfigImpl.createAgentLabels(cmd.getLabels());
        this.myStdinOnce = cmd.isStdInOnce();
    }

    public String[] getEntrypoint() {
        return this.myEntrypoint;
    }

    public String[] getCommand() {
        return this.myCommand;
    }

    public String getContainerName() {
        return this.myContainerName;
    }

    public String getUser() {
        return this.myUser;
    }

    public DockerLabel[] getLabels() {
        return this.myLabels;
    }

    public DockerVolumesFrom[] getVolumesFrom() {
        return this.myVolumesFrom;
    }

    public String getNetworkMode() {
        return this.myNetworkMode;
    }

    public String[] getExtraHosts() {
        return this.myExtraHosts;
    }

    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    public Boolean getNetworkDisabled() {
        return this.myNetworkDisabled;
    }

    public Boolean getPublishAllPorts() {
        return this.myPublishAllPorts;
    }

    public boolean isPublishAllPorts() {
        return Boolean.TRUE.equals(this.getPublishAllPorts());
    }

    public DockerPortBinding[] getPortBindings() {
        return this.myPortBindings;
    }

    public Integer[] getExposedPorts() {
        return this.myExposedPorts;
    }

    public DockerLink[] getLinks() {
        return this.myLinks;
    }

    public DockerVolumeBinding[] getVolumeBindings() {
        return this.myVolumeBindings;
    }

    public DockerEnvVar[] getEnvVars() {
        return this.myEnvVars;
    }

    public Boolean getStdinOnce() {
        return this.myStdinOnce;
    }

    @Deprecated
    public Ports createCmdPortBindings() {
        if (this.isPublishAllPorts() || this.myPortBindings == null) {
            return null;
        }
        return new Ports(this.createCmdPortBindingsArray());
    }

    public PortBinding[] createCmdPortBindingsArray() {
        if (this.isPublishAllPorts()) {
            return new PortBinding[0];
        }
        if (this.myPortBindings == null) {
            return null;
        }
        return (PortBinding[])DockerUtil.mapArray((Object[])this.myPortBindings, PortBinding.class, source -> new PortBinding(new Ports.Binding(source.getHostIp(), (String)Optional.ofNullable(source.getHostPort()).map(String::valueOf).orElse(null)), new ExposedPort(source.getContainerPort(), InternetProtocol.parse((String)source.getProtocol()))));
    }

    private static DockerPortBinding[] createAgentPortBindings(Ports ports) {
        if (ports == null) {
            return null;
        }
        ArrayList<DockerPortBindingImpl> portBindings = new ArrayList<DockerPortBindingImpl>();
        for (Map.Entry portEntry : ports.getBindings().entrySet()) {
            ExposedPort exposedPort = (ExposedPort)portEntry.getKey();
            Ports.Binding[] bindings = (Ports.Binding[])portEntry.getValue();
            if (bindings == null) continue;
            for (Ports.Binding next : bindings) {
                DockerPortBindingImpl portBinding = new DockerPortBindingImpl();
                portBinding.setHostIp(next.getHostIp());
                portBinding.setHostPort(DockerAgentContainerConfigImpl.parseHostPort(next));
                portBinding.setProtocol(exposedPort.getProtocol().toString());
                portBinding.setContainerPort(exposedPort.getPort());
                portBindings.add(portBinding);
            }
        }
        return portBindings.toArray(new DockerPortBinding[0]);
    }

    public ExposedPort[] createCmdExposedPorts() {
        return (ExposedPort[])DockerUtil.mapArray((Object[])this.myExposedPorts, ExposedPort.class, ExposedPort::new);
    }

    private static Integer parseHostPort(@NotNull Ports.Binding binding) {
        if (binding == null) {
            DockerAgentContainerConfigImpl.$$$reportNull$$$0(0);
        }
        return Optional.ofNullable(binding.getHostPortSpec()).map(spec -> DockerAgentContainerConfigImpl.isEmptyOrNull(spec) ? null : Integer.valueOf(Integer.parseInt(spec))).orElse(null);
    }

    private static Integer[] createAgentExposedPorts(ExposedPort[] ports) {
        return (Integer[])DockerUtil.mapArray((Object[])ports, Integer.class, exposedPort -> exposedPort.getPort());
    }

    public Link[] createCmdLinks() {
        return (Link[])DockerUtil.mapArray((Object[])this.myLinks, Link.class, source -> {
            String name = source.getName();
            String alias = source.getAlias();
            return new Link(name, alias == null ? name : alias);
        });
    }

    private static DockerLink[] createAgentLinks(Link[] links) {
        return (DockerLink[])DockerUtil.mapArray((Object[])links, DockerLink.class, source -> {
            DockerLinkImpl result = new DockerLinkImpl();
            result.setName(source.getName());
            result.setAlias(source.getAlias());
            return result;
        });
    }

    public VolumesFrom[] createCmdVolumesFrom() {
        return (VolumesFrom[])DockerUtil.mapArray((Object[])this.myVolumesFrom, VolumesFrom.class, source -> {
            String sourceContainerId = source.getContainerId();
            return sourceContainerId == null ? null : new VolumesFrom(sourceContainerId, AccessMode.fromBoolean((boolean)source.isReadOnly()));
        });
    }

    public Volume[] createCmdVolumes() {
        return (Volume[])DockerUtil.mapArray((Object[])this.myVolumeBindings, Volume.class, source -> source.getHostPath() == null ? new Volume(source.getContainerPath()) : null);
    }

    public Bind[] createCmdVolumeBindings() {
        return (Bind[])DockerUtil.mapArray((Object[])this.myVolumeBindings, Bind.class, source -> {
            String hostPath = source.getHostPath();
            return hostPath == null ? null : new Bind(hostPath, new Volume(source.getContainerPath()), AccessMode.fromBoolean((!source.isReadOnly() ? 1 : 0) != 0));
        });
    }

    private static DockerVolumesFrom[] createAgentVolumesFrom(VolumesFrom[] volumesFroms) {
        return (DockerVolumesFrom[])DockerUtil.mapArray((Object[])volumesFroms, DockerVolumesFrom.class, source -> new DockerVolumesFrom((VolumesFrom)source){
            final /* synthetic */ VolumesFrom val$source;
            {
                this.val$source = volumesFrom;
            }

            public String getContainerId() {
                return this.val$source.getContainer();
            }

            public boolean isReadOnly() {
                return this.val$source.getAccessMode().toBoolean();
            }
        });
    }

    @Nullable
    private static DockerVolumeBinding[] createAgentVolumeBindings(@Nullable Bind[] binds, @Nullable Volume[] volumes) {
        DockerVolumeBindingImpl nextResult;
        String nextContainerPath;
        if (binds == null) {
            binds = NO_BINDS;
        }
        if (volumes == null) {
            volumes = NO_VOLUMES;
        }
        if (binds.length == 0 && volumes.length == 0) {
            return null;
        }
        LinkedHashMap<String, DockerVolumeBindingImpl> resultsByPath = new LinkedHashMap<String, DockerVolumeBindingImpl>();
        for (Volume volume : volumes) {
            nextContainerPath = DockerAgentContainerConfigImpl.removeTrailingSlashes(volume.getPath());
            nextResult = DockerAgentContainerConfigImpl.newDockerVolumeBindingImpl(nextContainerPath);
            resultsByPath.put(nextContainerPath, nextResult);
        }
        for (Volume volume : binds) {
            nextContainerPath = DockerAgentContainerConfigImpl.removeTrailingSlashes(volume.getVolume().getPath());
            nextResult = resultsByPath.computeIfAbsent(nextContainerPath, path -> DockerAgentContainerConfigImpl.newDockerVolumeBindingImpl(path));
            String hostPath = volume.getPath();
            nextResult.setHostPath(hostPath == null ? nextResult.getContainerPath() : hostPath);
            nextResult.setReadOnly(!volume.getAccessMode().toBoolean());
        }
        return resultsByPath.values().toArray(new DockerVolumeBinding[0]);
    }

    @Nullable
    private static String removeTrailingSlashes(@Nullable String path) {
        char trailingChar;
        int curEndIdx;
        if (path == null) {
            return null;
        }
        for (curEndIdx = path.length(); curEndIdx >= 0 && ((trailingChar = path.charAt(curEndIdx - 1)) == '/' || trailingChar == '\\'); --curEndIdx) {
        }
        return curEndIdx == path.length() ? path : path.substring(0, curEndIdx);
    }

    private static DockerVolumeBindingImpl newDockerVolumeBindingImpl(String containerPath) {
        DockerVolumeBindingImpl result = new DockerVolumeBindingImpl();
        result.setContainerPath(containerPath);
        return result;
    }

    public String[] createCmdEnvVars() {
        return (String[])DockerUtil.mapArray((Object[])this.myEnvVars, String.class, source -> source.getName() + "=" + source.getValue());
    }

    private static DockerEnvVar[] createAgentEnvVars(String[] cmdEnv) {
        return (DockerEnvVar[])DockerUtil.mapArray((Object[])cmdEnv, DockerEnvVar.class, source -> {
            DockerEnvVarImpl result = new DockerEnvVarImpl();
            String[] parts = source.split("=", 2);
            result.setName(parts[0]);
            result.setValue(parts.length == 1 ? "" : parts[1]);
            return result;
        });
    }

    private static DockerLabel[] createAgentLabels(Map<String, String> links) {
        return links == null ? null : (DockerLabel[])links.entrySet().stream().map(link -> {
            DockerLabelImpl result = new DockerLabelImpl();
            result.setKey((String)link.getKey());
            result.setValue((String)link.getValue());
            return result;
        }).toArray(DockerLabel[]::new);
    }

    private static boolean isEmptyOrNull(String text) {
        return text == null || text.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binding", "com/intellij/docker/agent/DockerAgentContainerConfigImpl", "parseHostPort"));
    }
}

