/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.parse;

import com.google.common.base.Preconditions;
import com.intellij.docker.compose.configuration.beans.DockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingDockerComposeConfigurationParser
implements DockerComposeConfigurationParser {
    private final Object monitor = new Object();
    private DockerComposeConfiguration cachedValue;
    private IOException cachedIOException;
    @Nullable
    private Object underlyingEssentialInfoForCaching;
    private long[] cachedStamps = new long[0];
    private final DockerComposeConfigurationParser myUnderlying;

    public CachingDockerComposeConfigurationParser(DockerComposeConfigurationParser underlying) {
        this.myUnderlying = underlying;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public DockerComposeConfiguration parseBean(@NotNull List<String> dockerComposeFilePaths) throws IOException {
        if (dockerComposeFilePaths == null) {
            CachingDockerComposeConfigurationParser.$$$reportNull$$$0(0);
        }
        Preconditions.checkArgument((!dockerComposeFilePaths.isEmpty() ? 1 : 0) != 0, (Object)"Got empty dockerComposeFilePaths");
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        long[] actualStamps = (long[])ReadAction.compute(() -> CachingDockerComposeConfigurationParser.getTimeStamps(localFileSystem, dockerComposeFilePaths));
        Object object = this.monitor;
        // MONITORENTER : object
        Object newCacheKey = this.myUnderlying.getEssentialInfoForCaching();
        if (newCacheKey == null) {
            DockerComposeConfiguration dockerComposeConfiguration = this.myUnderlying.parseBean(dockerComposeFilePaths);
            // MONITOREXIT : object
            if (dockerComposeConfiguration != null) return dockerComposeConfiguration;
            CachingDockerComposeConfigurationParser.$$$reportNull$$$0(1);
            return dockerComposeConfiguration;
        }
        if (!Objects.equals(this.underlyingEssentialInfoForCaching, newCacheKey) || CachingDockerComposeConfigurationParser.timestampsExpired(this.cachedStamps, actualStamps)) {
            this.cachedIOException = null;
            try {
                this.cachedValue = this.myUnderlying.parseBean(dockerComposeFilePaths);
            }
            catch (IOException e) {
                this.cachedIOException = e;
            }
            finally {
                this.cachedStamps = actualStamps;
                this.underlyingEssentialInfoForCaching = newCacheKey;
            }
        }
        if (this.cachedIOException != null) {
            throw this.cachedIOException;
        }
        DockerComposeConfiguration dockerComposeConfiguration = this.cachedValue;
        // MONITOREXIT : object
        if (dockerComposeConfiguration != null) return dockerComposeConfiguration;
        CachingDockerComposeConfigurationParser.$$$reportNull$$$0(2);
        return dockerComposeConfiguration;
    }

    @Override
    @Nullable
    public Object getEssentialInfoForCaching() {
        return null;
    }

    private static long[] getTimeStamps(LocalFileSystem localFileSystem, @NotNull List<String> dockerComposeFilePaths) {
        if (dockerComposeFilePaths == null) {
            CachingDockerComposeConfigurationParser.$$$reportNull$$$0(3);
        }
        long[] result = new long[dockerComposeFilePaths.size()];
        int count = 0;
        for (String path : dockerComposeFilePaths) {
            VirtualFile virtualFile = localFileSystem.findFileByPath(path);
            result[count++] = virtualFile != null ? virtualFile.getTimeStamp() : Long.MAX_VALUE;
        }
        return result;
    }

    private static boolean timestampsExpired(long[] cachedStamps, long[] actualStamps) {
        if (cachedStamps.length != actualStamps.length) {
            return true;
        }
        for (int i = 0; i < cachedStamps.length; ++i) {
            if (cachedStamps[i] >= actualStamps[i]) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeFilePaths";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/configuration/beans/parse/CachingDockerComposeConfigurationParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/configuration/beans/parse/CachingDockerComposeConfigurationParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseBean";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamps";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

