/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.parse;

import com.google.common.base.Preconditions;
import com.intellij.docker.DockerSettings;
import com.intellij.docker.compose.configuration.beans.DockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeConfigurationStreamParser;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.io.StringReader;
import java.time.Duration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ToolBasedDockerComposeConfigurationParser
implements DockerComposeConfigurationParser {
    private static final Logger LOG = Logger.getInstance(ToolBasedDockerComposeConfigurationParser.class);
    private final DockerComposeConfigurationStreamParser myDeserializer;

    ToolBasedDockerComposeConfigurationParser(DockerComposeConfigurationStreamParser myDeserializer) {
        this.myDeserializer = myDeserializer;
    }

    @Override
    @Nullable
    public Object getEssentialInfoForCaching() {
        return ToolBasedDockerComposeConfigurationParser.getDockerComposePath();
    }

    @Override
    @NotNull
    public DockerComposeConfiguration parseBean(@NotNull List<String> dockerComposeFilePaths) throws IOException {
        if (dockerComposeFilePaths == null) {
            ToolBasedDockerComposeConfigurationParser.$$$reportNull$$$0(0);
        }
        Preconditions.checkArgument((!dockerComposeFilePaths.isEmpty() ? 1 : 0) != 0, (Object)"Got empty dockerComposeFilePaths");
        if (ApplicationManager.getApplication().isDispatchThread()) {
            DockerComposeConfiguration dockerComposeConfiguration = (DockerComposeConfiguration)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.parseBeanImpl(dockerComposeFilePaths), "Processing Docker Compose Configuration...", false, null);
            if (dockerComposeConfiguration == null) {
                ToolBasedDockerComposeConfigurationParser.$$$reportNull$$$0(1);
            }
            return dockerComposeConfiguration;
        }
        DockerComposeConfiguration dockerComposeConfiguration = this.parseBeanImpl(dockerComposeFilePaths);
        if (dockerComposeConfiguration == null) {
            ToolBasedDockerComposeConfigurationParser.$$$reportNull$$$0(2);
        }
        return dockerComposeConfiguration;
    }

    @NotNull
    private DockerComposeConfiguration parseBeanImpl(@NotNull List<String> dockerComposeFilePaths) throws IOException {
        CapturingProcessHandler handler;
        if (dockerComposeFilePaths == null) {
            ToolBasedDockerComposeConfigurationParser.$$$reportNull$$$0(3);
        }
        GeneralCommandLine commandBuilder = new GeneralCommandLine(new String[]{ToolBasedDockerComposeConfigurationParser.getDockerComposePath()});
        commandBuilder.setWorkDirectory(PathUtil.getParentPath((String)dockerComposeFilePaths.get(0)));
        for (String path : dockerComposeFilePaths) {
            commandBuilder.addParameters(new String[]{"--file", path});
        }
        commandBuilder.addParameter("config");
        commandBuilder.setRedirectErrorStream(false);
        try {
            handler = new CapturingProcessHandler(commandBuilder);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
        ProcessOutput processOutput = handler.runProcess((int)Duration.ofSeconds(5L).toMillis(), true);
        if (processOutput.getExitCode() != 0 || !processOutput.getStderr().trim().isEmpty()) {
            if (processOutput.getExitCode() != 0) {
                throw new IOException("Process `docker-compose config` failed.\n" + processOutput.getStderr());
            }
            LOG.warn(String.format("Process `%s` wrote something into stderr, may be precursor of a problem.\n%s", commandBuilder.getPreparedCommandLine().replace('\n', ' '), processOutput.getStderr()));
        }
        DockerComposeConfiguration dockerComposeConfiguration = this.myDeserializer.parseBean(new StringReader(processOutput.getStdout()));
        if (dockerComposeConfiguration == null) {
            ToolBasedDockerComposeConfigurationParser.$$$reportNull$$$0(4);
        }
        return dockerComposeConfiguration;
    }

    @NotNull
    private static String getDockerComposePath() {
        String string = DockerSettings.getInstance().getDockerComposePath();
        if (string == null) {
            ToolBasedDockerComposeConfigurationParser.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeFilePaths";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/configuration/beans/parse/ToolBasedDockerComposeConfigurationParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/configuration/beans/parse/ToolBasedDockerComposeConfigurationParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBean";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBeanImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerComposePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseBean";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseBeanImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

