/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.view.DockerServiceViewContributor;
import com.intellij.docker.view.DockerTreeStructure;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionListener;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ui.RemoteServersView;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.UIUtil;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerDeploymentManager {
    private static final int POLL_DEPLOYMENTS_DELAY = 2000;
    private final Project myProject;
    private final ServersTreeNodeSelector myNodeSelector;
    private final ServersToolWindowContent.MessagePanel myServerNodeContent;
    private final Map<Deployment, DockerTreeStructure.DeploymentContent> myDeployment2Content;

    public static DockerDeploymentManager getInstance(Project project) {
        return (DockerDeploymentManager)ServiceManager.getService((Project)project, DockerDeploymentManager.class);
    }

    public DockerDeploymentManager(@NotNull Project project) {
        if (project == null) {
            DockerDeploymentManager.$$$reportNull$$$0(0);
        }
        this.myServerNodeContent = ServersToolWindowContent.createMessagePanel();
        this.myProject = project;
        this.myNodeSelector = new DockerTreeNodeSelector(project, this::createDeploymentNode);
        this.myDeployment2Content = FactoryMap.create(deployment -> new DockerTreeStructure.DeploymentContent(this.myProject, (Deployment)deployment, this.getNodeSelector()));
        this.initListeners();
        RemoteServersView.getInstance((Project)project).registerCustomTreeNodeSelector(this.myNodeSelector, connection -> connection.getServer().getType().equals((Object)DockerCloudType.getInstance()));
    }

    private void initListeners() {
        this.myProject.getMessageBus().connect().subscribe(ServerConnectionListener.TOPIC, (Object)new ServerConnectionListener(){

            public void onConnectionCreated(@NotNull ServerConnection<?> connection) {
                if (connection == null) {
                    1.$$$reportNull$$$0(0);
                }
                ((ServiceEventListener)DockerDeploymentManager.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(DockerServiceViewContributor.class));
            }

            public void onConnectionStatusChanged(@NotNull ServerConnection<?> connection) {
                if (connection == null) {
                    1.$$$reportNull$$$0(1);
                }
                ((ServiceEventListener)DockerDeploymentManager.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(DockerServiceViewContributor.class));
                DockerDeploymentManager.this.updateServerNodeContent(connection);
                if (connection.getStatus() == ConnectionStatus.CONNECTED) {
                    DockerDeploymentManager.pollDeployments(connection);
                }
            }

            public void onDeploymentsChanged(@NotNull ServerConnection<?> connection) {
                if (connection == null) {
                    1.$$$reportNull$$$0(2);
                }
                ((ServiceEventListener)DockerDeploymentManager.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(DockerServiceViewContributor.class));
                DockerDeploymentManager.this.updateServerNodeContent(connection);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "connection";
                objectArray2[1] = "com/intellij/docker/view/DockerDeploymentManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConnectionCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConnectionStatusChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onDeploymentsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myProject.getMessageBus().connect().subscribe(RemoteServerListener.TOPIC, (Object)new RemoteServerListener(){

            public void serverAdded(@NotNull RemoteServer<?> server) {
                if (server == null) {
                    2.$$$reportNull$$$0(0);
                }
                ((ServiceEventListener)DockerDeploymentManager.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(DockerServiceViewContributor.class));
            }

            public void serverRemoved(@NotNull RemoteServer<?> server) {
                if (server == null) {
                    2.$$$reportNull$$$0(1);
                }
                ((ServiceEventListener)DockerDeploymentManager.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(DockerServiceViewContributor.class));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "server";
                objectArray2[1] = "com/intellij/docker/view/DockerDeploymentManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "serverAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "serverRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public AbstractTreeNode createDeploymentNode(ServerConnection<?> connection, ServersTreeStructure.RemoteServerNode serverNode, Deployment deployment) {
        if (this.myDeployment2Content.containsKey(deployment)) {
            DockerTreeStructure.DeploymentContent content = this.myDeployment2Content.get(deployment);
            UIUtil.invokeLaterIfNeeded(() -> {
                content.initContent();
                content.updateLogs();
            });
        }
        return new DockerTreeStructure.DockerDeploymentNode(this.myProject, connection, serverNode, deployment, this::createDeploymentNode, this.myDeployment2Content::get);
    }

    public ServersTreeNodeSelector getNodeSelector() {
        return this.myNodeSelector;
    }

    public JComponent getServerNodeContent(ServersTreeStructure.RemoteServerNode node) {
        this.updateServerNodeContent(ServerConnectionManager.getInstance().getConnection(node.getServer()));
        return this.myServerNodeContent.getComponent();
    }

    private void updateServerNodeContent(@Nullable ServerConnection<?> connection) {
        if (connection == null) {
            this.myServerNodeContent.setEmptyText("Double-click on the server node to connect");
        } else {
            String text = connection.getStatusText();
            if (text.contains("<br/>") && !text.startsWith("<html>")) {
                text = "<html><center>" + text + "</center></html>";
            }
            this.myServerNodeContent.setEmptyText(text);
        }
    }

    private static void pollDeployments(ServerConnection connection) {
        connection.computeDeployments(() -> new Alarm().addRequest(() -> {
            if (connection == ServerConnectionManager.getInstance().getConnection(connection.getServer())) {
                DockerDeploymentManager.pollDeployments(connection);
            }
        }, 2000, ModalityState.any()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/docker/view/DockerDeploymentManager", "<init>"));
    }

    private static class DockerTreeNodeSelector
    implements ServersTreeNodeSelector {
        private final Project myProject;
        private final ServersTreeStructure.DeploymentNodeProducer myNodeProducer;

        private DockerTreeNodeSelector(Project project, ServersTreeStructure.DeploymentNodeProducer nodeProducer) {
            this.myProject = project;
            this.myNodeProducer = nodeProducer;
        }

        public void select(@NotNull ServerConnection<?> connection) {
            if (connection == null) {
                DockerTreeNodeSelector.$$$reportNull$$$0(0);
            }
            ServersTreeStructure.RemoteServerNode serverNode = new ServersTreeStructure.RemoteServerNode(this.myProject, connection.getServer(), this.myNodeProducer);
            ServiceViewManager.getInstance((Project)this.myProject).select((Object)serverNode, DockerServiceViewContributor.class, false, false);
        }

        public void select(@NotNull ServerConnection<?> connection, @NotNull String deploymentName) {
            if (connection == null) {
                DockerTreeNodeSelector.$$$reportNull$$$0(1);
            }
            if (deploymentName == null) {
                DockerTreeNodeSelector.$$$reportNull$$$0(2);
            }
            this.doSelect(connection, deploymentName);
        }

        public void select(@NotNull ServerConnection<?> connection, @NotNull String deploymentName, @NotNull String logName) {
            DockerTreeStructure.DockerDeploymentNode node;
            if (connection == null) {
                DockerTreeNodeSelector.$$$reportNull$$$0(3);
            }
            if (deploymentName == null) {
                DockerTreeNodeSelector.$$$reportNull$$$0(4);
            }
            if (logName == null) {
                DockerTreeNodeSelector.$$$reportNull$$$0(5);
            }
            if ((node = this.doSelect(connection, deploymentName)) != null) {
                node.selectLog(logName);
            }
        }

        @Nullable
        private DockerTreeStructure.DockerDeploymentNode doSelect(@NotNull ServerConnection<?> connection, @NotNull String deploymentName) {
            if (connection == null) {
                DockerTreeNodeSelector.$$$reportNull$$$0(6);
            }
            if (deploymentName == null) {
                DockerTreeNodeSelector.$$$reportNull$$$0(7);
            }
            ServersTreeStructure.RemoteServerNode serverNode = new ServersTreeStructure.RemoteServerNode(this.myProject, connection.getServer(), this.myNodeProducer);
            DockerServiceViewContributor.DockerNodeServiceViewContributor serverContributor = new DockerServiceViewContributor.DockerNodeServiceViewContributor((AbstractTreeNode)serverNode);
            ((ServiceEventListener)this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_STRUCTURE_CHANGED, (Object)serverContributor, DockerServiceViewContributor.class));
            Deployment toSelect = null;
            for (Deployment deployment : connection.getDeployments()) {
                if (!deployment.getName().equals(deploymentName)) continue;
                toSelect = deployment;
                break;
            }
            if (toSelect == null) {
                return null;
            }
            AbstractTreeNode deploymentNode = this.myNodeProducer.createDeploymentNode(connection, serverNode, toSelect);
            ServiceViewManager.getInstance((Project)this.myProject).select((Object)deploymentNode, DockerServiceViewContributor.class, false, false);
            return (DockerTreeStructure.DockerDeploymentNode)((Object)ObjectUtils.tryCast((Object)deploymentNode, DockerTreeStructure.DockerDeploymentNode.class));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deploymentName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/view/DockerDeploymentManager$DockerTreeNodeSelector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "select";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doSelect";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

