/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.DockerDeploymentStatus;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerDeploymentRuntime;
import com.intellij.docker.view.DockerContainerBrowser;
import com.intellij.docker.view.DockerEnvVarsRuntimeEditor;
import com.intellij.docker.view.DockerPortBindingRuntimeEditor;
import com.intellij.docker.view.DockerPropertiesRuntimeEditor;
import com.intellij.docker.view.DockerRuntimeEditorBase;
import com.intellij.docker.view.DockerTableRuntimeEditor;
import com.intellij.docker.view.DockerTreeFilter;
import com.intellij.docker.view.DockerVolumeBindingsRuntimeEditor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.impl.runtime.deployment.LocalDeploymentImpl;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerImpl;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContribution;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedPaneContentUI;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.DockerIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerTreeStructure
extends ServersTreeStructure {
    private static final Logger LOG = Logger.getInstance(DockerTreeStructure.class);
    private static final Key<LoggingHandlerBase> ADDITIONAL_LOG_KEY = Key.create((String)"ADDITIONAL_LOG");
    private final Map<Deployment, DeploymentContent> myDeployment2Content;

    public DockerTreeStructure(@NotNull Project project, @NotNull RemoteServersViewContribution contribution, @NotNull ServersTreeNodeSelector nodeSelector) {
        if (project == null) {
            DockerTreeStructure.$$$reportNull$$$0(0);
        }
        if (contribution == null) {
            DockerTreeStructure.$$$reportNull$$$0(1);
        }
        if (nodeSelector == null) {
            DockerTreeStructure.$$$reportNull$$$0(2);
        }
        super(project, contribution, nodeSelector);
        this.myDeployment2Content = FactoryMap.create(deployment -> new DeploymentContent(this.doGetProject(), (Deployment)deployment, this.getNodeSelector()));
    }

    protected AbstractTreeNode createDeploymentNode(ServerConnection<?> connection, ServersTreeStructure.RemoteServerNode serverNode, Deployment deployment) {
        if (this.myDeployment2Content.containsKey(deployment)) {
            DeploymentContent content = this.myDeployment2Content.get(deployment);
            content.initContent();
            content.updateLogs();
        }
        return new DockerDeploymentNode(this.doGetProject(), connection, serverNode, deployment, this::createDeploymentNode, this.myDeployment2Content::get);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "contribution";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "nodeSelector";
                break;
            }
        }
        objectArray[1] = "com/intellij/docker/view/DockerTreeStructure";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    static interface DeploymentContentProvider {
        public DeploymentContent getDeploymentContent(@NotNull Deployment var1);
    }

    static class DeploymentContent {
        private static final String LOG_TOOLBAR_PLACE = "DockerDeploymentContentLogConsole#Toolbar";
        private final Project myProject;
        private final ContentManager myManager;
        private final Deployment myDeployment;
        private final ServersTreeNodeSelector myNodeSelector;
        private boolean myShown;
        private boolean myContentInitialized;
        private JPanel myLogPanel;
        private JComponent myLogToolbar;
        private Content myLogContent;
        private Content myContainerPropsContent;
        private Content myImagePropsContent;
        private Content myEnvVarsContent;
        private Content myPortBindingContent;
        private Content myVolumeBindingContent;
        private Content myContainerBrowserContent;
        private DockerContainerBrowser myContainerBrowser;

        DeploymentContent(@NotNull Project project, @NotNull Deployment deployment, @NotNull ServersTreeNodeSelector nodeSelector) {
            if (project == null) {
                DeploymentContent.$$$reportNull$$$0(0);
            }
            if (deployment == null) {
                DeploymentContent.$$$reportNull$$$0(1);
            }
            if (nodeSelector == null) {
                DeploymentContent.$$$reportNull$$$0(2);
            }
            this.myShown = false;
            this.myContentInitialized = false;
            this.myProject = project;
            this.myDeployment = deployment;
            this.myNodeSelector = nodeSelector;
            if (LOG.isTraceEnabled()) {
                LOG.trace(this + ":<init>, project: " + project);
            }
            ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
            TabbedPaneContentUI contentUI = new TabbedPaneContentUI(1);
            this.myManager = new ContentManagerImpl((ContentUI)contentUI, true, this.myProject){

                public boolean canCloseAllContents() {
                    return false;
                }
            };
            DeploymentLogManagerImpl logManager = (DeploymentLogManagerImpl)deployment.getOrCreateLogManager(this.myProject);
            this.myManager.addContentManagerListener((ContentManagerListener)new DockerTabContentListener((DeploymentLogManager)logManager));
            if (logManager.isMainHandlerVisible()) {
                Content content = contentFactory.createContent(logManager.getMainLoggingHandler().getConsole().getComponent(), "Deploy Log", true);
                content.setCloseable(false);
                this.myManager.addContent(content);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + ": " + this.myDeployment;
        }

        private ContentManager getManager() {
            return this.myManager;
        }

        private DockerApplicationRuntime getRuntime() {
            return (DockerApplicationRuntime)this.myDeployment.getRuntime();
        }

        private void show() {
            if (this.myShown) {
                return;
            }
            this.myShown = true;
            this.initContent();
        }

        void initContent() {
            if (this.myContentInitialized || !this.myShown) {
                return;
            }
            DockerApplicationRuntime applicationRuntime = this.getRuntime();
            if (applicationRuntime == null) {
                return;
            }
            if (applicationRuntime.getContainerId() != null) {
                this.doInitContainerContent();
                this.myContentInitialized = true;
            } else if (applicationRuntime.getImageId() != null) {
                this.doInitImageContent();
                this.myContentInitialized = true;
            }
        }

        private void initLogPanel() {
            this.myLogPanel = new JPanel();
            this.myLogPanel.setLayout(new BorderLayout());
            this.myLogContent = this.myManager.getFactory().createContent((JComponent)this.myLogPanel, "Log", true);
            this.myLogContent.setCloseable(false);
            this.myManager.addContent(this.myLogContent);
            this.myManager.setSelectedContent(this.myLogContent, true);
        }

        private void doInitContainerContent() {
            this.removeOldContent(this.myLogContent);
            this.removeOldContent(this.myEnvVarsContent);
            this.removeOldContent(this.myPortBindingContent);
            this.removeOldContent(this.myVolumeBindingContent);
            this.removeOldContent(this.myContainerPropsContent);
            this.removeOldContent(this.myContainerBrowserContent);
            this.myContainerBrowserContent = null;
            this.myContainerBrowser = null;
            this.initLogPanel();
            DockerApplicationRuntime applicationRuntime = this.getRuntime();
            applicationRuntime.showLog(this.myProject, EmptyRunnable.getInstance());
            ((CompletableFuture)applicationRuntime.promiseInspect().thenAcceptAsync(config -> {
                this.myContainerPropsContent = new EditorContentCreator((DockerAgentContainerInspection)config, applicationRuntime){
                    final /* synthetic */ DockerAgentContainerInspection val$config;
                    final /* synthetic */ DockerApplicationRuntime val$applicationRuntime;
                    {
                        this.val$config = dockerAgentContainerInspection;
                        this.val$applicationRuntime = dockerApplicationRuntime;
                    }

                    @Override
                    protected DockerRuntimeEditorBase createEditor(DockerRuntimeEditorBase.ConfigApplier onSave) {
                        return new DockerPropertiesRuntimeEditor((DockerAgentContainerConfig)this.val$config, this.val$applicationRuntime, onSave);
                    }
                }.createContent();
                this.myEnvVarsContent = new EditorContentCreator((DockerAgentContainerInspection)config){
                    final /* synthetic */ DockerAgentContainerInspection val$config;
                    {
                        this.val$config = dockerAgentContainerInspection;
                    }

                    @Override
                    protected DockerTableRuntimeEditor createEditor(DockerRuntimeEditorBase.ConfigApplier onSave) {
                        return new DockerEnvVarsRuntimeEditor((DockerAgentContainerConfig)this.val$config, onSave);
                    }
                }.createContent();
                this.myPortBindingContent = new EditorContentCreator((DockerAgentContainerInspection)config){
                    final /* synthetic */ DockerAgentContainerInspection val$config;
                    {
                        this.val$config = dockerAgentContainerInspection;
                    }

                    @Override
                    protected DockerTableRuntimeEditor createEditor(DockerRuntimeEditorBase.ConfigApplier onSave) {
                        return new DockerPortBindingRuntimeEditor((DockerAgentContainerConfig)this.val$config, onSave);
                    }
                }.createContent();
                this.myVolumeBindingContent = new EditorContentCreator((DockerAgentContainerInspection)config){
                    final /* synthetic */ DockerAgentContainerInspection val$config;
                    {
                        this.val$config = dockerAgentContainerInspection;
                    }

                    @Override
                    protected DockerTableRuntimeEditor createEditor(DockerRuntimeEditorBase.ConfigApplier onSave) {
                        return new DockerVolumeBindingsRuntimeEditor((DockerAgentContainerConfig)this.val$config, onSave, myDeployment.getConnection().getServer());
                    }
                }.createContent();
                this.myContainerBrowserContent = this.myManager.getFactory().createContent((JComponent)new JBPanelWithEmptyText((LayoutManager)new BorderLayout()).withEmptyText(DockerBundle.getText("DockerTreeStructure.DeploymentContent.containerBrowser.emptyText", new Object[0])).withBorder((Border)JBUI.Borders.empty()), DockerBundle.getText("DockerTreeStructure.DeploymentContent.containerBrowser.displayName", new Object[0]), true);
                this.myContainerBrowserContent.setCloseable(false);
                this.myManager.addContent(this.myContainerBrowserContent);
            }, (Executor)EdtExecutorService.getInstance())).exceptionally(applicationRuntime::reportError);
        }

        private void removeOldContent(Content content) {
            if (content != null) {
                this.myManager.removeFromSelection(content);
                this.myManager.removeContent(content, true);
            }
        }

        private void selectContainerLog() {
            ServerConnection connection = this.myDeployment.getConnection();
            connection.computeDeployments(() -> UIUtil.invokeLaterIfNeeded(() -> {
                String newContainerId = this.getRuntime().getContainerId();
                ServerConnection connection1 = this.myDeployment.getConnection();
                for (Deployment newDeployment : connection1.getDeployments()) {
                    DockerApplicationRuntime newDeploymentRuntime = (DockerApplicationRuntime)newDeployment.getRuntime();
                    if (newDeploymentRuntime == null || !StringUtil.equals((CharSequence)newDeploymentRuntime.getContainerId(), (CharSequence)newContainerId)) continue;
                    this.myNodeSelector.select(connection1, newDeployment.getName(), "Log");
                    break;
                }
            }));
        }

        private void doInitImageContent() {
            this.removeOldContent(this.myImagePropsContent);
            this.myImagePropsContent = new EditorContentCreator(){

                @Override
                protected DockerRuntimeEditorBase createEditor(DockerRuntimeEditorBase.ConfigApplier onSave) {
                    return new DockerPropertiesRuntimeEditor(null, this.getRuntime(), null);
                }
            }.createContent();
        }

        void updateLogs() {
            if (!this.myContentInitialized) {
                return;
            }
            DeploymentLogManagerImpl logManager = (DeploymentLogManagerImpl)this.myDeployment.getConnection().getLogManager(this.myProject, this.myDeployment);
            if (logManager == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this + ": log manager is already disposed");
                }
                return;
            }
            LinkedList<LoggingHandlerBase> logs = new LinkedList<LoggingHandlerBase>();
            LinkedList<LoggingHandlerBase> consoles = new LinkedList<LoggingHandlerBase>();
            LinkedList<LoggingHandlerBase> theRest = new LinkedList<LoggingHandlerBase>();
            for (LoggingHandlerBase next : logManager.getAdditionalLoggingHandlers()) {
                LinkedList<LoggingHandlerBase> targetList;
                String nextName;
                if (Disposer.isDisposed((Disposable)next) || (nextName = next.getPresentableName()) == null) continue;
                switch (nextName) {
                    case "Log": {
                        targetList = logs;
                        break;
                    }
                    case "Attached console": {
                        targetList = consoles;
                        break;
                    }
                    default: {
                        targetList = theRest;
                    }
                }
                targetList.add(next);
            }
            this.settleLogContent(logs);
            this.settleConsoles(consoles);
            this.settleNotReusableContents(theRest);
        }

        private void settleNotReusableContents(List<LoggingHandlerBase> rest) {
            for (LoggingHandlerBase nextHandler : rest) {
                Content existing = this.findExistingContent(nextHandler);
                if (existing != null) continue;
                JComponent handlerUI = nextHandler.getComponent();
                Content content = this.myManager.getFactory().createContent(handlerUI, nextHandler.getPresentableName(), true);
                DeploymentContent.attachToContent(content, nextHandler);
                this.myManager.addContent(content);
            }
        }

        private void settleLogContent(List<LoggingHandlerBase> logs) {
            boolean isContainer;
            LoggingHandlerBase theOneLogToShow = this.findTheOneToShow(logs);
            if (theOneLogToShow != null) {
                this.useForLogContent(theOneLogToShow);
            }
            boolean hasOpened = ContainerUtil.exists(logs, next -> !next.isClosed());
            boolean bl = isContainer = this.getRuntime() != null && this.getRuntime().getContainerId() != null;
            if (!hasOpened && isContainer && this.myDeployment.getStatus() == DeploymentStatus.DEPLOYED) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this + ": Requesting new pipe, container is deployed but no open logs: Deployment status: " + this.myDeployment.getStatus() + ", runtime status: " + this.getRuntime().getStatus());
                }
                this.getRuntime().showLog(this.myProject, EmptyRunnable.getInstance());
            }
        }

        @Nullable
        private LoggingHandlerBase findTheOneToShow(List<LoggingHandlerBase> handlers) {
            if (handlers.isEmpty()) {
                return null;
            }
            Set allNames = handlers.stream().map(LoggingHandlerBase::getPresentableName).collect(Collectors.toSet());
            assert (allNames.size() == 1) : "precondition: expect reusable handlers of the single type: " + allNames;
            List opened = ContainerUtil.filter(handlers, it -> !it.isClosed());
            if (!opened.isEmpty()) {
                if (opened.size() > 1 && LOG.isTraceEnabled()) {
                    LOG.trace(this + ": multiple OPEN log handlers found: " + opened);
                }
                return (LoggingHandlerBase)ContainerUtil.getLastItem((List)opened);
            }
            List closedLogs = ContainerUtil.filter(handlers, it -> it.isClosed());
            return (LoggingHandlerBase)ContainerUtil.getLastItem((List)closedLogs);
        }

        private void settleConsoles(List<LoggingHandlerBase> consoles) {
            if (consoles.isEmpty()) {
                return;
            }
            LoggingHandlerBase handlerToShow = this.findTheOneToShow(consoles);
            Content contentToUse = (Content)ContainerUtil.find((Object[])this.myManager.getContents(), DeploymentContent.withHandlerName("Attached console"));
            if (handlerToShow == null) {
                if (contentToUse != null) {
                    this.myManager.removeContent(contentToUse, true);
                }
            } else {
                JComponent newHandlerUI = handlerToShow.getComponent();
                if (contentToUse != null) {
                    contentToUse.setComponent(newHandlerUI);
                    DeploymentContent.attachToContent(contentToUse, handlerToShow);
                } else {
                    contentToUse = this.myManager.getFactory().createContent(newHandlerUI, handlerToShow.getPresentableName(), true);
                    DeploymentContent.attachToContent(contentToUse, handlerToShow);
                    this.myManager.addContent(contentToUse);
                }
            }
            List allSimilarContents = ContainerUtil.findAll((Object[])this.myManager.getContents(), DeploymentContent.withHandlerName("Attached console"));
            for (Content next : allSimilarContents) {
                if (next == contentToUse) continue;
                this.myManager.removeContent(next, true);
            }
        }

        private static Condition<Content> withHandlerName(@NotNull String nameToFind) {
            if (nameToFind == null) {
                DeploymentContent.$$$reportNull$$$0(3);
            }
            return handler -> {
                LoggingHandlerBase nextHandler = (LoggingHandlerBase)handler.getUserData(ADDITIONAL_LOG_KEY);
                return nextHandler != null && nameToFind.equals(nextHandler.getPresentableName());
            };
        }

        private static void attachToContent(@NotNull Content content, @NotNull LoggingHandlerBase loggingHandler) {
            if (content == null) {
                DeploymentContent.$$$reportNull$$$0(4);
            }
            if (loggingHandler == null) {
                DeploymentContent.$$$reportNull$$$0(5);
            }
            content.setPreferredFocusedComponent(() -> ((LoggingHandlerBase)loggingHandler).getPreferredFocusableComponent());
            content.putUserData(ADDITIONAL_LOG_KEY, (Object)loggingHandler);
        }

        private void useForLogContent(@NotNull LoggingHandlerBase loggingHandler) {
            if (loggingHandler == null) {
                DeploymentContent.$$$reportNull$$$0(6);
            }
            assert (!Disposer.isDisposed((Disposable)loggingHandler));
            if (this.myLogPanel == null) {
                return;
            }
            if (this.myLogPanel.getComponentCount() == 0) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this + ": useForLogContent [INITIAL]: " + loggingHandler);
                }
                this.myLogPanel.add((Component)loggingHandler.getComponent(), "Center");
                DeploymentContent.attachToContent(this.myLogContent, loggingHandler);
            } else {
                LoggingHandlerBase oldHandler = (LoggingHandlerBase)this.myLogContent.getUserData(ADDITIONAL_LOG_KEY);
                assert (oldHandler != null);
                if (oldHandler == loggingHandler) {
                    return;
                }
                if (!oldHandler.isClosed() && loggingHandler.isClosed()) {
                    LOG.warn(this + ": useForLogContent: replace OPEN " + oldHandler + ", with CLOSED: " + loggingHandler);
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace(this + ": useForLogContent: replace " + oldHandler + ", with " + loggingHandler);
                }
                this.myLogPanel.remove(oldHandler.getComponent());
                DeploymentContent.attachToContent(this.myLogContent, loggingHandler);
                this.myLogPanel.add((Component)loggingHandler.getComponent(), "Center");
            }
            this.replaceLogToolbar(loggingHandler);
            this.myLogPanel.revalidate();
        }

        @NotNull
        private static AnAction[] getToolbarActions(LoggingHandlerBase loggingHandler) {
            AnAction[] anActionArray = loggingHandler instanceof LoggingHandlerImpl ? ((LoggingHandlerImpl)loggingHandler).getConsole().createConsoleActions() : AnAction.EMPTY_ARRAY;
            if (anActionArray == null) {
                DeploymentContent.$$$reportNull$$$0(7);
            }
            return anActionArray;
        }

        private void replaceLogToolbar(@NotNull LoggingHandlerBase loggingHandler) {
            if (loggingHandler == null) {
                DeploymentContent.$$$reportNull$$$0(8);
            }
            if (this.myLogToolbar != null) {
                this.myLogPanel.remove(this.myLogToolbar);
                this.myLogToolbar = null;
            }
            AnAction[] toolbarActions = DeploymentContent.getToolbarActions(loggingHandler);
            DefaultActionGroup actions = new DefaultActionGroup();
            for (AnAction next : toolbarActions) {
                actions.add(next);
            }
            this.myLogContent.setActions((ActionGroup)actions, LOG_TOOLBAR_PLACE, loggingHandler.getComponent());
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(LOG_TOOLBAR_PLACE, (ActionGroup)actions, false);
            toolbar.setTargetComponent(loggingHandler.getComponent());
            this.myLogToolbar = toolbar.getComponent();
            this.myLogPanel.add((Component)this.myLogToolbar, "East");
        }

        @Nullable
        private Content findExistingContent(@NotNull LoggingHandlerBase handler) {
            if (handler == null) {
                DeploymentContent.$$$reportNull$$$0(9);
            }
            for (Content next : this.myManager.getContents()) {
                LoggingHandlerBase nextHandler = (LoggingHandlerBase)next.getUserData(ADDITIONAL_LOG_KEY);
                if (nextHandler != handler) continue;
                return next;
            }
            return null;
        }

        private void update() {
            if (this.myContainerBrowserContent != null) {
                ApplicationManager.getApplication().invokeLater(() -> this.updateBrowser(this.myContainerBrowserContent.isSelected()));
            }
        }

        private void selectionChanged(@NotNull Content content, @Nullable ContentManagerEvent.ContentOperation operation) {
            if (content == null) {
                DeploymentContent.$$$reportNull$$$0(10);
            }
            if (content == this.myContainerBrowserContent && operation == ContentManagerEvent.ContentOperation.add) {
                this.updateBrowser(true);
            }
        }

        private void updateBrowser(boolean selected) {
            DockerApplicationRuntime applicationRuntime;
            DockerApplicationRuntime dockerApplicationRuntime = applicationRuntime = this.myDeployment instanceof LocalDeploymentImpl ? (DockerApplicationRuntime)((LocalDeploymentImpl)this.myDeployment).getRemoteRuntime() : this.getRuntime();
            if (applicationRuntime == null || this.myDeployment.getStatus() != DeploymentStatus.DEPLOYED) {
                if (this.myContainerBrowser != null) {
                    this.myContainerBrowserContent.setActions(null, null, null);
                    JComponent component = this.myContainerBrowserContent.getComponent();
                    component.removeAll();
                    Disposer.dispose((Disposable)this.myContainerBrowser);
                    this.myContainerBrowser = null;
                    component.repaint();
                }
                return;
            }
            if (this.myContainerBrowser != null || !selected) {
                return;
            }
            this.myContainerBrowser = new DockerContainerBrowser(this.myProject, applicationRuntime, (arg_0, arg_1, arg_2) -> ((Content)this.myContainerBrowserContent).setActions(arg_0, arg_1, arg_2));
            this.myContainerBrowserContent.getComponent().add((Component)((Object)this.myContainerBrowser), "Center");
            Disposer.register((Disposable)this.myContainerBrowserContent, (Disposable)this.myContainerBrowser);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deployment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeSelector";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameToFind";
                    break;
                }
                case 4: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loggingHandler";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/view/DockerTreeStructure$DeploymentContent";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/view/DockerTreeStructure$DeploymentContent";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolbarActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "withHandlerName";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "attachToContent";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "useForLogContent";
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceLogToolbar";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "findExistingContent";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "selectionChanged";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class DockerTabContentListener
        extends ContentManagerAdapter {
            private final DeploymentLogManager myLogManager;

            DockerTabContentListener(DeploymentLogManager logManager) {
                if (logManager == null) {
                    DockerTabContentListener.$$$reportNull$$$0(0);
                }
                this.myLogManager = logManager;
            }

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                Content content;
                LoggingHandlerBase additionalLog;
                TerminalHandlerBase terminalHandler;
                if (event == null) {
                    DockerTabContentListener.$$$reportNull$$$0(1);
                }
                if ((terminalHandler = (TerminalHandlerBase)ObjectUtils.tryCast((Object)(additionalLog = (LoggingHandlerBase)(content = event.getContent()).getUserData(ADDITIONAL_LOG_KEY)), TerminalHandlerBase.class)) != null) {
                    terminalHandler.close();
                }
                if (additionalLog != null && content.isCloseable()) {
                    this.myLogManager.removeAdditionalLog(additionalLog.getPresentableName());
                    Disposer.dispose((Disposable)additionalLog);
                }
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    DockerTabContentListener.$$$reportNull$$$0(2);
                }
                DeploymentContent.this.selectionChanged(event.getContent(), event.getOperation());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "logManager";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/docker/view/DockerTreeStructure$DeploymentContent$DockerTabContentListener";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private abstract class EditorContentCreator {
            private EditorContentCreator() {
            }

            protected abstract DockerRuntimeEditorBase createEditor(DockerRuntimeEditorBase.ConfigApplier var1);

            public Content createContent() {
                DockerRuntimeEditorBase editor = this.createEditor(this::onEditorSave);
                Content result = DeploymentContent.this.myManager.getFactory().createContent((JComponent)editor.getMainPanel(), editor.getName(), true);
                result.setCloseable(false);
                DeploymentContent.this.myManager.addContent(result);
                return result;
            }

            private boolean onEditorSave(DockerAgentContainerConfig newConfig) {
                assert (newConfig != null);
                DockerApplicationRuntime runtime = DeploymentContent.this.getRuntime();
                if (runtime == null) {
                    return false;
                }
                runtime.updateContainer(newConfig).thenAccept(result -> {
                    DeploymentContent.this.myContentInitialized = false;
                    DeploymentContent.this.selectContainerLog();
                });
                return true;
            }
        }
    }

    public static class DockerDeploymentNode
    extends ServersTreeStructure.DeploymentNodeImpl {
        private final DeploymentContentProvider myContentProvider;
        private DeploymentContent myContent;

        public DockerDeploymentNode(Project project, @NotNull ServerConnection<?> connection, @NotNull ServersTreeStructure.RemoteServerNode serverNode, @NotNull Deployment value, @NotNull ServersTreeStructure.DeploymentNodeProducer nodeProducer, @NotNull DeploymentContentProvider contentProvider) {
            if (connection == null) {
                DockerDeploymentNode.$$$reportNull$$$0(0);
            }
            if (serverNode == null) {
                DockerDeploymentNode.$$$reportNull$$$0(1);
            }
            if (value == null) {
                DockerDeploymentNode.$$$reportNull$$$0(2);
            }
            if (nodeProducer == null) {
                DockerDeploymentNode.$$$reportNull$$$0(3);
            }
            if (contentProvider == null) {
                DockerDeploymentNode.$$$reportNull$$$0(4);
            }
            super(project, connection, serverNode, value, nodeProducer);
            this.myContentProvider = contentProvider;
        }

        @Nullable
        public JComponent getComponent() {
            DeploymentContent content = this.getContent();
            content.show();
            return content.getManager().getComponent();
        }

        private DeploymentContent getContent() {
            if (this.myContent == null) {
                this.myContent = this.myContentProvider.getDeploymentContent(this.getDeployment());
                this.myContent.initContent();
                this.myContent.updateLogs();
            }
            return this.myContent;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ArrayList result = new ArrayList();
            this.collectDeploymentChildren(result);
            Collection collection = result.stream().filter(DockerTreeFilter.getInstance()::acceptNode).filter(node -> !DockerDeploymentNode.isUndeployedDockerNode(node)).collect(Collectors.toList());
            if (collection == null) {
                DockerDeploymentNode.$$$reportNull$$$0(5);
            }
            return collection;
        }

        private static boolean isUndeployedDockerNode(@Nullable AbstractTreeNode node) {
            Deployment deployment = Optional.ofNullable(node).map(o -> (DockerDeploymentNode)((Object)((Object)ObjectUtils.tryCast((Object)o, DockerDeploymentNode.class)))).map(ServersTreeStructure.DeploymentNodeImpl::getDeployment).orElse(null);
            return deployment != null && DockerDeploymentStatus.DELETED.matches(deployment) && deployment.getRuntime() instanceof DockerDeploymentRuntime;
        }

        public void selectLog(String logName) {
            ContentManager contentManager = this.getContent().getManager();
            Content[] allContents = contentManager.getContents();
            for (int i = allContents.length - 1; i >= 0; --i) {
                Content content = allContents[i];
                LoggingHandlerBase additionalLog = (LoggingHandlerBase)content.getUserData(ADDITIONAL_LOG_KEY);
                if (additionalLog == null || !StringUtil.equals((CharSequence)additionalLog.getPresentableName(), (CharSequence)logName)) continue;
                contentManager.setSelectedContent(content, true);
                return;
            }
        }

        protected void update(@NotNull PresentationData presentation) {
            ComposeServiceRuntime serviceRuntime;
            if (presentation == null) {
                DockerDeploymentNode.$$$reportNull$$$0(6);
            }
            super.update(presentation);
            Deployment deployment = this.getDeployment();
            DockerApplicationRuntime runtime = (DockerApplicationRuntime)deployment.getRuntime();
            if (deployment.getStatus() == DeploymentStatus.DEPLOYED) {
                Icon icon = runtime != null && runtime.getStatus() == DockerDeploymentStatus.IMAGE.getStatus() ? DockerIcons.SingleImage : DockerIcons.SingleRunningContainer;
                presentation.setIcon(icon);
            }
            if ((serviceRuntime = (ComposeServiceRuntime)ObjectUtils.tryCast((Object)((Object)runtime), ComposeServiceRuntime.class)) != null) {
                presentation.setPresentableText(serviceRuntime.getServiceName());
            }
            (this.myContent != null ? this.myContent : this.myContentProvider.getDeploymentContent(deployment)).update();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeProducer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentProvider";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/view/DockerTreeStructure$DockerDeploymentNode";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/view/DockerTreeStructure$DockerDeploymentNode";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

