/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collections;
import java.util.Set;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2Entity;
import org.angular2.entities.source.Angular2SourceEntityListProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class Angular2SourceEntityListValidator<T extends Angular2Entity, E extends Enum>
extends Angular2SourceEntityListProcessor<T> {
    private final String myPropertyName;
    private ES6Decorator myDecorator;
    private ValidationResults<? super E> myResults;
    private TreeTraversal.TracingIt<PsiElement> myIterator;

    protected Angular2SourceEntityListValidator(@NotNull Class<T> entityClass, String propertyName) {
        if (entityClass == null) {
            Angular2SourceEntityListValidator.$$$reportNull$$$0(0);
        }
        super(entityClass);
        this.myPropertyName = propertyName;
    }

    public void validate(@NotNull ES6Decorator decorator, @NotNull ValidationResults<? super E> results) {
        if (decorator == null) {
            Angular2SourceEntityListValidator.$$$reportNull$$$0(1);
        }
        if (results == null) {
            Angular2SourceEntityListValidator.$$$reportNull$$$0(2);
        }
        this.myDecorator = decorator;
        this.myResults = results;
        JSProperty property = Angular2DecoratorUtil.getProperty(this.myDecorator, this.myPropertyName);
        if (property == null) {
            return;
        }
        AstLoadingFilter.forceAllowTreeLoading((PsiFile)property.getContainingFile(), () -> {
            JSExpression value = property.getValue();
            if (value == null) {
                return;
            }
            HashSet visited = new HashSet();
            this.myIterator = (TreeTraversal.TracingIt)TreeTraversal.LEAVES_DFS.traversal(Collections.singletonList(value), arg_0 -> this.lambda$null$0((Set)visited, arg_0)).typedIterator();
            while (this.myIterator.advance()) {
                ProgressManager.checkCanceled();
                ((PsiElement)this.myIterator.current()).accept((PsiElementVisitor)this.getResultsVisitor());
            }
        });
    }

    @NotNull
    protected PsiElement locateProblemElement() {
        PsiFile file = this.myDecorator.getContainingFile().getOriginalFile();
        for (PsiElement el : ContainerUtil.concat((Iterable[])new Iterable[]{Collections.singletonList(this.myIterator.current()), this.myIterator.backtrace()})) {
            if (!file.equals(el.getContainingFile().getOriginalFile()) || !this.myDecorator.getTextRange().contains(el.getTextRange())) continue;
            PsiElement psiElement = el;
            if (psiElement == null) {
                Angular2SourceEntityListValidator.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        ES6Decorator eS6Decorator = this.myDecorator;
        if (eS6Decorator == null) {
            Angular2SourceEntityListValidator.$$$reportNull$$$0(4);
        }
        return eS6Decorator;
    }

    protected void registerProblem(@NotNull E problemType, @NotNull String message, LocalQuickFix ... quickFixes) {
        if (problemType == null) {
            Angular2SourceEntityListValidator.$$$reportNull$$$0(5);
        }
        if (message == null) {
            Angular2SourceEntityListValidator.$$$reportNull$$$0(6);
        }
        ((ValidationResults)this.myResults).registerProblem(this.locateProblemElement(), problemType, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, quickFixes);
    }

    protected void registerProblem(@NotNull E problemType, @NotNull String message, @NotNull ProblemHighlightType severity, LocalQuickFix ... quickFixes) {
        if (problemType == null) {
            Angular2SourceEntityListValidator.$$$reportNull$$$0(7);
        }
        if (message == null) {
            Angular2SourceEntityListValidator.$$$reportNull$$$0(8);
        }
        if (severity == null) {
            Angular2SourceEntityListValidator.$$$reportNull$$$0(9);
        }
        ((ValidationResults)this.myResults).registerProblem(this.locateProblemElement(), problemType, message, severity, quickFixes);
    }

    private /* synthetic */ Iterable lambda$null$0(Set visited, PsiElement element) {
        return visited.add(element) ? this.resolve(element) : Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/inspections/Angular2SourceEntityListValidator";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemType";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/inspections/Angular2SourceEntityListValidator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "locateProblemElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ValidationResults<T extends Enum> {
        private static final ValidationResults<?> EMPTY = new ValidationResults(){

            public void registerProblems(@NotNull Enum problemType, @NotNull ProblemsHolder holder) {
                if (problemType == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (holder == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "problemType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "holder";
                        break;
                    }
                }
                objectArray[1] = "org/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults$1";
                objectArray[2] = "registerProblems";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        private final MultiMap<T, ValidationProblem> results = new MultiMap();

        @NotNull
        public static <T extends Enum> ValidationResults<T> empty() {
            ValidationResults<?> validationResults = EMPTY;
            if (validationResults == null) {
                ValidationResults.$$$reportNull$$$0(0);
            }
            return validationResults;
        }

        public void registerProblems(@NotNull T problemType, @NotNull ProblemsHolder holder) {
            if (problemType == null) {
                ValidationResults.$$$reportNull$$$0(1);
            }
            if (holder == null) {
                ValidationResults.$$$reportNull$$$0(2);
            }
            for (ValidationProblem problem : this.results.get(problemType)) {
                holder.registerProblem(problem.getLocation(), problem.getMessage(), problem.getSeverity(), problem.getFixes());
            }
        }

        private void registerProblem(final @NotNull PsiElement element, @NotNull T type, final @NotNull String message, final @NotNull ProblemHighlightType severity, final LocalQuickFix ... quickFixes) {
            if (element == null) {
                ValidationResults.$$$reportNull$$$0(3);
            }
            if (type == null) {
                ValidationResults.$$$reportNull$$$0(4);
            }
            if (message == null) {
                ValidationResults.$$$reportNull$$$0(5);
            }
            if (severity == null) {
                ValidationResults.$$$reportNull$$$0(6);
            }
            this.results.putValue(type, (Object)new ValidationProblem(){

                @Override
                @NotNull
                public String getMessage() {
                    String string = message;
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                @NotNull
                public PsiElement getLocation() {
                    PsiElement psiElement = element;
                    if (psiElement == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return psiElement;
                }

                @Override
                @NotNull
                public ProblemHighlightType getSeverity() {
                    ProblemHighlightType problemHighlightType = severity;
                    if (problemHighlightType == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return problemHighlightType;
                }

                @Override
                @Nullable
                public LocalQuickFix[] getFixes() {
                    return quickFixes;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "org/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getMessage";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getLocation";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getSeverity";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "empty";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/angular2/inspections/Angular2SourceEntityListValidator$ValidationResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "registerProblems";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "registerProblem";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ValidationProblem {
        @NotNull
        public PsiElement getLocation();

        @NotNull
        public String getMessage();

        @NotNull
        public ProblemHighlightType getSeverity();

        @Nullable
        public LocalQuickFix[] getFixes();
    }
}

