/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang.html.parser;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.angular2.codeInsight.template.Angular2TemplateElementsScopeProvider;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.html.parser.Angular2AttributeType;
import org.angular2.lang.html.psi.Angular2HtmlEvent;
import org.angular2.lang.html.psi.PropertyBindingType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2AttributeNameParser {
    @NonNls
    private static final Map<String, String> ATTR_TO_PROP_MAPPING = ContainerUtil.newHashMap((Pair)Pair.pair((Object)"class", (Object)"className"), (Pair[])new Pair[]{Pair.pair((Object)"for", (Object)"htmlFor"), Pair.pair((Object)"formaction", (Object)"formAction"), Pair.pair((Object)"innerHtml", (Object)"innerHTML"), Pair.pair((Object)"readonly", (Object)"readOnly"), Pair.pair((Object)"tabindex", (Object)"tabIndex")});

    @NotNull
    public static AttributeInfo parseBound(@NotNull String name) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(0);
        }
        AttributeInfo info = Angular2AttributeNameParser.parse(name);
        AttributeInfo attributeInfo = info.type != Angular2AttributeType.REGULAR ? info : new PropertyBindingInfo(info.name, info.isCanonical, false, PropertyBindingType.PROPERTY);
        if (attributeInfo == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(1);
        }
        return attributeInfo;
    }

    public static AttributeInfo parse(@NotNull String name) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(2);
        }
        return Angular2AttributeNameParser.parse(name, "ng-template");
    }

    @NotNull
    public static AttributeInfo parse(@NotNull String name, @Nullable XmlTag tag) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(3);
        }
        AttributeInfo attributeInfo = Angular2AttributeNameParser.parse(name, tag != null ? tag.getLocalName() : "ng-template");
        if (attributeInfo == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(4);
        }
        return attributeInfo;
    }

    @NotNull
    public static AttributeInfo parse(@NotNull String name, @NotNull String tagName) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(5);
        }
        if (tagName == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(6);
        }
        if ((name = Angular2AttributeNameParser.normalizeAttributeName(name)).startsWith("bindon-")) {
            AttributeInfo attributeInfo = Angular2AttributeNameParser.parsePropertyBindingCanonical(name.substring(7), true);
            if (attributeInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(7);
            }
            return attributeInfo;
        }
        if (name.startsWith("[(") && name.endsWith(")]")) {
            AttributeInfo attributeInfo = Angular2AttributeNameParser.parsePropertyBindingShort(name.substring(2, name.length() - 2), true);
            if (attributeInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(8);
            }
            return attributeInfo;
        }
        if (name.startsWith("bind-")) {
            AttributeInfo attributeInfo = Angular2AttributeNameParser.parsePropertyBindingCanonical(name.substring(5), false);
            if (attributeInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(9);
            }
            return attributeInfo;
        }
        if (name.startsWith("[") && name.endsWith("]")) {
            AttributeInfo attributeInfo = Angular2AttributeNameParser.parsePropertyBindingShort(name.substring(1, name.length() - 1), false);
            if (attributeInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(10);
            }
            return attributeInfo;
        }
        if (name.startsWith("on-")) {
            AttributeInfo attributeInfo = Angular2AttributeNameParser.parseEvent(name.substring(3), true);
            if (attributeInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(11);
            }
            return attributeInfo;
        }
        if (name.startsWith("(") && name.endsWith(")")) {
            AttributeInfo attributeInfo = Angular2AttributeNameParser.parseEvent(name.substring(1, name.length() - 1), false);
            if (attributeInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(12);
            }
            return attributeInfo;
        }
        if (name.startsWith("*")) {
            AttributeInfo attributeInfo = Angular2AttributeNameParser.parseTemplateBindings(name.substring(1));
            if (attributeInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(13);
            }
            return attributeInfo;
        }
        if (name.startsWith("let-")) {
            AttributeInfo attributeInfo = Angular2AttributeNameParser.parseVariable(name.substring(4), Angular2TemplateElementsScopeProvider.isTemplateTag(tagName));
            if (attributeInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(14);
            }
            return attributeInfo;
        }
        if (name.startsWith("#")) {
            AttributeInfo attributeInfo = Angular2AttributeNameParser.parseReference(name.substring(1), false);
            if (attributeInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(15);
            }
            return attributeInfo;
        }
        if (name.startsWith("ref-")) {
            AttributeInfo attributeInfo = Angular2AttributeNameParser.parseReference(name.substring(4), true);
            if (attributeInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(16);
            }
            return attributeInfo;
        }
        if (name.startsWith("@")) {
            PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo(name.substring(1), false, false, PropertyBindingType.ANIMATION);
            if (propertyBindingInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(17);
            }
            return propertyBindingInfo;
        }
        if (name.equals("select") && tagName.equals("ng-content")) {
            AttributeInfo attributeInfo = new AttributeInfo(name, false, Angular2AttributeType.NG_CONTENT_SELECTOR);
            if (attributeInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(18);
            }
            return attributeInfo;
        }
        AttributeInfo attributeInfo = new AttributeInfo(name, false, Angular2AttributeType.REGULAR);
        if (attributeInfo == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(19);
        }
        return attributeInfo;
    }

    @NotNull
    public static String normalizeAttributeName(@NotNull String name) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(20);
        }
        if (StringUtil.startsWithIgnoreCase((String)name, (String)"data-")) {
            String string = name.substring(5);
            if (string == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private static AttributeInfo parsePropertyBindingShort(@NotNull String name, boolean bananaBoxBinding) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(23);
        }
        if (!bananaBoxBinding && name.startsWith("@")) {
            PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo(name.substring(1), false, false, PropertyBindingType.ANIMATION);
            if (propertyBindingInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(24);
            }
            return propertyBindingInfo;
        }
        AttributeInfo attributeInfo = Angular2AttributeNameParser.parsePropertyBindingRest(name, false, bananaBoxBinding);
        if (attributeInfo == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(25);
        }
        return attributeInfo;
    }

    @NotNull
    private static AttributeInfo parsePropertyBindingCanonical(@NotNull String name, boolean bananaBoxBinding) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(26);
        }
        if (!bananaBoxBinding && name.startsWith("animate-")) {
            PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo(name.substring(8), true, false, PropertyBindingType.ANIMATION);
            if (propertyBindingInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(27);
            }
            return propertyBindingInfo;
        }
        AttributeInfo attributeInfo = Angular2AttributeNameParser.parsePropertyBindingRest(name, true, bananaBoxBinding);
        if (attributeInfo == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(28);
        }
        return attributeInfo;
    }

    @NotNull
    private static AttributeInfo parsePropertyBindingRest(@NotNull String name, boolean isCanonical, boolean bananaBoxBinding) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(29);
        }
        if (name.startsWith("attr.")) {
            PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo(name.substring(5), isCanonical, bananaBoxBinding, PropertyBindingType.ATTRIBUTE);
            if (propertyBindingInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(30);
            }
            return propertyBindingInfo;
        }
        if (name.startsWith("class.")) {
            PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo(name.substring(6), isCanonical, bananaBoxBinding, PropertyBindingType.CLASS);
            if (propertyBindingInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(31);
            }
            return propertyBindingInfo;
        }
        if (name.startsWith("style.")) {
            PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo(name.substring(6), isCanonical, bananaBoxBinding, PropertyBindingType.STYLE);
            if (propertyBindingInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(32);
            }
            return propertyBindingInfo;
        }
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo(name, isCanonical, bananaBoxBinding, PropertyBindingType.PROPERTY);
        if (propertyBindingInfo == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(33);
        }
        return propertyBindingInfo;
    }

    @NotNull
    private static AttributeInfo parseEvent(@NotNull String name, boolean isCanonical) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(34);
        }
        if (name.startsWith("@")) {
            name = name.substring(1);
        } else if (name.startsWith("animate-")) {
            name = name.substring(8);
        } else {
            EventInfo eventInfo = new EventInfo(name, isCanonical);
            if (eventInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(35);
            }
            return eventInfo;
        }
        AttributeInfo attributeInfo = Angular2AttributeNameParser.parseAnimationEvent(name, isCanonical);
        if (attributeInfo == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(36);
        }
        return attributeInfo;
    }

    @NotNull
    private static AttributeInfo parseTemplateBindings(@NotNull String name) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(37);
        }
        AttributeInfo attributeInfo = new AttributeInfo(name, false, Angular2AttributeType.TEMPLATE_BINDINGS);
        if (attributeInfo == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(38);
        }
        return attributeInfo;
    }

    @NotNull
    private static AttributeInfo parseAnimationEvent(@NotNull String name, boolean isCanonical) {
        int dot;
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(39);
        }
        if ((dot = name.indexOf(46)) < 0) {
            EventInfo eventInfo = new EventInfo(name, isCanonical, Angular2HtmlEvent.AnimationPhase.INVALID, Angular2Bundle.message("angular.parse.template.animation-trigger-missing-phase-value", name));
            if (eventInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(40);
            }
            return eventInfo;
        }
        String phase = StringUtil.toLowerCase((String)name.substring(dot + 1));
        name = name.substring(0, dot);
        if ("done".equals(phase)) {
            EventInfo eventInfo = new EventInfo(name, isCanonical, Angular2HtmlEvent.AnimationPhase.DONE);
            if (eventInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(41);
            }
            return eventInfo;
        }
        if ("start".equals(phase)) {
            EventInfo eventInfo = new EventInfo(name, isCanonical, Angular2HtmlEvent.AnimationPhase.START);
            if (eventInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(42);
            }
            return eventInfo;
        }
        EventInfo eventInfo = new EventInfo(name, isCanonical, Angular2HtmlEvent.AnimationPhase.INVALID, Angular2Bundle.message("angular.parse.template.animation-trigger-wrong-output-phase", phase, name.substring(0, dot)));
        if (eventInfo == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(43);
        }
        return eventInfo;
    }

    @NotNull
    private static AttributeInfo parseVariable(@NotNull String varName, boolean isInTemplateTag) {
        if (varName == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(44);
        }
        if (!isInTemplateTag) {
            AttributeInfo attributeInfo = new AttributeInfo(varName, false, Angular2AttributeType.REGULAR, Angular2Bundle.message("angular.parse.template.let-only-on-ng-template", new Object[0]));
            if (attributeInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(45);
            }
            return attributeInfo;
        }
        if (varName.contains("-")) {
            AttributeInfo attributeInfo = new AttributeInfo(varName, false, Angular2AttributeType.REGULAR, Angular2Bundle.message("angular.parse.template.let-dash-not-allowed-in-name", new Object[0]));
            if (attributeInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(46);
            }
            return attributeInfo;
        }
        AttributeInfo attributeInfo = new AttributeInfo(varName, false, Angular2AttributeType.VARIABLE);
        if (attributeInfo == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(47);
        }
        return attributeInfo;
    }

    @NotNull
    private static AttributeInfo parseReference(@NotNull String refName, boolean isCanonical) {
        if (refName == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(48);
        }
        if (refName.contains("-")) {
            AttributeInfo attributeInfo = new AttributeInfo(refName, false, Angular2AttributeType.REGULAR, Angular2Bundle.message("angular.parse.template.ref-var-dash-not-allowed-in-name", new Object[0]));
            if (attributeInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(49);
            }
            return attributeInfo;
        }
        if (refName.isEmpty()) {
            AttributeInfo attributeInfo = new AttributeInfo("", false, Angular2AttributeType.REGULAR);
            if (attributeInfo == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(50);
            }
            return attributeInfo;
        }
        AttributeInfo attributeInfo = new AttributeInfo(refName, isCanonical, Angular2AttributeType.REFERENCE);
        if (attributeInfo == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(51);
        }
        return attributeInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/lang/html/parser/Angular2AttributeNameParser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/lang/html/parser/Angular2AttributeNameParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBound";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeAttributeName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePropertyBindingShort";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePropertyBindingCanonical";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePropertyBindingRest";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "parseEvent";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTemplateBindings";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAnimationEvent";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVariable";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "parseReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseBound";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "normalizeAttributeName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parsePropertyBindingShort";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parsePropertyBindingCanonical";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parsePropertyBindingRest";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "parseEvent";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "parseTemplateBindings";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "parseAnimationEvent";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "parseVariable";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "parseReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EventInfo
    extends AttributeInfo {
        @Nullable
        public final Angular2HtmlEvent.AnimationPhase animationPhase;
        @NotNull
        public final Angular2HtmlEvent.EventType eventType;

        public EventInfo(@NotNull String name, boolean isCanonical) {
            if (name == null) {
                EventInfo.$$$reportNull$$$0(0);
            }
            super(name, isCanonical, Angular2AttributeType.EVENT);
            this.eventType = Angular2HtmlEvent.EventType.REGULAR;
            this.animationPhase = null;
        }

        public EventInfo(@NotNull String name, boolean isCanonical, @NotNull Angular2HtmlEvent.AnimationPhase animationPhase) {
            if (name == null) {
                EventInfo.$$$reportNull$$$0(1);
            }
            if (animationPhase == null) {
                EventInfo.$$$reportNull$$$0(2);
            }
            this(name, isCanonical, animationPhase, null);
        }

        public EventInfo(@NotNull String name, boolean isCanonical, @NotNull Angular2HtmlEvent.AnimationPhase animationPhase, @Nullable String error) {
            if (name == null) {
                EventInfo.$$$reportNull$$$0(3);
            }
            if (animationPhase == null) {
                EventInfo.$$$reportNull$$$0(4);
            }
            super(name, isCanonical, Angular2AttributeType.EVENT, error);
            this.animationPhase = animationPhase;
            this.eventType = Angular2HtmlEvent.EventType.ANIMATION;
        }

        @Override
        public boolean isEquivalent(@Nullable AttributeInfo otherInfo) {
            return otherInfo instanceof EventInfo && this.eventType == ((EventInfo)otherInfo).eventType && this.animationPhase == ((EventInfo)otherInfo).animationPhase && super.isEquivalent(otherInfo);
        }

        @Override
        public String getFullName() {
            if (this.eventType == Angular2HtmlEvent.EventType.ANIMATION) {
                if (this.animationPhase != null) {
                    switch (this.animationPhase) {
                        case DONE: {
                            return "@" + this.name + ".done";
                        }
                        case START: {
                            return "@" + this.name + ".start";
                        }
                    }
                }
                return "@" + this.name;
            }
            return this.name;
        }

        @Override
        public String toString() {
            return "<" + this.name + ", " + (Object)((Object)this.eventType) + (this.eventType == Angular2HtmlEvent.EventType.ANIMATION ? ", " + (Object)((Object)this.animationPhase) : "") + ">";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "animationPhase";
                    break;
                }
            }
            objectArray[1] = "org/angular2/lang/html/parser/Angular2AttributeNameParser$EventInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PropertyBindingInfo
    extends AttributeInfo {
        @NotNull
        public final PropertyBindingType bindingType;

        public PropertyBindingInfo(@NotNull String name, boolean isCanonical, boolean bananaBoxBinding, @NotNull PropertyBindingType bindingType) {
            if (name == null) {
                PropertyBindingInfo.$$$reportNull$$$0(0);
            }
            if (bindingType == null) {
                PropertyBindingInfo.$$$reportNull$$$0(1);
            }
            super(ATTR_TO_PROP_MAPPING.getOrDefault(name, name), isCanonical, bananaBoxBinding ? Angular2AttributeType.BANANA_BOX_BINDING : Angular2AttributeType.PROPERTY_BINDING);
            this.bindingType = bindingType;
        }

        @Override
        public boolean isEquivalent(@Nullable AttributeInfo otherInfo) {
            return otherInfo instanceof PropertyBindingInfo && this.bindingType == ((PropertyBindingInfo)otherInfo).bindingType && super.isEquivalent(otherInfo);
        }

        @Override
        public String getFullName() {
            switch (this.bindingType) {
                case ANIMATION: {
                    return (this.isCanonical ? "animate-" : "@") + this.name;
                }
                case ATTRIBUTE: {
                    return "attr." + this.name;
                }
                case STYLE: {
                    return "style." + this.name;
                }
                case CLASS: {
                    return "class." + this.name;
                }
            }
            return this.name;
        }

        @Override
        public String toString() {
            return "<" + this.name + "," + (Object)((Object)this.bindingType) + ">";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bindingType";
                    break;
                }
            }
            objectArray[1] = "org/angular2/lang/html/parser/Angular2AttributeNameParser$PropertyBindingInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AttributeInfo {
        @NotNull
        public final String name;
        @Nullable
        public final String error;
        @NotNull
        public final Angular2AttributeType type;
        public final boolean isCanonical;

        public AttributeInfo(@NotNull String name, boolean isCanonical, @NotNull Angular2AttributeType type) {
            if (name == null) {
                AttributeInfo.$$$reportNull$$$0(0);
            }
            if (type == null) {
                AttributeInfo.$$$reportNull$$$0(1);
            }
            this(name, isCanonical, type, null);
        }

        public AttributeInfo(@NotNull String name, boolean isCanonical, @NotNull Angular2AttributeType type, @Nullable String error) {
            if (name == null) {
                AttributeInfo.$$$reportNull$$$0(2);
            }
            if (type == null) {
                AttributeInfo.$$$reportNull$$$0(3);
            }
            this.name = name;
            this.error = error;
            this.type = type;
            this.isCanonical = isCanonical;
        }

        public boolean isEquivalent(@Nullable AttributeInfo otherInfo) {
            return otherInfo != null && this.name.equals(otherInfo.name) && this.type == otherInfo.type;
        }

        public String getFullName() {
            return this.name;
        }

        public String toString() {
            return "<" + this.name + ">";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "org/angular2/lang/html/parser/Angular2AttributeNameParser$AttributeInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

