/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ArrayUtilRt;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.Searcher;
import org.jetbrains.plugins.textmate.regex.StringWithId;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.exception.JOniException;

public class RegexFacade {
    private static final Regex FAILED_REGEX = new Regex("^$", (Encoding)UTF8Encoding.INSTANCE);
    private static final Logger LOGGER = Logger.getInstance(RegexFacade.class);
    @NotNull
    private byte[] myRegexBytes;
    private Regex myRegex;
    private final ThreadLocal<LastMatch> matchResult;
    private static final LoadingCache<String, RegexFacade> REGEX_CACHE = CacheBuilder.newBuilder().maximumSize(2048L).build(CacheLoader.from(regexString -> new RegexFacade(Objects.requireNonNull(regexString).getBytes(StandardCharsets.UTF_8))));

    private RegexFacade(@NotNull byte[] regexBytes) {
        if (regexBytes == null) {
            RegexFacade.$$$reportNull$$$0(0);
        }
        this.myRegex = null;
        this.matchResult = new ThreadLocal();
        this.myRegexBytes = regexBytes;
    }

    public MatchData match(StringWithId string) {
        return this.match(string, 0);
    }

    public MatchData match(@NotNull StringWithId string, int byteOffset) {
        MatchData lastMatch;
        LastMatch lastResult;
        if (string == null) {
            RegexFacade.$$$reportNull$$$0(1);
        }
        Object lastId = (lastResult = this.matchResult.get()) != null ? lastResult.lastId : null;
        int lastOffset = lastResult != null ? lastResult.lastOffset : Integer.MAX_VALUE;
        MatchData matchData = lastMatch = lastResult != null ? lastResult.lastMatch : MatchData.NOT_MATCHED;
        if (!(lastId != string.id || lastOffset > byteOffset || lastMatch.matched() && lastMatch.byteOffset().getStartOffset() < byteOffset)) {
            RegexFacade.checkMatched(lastMatch, string);
            return lastMatch;
        }
        ProgressManager.checkCanceled();
        lastId = string.id;
        lastOffset = byteOffset;
        Matcher matcher = this.getRegex().matcher(string.bytes);
        int matchIndex = matcher.search(byteOffset, string.bytes.length, 256);
        lastMatch = matchIndex > -1 ? MatchData.fromRegion(matcher.getEagerRegion()) : MatchData.NOT_MATCHED;
        RegexFacade.checkMatched(lastMatch, string);
        this.matchResult.set(new LastMatch(lastId, lastOffset, lastMatch));
        return lastMatch;
    }

    private static void checkMatched(MatchData match, StringWithId string) {
        if (match.matched() && match.byteOffset().getEndOffset() > string.bytes.length) {
            throw new IllegalStateException("Match data out of bounds: " + match.byteOffset().getStartOffset() + " > " + string.bytes.length + "\n" + new String(string.bytes, StandardCharsets.UTF_8));
        }
    }

    public Searcher searcher(byte[] stringBytes) {
        return new Searcher(stringBytes, this.getRegex().matcher(stringBytes, 0, stringBytes.length));
    }

    @NotNull
    private Regex getRegex() {
        if (this.myRegex == null) {
            try {
                this.myRegex = new Regex(this.myRegexBytes, 0, this.myRegexBytes.length, 256, (Encoding)UTF8Encoding.INSTANCE);
            }
            catch (JOniException e) {
                LOGGER.info("Failed to parse textmate regex", (Throwable)e);
                this.myRegex = FAILED_REGEX;
            }
            this.myRegexBytes = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        Regex regex = this.myRegex;
        if (regex == null) {
            RegexFacade.$$$reportNull$$$0(2);
        }
        return regex;
    }

    @NotNull
    public static RegexFacade regex(@NotNull String regexString) {
        RegexFacade regexFacade;
        if (regexString == null) {
            RegexFacade.$$$reportNull$$$0(3);
        }
        try {
            regexFacade = (RegexFacade)REGEX_CACHE.get((Object)regexString);
        }
        catch (ExecutionException e) {
            RegexFacade regexFacade2 = new RegexFacade(regexString.getBytes(StandardCharsets.UTF_8));
            if (regexFacade2 == null) {
                RegexFacade.$$$reportNull$$$0(5);
            }
            return regexFacade2;
        }
        if (regexFacade == null) {
            RegexFacade.$$$reportNull$$$0(4);
        }
        return regexFacade;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexBytes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/regex/RegexFacade";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/regex/RegexFacade";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegex";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "regex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "regex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LastMatch {
        private final Object lastId;
        private final int lastOffset;
        private final MatchData lastMatch;

        private LastMatch(Object id, int offset, MatchData data) {
            this.lastId = id;
            this.lastOffset = offset;
            this.lastMatch = data;
        }
    }
}

