/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.Dbms;
import com.intellij.database.actions.FullTextSearchAction;
import com.intellij.database.fulltextsearch.FullTextSearchOptions;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.ui.FullTextSearchDialog;
import com.intellij.find.FindModel;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseStringUsageTarget
implements ConfigurableUsageTarget,
ItemPresentation {
    private final Project myProject;
    private final FindModel myFindModel;
    private final FullTextSearchOptions myOptions;
    private final Collection<DbElement> myTargets;

    DatabaseStringUsageTarget(@NotNull Project project, @NotNull FindModel findModel, @NotNull FullTextSearchOptions options, @NotNull Collection<DbElement> targets2) {
        if (project == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(0);
        }
        if (findModel == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(1);
        }
        if (options == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(2);
        }
        if (targets2 == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myFindModel = findModel;
        this.myOptions = options;
        this.myTargets = targets2;
    }

    @NotNull
    public String getPresentableText() {
        String string = "Occurrences of '" + this.myFindModel.getStringToFind() + "' in database";
        if (string == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public String getLocationString() {
        return null;
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return AllIcons.Actions.Find;
    }

    public void showSettings() {
        new FullTextSearchDialog(this.myProject, this.myOptions, this.myTargets).show();
    }

    public KeyboardShortcut getShortcut() {
        return null;
    }

    @NotNull
    public String getLongDescriptiveName() {
        String string = this.getPresentableText();
        if (string == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void findUsages() {
        throw new UnsupportedOperationException();
    }

    public void findUsagesInEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(6);
        }
    }

    public void highlightUsages(@NotNull PsiFile file, @NotNull Editor editor, boolean clearHighlights) {
        if (file == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(8);
        }
    }

    public boolean isValid() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    @Nullable
    public VirtualFile[] getFiles() {
        return null;
    }

    public void update() {
    }

    @NotNull
    public String getName() {
        DbElement item = (DbElement)ContainerUtil.getFirstItem(this.myTargets);
        Dbms dbms = item == null ? Dbms.UNKNOWN : DbImplUtil.getDbms(item);
        DbImplUtil.StringLiteralDecorator decorator = FullTextSearchAction.Companion.toDecorator(this.myOptions.getLocation());
        String string = decorator.decorate(this.myOptions.getText(), dbms);
        if (string == null) {
            DatabaseStringUsageTarget.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public ItemPresentation getPresentation() {
        return this;
    }

    public void navigate(boolean requestFocus) {
        throw new UnsupportedOperationException();
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DatabaseStringUsageTarget";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DatabaseStringUsageTarget";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongDescriptiveName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findUsagesInEditor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "highlightUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

