/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.SynchronizeHandler;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;

public class RefreshSchemaAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        JBIterable<DbElement> selection;
        boolean enabled;
        if (e == null) {
            RefreshSchemaAction.$$$reportNull$$$0(0);
        }
        boolean visible = enabled = !(selection = DatabaseView.getSelectedElements(e.getDataContext(), true)).isEmpty();
        for (DbElement o : selection) {
            LocalDataSource dataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)o.getDataSource());
            visible &= dataSource != null && this.isEnabledForContextElement(o);
            enabled &= dataSource != null && !dataSource.isLoading() && DbImplUtil.canConnectTo(dataSource);
        }
        e.getPresentation().setVisible(visible || ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || e.isFromActionToolbar());
        e.getPresentation().setEnabled(enabled);
    }

    protected boolean isEnabledForContextElement(@NotNull DbElement o) {
        if (o == null) {
            RefreshSchemaAction.$$$reportNull$$$0(1);
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RefreshSchemaAction.$$$reportNull$$$0(2);
        }
        JBIterable<DbElement> selection = DatabaseView.getSelectedElements(e.getDataContext(), true);
        RefreshSchemaAction.refresh(e.getProject(), selection);
    }

    public static void refresh(Project project, JBIterable<DbElement> selection) {
        Map map2 = ContainerUtil.classify((Iterator)selection.iterator(), o -> o.getDataSource());
        HashSet dataSourceElements = new HashSet();
        dataSourceElements.addAll(map2.keySet());
        if (project != null) {
            for (SynchronizeHandler handler : (SynchronizeHandler[])SynchronizeHandler.EP_NAME.getExtensions()) {
                handler.synchronizationStarted(project, (Set)dataSourceElements);
            }
        }
        for (DbDataSource element2 : dataSourceElements) {
            Set elements = (Set)map2.get(element2);
            if (elements.contains(element2) && elements.size() > 1) {
                elements.retainAll(Collections.singletonList(element2));
            }
            RefreshSchemaAction.refresh(element2, elements);
        }
    }

    private static void refresh(DbDataSource element2, Collection<DbElement> selection) {
        DatabaseSystem delegate = element2.getDelegate();
        if (!(delegate instanceof LocalDataSource)) {
            return;
        }
        LocalDataSource dataSource = (LocalDataSource)delegate;
        LoaderContext context = RefreshSchemaAction.createLoaderContext(element2, selection, dataSource);
        DataSourceUiUtil.performManualSyncTask(context);
    }

    static LoaderContext createLoaderContext(@NotNull DbDataSource dataSourceElement, @NotNull Collection<? extends DbElement> selection, @NotNull LocalDataSource dataSource) {
        if (dataSourceElement == null) {
            RefreshSchemaAction.$$$reportNull$$$0(3);
        }
        if (selection == null) {
            RefreshSchemaAction.$$$reportNull$$$0(4);
        }
        if (dataSource == null) {
            RefreshSchemaAction.$$$reportNull$$$0(5);
        }
        LoaderContext context = new LoaderContext(dataSourceElement.getProject(), dataSource);
        boolean loadEverything = selection.contains(dataSourceElement);
        if (loadEverything) {
            context.includeAllSchemas();
        }
        if (selection.size() > 1 || !loadEverything) {
            for (DbElement dbElement : selection) {
                if (dbElement == dataSourceElement || dbElement.getDataSource() != dataSourceElement) continue;
                DbElement parent2 = dbElement.getParent();
                if (parent2 instanceof DbTable || dbElement instanceof DbPackage) {
                    context.include(parent2);
                    continue;
                }
                context.include(dbElement);
            }
        }
        return context;
    }

    public static void forgetAndRefresh(@NotNull Project project, @NotNull JBIterable<DbDataSource> selection, final boolean refresh) {
        if (project == null) {
            RefreshSchemaAction.$$$reportNull$$$0(6);
        }
        if (selection == null) {
            RefreshSchemaAction.$$$reportNull$$$0(7);
        }
        final DataSourceStorage storage = DataSourceStorage.getProjectStorage(project);
        for (final DbDataSource element2 : selection) {
            final LocalDataSource delegate = DbImplUtil.getMaybeLocalDataSource((DasDataSource)element2.getDataSource());
            if (delegate == null) {
                return;
            }
            new Task.Backgroundable(project, "Clearing Cached Schemas"){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    CompletionStage<DataSourceSyncManager.SyncResult> stage = DataSourceSyncManager.getInstance().stopSynchronization(delegate).whenCompleteAsync((r, th) -> delegate.clearModel(), AsyncUtil.POOL_EXECUTOR).whenCompleteAsync((r, th) -> storage.updateDataSource(delegate), AsyncUtil.EDT_EXECUTOR);
                    if (refresh) {
                        stage.whenCompleteAsync((r, th) -> RefreshSchemaAction.refresh(element2, Collections.singleton(element2)));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/actions/RefreshSchemaAction$1", "run"));
                }
            }.queue();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceElement";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/actions/RefreshSchemaAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForContextElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createLoaderContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "forgetAndRefresh";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Forget
    extends RefreshSchemaAction {
        Forget() {
        }

        @Override
        protected boolean isEnabledForContextElement(@NotNull DbElement o) {
            if (o == null) {
                Forget.$$$reportNull$$$0(0);
            }
            return o instanceof DasDataSource;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                Forget.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            JBIterable selection = DatabaseView.getSelectedElements(e.getDataContext(), true).filter(DbDataSource.class);
            Forget.forgetAndRefresh(project, (JBIterable<DbDataSource>)selection, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/RefreshSchemaAction$Forget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForContextElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ForceRefresh
    extends RefreshSchemaAction {
        @Override
        protected boolean isEnabledForContextElement(@NotNull DbElement o) {
            if (o == null) {
                ForceRefresh.$$$reportNull$$$0(0);
            }
            return o instanceof DasDataSource;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ForceRefresh.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            JBIterable selection = DatabaseView.getSelectedElements(e.getDataContext(), true).filter(DbDataSource.class);
            ForceRefresh.forgetAndRefresh(project, (JBIterable<DbDataSource>)selection, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/RefreshSchemaAction$ForceRefresh";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForContextElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

