/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseClientLogView;
import com.intellij.database.console.session.DatabaseLogViewService;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionLogView;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0006H\u0007J$\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\u0014H\u0007J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\nH\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\nH\u0007J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\nH\u0007J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R&\u0010\u0003\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/console/session/DatabaseLogViewService;", "", "()V", "clientViews", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/database/console/session/DatabaseClientLogView;", "sessionViews", "Lcom/intellij/database/console/session/DatabaseSession;", "Lcom/intellij/database/console/session/DatabaseSessionLogView;", "destroyView", "", "client", "Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "destroyViews", "project", "getView", "configurator", "Lkotlin/Function1;", "session", "getViewIfAny", "initView", "key", "MyLanguageConsoleImpl", "intellij.database.impl"})
public final class DatabaseLogViewService {
    private static final Map<DatabaseSession, DatabaseSessionLogView> sessionViews;
    private static final Map<Pair<Project, VirtualFile>, DatabaseClientLogView> clientViews;
    public static final DatabaseLogViewService INSTANCE;

    @JvmStatic
    @NotNull
    public static final DatabaseSessionLogView getView(@NotNull DatabaseSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        ApplicationManager.getApplication().assertIsDispatchThread();
        DatabaseSessionLogView databaseSessionLogView = sessionViews.computeIfAbsent(session2, new Function<DatabaseSession, DatabaseSessionLogView>(session2){
            final /* synthetic */ DatabaseSession $session;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DatabaseSessionLogView apply(@NotNull DatabaseSession it2) {
                void var3_3;
                Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                LanguageConsoleImpl console = new LanguageConsoleImpl(this.$session.getProject(), this.$session.getTitle(), (Language)DbSqlUtil.getSqlDialect((LocalDataSource)this.$session.getTarget()));
                DatabaseSessionLogView view2 = new DatabaseSessionLogView((LanguageConsoleView)console, this.$session);
                Disposer.register((Disposable)this.$session, (Disposable)new Disposable(this){
                    final /* synthetic */ getView.1 this$0;

                    public final void dispose() {
                        DatabaseLogViewService.access$getSessionViews$p(DatabaseLogViewService.INSTANCE).remove(this.this$0.$session);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                return var3_3;
            }
            {
                this.$session = databaseSession;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)databaseSessionLogView, (String)"sessionViews.computeIfAb\u2026sion) })\n      view\n    }");
        return databaseSessionLogView;
    }

    @JvmStatic
    public static final void initView(@NotNull DatabaseSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        DatabaseLogViewService.getView(session2);
    }

    @JvmStatic
    @Nullable
    public static final DatabaseSessionLogView getViewIfAny(@NotNull DatabaseSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        return sessionViews.get(session2);
    }

    @JvmStatic
    @NotNull
    public static final DatabaseClientLogView getView(@NotNull DatabaseSessionClientWithFile client, @NotNull Function1<? super DatabaseClientLogView, Unit> configurator) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull(configurator, (String)"configurator");
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project = ((DatabaseSession)client.getSession()).getProject();
        Pair<Project, VirtualFile> key2 = INSTANCE.key(client);
        DatabaseClientLogView databaseClientLogView = clientViews.computeIfAbsent(key2, (Function<Pair<Project, VirtualFile>, DatabaseClientLogView>)new Function<Pair<? extends Project, ? extends VirtualFile>, DatabaseClientLogView>(project, client, configurator, key2){
            final /* synthetic */ Project $project;
            final /* synthetic */ DatabaseSessionClientWithFile $client;
            final /* synthetic */ Function1 $configurator;
            final /* synthetic */ Pair $key;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DatabaseClientLogView apply(@NotNull Pair<? extends Project, ? extends VirtualFile> it2) {
                void var3_3;
                Intrinsics.checkParameterIsNotNull(it2, (String)"it");
                MyLanguageConsoleImpl console = new MyLanguageConsoleImpl(this.$project, this.$client.getTitle(), this.$client.getVirtualFile(), this.$client.getAutoClose());
                DatabaseClientLogView result2 = new DatabaseClientLogView((LanguageConsoleView)console, this.$client);
                this.$configurator.invoke((Object)result2);
                Disposer.register((Disposable)result2, (Disposable)new Disposable(this){
                    final /* synthetic */ getView.view.1 this$0;

                    public final void dispose() {
                        DatabaseLogViewService.access$getClientViews$p(DatabaseLogViewService.INSTANCE).remove(this.this$0.$key);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                return var3_3;
            }
            {
                this.$project = project;
                this.$client = databaseSessionClientWithFile;
                this.$configurator = function1;
                this.$key = pair;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)databaseClientLogView, (String)"clientViews.computeIfAbs\u2026ey) })\n      result\n    }");
        DatabaseClientLogView view2 = databaseClientLogView;
        if (Intrinsics.areEqual(view2.getTarget(), (Object)client) ^ true) {
            view2.setTarget(client, client.getMessageBus());
            configurator.invoke((Object)view2);
        }
        return view2;
    }

    private final Pair<Project, VirtualFile> key(DatabaseSessionClientWithFile client) {
        return new Pair((Object)((DatabaseSession)client.getSession()).getProject(), (Object)client.getVirtualFile());
    }

    @JvmStatic
    @Nullable
    public static final DatabaseClientLogView getViewIfAny(@NotNull DatabaseSessionClientWithFile client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        return client instanceof DataGridSessionClient ? client.getView() : clientViews.get(INSTANCE.key(client));
    }

    @JvmStatic
    public static final void destroyView(@NotNull DatabaseSessionClientWithFile client) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            DatabaseClientLogView databaseClientLogView = DatabaseLogViewService.getViewIfAny(client);
            if (databaseClientLogView == null) break block0;
            DatabaseClientLogView databaseClientLogView2 = databaseClientLogView;
            boolean bl = false;
            boolean bl2 = false;
            DatabaseClientLogView it2 = databaseClientLogView2;
            boolean bl3 = false;
            Disposer.dispose((Disposable)it2);
        }
    }

    @JvmStatic
    public static final void destroyViews(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        DbUIUtil.invokeLaterIfNeeded(new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                HashSet<E> keys = new HashSet<E>(DatabaseLogViewService.access$getClientViews$p(DatabaseLogViewService.INSTANCE).keySet());
                for (Pair key2 : keys) {
                    DatabaseClientLogView databaseClientLogView;
                    if (!Intrinsics.areEqual((Object)((Project)key2.getFirst()), (Object)this.$project)) continue;
                    if ((DatabaseClientLogView)DatabaseLogViewService.access$getClientViews$p(DatabaseLogViewService.INSTANCE).get(key2) == null) continue;
                    boolean bl = false;
                    boolean bl2 = false;
                    DatabaseClientLogView it2 = databaseClientLogView;
                    boolean bl3 = false;
                    Disposer.dispose((Disposable)it2);
                }
            }
            {
                this.$project = project;
            }
        });
    }

    private DatabaseLogViewService() {
    }

    static {
        DatabaseLogViewService databaseLogViewService;
        INSTANCE = databaseLogViewService = new DatabaseLogViewService();
        sessionViews = new HashMap();
        clientViews = new HashMap();
    }

    public static final /* synthetic */ Map access$getSessionViews$p(DatabaseLogViewService $this) {
        DatabaseLogViewService databaseLogViewService = $this;
        return sessionViews;
    }

    public static final /* synthetic */ Map access$getClientViews$p(DatabaseLogViewService $this) {
        DatabaseLogViewService databaseLogViewService = $this;
        return clientViews;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/console/session/DatabaseLogViewService$MyLanguageConsoleImpl;", "Lcom/intellij/execution/console/LanguageConsoleImpl;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "autoClose", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "closeFile", "", "intellij.database.impl"})
    private static final class MyLanguageConsoleImpl
    extends LanguageConsoleImpl {
        private final boolean autoClose;

        protected void closeFile() {
            if (this.autoClose) {
                super.closeFile();
            }
        }

        public MyLanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull VirtualFile file, boolean autoClose) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            super(project, title, file);
            this.autoClose = autoClose;
        }
    }
}

