/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.csv.ui.CsvFormatsUI;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class CsvFormatsSettingsUI
extends CsvFormatsUI {
    private static final String ADD_NAME = "Add Format";
    private static final String REMOVE_NAME = "Remove Format";
    private static final String COPY_NAME = "Copy Format";

    public CsvFormatsSettingsUI(@NotNull Disposable parent2) {
        if (parent2 == null) {
            CsvFormatsSettingsUI.$$$reportNull$$$0(0);
        }
        this(true, parent2, CsvFormatUISettings.DEFAULT);
    }

    public CsvFormatsSettingsUI(boolean allowNameEditing, @NotNull Disposable parent2, @NotNull CsvFormatUISettings settings) {
        if (parent2 == null) {
            CsvFormatsSettingsUI.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            CsvFormatsSettingsUI.$$$reportNull$$$0(2);
        }
        super(allowNameEditing, settings);
        Disposer.register((Disposable)parent2, (Disposable)this);
    }

    @Override
    @NotNull
    protected ToolbarDecorator createFormatListDecorator() {
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)this.getFormatsListComponent().getComponent()).setToolbarPosition(ActionToolbarPosition.TOP).setAddAction(button -> this.addNewAndEditName(DatabaseSettings.TSV_FORMAT)).setEditAction(button -> this.editName(this.getNotNullSelectedFormat())).setEditActionUpdater(e -> this.getFormatsListComponent().getSelected() != null).addExtraAction((AnActionButton)new CopyFormatAction()).setAddActionName(ADD_NAME).setRemoveActionName(REMOVE_NAME).setButtonComparator(new String[]{ADD_NAME, REMOVE_NAME, COPY_NAME});
        if (toolbarDecorator == null) {
            CsvFormatsSettingsUI.$$$reportNull$$$0(3);
        }
        return toolbarDecorator;
    }

    @NotNull
    private CsvFormat getNotNullSelectedFormat() {
        CsvFormat csvFormat = (CsvFormat)ObjectUtils.assertNotNull((Object)this.getFormatsListComponent().getSelected());
        if (csvFormat == null) {
            CsvFormatsSettingsUI.$$$reportNull$$$0(4);
        }
        return csvFormat;
    }

    private void addNewAndEditName(@NotNull CsvFormat templateFormat) {
        if (templateFormat == null) {
            CsvFormatsSettingsUI.$$$reportNull$$$0(5);
        }
        this.editName(this.getFormatsListComponent().newFormat(templateFormat));
    }

    private void editName(@NotNull CsvFormat format) {
        if (format == null) {
            CsvFormatsSettingsUI.$$$reportNull$$$0(6);
        }
        this.getFormatsListComponent().editFormatName(format, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/csv/ui/CsvFormatsSettingsUI";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFormat";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/csv/ui/CsvFormatsSettingsUI";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormatListDecorator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullSelectedFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addNewAndEditName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "editName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CopyFormatAction
    extends AnActionButton {
        CopyFormatAction() {
            super(CsvFormatsSettingsUI.COPY_NAME, PlatformIcons.COPY_ICON);
        }

        public void updateButton(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyFormatAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(CsvFormatsSettingsUI.this.getSelectedFormat() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyFormatAction.$$$reportNull$$$0(1);
            }
            CsvFormatsSettingsUI.this.addNewAndEditName(CsvFormatsSettingsUI.this.getNotNullSelectedFormat());
        }

        public ShortcutSet getShortcut() {
            return ActionManager.getInstance().getAction("EditorDuplicate").getShortcutSet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/csv/ui/CsvFormatsSettingsUI$CopyFormatAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateButton";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

