/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcStorageV1
implements AutoCloseable {
    static final String STAGING_DIR = "_staging_";
    static final String BASE_DIR = "_src_";
    static final String METADATA_DIR = "_metadata_";
    static final Logger LOG = Logger.getInstance(DbSrcStorageV1.class);
    private final DbSrcStorage myBackend;
    private final String myPath;
    private final DasModel myModel;
    private final PersistentHashMap<ObjectPath, DbSrcStorageDsMetadata.MetaData> myMap;
    private static final List<String> ESCAPE_FROM = Arrays.asList("/", "&", ".", "!", "\"", "\\", "<", ">", "|", "*", "?", ":");
    private static final List<String> ESCAPE_TO = Arrays.asList("&slash;", "&amp;", "&dot;", "&#33;", "&quot;", "&#92;", "&lt;", "&gt;", "&#124;", "&#42;", "&#63;", "&#58;");
    private static final String EMPTY = "&empty;";

    static boolean exists(@NotNull String v1Path) {
        if (v1Path == null) {
            DbSrcStorageV1.$$$reportNull$$$0(0);
        }
        return new File(v1Path, BASE_DIR).exists();
    }

    static void migrate(@NotNull DbSrcStorage backend, @NotNull String v1Path, @NotNull DasModel model) throws IOException {
        File metaFile;
        if (backend == null) {
            DbSrcStorageV1.$$$reportNull$$$0(1);
        }
        if (v1Path == null) {
            DbSrcStorageV1.$$$reportNull$$$0(2);
        }
        if (model == null) {
            DbSrcStorageV1.$$$reportNull$$$0(3);
        }
        if (!(metaFile = new File(v1Path + File.separator + METADATA_DIR + File.separator + "metadata")).isFile()) {
            return;
        }
        try (DbSrcStorageV1 m = new DbSrcStorageV1(backend, v1Path, model, DbSrcStorageDsMetadata.createMap(metaFile));){
            m.migrate();
        }
        catch (PersistentEnumeratorBase.CorruptedException e) {
            LOG.warn("Storage V1 is corrupted creating new empty storage", (Throwable)e);
        }
    }

    private DbSrcStorageV1(@NotNull DbSrcStorage backend, @NotNull String v1Path, @NotNull DasModel model, PersistentHashMap<ObjectPath, DbSrcStorageDsMetadata.MetaData> map2) {
        if (backend == null) {
            DbSrcStorageV1.$$$reportNull$$$0(4);
        }
        if (v1Path == null) {
            DbSrcStorageV1.$$$reportNull$$$0(5);
        }
        if (model == null) {
            DbSrcStorageV1.$$$reportNull$$$0(6);
        }
        this.myBackend = backend;
        this.myPath = v1Path;
        this.myModel = model;
        this.myMap = map2;
    }

    @Override
    public void close() throws IOException {
        this.myMap.close();
    }

    private void migrate() throws IOException {
        for (DasObject object : ((JBTreeTraverser)this.myModel.traverser().expand(o -> o.getKind() != ObjectKind.SCHEMA)).preOrderDfsTraversal()) {
            ObjectPath path = ObjectPaths.of(object);
            DbSrcStorageDsMetadata.MetaData metaData = this.getMetaData(path);
            if (!DbSrcStorageDsMetadata.MetaData.isEmpty(metaData)) {
                this.myBackend.putMetaData(path, metaData);
            }
            if (object.getKind() != ObjectKind.SCHEMA) continue;
            String zipPath = DbSrcStorageV1.createPath(this.myPath + File.separator + BASE_DIR, path, 0, ".zip", File.separator);
            JBZipFile zipFile = new File(zipPath).exists() ? new JBZipFile(zipPath) : null;
            Throwable throwable = null;
            try {
                this.migrateSchema(object, zipFile);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (zipFile == null) continue;
                if (throwable != null) {
                    try {
                        zipFile.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                zipFile.close();
            }
        }
    }

    @NotNull
    static String createPath(@NotNull String init2, ObjectPath path, int f, String ext, String separator) {
        if (init2 == null) {
            DbSrcStorageV1.$$$reportNull$$$0(7);
        }
        StringBuilder builder = new StringBuilder(init2);
        DbSrcStorageV1.createPathInner(builder, path, f, separator);
        String id = path.getIdentity();
        if (id != null) {
            builder.append(".").append(DbSrcStorageV1.escape(id));
        }
        builder.append(ext);
        String string = builder.toString();
        if (string == null) {
            DbSrcStorageV1.$$$reportNull$$$0(8);
        }
        return string;
    }

    static int createPathInner(@NotNull StringBuilder builder, ObjectPath path, int f, String separator) {
        int d2;
        if (builder == null) {
            DbSrcStorageV1.$$$reportNull$$$0(9);
        }
        int n = d2 = path.parent == null ? 0 : DbSrcStorageV1.createPathInner(builder, path.parent, f, separator);
        if (d2 >= f) {
            if (builder.length() != 0) {
                builder.append(separator);
            }
            builder.append(DbSrcStorageV1.escape(path.kind.code()));
            builder.append(separator).append(DbSrcStorageV1.escape(path.name));
        }
        return d2 + 1;
    }

    private void migrateSchema(DasObject root2, @Nullable JBZipFile file) throws IOException {
        int depth = ObjectPaths.getLength(ObjectPaths.of(root2));
        for (DasObject object : ((JBTreeTraverser)((JBTreeTraverser)this.myModel.traverser().withRoot((Object)root2)).expand(Conditions.alwaysTrue())).preOrderDfsTraversal()) {
            if (object == root2) continue;
            ObjectPath path = ObjectPaths.of(object);
            this.migrateOriginal(path, depth, file);
            this.migrateStaging(path);
        }
    }

    private void migrateStaging(ObjectPath path) throws IOException {
        byte[] stgData;
        File stgFile = new File(DbSrcStorageV1.createPath(this.myPath + File.separator + STAGING_DIR, path, 0, ".sql", File.separator));
        if (!stgFile.isFile()) {
            return;
        }
        try {
            stgData = FileUtil.loadFileBytes((File)stgFile);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return;
        }
        this.myBackend.putContent(path, stgData);
    }

    private void migrateOriginal(ObjectPath path, int depth, @Nullable JBZipFile file) throws IOException {
        String zipPath = DbSrcStorageV1.createPath("", path, depth, ".sql", "/");
        JBZipEntry entry = file == null ? null : file.getEntry(zipPath);
        DbSrcStorageDsMetadata.MetaData metaData = this.getMetaData(path);
        byte[] data = null;
        if (entry != null) {
            try {
                data = entry.getData();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                metaData = DbSrcStorageDsMetadata.MetaData.EMPTY;
            }
        }
        if (data != null) {
            this.myBackend.putOriginalContent(path, data, metaData);
        } else if (!DbSrcStorageDsMetadata.MetaData.isEmpty(metaData)) {
            this.myBackend.putMetaData(path, metaData);
        }
    }

    @NotNull
    private DbSrcStorageDsMetadata.MetaData getMetaData(ObjectPath path) {
        DbSrcStorageDsMetadata.MetaData metaData;
        try {
            metaData = (DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)this.myMap.get((Object)path), (Object)DbSrcStorageDsMetadata.MetaData.EMPTY);
        }
        catch (IOException e) {
            DbSrcStorageDsMetadata.MetaData metaData2 = DbSrcStorageDsMetadata.MetaData.EMPTY;
            if (metaData2 == null) {
                DbSrcStorageV1.$$$reportNull$$$0(11);
            }
            return metaData2;
        }
        if (metaData == null) {
            DbSrcStorageV1.$$$reportNull$$$0(10);
        }
        return metaData;
    }

    static String escape(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return EMPTY;
        }
        return StringUtil.replace((String)s, ESCAPE_FROM, ESCAPE_TO);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v1Path";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backend";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "init";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcStorageV1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcStorageV1";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "migrate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPath";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPathInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

