/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.DmlMutationContext;
import com.intellij.database.datagrid.mutating.MutationData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataGridRequestSource;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseMutatorImpl
implements GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> {
    private final GridListModelBase<DataConsumer.Row, DataConsumer.Column> myModel;
    private final DatabaseGridDataHookUp myHookUp;
    private final Queue<ModelIndex<DataConsumer.Row>> myInsertedRows;
    private final Set<ModelIndex<DataConsumer.Row>> myDeletedRows;
    private final MutationsStorage myStorage;
    private boolean myFailed;

    public DatabaseMutatorImpl(@NotNull GridListModelBase<DataConsumer.Row, DataConsumer.Column> model, @NotNull DatabaseGridDataHookUp hookUp) {
        if (model == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(0);
        }
        if (hookUp == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(1);
        }
        this.myModel = model;
        this.myHookUp = hookUp;
        this.myInsertedRows = new PriorityQueue<ModelIndex<DataConsumer.Row>>((o1, o2) -> Integer.compare(o2.asInteger(), o1.asInteger()));
        this.myDeletedRows = new HashSet<ModelIndex<DataConsumer.Row>>();
        this.myStorage = new MutationsStorage(model, 500, 10);
        this.myHookUp.addRequestListener(new MyRequestListener(), this.myHookUp);
    }

    @Override
    public void mutate(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @Nullable Object newValue) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(2);
        }
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(3);
        }
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(4);
        }
        this.mutate(source, DataGridUtil.createMutations(rows, columns, (Function<? super ModelIndex<DataConsumer.Row>, MutationType>)((Function)this::getMutationTypeWhenMutate), newValue));
    }

    @Override
    public void mutate(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull List<CellMutation> mutations) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(5);
        }
        if (mutations == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(6);
        }
        boolean hasInsertedRows = false;
        boolean hasNotInsertedRows = false;
        for (CellMutation mutation : mutations) {
            boolean shouldSkip;
            ModelIndex<DataConsumer.Column> columnIdx;
            Object value = mutation.getValue();
            ModelIndex<DataConsumer.Row> rowIdx = mutation.getRow();
            MutationData oldMutation = this.myStorage.get(rowIdx, columnIdx = mutation.getColumn());
            boolean bl = shouldSkip = oldMutation == null && this.myModel.allValuesEqualTo(Collections.singletonList(mutation)) || oldMutation != null && DbImplUtil.valuesEqual(oldMutation.getValue(), value);
            if (shouldSkip) continue;
            boolean isInserted = this.isInsertedRow(rowIdx);
            hasInsertedRows |= isInserted;
            hasNotInsertedRows |= !isInserted;
            CellMutation newValue = DbImplUtil.valuesEqual(mutation.getValue(), this.myModel.getValueAt((DataConsumer.Row)((Object)rowIdx), (DataConsumer.Column)((Object)columnIdx))) ? null : mutation;
            this.myStorage.set(rowIdx, columnIdx, newValue);
            this.myDeletedRows.remove(rowIdx);
            if (!isInserted) continue;
            this.myModel.setValueAt(rowIdx, columnIdx, value);
        }
        this.myFailed = false;
        if (this.isUpdateImmediately() && this.hasPendingChanges()) {
            this.submit(source, hasInsertedRows && hasNotInsertedRows && this.isUpdateImmediately());
            return;
        }
        DatabaseMutatorImpl.setForceSuccess(source);
        this.notifyRequestFinished(source, !this.isReadOnly());
    }

    @Override
    public void revert(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(7);
        }
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(8);
        }
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(9);
        }
        List<ModelIndex<DataConsumer.Row>> sorted = DatabaseMutatorImpl.sortedRows(rows);
        sorted.stream().filter(idx -> !this.isInsertedRow((ModelIndex<DataConsumer.Row>)idx) && !this.isDeletedRow((ModelIndex<DataConsumer.Row>)idx)).forEach(rowIdx -> columns.asIterable().forEach(colIdx -> this.revert((ModelIndex<DataConsumer.Row>)rowIdx, (ModelIndex<DataConsumer.Column>)colIdx)));
        this.doDeleteRows(ModelIndexSet.forRows(this.myModel, sorted.stream().filter(this::isInsertedRow).mapToInt(Index::asInteger).toArray()));
        sorted.stream().filter(this::isDeletedRow).forEach(this.myDeletedRows::remove);
        DatabaseMutatorImpl.setForceSuccess(source);
        this.notifyRequestFinished(source, true);
    }

    private void revert(@NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> colIdx) {
        if (rowIdx == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(10);
        }
        if (colIdx == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(11);
        }
        this.myStorage.set(rowIdx, colIdx, null);
    }

    @Override
    public boolean isUpdateSafe(@NotNull ModelIndexSet<DataConsumer.Row> rowIndices, @NotNull ModelIndexSet<DataConsumer.Column> columnIndices, @Nullable Object newValue) {
        if (rowIndices == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(12);
        }
        if (columnIndices == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(13);
        }
        if (!this.hasPendingChanges() || !this.isUpdateImmediately() || this.hasDifferentRowTypes(rowIndices)) {
            return true;
        }
        List<ModelIndex<DataConsumer.Row>> rows = this.getPhysicalRows(rowIndices);
        ModelIndex first2 = (ModelIndex)JBIterable.from(rows).filter(Condition.NOT_NULL).first();
        return first2 == null || this.myModel.allValuesEqualTo(rowIndices, columnIndices, newValue);
    }

    @Override
    public boolean isInsertedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(14);
        }
        return this.myInsertedRows.contains(row);
    }

    @Override
    @Nullable
    public MutationData getMutation(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(15);
        }
        if (column2 == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(16);
        }
        return this.myStorage.get(row, column2);
    }

    @Override
    public boolean isUpdateImmediately() {
        return DatabaseSettings.getSettings().isSubmitImmediately();
    }

    @Override
    public boolean hasPendingChanges() {
        return this.myStorage.isModified() || !this.myInsertedRows.isEmpty() || !this.myDeletedRows.isEmpty();
    }

    @Override
    public void deleteRows(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(17);
        }
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(18);
        }
        if (this.isReadOnly() || !this.doDeleteRows(rows)) {
            DatabaseMutatorImpl.setForceSuccess(source);
            this.notifyRequestFinished(source, !this.isReadOnly() && this.getDatabaseTable() != null);
            return;
        }
        if (this.isUpdateImmediately()) {
            this.submit(source, false);
            return;
        }
        DatabaseMutatorImpl.setForceSuccess(source);
        this.notifyRequestFinished(source, true);
    }

    @Override
    public void insertRow(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(19);
        }
        if (!this.isReadOnly()) {
            this.doInsertRow(this.createRow(null));
        }
        this.notifyRequestFinished(source, !this.isReadOnly());
    }

    @Override
    public void cloneRow(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndex<DataConsumer.Row> toClone) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(20);
        }
        if (toClone == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(21);
        }
        DataConsumer.Row rowToClone = this.myModel.getRow(toClone);
        if (this.isReadOnly() || rowToClone == null) {
            this.notifyRequestFinished(source, false);
            return;
        }
        DataConsumer.Row newRow = this.createRow(rowToClone);
        this.doInsertRow(newRow);
        this.notifyRequestFinished(source, !this.isReadOnly());
    }

    @Override
    public boolean isFailed() {
        return this.myFailed;
    }

    @NotNull
    protected DataConsumer.Row createRow(@Nullable DataConsumer.Row template) {
        DataConsumer.Row newRow = DataConsumer.Row.create(this.myHookUp.getPageModel().getPageEnd() + this.myInsertedRows.size(), new Object[this.myModel.getColumnCount()]);
        for (DataConsumer.Column column2 : this.myModel.getColumns()) {
            Object existing;
            DasColumn dbColumn = this.getDatabaseColumn(column2);
            Object object = existing = template == null ? null : column2.getValue(template);
            ReservedCellValue value = DbImplUtil.isRowId(column2) ? ReservedCellValue.COMPUTED : (template != null && !DasUtil.isPrimary((DasColumn)dbColumn) ? existing : DataGridUtil.getDefaultNullValue(dbColumn));
            column2.setValue(newRow, (Object)value);
        }
        DataConsumer.Row row = newRow;
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(22);
        }
        return row;
    }

    @Override
    @Nullable
    public ModelIndex<DataConsumer.Row> getLastInsertedRow() {
        return this.myInsertedRows.peek();
    }

    @Override
    public boolean isDeletedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(23);
        }
        return this.myDeletedRows.contains(row);
    }

    @Override
    public boolean isDeletedRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(24);
        }
        return this.myDeletedRows.containsAll(rows.asList());
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getAffectedRows() {
        HashSet<Integer> myRows = new HashSet<Integer>();
        for (int row2 : this.myStorage.getAffectedRows()) {
            myRows.add(row2);
        }
        this.myDeletedRows.forEach(row -> myRows.add(row.asInteger()));
        ModelIndexSet<DataConsumer.Row> modelIndexSet = ModelIndexSet.forRows(this.myModel, myRows.stream().mapToInt(Integer::valueOf).toArray());
        if (modelIndexSet == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(25);
        }
        return modelIndexSet;
    }

    @Override
    public void submit(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean inserted) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(26);
        }
        DasTable table = this.getDatabaseTable();
        if (this.isReadOnly() || table == null) {
            this.notifyRequestFinished(source, false);
            return;
        }
        if (this.myDeletedRows.isEmpty() && !this.myStorage.isModified() && (this.myInsertedRows.isEmpty() || !inserted)) {
            this.notifyUpdateCountReceived(source, this.myInsertedRows.size());
            this.notifyRequestFinished(source, true);
            return;
        }
        List<RowMutation> updateMutations = this.createUpdateMutations();
        List<RowMutation> insertMutations = inserted ? this.createInsertMutations() : ContainerUtil.emptyList();
        List<RowMutation> deleteMutations = this.myDeletedRows.stream().map(this.myModel::getRow).filter(Objects::nonNull).map(row -> new RowMutation((DataConsumer.Row)row, DatabaseMutatorImpl.createColumnsUpdateData(row, this.myModel.getColumns()))).collect(Collectors.toList());
        List<DataRequest.DmlRequest> requests = new ArrayList<DataRequest.DmlRequest>();
        requests.add(this.createRequest((PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest>)((PairFunction)DataRequest::newDeleteRequest), deleteMutations));
        requests.add(this.createRequest((PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest>)((PairFunction)DataRequest::newUpdateRequest), updateMutations));
        requests.add(this.createRequest((PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest>)((PairFunction)DataRequest::newInsertRequest), insertMutations));
        requests = ContainerUtil.filter(requests, Objects::nonNull);
        if (!requests.isEmpty()) {
            DataRequest request = DataRequest.newCompositeRequest(this.myHookUp, requests);
            this.processRequest(source, request, DataBusGridDataHookUp.ReloadPolicy.WHEN_DONE);
            return;
        }
        DatabaseMutatorImpl.setForceSuccess(source);
        this.notifyRequestFinished(source, true);
    }

    public void clearPendingChanges() {
        this.myDeletedRows.clear();
        this.myInsertedRows.clear();
        this.myStorage.clear();
        this.myFailed = false;
    }

    @Override
    public boolean hasMutatedRows(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(27);
        }
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(28);
        }
        for (ModelIndex row : rows.asIterable()) {
            for (ModelIndex column2 : columns.asIterable()) {
                MutationData mutation = this.myStorage.get(row, column2);
                if (mutation == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public MutationType getMutationType(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(29);
        }
        return !row.isValid(this.myModel) ? null : (this.isInsertedRow(row) ? MutationType.INSERT : (this.isDeletedRow(row) ? MutationType.DELETE : (this.myStorage.isModified(row) ? MutationType.MODIFY : null)));
    }

    @NotNull
    protected List<ModelIndex<DataConsumer.Row>> getPhysicalRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(30);
        }
        List list = rows.asIterable().map(row -> this.isInsertedRow((ModelIndex<DataConsumer.Row>)row) && row.isValid(this.myModel) ? null : row).toList();
        if (list == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(31);
        }
        return list;
    }

    protected void processRequest(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull DataRequest request, DataBusGridDataHookUp.ReloadPolicy reloadPolicy) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(32);
        }
        if (request == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(33);
        }
        this.myHookUp.processRequest(source, request, reloadPolicy);
    }

    @NotNull
    protected List<DataConsumer.Column> getPhysicalColumns(@NotNull ModelIndexSet<DataConsumer.Column> columnIndices) {
        if (columnIndices == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(34);
        }
        List list = columnIndices.asIterable().filterMap(columnIndex -> {
            DataConsumer.Column column2 = this.myModel.getColumn((ModelIndex<DataConsumer.Column>)columnIndex);
            return DbImplUtil.isRowId(column2) ? null : column2;
        }).toList();
        if (list == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    private static List<ModelIndex<DataConsumer.Row>> sortedRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(36);
        }
        List<ModelIndex<DataConsumer.Row>> list = rows.asList().stream().sorted(Comparator.comparingInt(Index::asInteger)).collect(Collectors.toList());
        if (list == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(37);
        }
        return list;
    }

    private boolean doDeleteRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(38);
        }
        this.myFailed = false;
        List physicalRows = ContainerUtil.filter(this.getPhysicalRows(rows), (Condition)Condition.NOT_NULL);
        this.myStorage.delete(physicalRows);
        this.synchronizeModels(rows);
        if (physicalRows.size() == 0 || this.getDatabaseTable() == null) {
            return false;
        }
        this.myDeletedRows.addAll(physicalRows);
        return true;
    }

    private void synchronizeModels(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        List sorted;
        ModelIndex first2;
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(39);
        }
        if ((first2 = (ModelIndex)ContainerUtil.getFirstItem((List)(sorted = ContainerUtil.filter(DatabaseMutatorImpl.sortedRows(rows), this::isInsertedRow)))) == null) {
            return;
        }
        for (int i2 = sorted.size() - 1; i2 > -1; --i2) {
            ModelIndex rowIdx = (ModelIndex)sorted.get(i2);
            if (!this.isInsertedRow(rowIdx)) continue;
            this.myInsertedRows.remove(rowIdx);
            List<ModelIndex<DataConsumer.Row>> indexes = this.findBiggerRowIndices(rowIdx);
            this.myInsertedRows.removeAll(indexes);
            JBIterable.from(indexes).transform(idx -> ModelIndex.forRow(this.myModel, idx.asInteger() - 1)).filter(idx -> idx.isValid(this.myModel)).forEach(this.myInsertedRows::add);
            this.myModel.removeRows(ModelIndexSet.forRows(this.myModel, rowIdx.asInteger()));
            this.myStorage.shiftUp(rowIdx);
        }
    }

    @NotNull
    private List<ModelIndex<DataConsumer.Row>> findBiggerRowIndices(@NotNull ModelIndex<DataConsumer.Row> rowIdx) {
        if (rowIdx == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(40);
        }
        List list = ContainerUtil.filter(this.myInsertedRows, row -> row.asInteger() > rowIdx.asInteger());
        if (list == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(41);
        }
        return list;
    }

    @NotNull
    private List<RowMutation> createInsertMutations() {
        ArrayList<RowMutation> rowMutations = new ArrayList<RowMutation>();
        for (ModelIndex modelIndex : this.myInsertedRows) {
            DataConsumer.Row row = this.myModel.getRow(modelIndex);
            if (row == null) continue;
            List<ColumnQueryData> infos = this.createUpdateData(modelIndex);
            rowMutations.add(new RowMutation(row, infos));
        }
        ArrayList<RowMutation> arrayList = rowMutations;
        if (arrayList == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(42);
        }
        return arrayList;
    }

    @NotNull
    private List<RowMutation> createUpdateMutations() {
        ArrayList<RowMutation> rowMutations = new ArrayList<RowMutation>();
        for (Integer i2 : this.myStorage) {
            DataConsumer.Row row;
            ModelIndex<DataConsumer.Row> rowIdx = ModelIndex.forRow(this.myModel, (int)i2);
            if (this.isInsertedRow(rowIdx) || !this.myStorage.isModified(rowIdx) || !rowIdx.isValid(this.myModel) || (row = this.myModel.getRow(rowIdx)) == null) continue;
            List<ColumnQueryData> infos = this.createUpdateData(rowIdx);
            rowMutations.add(new RowMutation(row, infos));
        }
        ArrayList<RowMutation> arrayList = rowMutations;
        if (arrayList == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    @NotNull
    private List<ColumnQueryData> createUpdateData(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(44);
        }
        ArrayList<ColumnQueryData> infos = new ArrayList<ColumnQueryData>();
        for (int i2 = 0; i2 < this.myStorage.columnCount(); ++i2) {
            DataConsumer.Column column2;
            ModelIndex<DataConsumer.Column> columnIdx = ModelIndex.forColumn(this.myModel, i2);
            MutationData mutation = this.myStorage.get(row, columnIdx);
            if (mutation == null || !columnIdx.isValid(this.myModel) || (column2 = this.myModel.getColumn(columnIdx)) == null) continue;
            infos.add(new ColumnQueryData(column2, mutation.getValue()));
        }
        ArrayList<ColumnQueryData> arrayList = infos;
        if (arrayList == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(45);
        }
        return arrayList;
    }

    private void doInsertRow(@NotNull DataConsumer.Row newRow) {
        if (newRow == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(46);
        }
        this.myFailed = false;
        int newRowIdx = this.myModel.getRowCount();
        this.myModel.addRows(ContainerUtil.newSmartList((Object)newRow));
        this.myInsertedRows.add(ModelIndex.forRow(this.myModel, newRowIdx));
        ArrayList<CellMutation> mutations = new ArrayList<CellMutation>();
        List<DataConsumer.Column> columns = this.getPhysicalColumns(this.myModel.getColumnIndices());
        for (DataConsumer.Column column2 : columns) {
            ModelIndex<DataConsumer.Row> rowIdx = ModelIndex.forRow(this.myModel, newRowIdx);
            ModelIndex<DataConsumer.Column> columnIdx = ModelIndex.forColumn(this.myModel, column2.columnNum);
            CellMutation mutation = new CellMutation(rowIdx, columnIdx, MutationType.INSERT, column2.getValue(newRow));
            mutations.add(mutation);
            this.myStorage.set(rowIdx, columnIdx, mutation);
        }
    }

    @Nullable
    private DasTable getDatabaseTable() {
        return this.myHookUp.getDatabaseTable();
    }

    private void notifyRequestFinished(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean success) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(47);
        }
        this.myHookUp.notifyRequestFinished(source, success);
    }

    private void notifyUpdateCountReceived(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int count2) {
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(48);
        }
        this.myHookUp.notifyUpdateCountReceived(source, count2);
    }

    private boolean isReadOnly() {
        return this.myHookUp.isReadOnly();
    }

    private boolean hasDifferentRowTypes(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(49);
        }
        boolean hasInserted = false;
        boolean hasNotInserted = false;
        for (ModelIndex rowModelIndex : rows.asIterable()) {
            boolean inserted = this.isInsertedRow(rowModelIndex);
            hasInserted |= inserted;
            hasNotInserted |= !inserted;
        }
        return hasInserted && hasNotInserted;
    }

    @Nullable
    private DasColumn getDatabaseColumn(@Nullable DataConsumer.Column column2) {
        return this.myHookUp.getDatabaseColumn(column2);
    }

    @NotNull
    private MutationType getMutationTypeWhenMutate(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(50);
        }
        MutationType mutationType = this.isInsertedRow(row) ? MutationType.INSERT : MutationType.MODIFY;
        if (mutationType == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(51);
        }
        return mutationType;
    }

    @Nullable
    private DataRequest.DmlRequest createRequest(@NotNull PairFunction<DataRequest.OwnerEx, DmlMutationContext, DataRequest.DmlRequest> creator, @NotNull List<RowMutation> mutations) {
        if (creator == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(52);
        }
        if (mutations == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(53);
        }
        if (mutations.isEmpty() || this.getDatabaseTable() == null) {
            return null;
        }
        ArrayList<RowMutation> sorted = new ArrayList<RowMutation>(mutations);
        ContainerUtil.sort(sorted);
        DmlMutationContext context = new DmlMutationContext(sorted, this.myModel.getColumns(), this.getDatabaseTable());
        return (DataRequest.DmlRequest)creator.fun((Object)this.myHookUp, (Object)context);
    }

    @NotNull
    private static List<ColumnQueryData> createColumnsUpdateData(@NotNull DataConsumer.Row row, @NotNull List<DataConsumer.Column> columns) {
        if (row == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(54);
        }
        if (columns == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(55);
        }
        List list = ContainerUtil.map(columns, column2 -> new ColumnQueryData((DataConsumer.Column)column2, column2.getValue(row)));
        if (list == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(56);
        }
        return list;
    }

    private static void setForceSuccess(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
        DataGridRequestSource requestSource;
        if (source == null) {
            DatabaseMutatorImpl.$$$reportNull$$$0(57);
        }
        if ((requestSource = (DataGridRequestSource)((Object)ObjectUtils.tryCast((Object)source.source, DataGridRequestSource.class))) != null) {
            requestSource.setForceSuccess(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 25: 
            case 31: 
            case 35: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 51: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 25: 
            case 31: 
            case 35: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 51: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 17: 
            case 19: 
            case 20: 
            case 26: 
            case 32: 
            case 47: 
            case 48: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 8: 
            case 18: 
            case 24: 
            case 27: 
            case 30: 
            case 36: 
            case 38: 
            case 39: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 4: 
            case 9: 
            case 28: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 6: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 10: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colIdx";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIndices";
                break;
            }
            case 13: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIndices";
                break;
            }
            case 14: 
            case 15: 
            case 23: 
            case 29: 
            case 44: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toClone";
                break;
            }
            case 22: 
            case 25: 
            case 31: 
            case 35: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DatabaseMutatorImpl";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRow";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DatabaseMutatorImpl";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createRow";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedRows";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhysicalRows";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhysicalColumns";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "sortedRows";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "findBiggerRowIndices";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createInsertMutations";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdateMutations";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdateData";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutationTypeWhenMutate";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnsUpdateData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mutate";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "revert";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isUpdateSafe";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedRow";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getMutation";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deleteRows";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "insertRow";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "cloneRow";
                break;
            }
            case 22: 
            case 25: 
            case 31: 
            case 35: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 51: 
            case 56: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDeletedRow";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isDeletedRows";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasMutatedRows";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getMutationType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPhysicalRows";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processRequest";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPhysicalColumns";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sortedRows";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "doDeleteRows";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "synchronizeModels";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findBiggerRowIndices";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateData";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "doInsertRow";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "notifyRequestFinished";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "notifyUpdateCountReceived";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "hasDifferentRowTypes";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getMutationTypeWhenMutate";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createColumnsUpdateData";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "setForceSuccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: 
            case 25: 
            case 31: 
            case 35: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 51: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRequestListener
    implements GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column> {
        private MyRequestListener() {
        }

        @Override
        public void error(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, String message2, Throwable th) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(0);
            }
            DatabaseMutatorImpl.this.myFailed = message2 != null || th != null;
        }

        @Override
        public void updateCountReceived(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int updateCount2) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void requestFinished(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean success) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(2);
            }
            DataGridRequestSource requestSource = (DataGridRequestSource)((Object)ObjectUtils.tryCast((Object)source.source, DataGridRequestSource.class));
            if (!success || requestSource == null || !requestSource.isErrorReported()) {
                return;
            }
            DatabaseMutatorImpl.this.myFailed = requestSource.getRows().size() != requestSource.getUpdateCount();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "source";
            objectArray2[1] = "com/intellij/database/datagrid/DatabaseMutatorImpl$MyRequestListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCountReceived";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

