/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportEditorState;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.tree.ImportTargetChooser;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportUtil {
    private ImportUtil() {
    }

    @NotNull
    public static InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        VirtualFileSystem system;
        if (file == null) {
            ImportUtil.$$$reportNull$$$0(0);
        }
        InputStream stream = (system = file.getFileSystem()) instanceof JarFileSystem ? ImportUtil.getInputStreamForZip(file) : new FileInputStream(file.getPath());
        InputStream inputStream = CharsetToolkit.inputStreamSkippingBOM((InputStream)stream);
        if (inputStream == null) {
            ImportUtil.$$$reportNull$$$0(1);
        }
        return inputStream;
    }

    @NotNull
    public static AutoValueDescriptor createDescriptor(@NotNull ColumnDescriptor delegate, boolean autogenerated, boolean hasDefault, boolean computed) {
        if (delegate == null) {
            ImportUtil.$$$reportNull$$$0(2);
        }
        AutoValueDescriptor.DelegateDescriptor<ColumnDescriptor> delegateDescriptor = new AutoValueDescriptor.DelegateDescriptor<ColumnDescriptor>(delegate, autogenerated, hasDefault, computed);
        if (delegateDescriptor == null) {
            ImportUtil.$$$reportNull$$$0(3);
        }
        return delegateDescriptor;
    }

    @NotNull
    public static AutoValueDescriptor createDescriptor(@NotNull DeColumn column2, boolean mapped) {
        if (column2 == null) {
            ImportUtil.$$$reportNull$$$0(4);
        }
        MyDeColumnDescriptor myDeColumnDescriptor = new MyDeColumnDescriptor(column2, mapped);
        if (myDeColumnDescriptor == null) {
            ImportUtil.$$$reportNull$$$0(5);
        }
        return myDeColumnDescriptor;
    }

    @NotNull
    public static ImportDatabaseTableEditor<?> createEditor(@NotNull DeTable table, @NotNull List<? extends ColumnDescriptor> descriptors, @NotNull ImportAction.ImportEditorContext context) {
        if (table == null) {
            ImportUtil.$$$reportNull$$$0(6);
        }
        if (descriptors == null) {
            ImportUtil.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(8);
        }
        SqlCodeStyleSettings settings = SqlCodeStyles.getSqlSettings((Project)context.getProject(), (Language)context.getSqlDialect());
        TableEditorModel tableEditorModel = new TableEditorModel(table, new EditorModelsCache(settings));
        ImportEditorState<? extends ColumnDescriptor> state2 = new ImportEditorState<ColumnDescriptor>(context, descriptors);
        ImportDatabaseTableEditor editor = new ImportDatabaseTableEditor(state2, context.getCaps(), tableEditorModel);
        Disposer.register((Disposable)context.getDisposable(), editor);
        ImportDatabaseTableEditor importDatabaseTableEditor = editor;
        if (importDatabaseTableEditor == null) {
            ImportUtil.$$$reportNull$$$0(9);
        }
        return importDatabaseTableEditor;
    }

    @NotNull
    public static List<DataConsumer.Row> getRows(@NotNull DataGrid grid) {
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(10);
        }
        List<DataConsumer.Row> list = grid.getDataModel(DataAccessType.DATABASE_DATA).getRows();
        if (list == null) {
            ImportUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public static DeTable createDeTableFromDasObject(@NotNull DasModel dasModel, @NotNull BasicElement element2, @NotNull DeModel model) {
        if (dasModel == null) {
            ImportUtil.$$$reportNull$$$0(12);
        }
        if (element2 == null) {
            ImportUtil.$$$reportNull$$$0(13);
        }
        if (model == null) {
            ImportUtil.$$$reportNull$$$0(14);
        }
        DeTable deTable = (DeTable)model.getExportHelper().exportDeep(dasModel, element2, true);
        if (deTable == null) {
            ImportUtil.$$$reportNull$$$0(15);
        }
        return deTable;
    }

    @NotNull
    public static DeTable createDeTableFromColumns(@NotNull DeModel model, @NotNull List<? extends ColumnDescriptor> descriptors, @NotNull String name2) {
        if (model == null) {
            ImportUtil.$$$reportNull$$$0(16);
        }
        if (descriptors == null) {
            ImportUtil.$$$reportNull$$$0(17);
        }
        if (name2 == null) {
            ImportUtil.$$$reportNull$$$0(18);
        }
        DeTable table = new DeTable(name2, null, model);
        table.columns.clear();
        for (ColumnDescriptor columnDescriptor : descriptors) {
            DeColumn column2 = new DeColumn(columnDescriptor.getName(), table, model);
            column2.dataType = columnDescriptor.getTypeName();
            table.columns.add(column2);
        }
        DeTable deTable = table;
        if (deTable == null) {
            ImportUtil.$$$reportNull$$$0(19);
        }
        return deTable;
    }

    public static void removeUnsupportedObjects(@NotNull DeTable table, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (table == null) {
            ImportUtil.$$$reportNull$$$0(20);
        }
        if (caps == null) {
            ImportUtil.$$$reportNull$$$0(21);
        }
        if (!caps.getComment().isSupported()) {
            table.comment = null;
        }
        if (!caps.getColumnCaps(false).getComment().isSupported()) {
            for (DeColumn column2 : table.columns) {
                column2.comment = null;
            }
        }
    }

    public static void removeUntransferableObjects(@NotNull DeTable table) {
        if (table == null) {
            ImportUtil.$$$reportNull$$$0(22);
        }
        table.foreignKeys.clear();
        for (DeColumn column2 : table.columns) {
            column2.defaultValue = null;
            column2.flags.clear();
        }
        table.keys.clear();
        table.indices.clear();
    }

    @NotNull
    public static DeTable createTable(@NotNull ImportAction.ImportEditorContext context, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<DataConsumer.Row> rows, @NotNull Function<? super ColumnTypePredictorInfo, String> columnTypePredictor) {
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(23);
        }
        if (descriptors == null) {
            ImportUtil.$$$reportNull$$$0(24);
        }
        if (columnTypePredictor == null) {
            ImportUtil.$$$reportNull$$$0(25);
        }
        ImportInfo.Builder builder = context.getBuilder();
        List<? extends ColumnDescriptor> visibleProducers = builder.getVisibleProducers();
        DeModel oldModel = context.getDeModel();
        DeNamespace parent2 = ImportUtil.getSchema(context);
        DeTable table = new DeTable(context.getTableName(), parent2, oldModel);
        List producers = (List)ObjectUtils.chooseNotNull(visibleProducers, descriptors);
        table.columns.addAll(ImportUtil.createDeColumns(context, producers, rows, table, oldModel, columnTypePredictor));
        oldModel.addRoot(table);
        DeTable deTable = table;
        if (deTable == null) {
            ImportUtil.$$$reportNull$$$0(26);
        }
        return deTable;
    }

    @Nullable
    protected static DeNamespace getSchema(@NotNull ImportAction.ImportEditorContext context) {
        DeNamespace parent2;
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(27);
        }
        if ((parent2 = context.getNamespace()) != null && parent2.getKind() != ObjectKind.SCHEMA) {
            BasicSchema schema;
            assert (parent2.getKind() == ObjectKind.DATABASE) : "Unexpected " + parent2.getKind().code();
            BasicDatabase db = (BasicDatabase)ObjectUtils.tryCast((Object)parent2.unwrap(), BasicDatabase.class);
            BasicSchema basicSchema = schema = db == null ? null : ModelFun.getCurrentSchema(db);
            if (schema == null) {
                DeNamespace sc = new DeNamespace("", ObjectKind.SCHEMA, parent2.model);
                sc.parent = parent2;
                parent2.addLightChild(sc);
                parent2 = sc;
            } else {
                parent2 = (DeNamespace)parent2.model.getExportHelper().exportDeep(schema.getModel(), schema, false);
            }
        }
        return parent2;
    }

    public static void showTargetChooser(@NotNull Project project, @NotNull ImportInfo.Builder builder, @Nullable DbElement producer) {
        if (project == null) {
            ImportUtil.$$$reportNull$$$0(28);
        }
        if (builder == null) {
            ImportUtil.$$$reportNull$$$0(29);
        }
        MyDialog dialog2 = new MyDialog(project, builder, producer);
        dialog2.show();
    }

    @NotNull
    public static List<DataConsumer.Column> getColumns(@NotNull DataGrid grid) {
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(30);
        }
        List<DataConsumer.Column> columns = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns();
        List list = ContainerUtil.filter(ImportUtil.unambiguous(grid, columns), (Condition)Conditions.not(DbImplUtil::isRowId));
        if (list == null) {
            ImportUtil.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    public static List<DataConsumer.Column> getVisibleColumns(@NotNull DataGrid grid) {
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(32);
        }
        ModelIndexSet indices = grid.getVisibleColumns();
        ArrayList<DataConsumer.Column> columns = new ArrayList<DataConsumer.Column>(grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns(indices));
        ContainerUtil.sort(columns, Comparator.comparingInt(c2 -> c2.columnNum));
        List list = ContainerUtil.filter(ImportUtil.unambiguous(grid, columns), (Condition)Conditions.not(DbImplUtil::isRowId));
        if (list == null) {
            ImportUtil.$$$reportNull$$$0(33);
        }
        return list;
    }

    @NotNull
    public static String getPreferredTypeBasedOnContent(@NotNull ColumnTypePredictorInfo info) {
        if (info == null) {
            ImportUtil.$$$reportNull$$$0(34);
        }
        TypeMerger merger = null;
        ImportManager manager = info.context.getManager();
        if (info.rows == null || !(info.column instanceof DataConsumer.Column)) {
            String string = manager.getStringMerger().getName();
            if (string == null) {
                ImportUtil.$$$reportNull$$$0(35);
            }
            return string;
        }
        DataConsumer.Column column2 = (DataConsumer.Column)info.column;
        for (DataConsumer.Row row : info.rows) {
            Object object = column2.getValue(row);
            if (!(object instanceof String)) continue;
            String value = (String)object;
            TypeMerger nextMerger = manager.getType(value);
            merger = merger == null ? nextMerger : merger.merge(nextMerger);
        }
        String string = merger == null ? manager.getStringMerger().getName() : merger.getName();
        if (string == null) {
            ImportUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    private static List<DataConsumer.Column> unambiguous(@NotNull DataGrid grid, @NotNull List<DataConsumer.Column> columns) {
        DatabaseGridDataHookUp hookUp;
        SqlTableType type;
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(37);
        }
        if (columns == null) {
            ImportUtil.$$$reportNull$$$0(38);
        }
        SqlTableType sqlTableType = type = (hookUp = DataGridUtil.getDatabaseHookUp(grid)) == null ? null : hookUp.getTableType();
        if (type == null) {
            List<DataConsumer.Column> list = columns;
            if (list == null) {
                ImportUtil.$$$reportNull$$$0(39);
            }
            return list;
        }
        List<String> names = DbSqlUtil.getUnambiguousColumnNames(DataGridUtil.getProject(grid), DataGridUtil.getDatabaseDialect(grid), type, null);
        ArrayList<DataConsumer.Column> result2 = new ArrayList<DataConsumer.Column>();
        for (DataConsumer.Column column2 : columns) {
            if (column2.columnNum >= names.size()) {
                result2.add(column2);
                continue;
            }
            result2.add(new DataConsumer.Column(column2.columnNum, names.get(column2.columnNum), column2.type, column2.typeName, column2.clazz, column2.precision, column2.scale, column2.catalog, column2.schema, column2.table));
        }
        ArrayList<DataConsumer.Column> arrayList = result2;
        if (arrayList == null) {
            ImportUtil.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    @NotNull
    private static List<DeColumn> createDeColumns(@NotNull ImportAction.ImportEditorContext context, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<DataConsumer.Row> rows, @NotNull DeTable table, @NotNull DeModel model, @NotNull Function<? super ColumnTypePredictorInfo, String> columnTypePredictor) {
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(41);
        }
        if (descriptors == null) {
            ImportUtil.$$$reportNull$$$0(42);
        }
        if (table == null) {
            ImportUtil.$$$reportNull$$$0(43);
        }
        if (model == null) {
            ImportUtil.$$$reportNull$$$0(44);
        }
        if (columnTypePredictor == null) {
            ImportUtil.$$$reportNull$$$0(45);
        }
        ArrayList<DeColumn> result2 = new ArrayList<DeColumn>();
        for (ColumnDescriptor columnDescriptor : descriptors) {
            DeColumn deColumn = new DeColumn(columnDescriptor.getName(), table, model);
            deColumn.dataType = (String)columnTypePredictor.fun((Object)new ColumnTypePredictorInfo(context, columnDescriptor, rows));
            result2.add(deColumn);
        }
        ArrayList<DeColumn> arrayList = result2;
        if (arrayList == null) {
            ImportUtil.$$$reportNull$$$0(46);
        }
        return arrayList;
    }

    @NotNull
    private static InputStream getInputStreamForZip(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            ImportUtil.$$$reportNull$$$0(47);
        }
        JarFileSystem instance = JarFileSystem.getInstance();
        VirtualFile jar = instance.getVirtualFileForJar(file);
        VirtualFile root2 = instance.getJarRootForLocalFile((VirtualFile)ObjectUtils.assertNotNull((Object)jar));
        ZipFile zipFile = new ZipFile(((VirtualFile)ObjectUtils.assertNotNull((Object)jar)).getPath());
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)((VirtualFile)ObjectUtils.assertNotNull((Object)root2)));
        ZipEntry entry = zipFile.getEntry(relativePath);
        MyDelegateInputStream myDelegateInputStream = new MyDelegateInputStream(zipFile.getInputStream(entry), zipFile);
        if (myDelegateInputStream == null) {
            ImportUtil.$$$reportNull$$$0(48);
        }
        return myDelegateInputStream;
    }

    @NotNull
    public static String pluralizeRows(long count2) {
        String string = ImportUtil.pluralize("row", count2);
        if (string == null) {
            ImportUtil.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    public static String pluralize(@NotNull String word, long count2) {
        if (word == null) {
            ImportUtil.$$$reportNull$$$0(50);
        }
        String string = count2 == 1L ? word : StringUtil.pluralize((String)word);
        if (string == null) {
            ImportUtil.$$$reportNull$$$0(51);
        }
        return string;
    }

    public static boolean canBeProducer(@Nullable DbElement element2) {
        return element2 != null && DbImplUtil.canConnectTo(element2) && DbImplUtil.isDataTable(element2.getKind());
    }

    public static boolean canBeConsumer(@Nullable DbElement element2) {
        return ImportUtil.canBeConsumerFast((DasObject)element2) && DbImplUtil.canConnectToAndModify(element2);
    }

    public static boolean canBeConsumerFast(@Nullable DasObject element2) {
        return element2 != null && (!(element2 instanceof DasNamespace) && !(element2 instanceof DbDataSource) || DbImplUtil.getTopSingleNamespace(element2) != null) && ImportType.of(element2) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 46: 
            case 48: 
            case 49: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 46: 
            case 48: 
            case 49: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 46: 
            case 48: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: 
            case 20: 
            case 22: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 7: 
            case 17: 
            case 24: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 8: 
            case 23: 
            case 27: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 30: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasModel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: 
            case 16: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 25: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnTypePredictor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeTableFromDasObject";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeTableFromColumns";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createTable";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleColumns";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredTypeBasedOnContent";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "unambiguous";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeColumns";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStreamForZip";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralizeRows";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 46: 
            case 48: 
            case 49: 
            case 51: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRows";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDeTableFromDasObject";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createDeTableFromColumns";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeUnsupportedObjects";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeUntransferableObjects";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createTable";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSchema";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showTargetChooser";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleColumns";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredTypeBasedOnContent";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "unambiguous";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createDeColumns";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getInputStreamForZip";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 46: 
            case 48: 
            case 49: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDialog
    extends DialogWrapper {
        private final ImportTargetChooser myChooser;
        private final Project myProject;
        private final ImportInfo.Builder myBuilder;

        protected MyDialog(@NotNull Project project, @NotNull ImportInfo.Builder builder, @Nullable DbElement producer) {
            if (project == null) {
                MyDialog.$$$reportNull$$$0(0);
            }
            if (builder == null) {
                MyDialog.$$$reportNull$$$0(1);
            }
            super(project);
            this.myChooser = new ImportTargetChooser(project, (Consumer<Object>)((Consumer)this::selectionChanged), producer);
            this.myProject = project;
            this.myBuilder = builder;
            Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myChooser);
            this.setTitle("Choose Target");
            this.init();
        }

        protected void init() {
            super.init();
            this.myChooser.getChoseByNamePanel().invoke(new ChooseByNamePopupComponent.Callback(){

                public void elementChosen(Object element2) {
                    this.chosen(element2);
                }
            }, ModalityState.stateForComponent((Component)this.getRootPane()), false);
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myChooser.getChoseByNamePanel().getPreferredFocusedComponent();
        }

        protected void doOKAction() {
            Object element2 = this.myChooser.getChoseByNamePanel().getChosenElement();
            this.chosen(element2);
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myChooser;
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return ((Object)((Object)this)).getClass().getCanonicalName();
        }

        private void chosen(@Nullable Object element2) {
            if (!this.getOKAction().isEnabled()) {
                return;
            }
            this.close(0);
            if (!(element2 instanceof DbElement)) {
                return;
            }
            ImportAction.showDialog(this.myProject, this.myBuilder, (DbElement)element2);
        }

        private void selectionChanged(@Nullable Object element2) {
            this.getOKAction().setEnabled(ObjectUtils.tryCast((Object)element2, DbElement.class) != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "builder";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dbimport/ImportUtil$MyDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyDeColumnDescriptor
    implements AutoValueDescriptor {
        private final DeColumn myColumn;
        private final boolean myMapped;

        private MyDeColumnDescriptor(@NotNull DeColumn column2, boolean mapped) {
            if (column2 == null) {
                MyDeColumnDescriptor.$$$reportNull$$$0(0);
            }
            this.myColumn = column2;
            this.myMapped = mapped;
        }

        @Override
        public int getScale() {
            return this.myColumn.getDataType().getScale();
        }

        @Override
        public int getSize() {
            return this.myColumn.getDataType().getPrecision();
        }

        @Override
        public int getType() {
            return JdbcUtil.guessJdbcTypeByName((String)this.myColumn.dataType);
        }

        @Override
        public String getName() {
            return this.myColumn.getName();
        }

        @Override
        public String getTypeName() {
            return this.myColumn.dataType;
        }

        @Override
        public String getJavaClassName() {
            return "";
        }

        @Override
        public boolean isAutogenerated() {
            return !this.myMapped && this.myColumn.flags.contains((Object)DeColumn.Flag.AUTO_INC);
        }

        @Override
        public boolean isComputed() {
            return !this.myMapped && this.myColumn.isComputed();
        }

        @Override
        public boolean hasDefault() {
            return !this.myMapped && this.myColumn.defaultValue != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ImportUtil$MyDeColumnDescriptor", "<init>"));
        }
    }

    private static class MyDelegateInputStream
    extends InputStream {
        private final InputStream myStream;
        private final Closeable myCloseable;

        private MyDelegateInputStream(@NotNull InputStream stream, @NotNull Closeable closeable) {
            if (stream == null) {
                MyDelegateInputStream.$$$reportNull$$$0(0);
            }
            if (closeable == null) {
                MyDelegateInputStream.$$$reportNull$$$0(1);
            }
            this.myStream = stream;
            this.myCloseable = closeable;
        }

        @Override
        public int read() throws IOException {
            return this.myStream.read();
        }

        @Override
        public int read(@NotNull byte[] b2, int off, int len) throws IOException {
            if (b2 == null) {
                MyDelegateInputStream.$$$reportNull$$$0(2);
            }
            return this.myStream.read(b2, off, len);
        }

        @Override
        public int read(@NotNull byte[] b2) throws IOException {
            if (b2 == null) {
                MyDelegateInputStream.$$$reportNull$$$0(3);
            }
            return this.myStream.read(b2);
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
            this.myCloseable.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closeable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "b";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dbimport/ImportUtil$MyDelegateInputStream";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ColumnTypePredictorInfo {
        public final ImportAction.ImportEditorContext context;
        public final ColumnDescriptor column;
        public final List<DataConsumer.Row> rows;

        public ColumnTypePredictorInfo(@NotNull ImportAction.ImportEditorContext context, @NotNull ColumnDescriptor column2, @Nullable List<DataConsumer.Row> rows) {
            if (context == null) {
                ColumnTypePredictorInfo.$$$reportNull$$$0(0);
            }
            if (column2 == null) {
                ColumnTypePredictorInfo.$$$reportNull$$$0(1);
            }
            this.context = context;
            this.column = column2;
            this.rows = rows;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dbimport/ImportUtil$ColumnTypePredictorInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

