/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.Dbms;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialectUtils {
    public static final String ALIAS = "t";

    public static <T, M extends BasicModModel, R extends BasicModRoot> T withNewModel(Dbms dbms, Class<M> modelClass, Class<R> rootClass, Function<? super R, ? extends T> function2) {
        M model = new ModelFactory(new MemoryTextStorage()).createModel(dbms, modelClass);
        Ref resultRef = Ref.create();
        model.modify(rootClass, root2 -> resultRef.set(function2.fun(root2)));
        return (T)resultRef.get();
    }

    public static <T extends BasicModNamedElement> T create(ModNamingFamily<? extends T> f, DasObject copy) {
        if (copy == null) {
            return DialectUtils.create(f, "");
        }
        T obj2 = f.createOrGet(copy.getName());
        obj2.setNameScripted(DbSqlUtil.isSqlObject(copy));
        obj2.setNameQuoted(DbSqlUtil.isQuoted(copy));
        return obj2;
    }

    public static <T extends BasicModNamedElement> T create(ModNamingFamily<? extends T> f, String name2) {
        T obj2 = f.createOrGet(name2);
        obj2.setNameScripted(true);
        obj2.setNameQuoted(false);
        return obj2;
    }

    public static DdlBuilder getDropSequenceSQL(@NotNull DdlBuilder builder, @NotNull DasObject sequence, @Nullable Boolean cascade) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(0);
        }
        if (sequence == null) {
            DialectUtils.$$$reportNull$$$0(1);
        }
        builder.keywords("DROP", "SEQUENCE").space().qualifiedRef(sequence);
        if (cascade != null) {
            builder.space().keyword(cascade != false ? "CASCADE" : "RESTRICT");
        }
        return builder;
    }

    public static DdlBuilder getDropViewSQL(@NotNull DdlBuilder builder, @NotNull DasTable view2, @Nullable Boolean cascade) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(2);
        }
        if (view2 == null) {
            DialectUtils.$$$reportNull$$$0(3);
        }
        builder.keyword("DROP").space().keyword("VIEW").space().qualifiedRef((DasObject)view2);
        if (cascade != null) {
            builder.space();
            builder.keyword(cascade != false ? "CASCADE" : "RESTRICT");
        }
        return builder;
    }

    public static void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode, int dirPos, boolean inOutSeparate) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(4);
        }
        ArgumentDirection parameterType = parameter.getArgumentDirection();
        if (dirPos == 0) {
            DialectUtils.sqlParameterDirection(builder, parameterType, inOutSeparate, true);
        }
        if (longMode && StringUtil.isNotEmpty((String)parameter.getName())) {
            if (builder.getDialect().getDbms().isTransactSql()) {
                builder.plain(parameter.getName()).space();
            } else {
                builder.identifier((DasObject)parameter, parameter.getName()).space();
            }
        }
        if (dirPos == 1) {
            DialectUtils.sqlParameterDirection(builder, parameterType, inOutSeparate, true);
        }
        builder.type((DasTypedObject)parameter);
        if (dirPos == 2) {
            DialectUtils.sqlParameterDirection(builder, parameterType, inOutSeparate, false);
        }
    }

    public static void sqlParameterDirection(@NotNull DdlBuilder builder, ArgumentDirection parameterType, boolean inOutSeparate, boolean space) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(5);
        }
        if (parameterType != ArgumentDirection.IN) {
            if (!space) {
                builder.space();
            }
            if (inOutSeparate && parameterType == ArgumentDirection.INOUT) {
                builder.keywords("IN", "OUT");
            } else {
                builder.keyword(parameterType.name());
            }
            if (space) {
                builder.space();
            }
        }
    }

    public static <E> Iterable<E> resolve(final @NotNull MultiRef<E> ref) {
        if (ref == null) {
            DialectUtils.$$$reportNull$$$0(6);
        }
        return new Iterable<E>(){

            @Override
            @NotNull
            public Iterator<E> iterator() {
                Iterator iterator = new Iterator<E>(){
                    MultiRef.It<E> it;
                    {
                        this.it = ref.iterate();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public E next() {
                        this.it.next();
                        return this.it.resolve();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
                if (iterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/DialectUtils$1", "iterator"));
            }
        };
    }

    @NotNull
    public static String toHexString(@NotNull byte[] bytes) {
        if (bytes == null) {
            DialectUtils.$$$reportNull$$$0(7);
        }
        CharOut out = CharOut.Util.newSink(new StringBuilder(bytes.length * 2));
        for (byte b2 : bytes) {
            DialectUtils.appendHex(out, (long)b2 & 0xFFL, 2);
        }
        String string = out.toString();
        if (string == null) {
            DialectUtils.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String toPresentableHexString(@NotNull byte[] bytes) {
        String string;
        if (bytes == null) {
            DialectUtils.$$$reportNull$$$0(9);
        }
        try {
            int expectedLength = (bytes.length / 16 + 1) * 78;
            CharOut out = CharOut.Util.newSink(new StringBuilder(expectedLength));
            DialectUtils.toPresentableHexString(new ByteArrayInputStream(bytes), out);
            string = out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            DialectUtils.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static void toPresentableHexString(@NotNull InputStream input, @NotNull CharOut output) throws IOException {
        if (input == null) {
            DialectUtils.$$$reportNull$$$0(11);
        }
        if (output == null) {
            DialectUtils.$$$reportNull$$$0(12);
        }
        long i2 = 0L;
        StringBuilder sb2 = new StringBuilder();
        while (input.available() > 0) {
            sb2.setLength(0);
            DialectUtils.appendHex(output, i2 * 16L, 8).append("  ");
            for (int j = 0; j < 16; ++j) {
                if (input.available() > 0) {
                    int value = input.read();
                    DialectUtils.appendHex(output, value, 2).append(" ");
                    sb2.append((char)(!Character.isISOControl(value) ? (int)value : 46));
                    continue;
                }
                while (j < 16) {
                    output.append("   ");
                    ++j;
                }
            }
            output.append("   ").append(sb2).append("\n");
            ++i2;
        }
        input.close();
    }

    private static CharOut appendHex(CharOut out, long value, int padTo) {
        String hex = Long.toHexString(value);
        for (int i2 = hex.length(); i2 < padTo; ++i2) {
            out.append("0");
        }
        return out.append(StringUtil.toUpperCase((String)hex));
    }

    public static DdlBuilder getCreateViewSQL(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition) {
        if (builder == null) {
            DialectUtils.$$$reportNull$$$0(13);
        }
        if (view2 == null) {
            DialectUtils.$$$reportNull$$$0(14);
        }
        if (definition == null) {
            DialectUtils.$$$reportNull$$$0(15);
        }
        builder.keywords("CREATE", "VIEW").space().qualifiedRef((DasObject)view2).space().keyword("AS").space().plain(definition);
        return builder;
    }

    @NotNull
    public static String sqlConcat(@NotNull List<String> statements2) {
        if (statements2 == null) {
            DialectUtils.$$$reportNull$$$0(16);
        }
        String string = StringUtil.join(statements2, (String)";\n") + (statements2.isEmpty() ? "" : ";");
        if (string == null) {
            DialectUtils.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static void appendStringList(DdlBuilder builder, Iterable<String> columns) {
        DialectUtils.appendCommaSeparated(builder, ContainerUtil.map(columns, column2 -> b2 -> b2.columnRef((String)column2)));
    }

    public static void appendCommaSeparated(DdlBuilder builder, Iterable<? extends Consumer<DdlBuilder>> values2) {
        boolean first2 = true;
        for (Consumer<DdlBuilder> consumer2 : values2) {
            if (first2) {
                first2 = false;
            } else {
                builder.symbol(",").space();
            }
            consumer2.consume((Object)builder);
        }
    }

    public static DdlBuilder sqlDropProcedure(DdlBuilder builder, DasRoutine procedure, boolean ifExists) {
        String type = procedure.getRoutineKind().name();
        builder.keyword("DROP").space().keyword(type).space();
        if (ifExists) {
            builder.keywords("IF", "EXISTS").space();
        }
        return builder.qualifiedRef((DasObject)procedure);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 8: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/DialectUtils";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/DialectUtils";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableHexString";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlConcat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDropSequenceSQL";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDropViewSQL";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameterDirection";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
            case 8: 
            case 10: 
            case 17: {
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toPresentableHexString";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCreateViewSQL";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlConcat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

