/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.BaseDmlGenerator;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.util.DdlBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J(\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/cassandra/CassDmlGenerator;", "Lcom/intellij/database/dialects/base/BaseDmlGenerator;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "appendColumns", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "table", "Lcom/intellij/database/model/DasTable;", "columns", "", "Lcom/intellij/database/model/DasColumn;", "appendFromTable", "dasTable", "insertNewLines", "", "alias", "", "select", "task", "Lcom/intellij/database/script/generator/dml/SelectTask;", "intellij.database.dialects.cassandra"})
public final class CassDmlGenerator
extends BaseDmlGenerator {
    @Override
    @NotNull
    protected DdlBuilder select(@NotNull DdlBuilder builder, @NotNull SelectTask task) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super.select(builder, task);
        if (task.getWhereClause() != null) {
            builder.newLine().keywords("ALLOW", "FILTERING");
        }
        return builder;
    }

    @Override
    protected void appendColumns(@NotNull DdlBuilder builder, @Nullable DasTable table, @NotNull List<? extends DasColumn> columns) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
        if (columns.isEmpty()) {
            Intrinsics.checkExpressionValueIsNotNull((Object)builder.symbol("*"), (String)"builder.symbol(\"*\")");
        } else {
            this.appendColumnList(null, builder, (Iterable<? extends DasColumn>)columns);
        }
    }

    @Override
    protected void appendFromTable(@NotNull DdlBuilder builder, @NotNull DasTable dasTable, boolean insertNewLines, @NotNull String alias) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)dasTable, (String)"dasTable");
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        if (insertNewLines) {
            builder.newLine();
        } else {
            builder.space();
        }
        builder.keyword("FROM").space().qualifiedRef((DasObject)dasTable);
    }

    public CassDmlGenerator(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        super(dbms);
    }
}

