/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.generator.producers;

import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.CreateSequence;
import com.intellij.database.dialects.db2.model.Db2Sequence;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicSequence;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u001a\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/db2/generator/producers/Db2CreateSequence;", "Lcom/intellij/database/dialects/base/generator/producers/CreateSequence;", "Lcom/intellij/database/dialects/db2/model/Db2Sequence;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/db2/model/Db2Sequence;)V", "gatherSequenceIdentityParameters", "", "sequence", "forCreateSequence", "", "parameters", "", "", "produceComment", "exists", "comment", "intellij.database.dialects.db2"})
public final class Db2CreateSequence
extends CreateSequence<Db2Sequence> {
    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
        BaseProducersKt.commentStatement(this, "sequence", comment);
    }

    @Override
    public void gatherSequenceIdentityParameters(@NotNull Db2Sequence sequence, @NotNull List<String> parameters) {
        Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        this.gatherSequenceIdentityParameters(sequence, true, parameters);
    }

    public final void gatherSequenceIdentityParameters(@NotNull Db2Sequence sequence, boolean forCreateSequence, @NotNull List<String> parameters) {
        Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        if (forCreateSequence) {
            DataType dataType = sequence.getDataType();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"sequence.dataType");
            if (!StringsKt.equals((String)dataType.getSpecification(), (String)"INTEGER", (boolean)true)) {
                StringBuilder stringBuilder = new StringBuilder().append("as ");
                DataType dataType2 = sequence.getDataType();
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType2, (String)"sequence.dataType");
                parameters.add(stringBuilder.append(this.script(dataType2)).toString());
            }
        }
        super.gatherSequenceIdentityParameters((BasicSequence)sequence, parameters);
        int cacheSize = sequence.getCacheSize();
        if (sequence.isOrdered()) {
            parameters.add("order");
        }
        if (sequence.isCycling()) {
            parameters.add("cycle");
        }
        if (cacheSize <= 1) {
            parameters.add("no cache");
        } else if (cacheSize != 20) {
            parameters.add("cache " + cacheSize);
        }
    }

    public Db2CreateSequence(@NotNull ScriptingContext context, @NotNull Db2Sequence element2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super(context, (BasicSequence)element2);
    }
}

