/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.greenplum.model;

import com.intellij.database.dialects.greenplum.model.GPlumAggregate;
import com.intellij.database.dialects.greenplum.model.GPlumDefType;
import com.intellij.database.dialects.greenplum.model.GPlumExternalTable;
import com.intellij.database.dialects.greenplum.model.GPlumLocalTable;
import com.intellij.database.dialects.greenplum.model.GPlumLocalTableColumn;
import com.intellij.database.dialects.greenplum.model.GPlumModelHelper;
import com.intellij.database.dialects.greenplum.model.GPlumPartition;
import com.intellij.database.dialects.greenplum.model.GPlumRole;
import com.intellij.database.dialects.greenplum.model.GPlumRoutine;
import com.intellij.database.dialects.greenplum.model.GPlumTrigger;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumDescriptionService;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.properties.GPlumPartitionKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001B\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/greenplum/model/GPlumDescriptionService;", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumDescriptionService;", "Lcom/intellij/database/dialects/greenplum/model/GPlumRoutine;", "Lcom/intellij/database/dialects/greenplum/model/GPlumDefType;", "Lcom/intellij/database/dialects/greenplum/model/GPlumTrigger;", "Lcom/intellij/database/dialects/greenplum/model/GPlumRole;", "Lcom/intellij/database/dialects/greenplum/model/GPlumAggregate;", "()V", "helper", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeExternalTable", "t", "Lcom/intellij/database/dialects/greenplum/model/GPlumExternalTable;", "describeLocalTable", "Lcom/intellij/database/dialects/greenplum/model/GPlumLocalTable;", "describePartition", "Lcom/intellij/database/dialects/greenplum/model/GPlumPartition;", "inclusiveOrExclusive", "inclusive", "", "intellij.database.dialects.greenplum"})
public final class GPlumDescriptionService
extends PgGPlumDescriptionService<GPlumRoutine, GPlumDefType, GPlumTrigger, GPlumRole, GPlumAggregate> {
    @Override
    @NotNull
    protected PgGPlumBaseModelHelper getHelper() {
        return GPlumModelHelper.INSTANCE;
    }

    @Override
    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof GPlumExternalTable ? this.describeExternalTable((GPlumExternalTable)e) : (basicElement instanceof GPlumLocalTable ? this.describeLocalTable((GPlumLocalTable)e) : (basicElement instanceof GPlumPartition ? this.describePartition((GPlumPartition)e) : super.content(e, context)));
    }

    private final String describeLocalTable(GPlumLocalTable t) {
        String res2 = super.describePgTable(t);
        List<Integer> list = t.getDistributionKeys();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"t.distributionKeys");
        Object object = list;
        boolean bl = false;
        if (!object.isEmpty()) {
            res2 = res2 + " distribution_keys " + t.getDistributionKeys();
        }
        if (t.isDistributedRandomly()) {
            res2 = res2 + " distributed_randomly";
        }
        object = res2;
        bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
    }

    private final String describeExternalTable(GPlumExternalTable t) {
        String string;
        ArrayList attributes2 = new ArrayList();
        Collection collection = attributes2;
        Boolean bl = t.getWritable();
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"t.writable");
        Object object = bl != false ? "writable" : "readable";
        boolean bl2 = false;
        collection.add(object);
        collection = attributes2;
        List<String> list = t.getLocations();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"t.locations");
        object = list;
        bl2 = false;
        if (!object.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append("locations (");
            List<String> list2 = t.getLocations();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"t.locations");
            string = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString();
        } else {
            string = "command (" + t.getCommand() + ')';
        }
        object = string;
        bl2 = false;
        collection.add(object);
        if (t.getExecLocation() != null) {
            collection = attributes2;
            object = "exec location (" + t.getExecLocation() + ')';
            bl2 = false;
            collection.add(object);
        }
        collection = attributes2;
        object = "format (" + t.getFormat().getName() + ')';
        bl2 = false;
        collection.add(object);
        collection = attributes2;
        object = "options (" + t.getFormatOptions() + ')';
        bl2 = false;
        collection.add(object);
        collection = attributes2;
        object = "encoding (" + t.getEncoding() + ')';
        bl2 = false;
        collection.add(object);
        if (t.getRejectLimit() != 0) {
            collection = attributes2;
            object = "reject limit (" + t.getRejectLimit() + ' ' + t.getRejectLimitType().getName() + ')';
            bl2 = false;
            collection.add(object);
        }
        List<Integer> list3 = t.getDistributionKeys();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"t.distributionKeys");
        collection = list3;
        boolean bl3 = false;
        if (!collection.isEmpty()) {
            collection = attributes2;
            String string2 = "distribution_keys " + t.getDistributionKeys();
            bl2 = false;
            collection.add(string2);
        }
        if (t.isDistributedRandomly()) {
            collection = attributes2;
            String string3 = "distributed_randomly";
            bl2 = false;
            collection.add(string3);
        }
        return CollectionsKt.joinToString$default((Iterable)attributes2, null, null, null, (int)0, null, null, (int)63, null);
    }

    private final String describePartition(GPlumPartition e) {
        ArrayList descriptions = new ArrayList();
        GPlumLocalTable gPlumLocalTable = e.getLocalTable();
        if (gPlumLocalTable == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gPlumLocalTable, (String)"e.localTable!!");
        GPlumLocalTable table = gPlumLocalTable;
        ArrayList columns = new ArrayList();
        for (Integer attribute : e.getColumns()) {
            Object object = (GPlumLocalTableColumn)table.getColumns().getByNaturalPosition((short)attribute.intValue());
            if (object == null || (object = object.getName()) == null) {
                object = "?unknown?";
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"table.columns.getByNatur\u2026t())?.name ?: \"?unknown?\"");
            Object column2 = object;
            Collection collection = columns;
            boolean bl = false;
            collection.add(column2);
        }
        Collection collection = columns;
        boolean bl = false;
        if (!collection.isEmpty()) {
            collection = descriptions;
            String string = "columns (" + CollectionsKt.joinToString$default((Iterable)columns, null, null, null, (int)0, null, null, (int)63, null) + ')';
            boolean bl2 = false;
            collection.add(string);
        }
        collection = descriptions;
        StringBuilder stringBuilder = new StringBuilder().append("kind (");
        GPlumPartitionKind gPlumPartitionKind = e.getPartitionKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gPlumPartitionKind), (String)"e.partitionKind");
        String string = stringBuilder.append(gPlumPartitionKind.getSqlName()).append(')').toString();
        boolean bl3 = false;
        collection.add(string);
        if (e.getPartitionKind() == GPlumPartitionKind.LIST) {
            if (e.getValues() != null) {
                collection = descriptions;
                string = "values (" + e.getValues() + ')';
                bl3 = false;
                collection.add(string);
            }
        } else {
            if (e.getStartValue() != null) {
                collection = descriptions;
                string = "start (" + e.getStartValue() + ' ' + this.inclusiveOrExclusive(e.isStartInclusive()) + ')';
                bl3 = false;
                collection.add(string);
            }
            if (e.getEndValue() != null) {
                collection = descriptions;
                string = "end (" + e.getEndValue() + ' ' + this.inclusiveOrExclusive(e.isEndInclusive()) + ')';
                bl3 = false;
                collection.add(string);
            }
            if (e.getEveryValue() != null) {
                collection = descriptions;
                string = "every (" + e.getEveryValue() + ')';
                bl3 = false;
                collection.add(string);
            }
        }
        collection = descriptions;
        string = "order (" + e.getOrder() + ')';
        bl3 = false;
        collection.add(string);
        if (e.isDefaultPartition()) {
            collection = descriptions;
            string = "default";
            bl3 = false;
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)descriptions, null, null, null, (int)0, null, null, (int)63, null);
    }

    private final String inclusiveOrExclusive(boolean inclusive) {
        return inclusive ? "inclusive" : "exclusive";
    }
}

