/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hsql;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.AbstractDefinitionProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;

public class HsqlDefinitionProvider
extends AbstractDefinitionProvider {
    private static final String ROUTINE_STMT = "SELECT ROUTINE_DEFINITION FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_SCHEMA=? AND ROUTINE_NAME=?";

    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            HsqlDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.ROUTINE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects2, @NotNull DatabaseConnection connection2, @NotNull PairConsumer<DasObject, Object> consumer2) {
        if (objects2 == null) {
            HsqlDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            HsqlDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer2 == null) {
            HsqlDefinitionProvider.$$$reportNull$$$0(3);
        }
        ReusableSmartStatement<ParameterizedStatementDecoration> routineStmt = null;
        try {
            routineStmt = SmartStatements.poweredBy(connection2).parameterized().reuse(ROUTINE_STMT);
            for (DasObject dasObject : objects2) {
                ObjectKind kind = dasObject.getKind();
                if (kind != ObjectKind.ROUTINE) continue;
                ReusableSmartStatement<ParameterizedStatementDecoration> statement = routineStmt;
                consumer2.consume((Object)dasObject, statement.execute(new StatementParameters().text(DasUtil.getSchema((DasObject)dasObject)).text(dasObject.getName()).asDecoration(), StandardResultsProcessors.FIRST_STRING).any());
            }
        }
        finally {
            JdbcUtil.closeSafe(routineStmt);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/hsql/HsqlDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

