/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hsql;

import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dialects.base.BaseExecutionEnvironmentHelper;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class HsqlExecutionEnvironmentHelper
extends BaseExecutionEnvironmentHelper {
    @Override
    @NotNull
    public ExecutionEnvironmentHelper.TimeZoneManager getTimeZoneManager() {
        ExecutionEnvironmentHelper.TimeZoneManager timeZoneManager = HsqlTimeZoneManager.INSTANCE;
        if (timeZoneManager == null) {
            HsqlExecutionEnvironmentHelper.$$$reportNull$$$0(0);
        }
        return timeZoneManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/hsql/HsqlExecutionEnvironmentHelper", "getTimeZoneManager"));
    }

    private static class HsqlTimeZoneManager
    implements ExecutionEnvironmentHelper.TimeZoneManager {
        static final ExecutionEnvironmentHelper.TimeZoneManager INSTANCE = new HsqlTimeZoneManager();
        private static final String INTERVAL_STATEMENT = "set time zone interval '%s' hour to minute;";
        private static final String LOCAL_STATEMENT = "set time zone local";

        private HsqlTimeZoneManager() {
        }

        @Override
        public boolean canChange() {
            return true;
        }

        @Override
        public Collection<String> getAvailableTimeZones() {
            return Arrays.asList("UTC", "Local");
        }

        @Override
        public void changeTimeZone(@NotNull DatabaseConnection connection2, @NotNull String timeZone) {
            String converted;
            if (connection2 == null) {
                HsqlTimeZoneManager.$$$reportNull$$$0(0);
            }
            if (timeZone == null) {
                HsqlTimeZoneManager.$$$reportNull$$$0(1);
            }
            String input = StringUtil.equalsIgnoreCase((CharSequence)(converted = HsqlTimeZoneManager.convertTimeZone(timeZone)), (CharSequence)"local") ? LOCAL_STATEMENT : String.format(INTERVAL_STATEMENT, timeZone);
            SmartStatements.poweredBy(connection2).simple(Configuration.sourced(SmartStatements.Source.SYSTEM)).barren().quiet().execute(input);
        }

        @NotNull
        private static String convertTimeZone(@NotNull String timeZone) {
            String trimmed;
            if (timeZone == null) {
                HsqlTimeZoneManager.$$$reportNull$$$0(2);
            }
            String string = StringUtil.equalsIgnoreCase((CharSequence)(trimmed = timeZone.trim()), (CharSequence)"UTC") ? "+00:00" : trimmed;
            if (string == null) {
                HsqlTimeZoneManager.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timeZone";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/hsql/HsqlExecutionEnvironmentHelper$HsqlTimeZoneManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/hsql/HsqlExecutionEnvironmentHelper$HsqlTimeZoneManager";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertTimeZone";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "changeTimeZone";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "convertTimeZone";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

