/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.dialects.base.introspector.NameCache;
import com.intellij.database.dialects.mysqlbase.generator.MysqlBaseNamingService;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntroQueries;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveColumns$;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveEvents$;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveRoutineParameters$;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveRoutineParametersFromSource$;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveRoutines$;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTableConstraintColumns$;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTableDetails$;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTables$;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTriggers$;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector$applySchemas$1$$special$;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector$retrieveCollations$1$$special$;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospectorKt;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseArgument;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseCollation;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseConstraint;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseEvent;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseForeignKey;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseIndex;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseKey;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseLikeColumn;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseLikeTable;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseRoot;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseRoutine;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseSchema;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseTable;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseTableColumn;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseTrigger;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseView;
import com.intellij.database.dialects.mysqlbase.model.MysqlModelFunKt;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.NameIndex;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.MysqlColumnKind;
import com.intellij.database.model.properties.MysqlEventStatus;
import com.intellij.database.script.CompositeText;
import com.intellij.database.util.Casing;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.exceptions.DBException;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005:\u0003EFGB\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J3\u0010%\u001a\u0018\u0012\u0004\u0012\u00028\u00000&R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010*J5\u0010+\u001a\u001a\u0012\u0006\b\u0001\u0012\u00028\u00010,R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010-\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020!H\u0014J\b\u00100\u001a\u00020!H\u0014J\u0010\u00101\u001a\u00020!2\u0006\u00102\u001a\u00020(H\u0014J\u001d\u00103\u001a\u00020!2\u0006\u00102\u001a\u00020(2\u0006\u0010-\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u00104J\u001e\u00105\u001a\u00020!2\u0006\u00102\u001a\u00020(2\f\u00106\u001a\b\u0012\u0004\u0012\u00028\u00010#H\u0014J\u001d\u00107\u001a\u00020!2\u0006\u00108\u001a\u00028\u00002\u0006\u00109\u001a\u00020:H\u0014\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020!H\u0016J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>H\u0002J\b\u0010@\u001a\u00020!H\u0016J\u0010\u0010A\u001a\u00020!2\u0006\u00102\u001a\u00020(H\u0002J\u0010\u0010B\u001a\u00020!2\u0006\u00102\u001a\u00020(H\u0002J\b\u0010C\u001a\u00020>H\u0004J\b\u0010D\u001a\u00020>H\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u001a\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R\u001a\u0010\u001d\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0011\"\u0004\b\u001f\u0010\u0013\u00a8\u0006H"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector;", "R", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoot;", "S", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/Dbms;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "circumventDbe5060", "", "defProperlyQuoted", "getDefProperlyQuoted", "()Z", "setDefProperlyQuoted", "(Z)V", "genFromSrc", "getGenFromSrc", "setGenFromSrc", "parametersTableExists", "getParametersTableExists", "setParametersTableExists", "schedulerEnabled", "getSchedulerEnabled", "setSchedulerEnabled", "unescapeGenExpr", "getUnescapeGenExpr", "setUnescapeGenExpr", "applySchemas", "", "newSchemas", "", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Schema;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlDatabaseRetriever;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "(Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoot;)Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlDatabaseRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlSchemaRetriever;", "schema", "(Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;)Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlSchemaRetriever;", "initConnectionRelatedState", "initFlags", "introspectNamespacesInTran", "tran", "introspectOneSchema", "(Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;)V", "introspectSchemasAuto", "schemas", "introspectServerInfo", "root", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "(Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoot;Lcom/intellij/database/dataSource/DatabaseConnection;)V", "introspectServerObjects", "quote", "", "def", "retrieveAndApplySchemas", "retrieveCasing", "retrieveCollations", "storageEngineVar", "tmpStorageEngineVar", "Factory", "MysqlDatabaseRetriever", "MysqlSchemaRetriever", "intellij.database.dialects.mysqlbase"})
public class MysqlBaseIntrospector<R extends MysqlBaseRoot, S extends MysqlBaseSchema>
extends BaseSingleDatabaseIntrospector<R, S> {
    private final boolean circumventDbe5060;
    private boolean genFromSrc;
    private boolean defProperlyQuoted;
    private boolean unescapeGenExpr;
    private boolean parametersTableExists;
    private boolean schedulerEnabled;

    protected final boolean getGenFromSrc() {
        return this.genFromSrc;
    }

    protected final void setGenFromSrc(boolean bl) {
        this.genFromSrc = bl;
    }

    protected final boolean getDefProperlyQuoted() {
        return this.defProperlyQuoted;
    }

    protected final void setDefProperlyQuoted(boolean bl) {
        this.defProperlyQuoted = bl;
    }

    protected final boolean getUnescapeGenExpr() {
        return this.unescapeGenExpr;
    }

    protected final void setUnescapeGenExpr(boolean bl) {
        this.unescapeGenExpr = bl;
    }

    protected final boolean getParametersTableExists() {
        return this.parametersTableExists;
    }

    protected final void setParametersTableExists(boolean bl) {
        this.parametersTableExists = bl;
    }

    protected final boolean getSchedulerEnabled() {
        return this.schedulerEnabled;
    }

    protected final void setSchedulerEnabled(boolean bl) {
        this.schedulerEnabled = bl;
    }

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        this.initFlags();
        this.schedulerEnabled = (Boolean)this.inTransaction((Function1)new Function1<DBTransaction, Boolean>(this){
            final /* synthetic */ MysqlBaseIntrospector this$0;

            public final boolean invoke(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                return Intrinsics.areEqual((Object)MysqlBaseIntroQueries.INSTANCE.retrieveSchedulerStatus(tran, this.this$0.getDbms()), (Object)"DISABLED") ^ true;
            }
            {
                this.this$0 = mysqlBaseIntrospector;
                super(1);
            }
        });
    }

    protected void initFlags() {
        Dbms dbms = this.getDbms();
        if (Intrinsics.areEqual((Object)dbms, (Object)Dbms.MEMSQL)) {
            this.genFromSrc = false;
            this.defProperlyQuoted = false;
            this.unescapeGenExpr = false;
        } else {
            this.genFromSrc = false;
            this.defProperlyQuoted = false;
            this.unescapeGenExpr = this.getServerVersion().isOrGreater(new int[]{8});
        }
    }

    @Override
    protected void introspectServerInfo(@NotNull R root2, @NotNull DatabaseConnection connection2) {
        Intrinsics.checkParameterIsNotNull(root2, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
        super.introspectServerInfo((BasicModRoot)root2, connection2);
        String[] engs2 = (String[])this.inTransaction((Function1)new Function1<DBTransaction, String[]>(this){
            final /* synthetic */ MysqlBaseIntrospector this$0;

            @Nullable
            public final String[] invoke(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                return MysqlBaseIntroQueries.INSTANCE.retrieveDefaultEngines(tran, this.this$0.getDbms(), this.this$0.storageEngineVar(), this.this$0.tmpStorageEngineVar());
            }
            {
                this.this$0 = mysqlBaseIntrospector;
                super(1);
            }
        });
        root2.setDefaultEngine(engs2 != null ? engs2[0] : null);
        root2.setDefaultTmpEngine(engs2 != null ? engs2[1] : null);
        this.parametersTableExists = (Boolean)this.inTransaction((Function1)new Function1<DBTransaction, Boolean>(root2){
            final /* synthetic */ MysqlBaseRoot $root;

            public final boolean invoke(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                return MysqlBaseIntroQueries.INSTANCE.retrieveParametersTableExists(tran, this.$root) != null;
            }
            {
                this.$root = mysqlBaseRoot;
                super(1);
            }
        });
    }

    @NotNull
    protected String tmpStorageEngineVar() {
        return Intrinsics.areEqual((Object)this.getDbms(), (Object)Dbms.MYSQL) && this.getServerVersion().isOrGreater(new int[]{5, 6, 3}) ? "default_tmp_storage_engine" : this.storageEngineVar();
    }

    @NotNull
    protected final String storageEngineVar() {
        return this.getServerVersion().isOrGreater(new int[]{5, 5, 3}) ? "default_storage_engine" : "storage_engine";
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        this.retrieveCasing(tran);
        List<MysqlBaseIntroQueries.Schema> schemaNames2 = MysqlBaseIntroQueries.INSTANCE.retrieveSchemas(tran);
        this.applySchemas(schemaNames2);
    }

    @Override
    public void retrieveAndApplySchemas() {
        List schemaNames2 = (List)this.inTransaction((Function1)new Function1<DBTransaction, List<? extends MysqlBaseIntroQueries.Schema>>(MysqlBaseIntroQueries.INSTANCE){

            @NotNull
            public final List<MysqlBaseIntroQueries.Schema> invoke(@NotNull DBTransaction p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((MysqlBaseIntroQueries)this.receiver).retrieveSchemas(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MysqlBaseIntroQueries.class);
            }

            public final String getName() {
                return "retrieveSchemas";
            }

            public final String getSignature() {
                return "retrieveSchemas(Lorg/jetbrains/dekaf/core/DBTransaction;)Ljava/util/List;";
            }
        });
        this.applySchemas(schemaNames2);
    }

    @Override
    public void introspectServerObjects() {
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this){
            final /* synthetic */ MysqlBaseIntrospector this$0;

            public final void invoke(@NotNull DBTransaction it2) {
                Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                MysqlBaseIntrospector.access$retrieveCollations(this.this$0, it2);
            }
            {
                this.this$0 = mysqlBaseIntrospector;
                super(1);
            }
        }));
    }

    private final void applySchemas(List<MysqlBaseIntroQueries.Schema> newSchemas) {
        this.inModel((Function1)new Function1<R, Unit>(this, newSchemas){
            final /* synthetic */ MysqlBaseIntrospector this$0;
            final /* synthetic */ List $newSchemas;

            public final void invoke(@NotNull R root2) {
                Intrinsics.checkParameterIsNotNull(root2, (String)"root");
                NamingFamily namingFamily = root2.getSchemas();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"root.schemas");
                NameIndex<T> schemas2 = new NameIndex<T>(namingFamily);
                boolean $i$f$cleanupFamilies = false;
                Function1 it2 = applySchemas$1$$special$$inlined$cleanupFamilies$1.INSTANCE;
                boolean bl = false;
                it2.invoke(schemas2.getFamily());
                boolean bl2 = false;
                boolean first2 = true;
                for (MysqlBaseIntroQueries.Schema s : this.$newSchemas) {
                    MysqlBaseSchema schema;
                    MysqlBaseSchema mysqlBaseSchema = schema = (MysqlBaseSchema)schemas2.createOrGet(s.schema_name);
                    Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseSchema, (String)"schema");
                    String string = s.default_collation_name;
                    mysqlBaseSchema.setCollation(string != null ? MysqlBaseIntrospector.access$dbIntern(this.this$0, string) : null);
                    if (!first2) continue;
                    schema.setCurrent(true);
                    first2 = false;
                }
                it = applySchemas$1$$special$$inlined$cleanupFamilies$2.INSTANCE;
                bl = false;
                it.invoke(schemas2.getFamily());
            }
            {
                this.this$0 = mysqlBaseIntrospector;
                this.$newSchemas = list;
                super(1);
            }
        });
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends S> schemas2) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull(schemas2, (String)"schemas");
        for (MysqlBaseSchema schema : schemas2) {
            this.introspectOneSchema(tran, schema);
        }
    }

    private final void retrieveCasing(DBTransaction tran) {
        int casing = MysqlBaseIntroQueries.INSTANCE.retrieveCasing(tran);
        this.inModel((Function1)new Function1<R, Unit>(casing){
            final /* synthetic */ int $casing;

            public final void invoke(@NotNull R r) {
                Casing casing;
                Intrinsics.checkParameterIsNotNull(r, (String)"r");
                switch (this.$casing) {
                    case 0: {
                        casing = BasicNamespace.EXACT_CASING;
                        break;
                    }
                    case 1: {
                        casing = BasicNamespace.LOWER_CASING;
                        break;
                    }
                    default: {
                        casing = BasicNamespace.MIXED_CASING;
                    }
                }
                r.setDefaultCasing(casing);
            }
            {
                this.$casing = n;
                super(1);
            }
        });
    }

    private final void retrieveCollations(DBTransaction tran) {
        this.inModel((Function1)new Function1<R, Unit>(this, tran){
            final /* synthetic */ MysqlBaseIntrospector this$0;
            final /* synthetic */ DBTransaction $tran;

            public final void invoke(@NotNull R r) {
                Intrinsics.checkParameterIsNotNull(r, (String)"r");
                boolean $i$f$cleanupFamilies = false;
                Function1 it2 = retrieveCollations$1$$special$$inlined$cleanupFamilies$1.INSTANCE;
                boolean bl = false;
                ModNamingFamily<? extends MysqlBaseCollation> modNamingFamily = r.getCollations();
                Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"r.collations");
                it2.invoke(modNamingFamily);
                boolean bl2 = false;
                MysqlBaseIntroQueries.INSTANCE.processCollations(this.$tran, (MysqlBaseRoot)r, (Function1<? super MysqlBaseIntroQueries.Collation, Unit>)((Function1)new Function1<MysqlBaseIntroQueries.Collation, Unit>(this, r){
                    final /* synthetic */ retrieveCollations.1 this$0;
                    final /* synthetic */ MysqlBaseRoot $r$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$r$inlined = mysqlBaseRoot;
                        super(1);
                    }

                    public final void invoke(@NotNull MysqlBaseIntroQueries.Collation c2) {
                        Intrinsics.checkParameterIsNotNull((Object)c2, (String)"c");
                        MysqlBaseCollation mysqlBaseCollation = this.$r$inlined.getCollations().createOrGet(c2.collation_name);
                        boolean bl = false;
                        boolean bl2 = false;
                        MysqlBaseCollation $this$apply = mysqlBaseCollation;
                        boolean bl3 = false;
                        String string = c2.character_set_name;
                        $this$apply.setCharset(string != null ? MysqlBaseIntrospector.access$dbIntern(this.this$0.this$0, string) : null);
                        $this$apply.setDefaultForCharset(c2.is_default);
                    }
                }));
                it = retrieveCollations$1$$special$$inlined$cleanupFamilies$2.INSTANCE;
                bl = false;
                ModNamingFamily<? extends MysqlBaseCollation> modNamingFamily2 = r.getCollations();
                Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"r.collations");
                it.invoke(modNamingFamily2);
            }
            {
                this.this$0 = mysqlBaseIntrospector;
                this.$tran = dBTransaction;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void introspectOneSchema(DBTransaction tran, S schema) {
        void this_$iv;
        MysqlBaseIntrospector mysqlBaseIntrospector = this;
        String operationName$iv = "Introspect schema " + schema.getName();
        boolean $i$f$handleErrors = false;
        try {
            boolean bl = false;
            MysqlSchemaRetriever<S> retriever = this.createSchemaRetriever(tran, schema);
            retriever.process();
        }
        catch (InterruptedException ie$iv) {
            throw (Throwable)ie$iv;
        }
        catch (DBException d$iv) {
            String message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
        }
        catch (NullPointerException npe$iv) {
            String message$iv = "NPE encountered when performing " + operationName$iv;
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
            BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv).error(message$iv, (Throwable)npe$iv);
        }
        catch (Exception e$iv) {
            String message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
        }
    }

    @Override
    @NotNull
    protected MysqlDatabaseRetriever<R> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull R database) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull(database, (String)"database");
        return new MysqlDatabaseRetriever(transaction);
    }

    @Override
    @NotNull
    protected MysqlSchemaRetriever<? extends S> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull S schema) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
        return new MysqlSchemaRetriever(this, transaction, schema);
    }

    private final String quote(String def) {
        String simpleEscaped = StringsKt.replace$default((String)def, (String)"'", (String)"''", (boolean)false, (int)4, null);
        return StringsKt.replace$default((String)StringsKt.replace$default((String)("" + '\'' + StringUtil.escapeStringCharacters((int)simpleEscaped.length(), (String)simpleEscaped, null, (boolean)true, (boolean)false, (StringBuilder)new StringBuilder()) + '\''), (String)"\u001a", (String)"\\Z", (boolean)false, (int)4, null), (String)"\u0000", (String)"\\0", (boolean)false, (int)4, null);
    }

    public MysqlBaseIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
        super(dbms, project, modelFactory);
        this.circumventDbe5060 = Registry.is((String)"database.introspection.mysql.dbe5060", (boolean)true);
        this.schedulerEnabled = true;
    }

    public static final /* synthetic */ void access$writeSources(MysqlBaseIntrospector $this, Function0 r) {
        $this.writeSources((Function0<Unit>)r);
    }

    public static final /* synthetic */ Object[] access$inplace(MysqlBaseIntrospector $this, Object[] $this$access_u24inplace, Function1 t) {
        return $this.inplace($this$access_u24inplace, t);
    }

    public static final /* synthetic */ void access$retrieveCollations(MysqlBaseIntrospector $this, DBTransaction tran) {
        $this.retrieveCollations(tran);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.mysqlbase"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @NotNull
        private final Dbms dbms;

        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            return version.isOrGreater(new int[]{5, 1});
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
            return new MysqlBaseIntrospector(dbms, project, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        @NotNull
        public final Dbms getDbms() {
            return this.dbms;
        }

        public Factory(@NotNull Dbms dbms) {
            Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
            this.dbms = dbms;
        }

        @Override
        public boolean isNative() {
            return DBIntrospector.Factory.DefaultImpls.isNative(this);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.mysqlbase"})
        public static final class VERSION
        extends PerObjectVersion {
            public static final VERSION INSTANCE;

            private VERSION() {
            }

            static {
                VERSION vERSION;
                INSTANCE = vERSION = new VERSION();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\b\u0084\u0004\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\u0018\u0012\u0004\u0012\u0002H\u00010\u0003R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J8\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0015H\u0014R\"\u0010\b\u001a\u0016\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlDatabaseRetriever;", "R", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoot;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "(Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;)V", "nativeDefinitionColumnNumber", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "", "process", "", "retrieveNativeDefinitionsFor", "kind", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "result", "", "", "", "intellij.database.dialects.mysqlbase"})
    protected final class MysqlDatabaseRetriever<R extends MysqlBaseRoot>
    extends BaseSingleDatabaseIntrospector.BaseDatabaseRetriever<R> {
        private final Map<ObjectKind, Integer> nativeDefinitionColumnNumber;

        @Override
        public void process() {
        }

        @Override
        protected void retrieveNativeDefinitionsFor(@NotNull ObjectKind kind, @NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            Integer n = this.nativeDefinitionColumnNumber.get(kind);
            if (n == null) {
                return;
            }
            int k = n;
            for (BasicElement basicElement : elements) {
                String string;
                Object object;
                block15: {
                    block14: {
                        object = basicElement.getSchema();
                        if (object == null || (object = object.getRealName()) == null) break block14;
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it2 = object2;
                        boolean bl3 = false;
                        object = '`' + (String)it2 + "`.";
                        if (object != null) break block15;
                    }
                    object = "";
                }
                Object q = object;
                String n2 = "`" + basicElement.getName() + "`";
                BasicElement basicElement2 = basicElement;
                if (basicElement2 instanceof MysqlBaseTable) {
                    string = "show create table " + (String)q + n2;
                } else if (basicElement2 instanceof MysqlBaseView) {
                    string = "show create view " + (String)q + n2;
                } else if (basicElement2 instanceof MysqlBaseTrigger) {
                    string = "show create trigger " + (String)q + n2;
                } else if (basicElement2 instanceof MysqlBaseEvent) {
                    string = "show create event " + (String)q + n2;
                } else {
                    String string2;
                    if (!(basicElement2 instanceof MysqlBaseRoutine)) continue;
                    String string3 = ((MysqlBaseRoutine)basicElement).getRoutineKind().name();
                    StringBuilder stringBuilder = new StringBuilder().append("show create ");
                    boolean bl = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                    string = stringBuilder.append(string2).append(' ').append((String)q).append(n2).toString();
                }
                String query = string;
                Object object2 = this.getTransaction().query(query, Layouts.rowOf((RowLayout)Layouts.arrayOf((int)k, String.class))).run();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"transaction.query(query,\u2026ring::class.java))).run()");
                String[] respond = (String[])object2;
                if (respond.length < k) continue;
                result2.put(basicElement, new String[]{respond[k - 1]});
            }
        }

        public MysqlDatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            super(MysqlBaseIntrospector.this, transaction);
            this.nativeDefinitionColumnNumber = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ObjectKind.USER, (Object)1), TuplesKt.to((Object)ObjectKind.SCHEMA, (Object)2), TuplesKt.to((Object)ObjectKind.TABLE, (Object)2), TuplesKt.to((Object)ObjectKind.VIEW, (Object)2), TuplesKt.to((Object)ObjectKind.TRIGGER, (Object)3), TuplesKt.to((Object)ObjectKind.ROUTINE, (Object)3), TuplesKt.to((Object)ObjectKind.SCHEDULED_EVENT, (Object)4)});
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0094\u0004\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J3\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00192\f\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\"\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u00172\f\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001cH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010 \u001a\u00020\u0017H\u0002J\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010 \u001a\u00020\u0017H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\u00172\u0006\u0010'\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0017H\u0002J\u0014\u0010+\u001a\u0004\u0018\u00010\u00172\b\u0010#\u001a\u0004\u0018\u00010\u0017H\u0002J\u001c\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010\fH\u0002J\u001d\u0010.\u001a\u00020/2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u0002022\u0006\u00104\u001a\u00020\u0017H\u0004J\u0010\u00105\u001a\u0002022\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002022\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u0002022\u0006\u0010<\u001a\u00020=H\u0002J\u0018\u0010>\u001a\u0002022\u0006\u0010\r\u001a\u00020?2\u0006\u0010@\u001a\u00020%H\u0002J\u0010\u0010A\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010B\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010C\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010D\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010E\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010E\u001a\u0002022\u0006\u0010\r\u001a\u00020?2\u0006\u0010@\u001a\u00020%H\u0014J\u0010\u0010F\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010G\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u001a\u0010H\u001a\u0002022\u0006\u00109\u001a\u00020:2\b\u0010 \u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010I\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010J\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010K\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010L\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0015\u0010M\u001a\u0002022\u0006\u0010\u0007\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010NJ\u0010\u0010O\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010P\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010Q\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010R\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010S\u001a\u00020\u00172\u0006\u0010T\u001a\u00020UH\u0002J \u0010V\u001a\u0002022\b\u0010W\u001a\u0004\u0018\u00010X2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0ZH\u0002J \u0010\\\u001a\u0002022\b\u0010]\u001a\u0004\u0018\u00010^2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020`0ZH\u0002J\b\u0010a\u001a\u00020/H\u0014J\u0010\u0010a\u001a\u00020/2\u0006\u0010\r\u001a\u00020?H\u0014J\u001f\u0010b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00192\b\u0010c\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010dJ\u0010\u0010e\u001a\u00020\u00172\u0006\u0010f\u001a\u00020\u0017H\u0002J\u0010\u0010g\u001a\u00020\u00172\u0006\u0010h\u001a\u00020\u0017H\u0002J\f\u0010i\u001a\u00020\u0017*\u00020\u0017H\u0002J3\u0010j\u001a\u000202\"\b\b\u0003\u0010k*\u00020l*\u0002Hk2\b\u0010m\u001a\u0004\u0018\u00010\u00172\f\u0010n\u001a\b\u0012\u0004\u0012\u0002Hk0ZH\u0002\u00a2\u0006\u0002\u0010oR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006p"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlSchemaRetriever;", "S", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;)V", "BUG", "Lkotlin/text/Regex;", "applyColumn", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseLikeColumn;", "table", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseLikeTable;", "c", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Column;", "applyTable", "t", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Table;", "asCascadeRule", "Lcom/intellij/database/model/properties/CascadeRule;", "s", "", "fixCasing", "", "names", "family", "Lcom/intellij/database/model/families/NamingFamily;", "([Ljava/lang/String;Lcom/intellij/database/model/families/NamingFamily;)[Ljava/lang/String;", "name", "getBody", "src", "getColumnKind", "Lcom/intellij/database/model/properties/MysqlColumnKind;", "extra", "getCreate", "Lcom/intellij/sql/psi/SqlCreateStatement;", "getDefaultExpression", "column", "getEventStatus", "Lcom/intellij/database/model/properties/MysqlEventStatus;", "status", "getOnUpdate", "getSequenceIdentity", "Lcom/intellij/database/model/SequenceIdentity;", "isPossibleToIntrospectSchemaIncrementally", "", "(Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;)Z", "process", "", "progress", "what", "retrieveBuggedEventSources", "event", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseEvent;", "retrieveBuggedRoutineSources", "routine", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoutine;", "retrieveBuggedTriggerSources", "trigger", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseTrigger;", "retrieveColumnGenExprFromTableSrc", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseTable;", "sql", "retrieveColumns", "retrieveEventSources", "retrieveEvents", "retrieveIndices", "retrieveInfoFromTableSrc", "retrieveRoutineParameters", "retrieveRoutineParametersFromInformationSchema", "retrieveRoutineParametersFromSource", "retrieveRoutineSources", "retrieveRoutines", "retrieveTableConstraintColumns", "retrieveTableConstraints", "retrieveTableDetails", "(Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;)V", "retrieveTables", "retrieveTriggerSources", "retrieveTriggers", "retrieveViewSources", "scriptName", "o", "Lcom/intellij/database/model/basic/BasicNamedElement;", "setUpConstraint", "con", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseConstraint;", "cols", "", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$ConstraintColumn;", "setUpIdx", "index", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseIndex;", "idxCols", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$IndexColumn;", "shouldRetrieveTableSrc", "splitColNames", "cn", "(Ljava/lang/String;)[Ljava/lang/String;", "trimLeadingZeroes", "def", "unescape", "str", "replaceBin", "setSourceOrMarkBugged", "T", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "text", "bugged", "(Lcom/intellij/database/model/basic/BasicModSourceAware;Ljava/lang/String;Ljava/util/List;)V", "intellij.database.dialects.mysqlbase"})
    protected static class MysqlSchemaRetriever<S extends MysqlBaseSchema>
    extends BaseIntrospector.AbstractSchemaRetriever<S> {
        private final Regex BUG;
        final /* synthetic */ MysqlBaseIntrospector this$0;

        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull S schema) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            return false;
        }

        protected final void progress(@NotNull String what) {
            Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
            this.this$0.updateStatus("Introspecting schema " + ((MysqlBaseSchema)this.getSchema()).getName() + " (completely)", what);
        }

        @Override
        public void process() {
            this.inSchema((Function1)new Function1<S, Unit>(this){
                final /* synthetic */ MysqlSchemaRetriever this$0;

                public final void invoke(@NotNull S schema) {
                    Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                    MysqlSchemaRetriever.access$retrieveTables(this.this$0, schema);
                }
                {
                    this.this$0 = mysqlSchemaRetriever;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<S, Unit>(this){
                final /* synthetic */ MysqlSchemaRetriever this$0;

                public final void invoke(@NotNull S schema) {
                    Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                    MysqlSchemaRetriever.access$retrieveColumns(this.this$0, schema);
                }
                {
                    this.this$0 = mysqlSchemaRetriever;
                    super(1);
                }
            });
            if (StringsKt.equals((String)((MysqlBaseSchema)this.getSchema()).getName(), (String)"information_schema", (boolean)true)) {
                return;
            }
            this.inSchema((Function1)new Function1<S, Unit>(this){
                final /* synthetic */ MysqlSchemaRetriever this$0;

                public final void invoke(@NotNull S schema) {
                    Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                    this.this$0.retrieveTableDetails(schema);
                }
                {
                    this.this$0 = mysqlSchemaRetriever;
                    super(1);
                }
            });
            this.inSchema((Function1)new Function1<S, Unit>(this){
                final /* synthetic */ MysqlSchemaRetriever this$0;

                public final void invoke(@NotNull S schema) {
                    Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                    MysqlSchemaRetriever.access$retrieveTriggers(this.this$0, schema);
                    MysqlSchemaRetriever.access$retrieveEvents(this.this$0, schema);
                    MysqlSchemaRetriever.access$retrieveRoutines(this.this$0, schema);
                }
                {
                    this.this$0 = mysqlSchemaRetriever;
                    super(1);
                }
            });
            if (this.this$0.getParametersTableExists()) {
                this.inSchema((Function1)new Function1<S, Unit>(this){
                    final /* synthetic */ MysqlSchemaRetriever this$0;

                    public final void invoke(@NotNull S schema) {
                        Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                        MysqlSchemaRetriever.access$retrieveRoutineParameters(this.this$0, schema);
                    }
                    {
                        this.this$0 = mysqlSchemaRetriever;
                        super(1);
                    }
                });
            }
            if (this.shouldRetrieveTableSrc()) {
                this.inSchema((Function1)new Function1<S, Unit>(this){
                    final /* synthetic */ MysqlSchemaRetriever this$0;

                    public final void invoke(@NotNull S schema) {
                        Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                        MysqlSchemaRetriever.access$retrieveInfoFromTableSrc(this.this$0, schema);
                    }
                    {
                        this.this$0 = mysqlSchemaRetriever;
                        super(1);
                    }
                });
            }
            if (this.getWithSources()) {
                this.inSchema((Function1)new Function1<S, Unit>(this){
                    final /* synthetic */ MysqlSchemaRetriever this$0;

                    public final void invoke(@NotNull S schema) {
                        Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                        MysqlBaseIntrospector this_$iv = this.this$0.this$0;
                        boolean $i$f$writeSources = false;
                        this_$iv.getModel().writeSources(new Runnable(this, (MysqlBaseSchema)schema){
                            final /* synthetic */ process.7 this$0;
                            final /* synthetic */ MysqlBaseSchema $schema$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$schema$inlined = mysqlBaseSchema;
                            }

                            public final void run() {
                                boolean bl = false;
                                MysqlSchemaRetriever.access$retrieveViewSources(this.this$0.this$0, this.$schema$inlined);
                                MysqlSchemaRetriever.access$retrieveRoutineSources(this.this$0.this$0, this.$schema$inlined);
                                MysqlSchemaRetriever.access$retrieveTriggerSources(this.this$0.this$0, this.$schema$inlined);
                                MysqlSchemaRetriever.access$retrieveEventSources(this.this$0.this$0, this.$schema$inlined);
                            }
                        });
                    }
                    {
                        this.this$0 = mysqlSchemaRetriever;
                        super(1);
                    }
                });
            } else if (!this.this$0.getParametersTableExists()) {
                this.inSchema((Function1)new Function1<S, Unit>(this){
                    final /* synthetic */ MysqlSchemaRetriever this$0;

                    public final void invoke(@NotNull S schema) {
                        Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
                        MysqlBaseIntrospector this_$iv = this.this$0.this$0;
                        boolean $i$f$writeSources = false;
                        this_$iv.getModel().writeSources(new Runnable(this, (MysqlBaseSchema)schema){
                            final /* synthetic */ process.8 this$0;
                            final /* synthetic */ MysqlBaseSchema $schema$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$schema$inlined = mysqlBaseSchema;
                            }

                            public final void run() {
                                boolean bl = false;
                                MysqlSchemaRetriever.access$retrieveRoutineSources(this.this$0.this$0, this.$schema$inlined);
                            }
                        });
                    }
                    {
                        this.this$0 = mysqlSchemaRetriever;
                        super(1);
                    }
                });
            }
        }

        protected void retrieveTableDetails(@NotNull S schema) {
            boolean bl;
            MysqlBaseTable t;
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            boolean $i$f$cleanupFamilies = false;
            Function1 it2 = MysqlSchemaRetriever$retrieveTableDetails$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl2 = false;
            ModNamingFamily<? extends MysqlBaseTable> modNamingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.tables");
            Iterable $this$forEach$iv = modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (MysqlBaseTable)element$iv;
                bl = false;
                MysqlBaseTable mysqlBaseTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseTable, (String)"t");
                Family family = mysqlBaseTable.getKeys();
                Intrinsics.checkExpressionValueIsNotNull((Object)family, (String)"t.keys");
                it2.invoke((Object)family);
                Family family2 = t.getForeignKeys();
                Intrinsics.checkExpressionValueIsNotNull((Object)family2, (String)"t.foreignKeys");
                it2.invoke((Object)family2);
                Family family3 = t.getIndices();
                Intrinsics.checkExpressionValueIsNotNull((Object)family3, (String)"t.indices");
                it2.invoke((Object)family3);
            }
            boolean bl3 = false;
            this.retrieveIndices((MysqlBaseSchema)schema);
            this.retrieveTableConstraints((MysqlBaseSchema)schema);
            this.retrieveTableConstraintColumns((MysqlBaseSchema)schema);
            it = MysqlSchemaRetriever$retrieveTableDetails$$inlined$cleanupFamilies$2.INSTANCE;
            bl2 = false;
            ModNamingFamily<? extends MysqlBaseTable> modNamingFamily2 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"schema.tables");
            $this$forEach$iv = modNamingFamily2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (MysqlBaseTable)element$iv;
                bl = false;
                MysqlBaseTable mysqlBaseTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseTable, (String)"t");
                Family family = mysqlBaseTable.getKeys();
                Intrinsics.checkExpressionValueIsNotNull((Object)family, (String)"t.keys");
                it.invoke((Object)family);
                Family family4 = t.getForeignKeys();
                Intrinsics.checkExpressionValueIsNotNull((Object)family4, (String)"t.foreignKeys");
                it.invoke((Object)family4);
                Family family5 = t.getIndices();
                Intrinsics.checkExpressionValueIsNotNull((Object)family5, (String)"t.indices");
                it.invoke((Object)family5);
            }
        }

        private final void retrieveTables(MysqlBaseSchema schema) {
            this.progress("tables and views");
            boolean $i$f$cleanupFamilies = false;
            Function1 it2 = MysqlSchemaRetriever$retrieveTables$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl = false;
            ModNamingFamily<? extends MysqlBaseTable> modNamingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.tables");
            it2.invoke(modNamingFamily);
            ModNamingFamily<? extends MysqlBaseView> modNamingFamily2 = schema.getViews();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"schema.views");
            it2.invoke(modNamingFamily2);
            boolean bl2 = false;
            MysqlBaseIntroQueries.INSTANCE.processTablesAndViews(this.getTransaction(), schema, (Function1<? super MysqlBaseIntroQueries.Table, Unit>)((Function1)new Function1<MysqlBaseIntroQueries.Table, Unit>(this, schema){
                final /* synthetic */ MysqlSchemaRetriever this$0;
                final /* synthetic */ MysqlBaseSchema $schema$inlined;
                {
                    this.this$0 = mysqlSchemaRetriever;
                    this.$schema$inlined = mysqlBaseSchema;
                    super(1);
                }

                public final void invoke(@NotNull MysqlBaseIntroQueries.Table t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    this.this$0.applyTable(this.$schema$inlined, t);
                }
            }));
            it = MysqlSchemaRetriever$retrieveTables$$inlined$cleanupFamilies$2.INSTANCE;
            bl = false;
            ModNamingFamily<? extends MysqlBaseTable> modNamingFamily3 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily3, (String)"schema.tables");
            it.invoke(modNamingFamily3);
            ModNamingFamily<? extends MysqlBaseView> modNamingFamily4 = schema.getViews();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily4, (String)"schema.views");
            it.invoke(modNamingFamily4);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @NotNull
        protected MysqlBaseLikeTable applyTable(@NotNull MysqlBaseSchema schema, @NotNull MysqlBaseIntroQueries.Table t) {
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                type = t.table_type;
                isView = StringUtil.contains((CharSequence)type, (CharSequence)"VIEW");
                v0 = schema.getViews();
                Intrinsics.checkExpressionValueIsNotNull(v0, (String)"schema.views");
                v1 = schema.getTables();
                Intrinsics.checkExpressionValueIsNotNull(v1, (String)"schema.tables");
                var5_5 = ModelFun.choose(isView, v0, v1).createOrGet(t.table_name);
                var6_6 = false;
                var7_7 = false;
                $this$apply = var5_5;
                $i$a$-apply-MysqlBaseIntrospector$MysqlSchemaRetriever$applyTable$1 = false;
                $this$apply.setSystem(StringsKt.equals((String)type, (String)"SYSTEM VERSIONED", (boolean)true) == false && StringUtil.containsIgnoreCase((String)type, (String)"SYSTEM") != false);
                v2 = $this$apply;
                v3 = StringKt.nullize$default((String)t.table_comment, (boolean)false, (int)1, null);
                if (v3 != null) {
                    var10_10 = v3;
                    var11_11 = v2;
                    var12_12 = false;
                    var13_13 = false;
                    it = var10_10;
                    $i$a$-takeIf-MysqlBaseIntrospector$MysqlSchemaRetriever$applyTable$1$1 = false;
                    var16_16 = (isView == false || (Intrinsics.areEqual((Object)it, (Object)"VIEW") ^ true) != false) != false ? var10_10 : null;
                    v2 = var11_11;
                    v4 = var16_16;
                } else {
                    v4 = null;
                }
                v2.setComment(v4);
                if (!($this$apply instanceof MysqlBaseTable)) break block7;
                v5 /* !! */  = (MysqlBaseTable)$this$apply;
                v6 = t.engine;
                if (v6 == null) ** GOTO lbl-1000
                var10_10 = v6;
                var11_11 = v5 /* !! */ ;
                var12_12 = false;
                var13_13 = false;
                it = var10_10;
                $i$a$-takeIf-MysqlBaseIntrospector$MysqlSchemaRetriever$applyTable$1$2 = false;
                v7 = schema.getRoot();
                if (v7 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"schema.root!!");
                var16_16 = (Intrinsics.areEqual((Object)it, (Object)MysqlModelFunKt.getDefaultEngine(v7, ((MysqlBaseTable)$this$apply).isTemporary())) ^ true) != false ? var10_10 : null;
                v5 /* !! */  = var11_11;
                v6 = var16_16;
                if (v6 != null) {
                    v8 = MysqlBaseIntrospector.access$dbIntern(this.this$0, v6);
                } else lbl-1000:
                // 2 sources

                {
                    v8 = null;
                }
                v5 /* !! */ .setEngine(v8);
                v9 /* !! */  = (MysqlBaseTable)$this$apply;
                v10 = t.table_collation;
                if (v10 == null) ** GOTO lbl-1000
                var10_10 = v10;
                var11_11 = v9 /* !! */ ;
                var12_12 = false;
                var13_13 = false;
                it = var10_10;
                $i$a$-takeIf-MysqlBaseIntrospector$MysqlSchemaRetriever$applyTable$1$3 = false;
                var16_16 = (Intrinsics.areEqual((Object)it, (Object)schema.getCollation()) ^ true) != false ? var10_10 : null;
                v9 /* !! */  = var11_11;
                v10 = var16_16;
                if (v10 != null) {
                    v11 = MysqlBaseIntrospector.access$dbIntern(this.this$0, v10);
                } else lbl-1000:
                // 2 sources

                {
                    v11 = null;
                }
                v9 /* !! */ .setCollation(v11);
            }
            v12 = var5_5;
            Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"isView.choose(schema.vie\u2026ntern()\n        }\n      }");
            return v12;
        }

        private final void retrieveIndices(MysqlBaseSchema schema) {
            this.progress("indices");
            NameCache tableCache = new NameCache();
            NameCache idxCache = new NameCache();
            boolean bl = false;
            List idxCols = new ArrayList();
            MysqlBaseIntroQueries.INSTANCE.processIndices(this.getTransaction(), schema, (Function1<? super MysqlBaseIntroQueries.IndexColumn, Unit>)((Function1)new Function1<MysqlBaseIntroQueries.IndexColumn, Unit>(this, tableCache, idxCache, idxCols, schema){
                final /* synthetic */ MysqlSchemaRetriever this$0;
                final /* synthetic */ NameCache $tableCache;
                final /* synthetic */ NameCache $idxCache;
                final /* synthetic */ List $idxCols;
                final /* synthetic */ MysqlBaseSchema $schema;

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void invoke(@NotNull MysqlBaseIntroQueries.IndexColumn c) {
                    Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                    var3_2 = this.$tableCache;
                    name$iv = c.table_name;
                    $i$f$get = false;
                    var6_5 = this_$iv;
                    create$iv$iv = false;
                    $i$f$get = false;
                    if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                    v0 = this_$iv$iv.getV();
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                        v1 = this_$iv$iv.getV();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var9_11 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                            final /* synthetic */ boolean $create;
                            final /* synthetic */ String $name;
                            {
                                this.$create = bl;
                                this.$name = string;
                                super(1);
                            }

                            @Nullable
                            public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                Intrinsics.checkParameterIsNotNull($this$invoke, (String)"$this$invoke");
                                return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                            }
                        };
                        var10_13 = this_$iv$iv;
                        var12_14 = this_$iv$iv;
                        $i$a$-get-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveIndices$1$table$1 = false;
                        MysqlSchemaRetriever.access$setUpIdx(this.this$0, (MysqlBaseIndex)this.$idxCache.getV(), this.$idxCols);
                        this.$idxCache.setV(null);
                        v2 = this.$schema.getTables();
                        Intrinsics.checkExpressionValueIsNotNull(v2, (String)"schema.tables");
                        var13_16 /* !! */  = (MysqlBaseTable)it.invoke(v2);
                        var12_14.setV((BasicModNamedElement)var13_16 /* !! */ );
                        v1 = this_$iv$iv.getV();
                    }
                    v3 = (MysqlBaseTable)v1;
                    if (v3 == null) {
                        return;
                    }
                    table = v3;
                    this_$iv = this.$idxCache;
                    name$iv = c.index_name;
                    create$iv = true;
                    $i$f$get = false;
                    if (this_$iv.getV() == null) ** GOTO lbl-1000
                    v4 = this_$iv.getV();
                    if (v4 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (Intrinsics.areEqual((Object)v4.getName(), (Object)name$iv)) {
                        v5 = this_$iv.getV();
                    } else lbl-1000:
                    // 2 sources

                    {
                        create$iv$iv = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv, name$iv){
                            final /* synthetic */ boolean $create;
                            final /* synthetic */ String $name;
                            {
                                this.$create = bl;
                                this.$name = string;
                                super(1);
                            }

                            @Nullable
                            public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                Intrinsics.checkParameterIsNotNull($this$invoke, (String)"$this$invoke");
                                return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                            }
                        };
                        $i$f$get = this_$iv;
                        var12_14 = this_$iv;
                        $i$a$-get-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveIndices$1$1 = false;
                        MysqlSchemaRetriever.access$setUpIdx(this.this$0, (MysqlBaseIndex)$this$get.getV(), this.$idxCols);
                        v6 = table.getIndices();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"table.indices");
                        var13_16 /* !! */  = (MysqlBaseIndex)it.invoke((Object)v6);
                        var12_14.setV((BasicModNamedElement)var13_16 /* !! */ );
                        v5 = this_$iv.getV();
                    }
                    this.$idxCols.add(c);
                }
                {
                    this.this$0 = mysqlSchemaRetriever;
                    this.$tableCache = nameCache;
                    this.$idxCache = nameCache2;
                    this.$idxCols = list;
                    this.$schema = mysqlBaseSchema;
                    super(1);
                }
            }));
            this.setUpIdx((MysqlBaseIndex)idxCache.getV(), idxCols);
        }

        /*
         * Unable to fully structure code
         */
        private final void setUpIdx(MysqlBaseIndex index, List<MysqlBaseIntroQueries.IndexColumn> idxCols) {
            block5: {
                v0 = index;
                if (v0 == null) break block5;
                var3_3 = v0;
                var4_4 = false;
                var5_5 = false;
                $this$apply = var3_3;
                $i$a$-apply-MysqlBaseIntrospector$MysqlSchemaRetriever$setUpIdx$1 = false;
                idx = (MysqlBaseIntroQueries.IndexColumn)CollectionsKt.first(idxCols);
                $this$apply.setUnique(idx.non_unique == false);
                var9_9 = idxCols;
                var10_10 = $this$apply;
                $i$f$map = false;
                var12_14 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var17_22 = (MysqlBaseIntroQueries.IndexColumn)item$iv$iv;
                    var18_23 = destination$iv$iv;
                    $i$a$-map-MysqlBaseIntrospector$MysqlSchemaRetriever$setUpIdx$1$1 = false;
                    var20_25 = it.column_name;
                    var18_23.add(var20_25);
                }
                var18_23 = (List)destination$iv$iv;
                var10_10.setColNames((List<String>)var18_23);
                $this$map$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)idxCols), (Function1)setUpIdx.1.2.INSTANCE);
                $i$f$map = new LinkedHashSet<E>();
                var10_10 = $this$apply;
                $i$f$mapTo = false;
                for (E item$iv : $this$mapTo$iv) {
                    var15_19 = (MysqlBaseIntroQueries.IndexColumn)item$iv;
                    var18_23 = destination$iv;
                    $i$a$-mapTo-MysqlBaseIntrospector$MysqlSchemaRetriever$setUpIdx$1$3 = false;
                    var20_25 = it.column_name;
                    var18_23.add(var20_25);
                }
                var18_23 = destination$iv;
                var10_10.setReverseColNames((Set)var18_23);
                v1 = $this$apply;
                v2 = idx.index_type;
                if (v2 == null) ** GOTO lbl-1000
                var9_9 = v2;
                var10_10 = v1;
                var11_13 = false;
                v3 = var9_9;
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                v4 = v3.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"(this as java.lang.String).toLowerCase()");
                var18_23 = v4;
                v1 = var10_10;
                v2 = var18_23;
                if (v2 != null) {
                    v5 = MysqlBaseIntrospector.access$dbIntern(this.this$0, (String)v2);
                } else lbl-1000:
                // 2 sources

                {
                    v5 = null;
                }
                v1.setType(v5);
                $this$apply.setComment(idx.index_comment);
            }
            idxCols.clear();
        }

        /*
         * Unable to fully structure code
         */
        private final CascadeRule asCascadeRule(String s) {
            block7: {
                block6: {
                    var2_2 = s;
                    var3_3 = false;
                    v0 = var2_2;
                    if (v0 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    v1 = v0.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"(this as java.lang.String).toLowerCase()");
                    var2_2 = v1;
                    switch (var2_2.hashCode()) {
                        case 1357211269: {
                            if (!var2_2.equals("set null")) ** break;
                            break block6;
                        }
                        case -890131325: {
                            if (!var2_2.equals("set default")) ** break;
                            break;
                        }
                        case 554829492: {
                            if (!var2_2.equals("cascade")) ** break;
                            v2 = CascadeRule.cascade;
                            break block7;
                        }
                    }
                    v2 = CascadeRule.set_default;
                    break block7;
                }
                v2 = CascadeRule.set_null;
                break block7;
                v2 = CascadeRule.no_action;
            }
            return v2;
        }

        private final void retrieveTableConstraints(MysqlBaseSchema schema) {
            this.progress("table constraints");
            NameCache tableCache = new NameCache();
            MysqlBaseIntroQueries.INSTANCE.processConstraints(this.getTransaction(), schema, (Function1<? super MysqlBaseIntroQueries.Constraint, Unit>)((Function1)new Function1<MysqlBaseIntroQueries.Constraint, Unit>(this, tableCache, schema){
                final /* synthetic */ MysqlSchemaRetriever this$0;
                final /* synthetic */ NameCache $tableCache;
                final /* synthetic */ MysqlBaseSchema $schema;

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull MysqlBaseIntroQueries.Constraint c) {
                    Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                    var3_2 = this.$tableCache;
                    name$iv = c.table_name;
                    $i$f$get = false;
                    var6_8 = this_$iv;
                    create$iv$iv = false;
                    $i$f$get = false;
                    if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                    v0 = this_$iv$iv.getV();
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                        v1 = this_$iv$iv.getV();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var9_17 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                            final /* synthetic */ boolean $create;
                            final /* synthetic */ String $name;
                            {
                                this.$create = bl;
                                this.$name = string;
                                super(1);
                            }

                            @Nullable
                            public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                Intrinsics.checkParameterIsNotNull($this$invoke, (String)"$this$invoke");
                                return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                            }
                        };
                        var10_21 = this_$iv$iv;
                        var12_22 = this_$iv$iv;
                        $i$a$-get-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTableConstraints$1$table$1 = false;
                        v2 = this.$schema.getTables();
                        Intrinsics.checkExpressionValueIsNotNull(v2, (String)"schema.tables");
                        var13_24 = (MysqlBaseTable)it.invoke(v2);
                        var12_22.setV((BasicModNamedElement)var13_24);
                        v1 = this_$iv$iv.getV();
                    }
                    v3 = (MysqlBaseTable)v1;
                    if (v3 == null) {
                        return;
                    }
                    table = v3;
                    v4 = StringKt.nullize((String)c.constraint_name, (boolean)false);
                    if (v4 == null || (v4 = MysqlBaseIntrospector.access$dbIntern(this.this$0.this$0, v4)) == null) {
                        return;
                    }
                    name = v4;
                    var4_3 = c.constraint_type;
                    tmp = -1;
                    switch (var4_3.hashCode()) {
                        case 1284802305: {
                            if (!var4_3.equals("PRIMARY KEY")) break;
                            tmp = 1;
                            break;
                        }
                        case -1787199535: {
                            if (!var4_3.equals("UNIQUE")) break;
                            tmp = 2;
                            break;
                        }
                        case 704200915: {
                            if (!var4_3.equals("FOREIGN KEY")) break;
                            tmp = 3;
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            var5_5 = table.getKeys().createOrGet(name);
                            var6_9 = false;
                            var7_12 = false;
                            $this$apply = (MysqlBaseKey)var5_5;
                            $i$a$-apply-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTableConstraints$1$1 = false;
                            $this$apply.setPrimary(true);
                            $this$apply.setNameSurrogate(Intrinsics.areEqual((Object)name, (Object)"PRIMARY"));
                            break;
                        }
                        case 3: {
                            var5_6 = table.getForeignKeys().createOrGet(name);
                            var6_10 = false;
                            var7_12 = false;
                            $this$apply = (MysqlBaseForeignKey)var5_6;
                            $i$a$-apply-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTableConstraints$1$2 = false;
                            $this$apply.setOnUpdate(MysqlSchemaRetriever.access$asCascadeRule(this.this$0, c.update_rule));
                            $this$apply.setOnDelete(MysqlSchemaRetriever.access$asCascadeRule(this.this$0, c.delete_rule));
                            break;
                        }
                        case 2: {
                            var5_7 = table.getKeys().createOrGet(name);
                            var6_11 = false;
                            var7_12 = false;
                            $this$apply = (MysqlBaseKey)var5_7;
                            $i$a$-apply-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTableConstraints$1$3 = false;
                            $this$apply.setUnderlyingIndexName(name);
                        }
                    }
                }
                {
                    this.this$0 = mysqlSchemaRetriever;
                    this.$tableCache = nameCache;
                    this.$schema = mysqlBaseSchema;
                    super(1);
                }
            }));
        }

        private final void retrieveTableConstraintColumns(MysqlBaseSchema schema) {
            boolean bl;
            MysqlBaseTable t;
            this.progress("table constraint columns");
            boolean $i$f$cleanupFamilies = false;
            Function1 it2 = MysqlSchemaRetriever$retrieveTableConstraintColumns$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl2 = false;
            ModNamingFamily<? extends MysqlBaseTable> modNamingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.tables");
            Iterable $this$forEach$iv = modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (MysqlBaseTable)element$iv;
                bl = false;
                MysqlBaseTable mysqlBaseTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseTable, (String)"t");
                Family family = mysqlBaseTable.getKeys();
                Intrinsics.checkExpressionValueIsNotNull((Object)family, (String)"t.keys");
                it2.invoke((Object)family);
                Family family2 = t.getForeignKeys();
                Intrinsics.checkExpressionValueIsNotNull((Object)family2, (String)"t.foreignKeys");
                it2.invoke((Object)family2);
            }
            boolean bl3 = false;
            NameCache tableCache = new NameCache();
            NameCache conCache = new NameCache();
            $i$f$forEach = false;
            List conCols = new ArrayList();
            MysqlBaseIntroQueries.INSTANCE.processConstraintColumns(this.getTransaction(), schema, (Function1<? super MysqlBaseIntroQueries.ConstraintColumn, Unit>)((Function1)new Function1<MysqlBaseIntroQueries.ConstraintColumn, Unit>(tableCache, conCache, conCols, this, schema){
                final /* synthetic */ NameCache $tableCache;
                final /* synthetic */ NameCache $conCache;
                final /* synthetic */ List $conCols;
                final /* synthetic */ MysqlSchemaRetriever this$0;
                final /* synthetic */ MysqlBaseSchema $schema$inlined;
                {
                    this.$tableCache = nameCache;
                    this.$conCache = nameCache2;
                    this.$conCols = list;
                    this.this$0 = mysqlSchemaRetriever;
                    this.$schema$inlined = mysqlBaseSchema;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void invoke(@NotNull MysqlBaseIntroQueries.ConstraintColumn c) {
                    Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                    var2_2 = this.$tableCache;
                    name$iv = c.table_name;
                    $i$f$get = false;
                    var5_7 = this_$iv;
                    create$iv$iv = false;
                    $i$f$get = false;
                    if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                    v0 = this_$iv$iv.getV();
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                        v1 = this_$iv$iv.getV();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var8_12 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv){
                            final /* synthetic */ boolean $create;
                            final /* synthetic */ String $name;
                            {
                                this.$create = bl;
                                this.$name = string;
                                super(1);
                            }

                            @Nullable
                            public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                Intrinsics.checkParameterIsNotNull($this$invoke, (String)"$this$invoke");
                                return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                            }
                        };
                        var9_13 = this_$iv$iv;
                        var10_15 = this_$iv$iv;
                        $i$a$-get-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTableConstraintColumns$2$1$table$1 = false;
                        MysqlSchemaRetriever.access$setUpConstraint(this.this$0, (MysqlBaseConstraint)this.$conCache.getV(), this.$conCols);
                        this.$conCache.setV(null);
                        v2 = this.$schema$inlined.getTables();
                        Intrinsics.checkExpressionValueIsNotNull(v2, (String)"schema.tables");
                        var12_17 /* !! */  = (MysqlBaseTable)it.invoke(v2);
                        var10_15.setV((BasicModNamedElement)var12_17 /* !! */ );
                        v1 = this_$iv$iv.getV();
                    }
                    v3 = (MysqlBaseTable)v1;
                    if (v3 == null) {
                        return;
                    }
                    table = v3;
                    isKey = c.referenced_column_name == null;
                    v4 = (MysqlBaseConstraint)this.$conCache.getV();
                    if (isKey != Intrinsics.areEqual((Object)(v4 != null ? v4.getKind() : null), (Object)ObjectKind.KEY)) {
                        MysqlSchemaRetriever.access$setUpConstraint(this.this$0, (MysqlBaseConstraint)this.$conCache.getV(), this.$conCols);
                        this.$conCache.setV(null);
                    }
                    name$iv = this.$conCache;
                    $i$f$get = c.constraint_name;
                    create$iv = true;
                    $i$f$get = false;
                    if (this_$iv.getV() == null) ** GOTO lbl-1000
                    v5 = this_$iv.getV();
                    if (v5 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (Intrinsics.areEqual((Object)v5.getName(), (Object)name$iv)) {
                        v6 = this_$iv.getV();
                    } else lbl-1000:
                    // 2 sources

                    {
                        $i$f$get = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv, (String)name$iv){
                            final /* synthetic */ boolean $create;
                            final /* synthetic */ String $name;
                            {
                                this.$create = bl;
                                this.$name = string;
                                super(1);
                            }

                            @Nullable
                            public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                Intrinsics.checkParameterIsNotNull($this$invoke, (String)"$this$invoke");
                                return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                            }
                        };
                        it = this_$iv;
                        var10_15 = this_$iv;
                        $i$a$-get-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTableConstraintColumns$2$1$1 = false;
                        MysqlSchemaRetriever.access$setUpConstraint(this.this$0, (MysqlBaseConstraint)$this$get.getV(), this.$conCols);
                        if (isKey) {
                            v7 = table.getKeys();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"table.keys");
                            v8 = (MysqlBaseConstraint)it.invoke((Object)v7);
                        } else {
                            v9 = table.getForeignKeys();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"table.foreignKeys");
                            v8 = (MysqlBaseConstraint)it.invoke((Object)v9);
                        }
                        var12_17 /* !! */  = v8;
                        var10_15.setV((BasicModNamedElement)var12_17 /* !! */ );
                        v6 = this_$iv.getV();
                    }
                    this.$conCols.add(c);
                }
            }));
            this.setUpConstraint((MysqlBaseConstraint)conCache.getV(), conCols);
            it = MysqlSchemaRetriever$retrieveTableConstraintColumns$$inlined$cleanupFamilies$2.INSTANCE;
            $i$a$-cleanupFamilies-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTableConstraintColumns$1 = false;
            ModNamingFamily<? extends MysqlBaseTable> modNamingFamily2 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"schema.tables");
            $this$forEach$iv = modNamingFamily2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (MysqlBaseTable)element$iv;
                bl = false;
                MysqlBaseTable mysqlBaseTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseTable, (String)"t");
                Family family = mysqlBaseTable.getKeys();
                Intrinsics.checkExpressionValueIsNotNull((Object)family, (String)"t.keys");
                it.invoke((Object)family);
                Family family3 = t.getForeignKeys();
                Intrinsics.checkExpressionValueIsNotNull((Object)family3, (String)"t.foreignKeys");
                it.invoke((Object)family3);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void setUpConstraint(MysqlBaseConstraint con, List<MysqlBaseIntroQueries.ConstraintColumn> cols2) {
            MysqlBaseConstraint mysqlBaseConstraint = con;
            if (mysqlBaseConstraint instanceof MysqlBaseKey) {
                Collection<String> collection;
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                MysqlBaseConstraint mysqlBaseConstraint2 = con;
                boolean bl = false;
                boolean bl2 = false;
                MysqlBaseKey $this$apply = (MysqlBaseKey)mysqlBaseConstraint2;
                boolean bl3 = false;
                Iterable iterable = cols2;
                MysqlBaseKey mysqlBaseKey = $this$apply;
                boolean $i$f$map = false;
                void var12_21 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it2;
                    MysqlBaseIntroQueries.ConstraintColumn constraintColumn = (MysqlBaseIntroQueries.ConstraintColumn)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    String string = it2.column_name;
                    collection.add(string);
                }
                collection = (List)destination$iv$iv2;
                mysqlBaseKey.setColNames((List<String>)collection);
                if (!$this$apply.isPrimary()) {
                    MysqlBaseTable mysqlBaseTable = $this$apply.getTable();
                    if (mysqlBaseTable == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseTable, (String)"table!!");
                    MysqlBaseIndex index2 = (MysqlBaseIndex)mysqlBaseTable.getIndices().get($this$apply.getName());
                    if (index2 == null || index2.isSyncPending()) {
                        MysqlBaseIndex mysqlBaseIndex = index2;
                        if (mysqlBaseIndex == null) {
                            MysqlBaseTable mysqlBaseTable2 = $this$apply.getTable();
                            if (mysqlBaseTable2 == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseTable2, (String)"table!!");
                            mysqlBaseIndex = (MysqlBaseIndex)mysqlBaseTable2.getIndices().createOrGet($this$apply.getName());
                        }
                        MysqlBaseIndex mysqlBaseIndex2 = mysqlBaseIndex;
                        boolean $this$mapTo$iv$iv2 = false;
                        boolean destination$iv$iv2 = false;
                        MysqlBaseIndex idx = mysqlBaseIndex2;
                        boolean bl5 = false;
                        $this$apply.resetSyncPending();
                        MysqlBaseIndex mysqlBaseIndex3 = idx;
                        Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseIndex3, (String)"idx");
                        mysqlBaseIndex3.setUnique(true);
                        idx.setColNames($this$apply.getColNames());
                    }
                }
            } else if (mysqlBaseConstraint instanceof MysqlBaseForeignKey) {
                String string;
                MysqlBaseIntroQueries.ConstraintColumn it3;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                String string2;
                Object object;
                String it4;
                MysqlBaseForeignKey mysqlBaseForeignKey;
                MysqlBaseConstraint mysqlBaseConstraint3 = con;
                boolean bl = false;
                boolean bl6 = false;
                MysqlBaseForeignKey $this$apply = (MysqlBaseForeignKey)mysqlBaseConstraint3;
                boolean bl7 = false;
                MysqlBaseIntroQueries.ConstraintColumn f = (MysqlBaseIntroQueries.ConstraintColumn)CollectionsKt.firstOrNull(cols2);
                MysqlBaseForeignKey mysqlBaseForeignKey2 = $this$apply;
                MysqlBaseIntroQueries.ConstraintColumn constraintColumn = f;
                String string3 = constraintColumn != null ? constraintColumn.referenced_table_schema : null;
                MysqlBaseSchema mysqlBaseSchema = $this$apply.getSchema();
                if (mysqlBaseSchema == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseSchema, (String)"schema!!");
                String string4 = this.fixCasing(string3, (NamingFamily<?>)mysqlBaseSchema.getParentFamily());
                if (string4 != null) {
                    String string5 = string4;
                    mysqlBaseForeignKey = mysqlBaseForeignKey2;
                    boolean $this$mapTo$iv$iv2 = false;
                    boolean destination$iv$iv2 = false;
                    it4 = string5;
                    boolean bl8 = false;
                    MysqlBaseSchema mysqlBaseSchema2 = $this$apply.getSchema();
                    if (mysqlBaseSchema2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseSchema2, (String)"schema!!");
                    object = Intrinsics.areEqual((Object)it4, (Object)mysqlBaseSchema2.getName()) ^ true ? string5 : null;
                    mysqlBaseForeignKey2 = mysqlBaseForeignKey;
                    string2 = object;
                } else {
                    string2 = null;
                }
                mysqlBaseForeignKey2.setRefSchemaName(string2);
                MysqlBaseIntroQueries.ConstraintColumn constraintColumn2 = f;
                String string6 = constraintColumn2 != null ? constraintColumn2.referenced_table_name : null;
                BasicSchema basicSchema = $this$apply.getRefSchema();
                if (!(basicSchema instanceof MysqlBaseSchema)) {
                    basicSchema = null;
                }
                MysqlBaseSchema mysqlBaseSchema3 = (MysqlBaseSchema)basicSchema;
                $this$apply.setRefTableName(this.fixCasing(string6, (NamingFamily)(mysqlBaseSchema3 != null ? mysqlBaseSchema3.getTables() : null)));
                BasicTableOrView basicTableOrView = $this$apply.getRefTable();
                PositioningNamingFamily<? extends BasicTableOrViewColumn> columns = basicTableOrView != null ? basicTableOrView.getColumns() : null;
                Iterable $this$mapTo$iv$iv2 = cols2;
                mysqlBaseForeignKey = $this$apply;
                boolean $i$f$map = false;
                it4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    MysqlBaseIntroQueries.ConstraintColumn constraintColumn3 = (MysqlBaseIntroQueries.ConstraintColumn)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl9 = false;
                    string = this.fixCasing(it3.referenced_column_name, (NamingFamily)columns);
                    object.add(string);
                }
                object = (List)destination$iv$iv;
                mysqlBaseForeignKey.setRefColNames((List<String>)object);
                $this$map$iv = cols2;
                mysqlBaseForeignKey = $this$apply;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it3 = (MysqlBaseIntroQueries.ConstraintColumn)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl10 = false;
                    string = it3.column_name;
                    object.add(string);
                }
                object = (List)destination$iv$iv;
                mysqlBaseForeignKey.setColNames((List<String>)object);
            }
            cols2.clear();
        }

        /*
         * WARNING - void declaration
         */
        private final String[] fixCasing(String[] names, NamingFamily<?> family) {
            void $this$inplace$iv;
            if (family == null) {
                return names;
            }
            String[] stringArray = names;
            MysqlBaseIntrospector this_$iv = this.this$0;
            boolean $i$f$inplace = false;
            void var6_6 = $this$inplace$iv;
            boolean bl = false;
            boolean bl2 = false;
            void $this$apply$iv = var6_6;
            boolean bl3 = false;
            void $this$forEachIndexed$iv$iv = $this$apply$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$forEachIndexed$iv$iv) {
                void it2;
                String string;
                void s$iv;
                int n = index$iv$iv++;
                void var18_18 = item$iv$iv;
                int i$iv = n;
                boolean bl4 = false;
                void var21_21 = s$iv;
                int n2 = i$iv;
                void var23_23 = $this$apply$iv;
                boolean bl5 = false;
                var23_23[n2] = string = this.fixCasing((String)it2, family);
            }
            return var6_6;
        }

        private final String fixCasing(String name2, NamingFamily<?> family) {
            Object obj2;
            if (family == null || name2 == null) {
                return name2;
            }
            Object obj3 = family.get(name2);
            if (obj3 == null) {
                obj3 = obj2 = family.get(name2, false);
            }
            if (obj3 == null || (obj2 = obj2.getName()) == null) {
                obj2 = name2;
            }
            return obj2;
        }

        /*
         * WARNING - void declaration
         */
        private final String[] splitColNames(String cn) {
            if (cn == null) {
                return new String[0];
            }
            String[] stringArray = StringUtil.splitByLines((String)cn);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"splitByLines(cn)");
            String[] $this$inplace$iv = stringArray;
            MysqlBaseIntrospector this_$iv = this.this$0;
            boolean $i$f$inplace = false;
            String[] stringArray2 = $this$inplace$iv;
            boolean bl = false;
            boolean bl2 = false;
            String[] $this$apply$iv = stringArray2;
            boolean bl3 = false;
            String[] $this$forEachIndexed$iv$iv = $this$apply$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv = 0;
            for (String item$iv$iv : $this$forEachIndexed$iv$iv) {
                String string;
                String string2;
                void ln;
                void s$iv;
                int n = index$iv$iv++;
                String string3 = item$iv$iv;
                int i$iv = n;
                boolean bl4 = false;
                void var20_20 = s$iv;
                int n2 = i$iv;
                String[] stringArray3 = $this$apply$iv;
                boolean bl5 = false;
                if (ln != null) {
                    void var22_22;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    void it2 = var22_22;
                    boolean bl8 = false;
                    String string4 = StringUtil.unescapeStringCharacters((String)it2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"unescapeStringCharacters(it)");
                    string2 = this.this$0.dbIntern(string4);
                } else {
                    string2 = null;
                }
                stringArray3[n2] = string = string2;
            }
            return stringArray2;
        }

        private final void retrieveRoutines(MysqlBaseSchema schema) {
            this.progress("routines");
            boolean $i$f$cleanupFamilies = false;
            Function1 it2 = MysqlSchemaRetriever$retrieveRoutines$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl = false;
            ModNamingFamily<? extends MysqlBaseRoutine> modNamingFamily = schema.getRoutines();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.routines");
            it2.invoke(modNamingFamily);
            boolean bl2 = false;
            MysqlBaseIntroQueries.INSTANCE.processRoutines(this.getTransaction(), schema, (Function1<? super MysqlBaseIntroQueries.Routine, Unit>)((Function1)new Function1<MysqlBaseIntroQueries.Routine, Unit>(this, schema){
                final /* synthetic */ MysqlSchemaRetriever this$0;
                final /* synthetic */ MysqlBaseSchema $schema$inlined;
                {
                    this.this$0 = mysqlSchemaRetriever;
                    this.$schema$inlined = mysqlBaseSchema;
                    super(1);
                }

                public final void invoke(@NotNull MysqlBaseIntroQueries.Routine r) {
                    Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
                    MysqlBaseRoutine mysqlBaseRoutine = this.$schema$inlined.getRoutines().createOrGet(r.routine_name);
                    boolean bl = false;
                    boolean bl2 = false;
                    MysqlBaseRoutine $this$apply = mysqlBaseRoutine;
                    boolean bl3 = false;
                    DasRoutine.Kind type = MysqlBaseIntrospectorKt.access$getType(r.routine_type);
                    $this$apply.setRoutineKind(type);
                    if (type == DasRoutine.Kind.FUNCTION) {
                        BasicModArgument basicModArgument = $this$apply.createOrGetReturnArgument();
                        Intrinsics.checkExpressionValueIsNotNull((Object)basicModArgument, (String)"createOrGetReturnArgument()");
                        BasicModArgument returnArgument2 = basicModArgument;
                        returnArgument2.setDataType(DataTypeFactory.of(r.dtd_identifier));
                    }
                    $this$apply.setComment(StringKt.nullize$default((String)r.routine_comment, (boolean)false, (int)1, null));
                    String string = r.definer;
                    $this$apply.setDefiner(string != null ? MysqlBaseIntrospector.access$dbIntern(this.this$0.this$0, string) : null);
                }
            }));
            it = MysqlSchemaRetriever$retrieveRoutines$$inlined$cleanupFamilies$2.INSTANCE;
            bl = false;
            ModNamingFamily<? extends MysqlBaseRoutine> modNamingFamily2 = schema.getRoutines();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"schema.routines");
            it.invoke(modNamingFamily2);
        }

        private final void retrieveRoutineParameters(MysqlBaseSchema schema) {
            boolean bl;
            this.progress("routine parameters");
            boolean $i$f$cleanupFamilies = false;
            Function1 it2 = MysqlSchemaRetriever$retrieveRoutineParameters$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl2 = false;
            ModNamingFamily<? extends MysqlBaseRoutine> modNamingFamily = schema.getRoutines();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.routines");
            Iterable $this$forEach$iv = modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MysqlBaseRoutine r = (MysqlBaseRoutine)element$iv;
                bl = false;
                MysqlBaseRoutine mysqlBaseRoutine = r;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseRoutine, (String)"r");
                PositioningNamingFamily positioningNamingFamily = mysqlBaseRoutine.getArguments();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"r.arguments");
                it2.invoke((Object)positioningNamingFamily);
            }
            boolean bl3 = false;
            ModNamingFamily<? extends MysqlBaseRoutine> modNamingFamily2 = schema.getRoutines();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"schema.routines");
            Iterable $this$forEach$iv2 = modNamingFamily2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                MysqlBaseRoutine it3 = (MysqlBaseRoutine)element$iv;
                boolean bl4 = false;
                MysqlBaseRoutine mysqlBaseRoutine = it3;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseRoutine, (String)"it");
                if (mysqlBaseRoutine.getRoutineKind() != DasRoutine.Kind.FUNCTION) continue;
                it3.createOrGetReturnArgument();
            }
            this.retrieveRoutineParametersFromInformationSchema(schema);
            it = MysqlSchemaRetriever$retrieveRoutineParameters$$inlined$cleanupFamilies$2.INSTANCE;
            $i$a$-cleanupFamilies-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveRoutineParameters$1 = false;
            ModNamingFamily<? extends MysqlBaseRoutine> modNamingFamily3 = schema.getRoutines();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily3, (String)"schema.routines");
            $this$forEach$iv = modNamingFamily3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MysqlBaseRoutine r = (MysqlBaseRoutine)element$iv;
                bl = false;
                MysqlBaseRoutine mysqlBaseRoutine = r;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseRoutine, (String)"r");
                PositioningNamingFamily positioningNamingFamily = mysqlBaseRoutine.getArguments();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"r.arguments");
                it.invoke((Object)positioningNamingFamily);
            }
        }

        private final void retrieveRoutineParametersFromInformationSchema(MysqlBaseSchema schema) {
            NameCache routineCache = new NameCache();
            MysqlBaseIntroQueries.INSTANCE.processRoutineParams(this.getTransaction(), schema, (Function1<? super MysqlBaseIntroQueries.Parameter, Unit>)((Function1)new Function1<MysqlBaseIntroQueries.Parameter, Unit>(routineCache, schema){
                final /* synthetic */ NameCache $routineCache;
                final /* synthetic */ MysqlBaseSchema $schema;

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void invoke(@NotNull MysqlBaseIntroQueries.Parameter p) {
                    Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
                    var3_2 /* !! */  = this.$routineCache;
                    name$iv = p.specific_name;
                    $i$f$get = false;
                    var6_6 = this_$iv;
                    create$iv$iv = false;
                    $i$f$get = false;
                    if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                    v0 = this_$iv$iv.getV();
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                        v1 = this_$iv$iv.getV();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var9_9 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                            final /* synthetic */ boolean $create;
                            final /* synthetic */ String $name;
                            {
                                this.$create = bl;
                                this.$name = string;
                                super(1);
                            }

                            @Nullable
                            public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                Intrinsics.checkParameterIsNotNull($this$invoke, (String)"$this$invoke");
                                return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                            }
                        };
                        var10_10 = this_$iv$iv;
                        var12_11 = this_$iv$iv;
                        $i$a$-get-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveRoutineParametersFromInformationSchema$1$routine$1 = false;
                        v2 = this.$schema.getRoutines();
                        Intrinsics.checkExpressionValueIsNotNull(v2, (String)"schema.routines");
                        var13_13 = (MysqlBaseRoutine)it.invoke(v2);
                        var12_11.setV((BasicModNamedElement)var13_13);
                        v1 = this_$iv$iv.getV();
                    }
                    v3 = (MysqlBaseRoutine)v1;
                    if (v3 == null) {
                        return;
                    }
                    routine = v3;
                    var3_2 /* !! */  = routine.getArguments().renewAt(p.ordinal_position, p.parameter_name);
                    var4_4 = false;
                    var5_5 = false;
                    $this$apply = (MysqlBaseArgument)var3_2 /* !! */ ;
                    $i$a$-apply-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveRoutineParametersFromInformationSchema$1$1 = false;
                    $this$apply.setDataType(DataTypeFactory.of(p.dtd_identifier));
                    $this$apply.setArgumentDirection(MysqlBaseIntrospectorKt.access$getDirection(p.parameter_mode));
                }
                {
                    this.$routineCache = nameCache;
                    this.$schema = mysqlBaseSchema;
                    super(1);
                }
            }));
        }

        private final void retrieveInfoFromTableSrc(MysqlBaseSchema schema) {
            Iterator iterator = schema.getTables().iterator();
            while (iterator.hasNext()) {
                MysqlBaseTable table;
                MysqlBaseTable mysqlBaseTable = table = (MysqlBaseTable)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseTable, (String)"table");
                if (!this.shouldRetrieveTableSrc(mysqlBaseTable)) continue;
                String string = MysqlBaseIntroQueries.INSTANCE.retrieveOneTableSource(this.getTransaction(), table);
                if (string == null) continue;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it2 = string2;
                boolean bl3 = false;
                string = this.getCreate(this.replaceBin(it2));
                if (string == null) {
                    continue;
                }
                String sql = string;
                this.retrieveInfoFromTableSrc(table, (SqlCreateStatement)sql);
            }
        }

        protected void retrieveInfoFromTableSrc(@NotNull MysqlBaseTable table, @NotNull SqlCreateStatement sql) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
            if (this.this$0.getGenFromSrc()) {
                this.retrieveColumnGenExprFromTableSrc(table, sql);
            }
        }

        protected boolean shouldRetrieveTableSrc(@NotNull MysqlBaseTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            return this.this$0.getGenFromSrc() && table.getColumns().find(shouldRetrieveTableSrc.1.INSTANCE) != null;
        }

        protected boolean shouldRetrieveTableSrc() {
            return this.this$0.getGenFromSrc();
        }

        private final void retrieveColumnGenExprFromTableSrc(MysqlBaseTable table, SqlCreateStatement sql) {
            for (SqlColumnDefinition c2 : sql.getDasChildren(ObjectKind.COLUMN).filter(SqlColumnDefinition.class)) {
                MysqlBaseTableColumn target2;
                if ((MysqlBaseTableColumn)table.getColumns().find((Predicate)new Predicate<MysqlBaseTableColumn>(c2){
                    final /* synthetic */ SqlColumnDefinition $c;

                    public final boolean test(MysqlBaseTableColumn it2) {
                        MysqlBaseTableColumn mysqlBaseTableColumn = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseTableColumn, (String)"it");
                        String string = mysqlBaseTableColumn.getName();
                        SqlColumnDefinition sqlColumnDefinition = this.$c;
                        Intrinsics.checkExpressionValueIsNotNull((Object)sqlColumnDefinition, (String)"c");
                        return StringsKt.equals((String)string, (String)sqlColumnDefinition.getName(), (boolean)true);
                    }
                    {
                        this.$c = sqlColumnDefinition;
                    }
                }) == null) {
                    continue;
                }
                this.this$0.getSqlHelper().getBuilder().partialBuild((DasObject)target2, (DasObject)c2);
            }
        }

        private final void retrieveColumns(MysqlBaseSchema schema) {
            boolean bl;
            MysqlBaseView v2;
            boolean bl2;
            MysqlBaseTable t;
            this.progress("table columns");
            NameCache tableCache = new NameCache();
            ModNamingFamily<? extends MysqlBaseTable> modNamingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.tables");
            ModNamingFamily<? extends MysqlBaseTable> tables = modNamingFamily;
            ModNamingFamily<? extends MysqlBaseView> modNamingFamily2 = schema.getViews();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"schema.views");
            ModNamingFamily<? extends MysqlBaseView> views = modNamingFamily2;
            boolean $i$f$cleanupFamilies = false;
            Function1 it2 = MysqlSchemaRetriever$retrieveColumns$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl3 = false;
            Iterable $this$forEach$iv = tables;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (MysqlBaseTable)element$iv;
                bl2 = false;
                MysqlBaseTable mysqlBaseTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseTable, (String)"t");
                PositioningNamingFamily positioningNamingFamily = mysqlBaseTable.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"t.columns");
                it2.invoke((Object)positioningNamingFamily);
            }
            $this$forEach$iv = views;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                v2 = (MysqlBaseView)element$iv;
                bl = false;
                MysqlBaseView mysqlBaseView = v2;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseView, (String)"v");
                PositioningNamingFamily positioningNamingFamily = mysqlBaseView.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"v.columns");
                it2.invoke((Object)positioningNamingFamily);
            }
            boolean bl4 = false;
            MysqlBaseIntroQueries.INSTANCE.processColumns(this.getTransaction(), schema, (Function1<? super MysqlBaseIntroQueries.Column, Unit>)((Function1)new Function1<MysqlBaseIntroQueries.Column, Unit>(this, schema, tableCache, tables, views){
                final /* synthetic */ MysqlSchemaRetriever this$0;
                final /* synthetic */ MysqlBaseSchema $schema$inlined;
                final /* synthetic */ NameCache $tableCache$inlined;
                final /* synthetic */ ModNamingFamily $tables$inlined;
                final /* synthetic */ ModNamingFamily $views$inlined;
                {
                    this.this$0 = mysqlSchemaRetriever;
                    this.$schema$inlined = mysqlBaseSchema;
                    this.$tableCache$inlined = nameCache;
                    this.$tables$inlined = modNamingFamily;
                    this.$views$inlined = modNamingFamily2;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull MysqlBaseIntroQueries.Column c) {
                    block4: {
                        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                        var2_2 = this.$tableCache$inlined;
                        name$iv = c.table_name;
                        $i$f$get = false;
                        var5_6 = this_$iv;
                        create$iv$iv = false;
                        $i$f$get = false;
                        if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                        v0 = this_$iv$iv.getV();
                        if (v0 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                            v1 = this_$iv$iv.getV();
                        } else lbl-1000:
                        // 2 sources

                        {
                            var8_9 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                                final /* synthetic */ boolean $create;
                                final /* synthetic */ String $name;
                                {
                                    this.$create = bl;
                                    this.$name = string;
                                    super(1);
                                }

                                @Nullable
                                public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                    Intrinsics.checkParameterIsNotNull($this$invoke, (String)"$this$invoke");
                                    return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                                }
                            };
                            var9_10 = this_$iv$iv;
                            var10_11 = this_$iv$iv;
                            $i$a$-get-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveColumns$2$1$1 = false;
                            v2 = (MysqlBaseLikeTable)it.invoke((Object)this.$tables$inlined);
                            if (v2 == null) {
                                v2 = (MysqlBaseLikeTable)it.invoke((Object)this.$views$inlined);
                            }
                            var12_13 = v2;
                            var10_11.setV((BasicModNamedElement)var12_13);
                            v1 = this_$iv$iv.getV();
                        }
                        v3 = (MysqlBaseLikeTable)v1;
                        if (v3 == null) break block4;
                        var2_2 = v3;
                        var3_4 = false;
                        var4_5 = false;
                        table = var2_2;
                        $i$a$-let-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveColumns$2$1$2 = false;
                        this.this$0.applyColumn((MysqlBaseLikeTable)table, c);
                    }
                }
            }));
            it = MysqlSchemaRetriever$retrieveColumns$$inlined$cleanupFamilies$2.INSTANCE;
            bl3 = false;
            $this$forEach$iv = tables;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (MysqlBaseTable)element$iv;
                bl2 = false;
                MysqlBaseTable mysqlBaseTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseTable, (String)"t");
                PositioningNamingFamily positioningNamingFamily = mysqlBaseTable.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"t.columns");
                it.invoke((Object)positioningNamingFamily);
            }
            $this$forEach$iv = views;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                v2 = (MysqlBaseView)element$iv;
                bl = false;
                MysqlBaseView mysqlBaseView = v2;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseView, (String)"v");
                PositioningNamingFamily positioningNamingFamily = mysqlBaseView.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"v.columns");
                it.invoke((Object)positioningNamingFamily);
            }
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        protected MysqlBaseLikeColumn applyColumn(@NotNull MysqlBaseLikeTable table, @NotNull MysqlBaseIntroQueries.Column c) {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                var3_3 = table.getColumns().renewAt(c.ordinal_position, c.column_name);
                var4_4 = false;
                var5_5 = false;
                $this$apply = (MysqlBaseLikeColumn)var3_3;
                $i$a$-apply-MysqlBaseIntrospector$MysqlSchemaRetriever$applyColumn$1 = false;
                $this$apply.setNotNull(Intrinsics.areEqual((Object)c.is_nullable, (Object)"YES") ^ true);
                $this$apply.setDataType(DataTypeFactory.of(c.column_type));
                $this$apply.setComment(StringKt.nullize$default((String)c.column_comment, (boolean)false, (int)1, null));
                if (!($this$apply instanceof MysqlBaseTableColumn)) break block6;
                ((MysqlBaseTableColumn)$this$apply).setColumnKind(this.getColumnKind(c.extra));
                v0 = this.getOnUpdate(c.extra);
                ((MysqlBaseTableColumn)$this$apply).setOnUpdate(v0 != null ? MysqlBaseIntrospector.access$dbIntern(this.this$0, v0) : null);
                v1 = ((MysqlBaseTableColumn)$this$apply).getParent();
                if (v1 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"parent!!");
                v2 = v1.getCollation();
                if (v2 == null) {
                    v3 = ((MysqlBaseTableColumn)$this$apply).getParent();
                    if (v3 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"parent!!");
                    v4 = v3.getSchema();
                    if (v4 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"parent!!.schema!!");
                    v2 = v4.getCollation();
                }
                defaultCollation = v2;
                v5 = (MysqlBaseTableColumn)$this$apply;
                v6 = c.collation_name;
                if (v6 == null) ** GOTO lbl-1000
                var9_9 = v6;
                var10_10 = v5;
                var11_11 = false;
                var12_12 = false;
                it = var9_9;
                $i$a$-takeIf-MysqlBaseIntrospector$MysqlSchemaRetriever$applyColumn$1$1 = false;
                var15_15 = (Intrinsics.areEqual((Object)it, (Object)defaultCollation) ^ true) != false ? var9_9 : null;
                v5 = var10_10;
                v6 = var15_15;
                if (v6 != null) {
                    v7 = MysqlBaseIntrospector.access$dbIntern(this.this$0, v6);
                } else lbl-1000:
                // 2 sources

                {
                    v7 = null;
                }
                v5.setCollation(v7);
                ((MysqlBaseTableColumn)$this$apply).setDefaultExpression(this.getDefaultExpression($this$apply, c));
                ((MysqlBaseTableColumn)$this$apply).setSequenceIdentity(this.getSequenceIdentity(c, $this$apply));
            }
            v8 = var3_3;
            Intrinsics.checkExpressionValueIsNotNull(v8, (String)"table.columns.renewAt(c.\u2026, this)\n        }\n      }");
            return (MysqlBaseLikeColumn)v8;
        }

        private final String getOnUpdate(String extra) {
            if (extra == null) {
                return null;
            }
            Matcher matcher = MysqlBaseIntrospectorKt.access$getON_UPDATE$p().matcher(extra);
            if (!matcher.find()) {
                return null;
            }
            return matcher.group(1);
        }

        private final MysqlColumnKind getColumnKind(String extra) {
            if (extra == null) {
                return MysqlColumnKind.NORMAL;
            }
            if (StringsKt.contains$default((CharSequence)extra, (CharSequence)"VIRTUAL GENERATED", (boolean)false, (int)2, null)) {
                return MysqlColumnKind.GENERATED_VIRTUAL;
            }
            if (StringsKt.contains$default((CharSequence)extra, (CharSequence)"STORED GENERATED", (boolean)false, (int)2, null)) {
                return MysqlColumnKind.GENERATED_STORED;
            }
            if (StringsKt.contains$default((CharSequence)extra, (CharSequence)"VIRTUAL", (boolean)false, (int)2, null)) {
                return MysqlColumnKind.GENERATED_VIRTUAL;
            }
            return MysqlColumnKind.NORMAL;
        }

        private final SequenceIdentity getSequenceIdentity(MysqlBaseIntroQueries.Column c2, MysqlBaseLikeColumn column2) {
            if (StringsKt.equals((String)c2.extra, (String)"auto_increment", (boolean)true) && column2 instanceof MysqlBaseTableColumn) {
                return SequenceIdentity.UNKNOWN;
            }
            return null;
        }

        private final String getDefaultExpression(MysqlBaseLikeColumn column2, MysqlBaseIntroQueries.Column c2) {
            String gen;
            String string = c2.generation_expression;
            String string2 = gen = string != null ? this.replaceBin(string) : null;
            if (StringUtil.isNotEmpty((String)gen)) {
                String string3;
                if (this.this$0.getUnescapeGenExpr()) {
                    String string4 = gen;
                    if (string4 == null) {
                        Intrinsics.throwNpe();
                    }
                    string3 = this.unescape(string4);
                } else {
                    string3 = gen;
                }
                return string3;
            }
            String def = c2.column_default;
            if (this.this$0.getDefProperlyQuoted() || def == null) {
                if (Intrinsics.areEqual((Object)def, (Object)"NULL")) {
                    return null;
                }
                String string5 = def;
                return string5 != null ? this.replaceBin(string5) : null;
            }
            if (!(column2 instanceof MysqlBaseTableColumn)) {
                return null;
            }
            String string6 = ((MysqlBaseTableColumn)column2).getDataType().typeName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"column.dataType.typeName");
            String typeName = string6;
            boolean isInt = StringsKt.endsWith$default((String)typeName, (String)"int", (boolean)false, (int)2, null);
            boolean noQuote = isInt || ((MysqlBaseTableColumn)column2).isComputed() || Intrinsics.areEqual((Object)typeName, (Object)"bit") || Intrinsics.areEqual((Object)typeName, (Object)"double") || Intrinsics.areEqual((Object)typeName, (Object)"float") || Intrinsics.areEqual((Object)typeName, (Object)"decimal") || StringsKt.endsWith$default((String)typeName, (String)"binary", (boolean)false, (int)2, null) || StringUtil.startsWithIgnoreCase((String)def, (String)"CURRENT_TIMESTAMP") && (StringsKt.startsWith$default((String)typeName, (String)"datetime", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)typeName, (String)"timestamp", (boolean)false, (int)2, null));
            return isInt ? this.trimLeadingZeroes(def) : (!noQuote ? this.this$0.quote(def) : def);
        }

        private final String trimLeadingZeroes(String def) {
            String string;
            Matcher matcher = MysqlBaseIntrospectorKt.access$getTRIM_ZEROES$p().matcher(def);
            boolean bl = false;
            boolean bl2 = false;
            Matcher it2 = matcher;
            boolean bl3 = false;
            if (it2.matches()) {
                String string2 = it2.group(1);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.group(1)");
            } else {
                string = def;
            }
            return string;
        }

        private final String replaceBin(@NotNull String $this$replaceBin) {
            String string = StringUtil.replace((String)$this$replaceBin, (List)CollectionsKt.listOf((Object[])new String[]{"\b", "\u001a", "\u0000"}), (List)CollectionsKt.listOf((Object[])new String[]{"\\b", "\\Z", "\\0"}));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"replace(\n        this,\n \u2026tOf(\"\\\\b\", \"\\\\Z\", \"\\\\0\"))");
            return string;
        }

        private final String unescape(String str) {
            StringBuilder buf = new StringBuilder();
            int last = str.length() - 1;
            for (int i2 = 0; i2 <= last; ++i2) {
                char ch = str.charAt(i2);
                if (ch == '\\' && i2 != last && (ch = str.charAt(++i2)) != '\'' && ch != '\\') {
                    buf.append('\\');
                }
                buf.append(ch);
            }
            String string = buf.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buf.toString()");
            return string;
        }

        private final void retrieveViewSources(MysqlBaseSchema schema) {
            this.progress("view sources");
            MysqlBaseIntroQueries.INSTANCE.processViews(this.getTransaction(), schema, (Function1<? super MysqlBaseIntroQueries.View, Unit>)((Function1)new Function1<MysqlBaseIntroQueries.View, Unit>(this, schema){
                final /* synthetic */ MysqlSchemaRetriever this$0;
                final /* synthetic */ MysqlBaseSchema $schema;

                public final void invoke(@NotNull MysqlBaseIntroQueries.View t) {
                    block0: {
                        String viewText;
                        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                        MysqlBaseView mysqlBaseView = (MysqlBaseView)this.$schema.getViews().get(t.table_name);
                        if (mysqlBaseView == null) break block0;
                        MysqlBaseView mysqlBaseView2 = mysqlBaseView;
                        boolean bl = false;
                        boolean bl2 = false;
                        MysqlBaseView $this$apply = mysqlBaseView2;
                        boolean bl3 = false;
                        String string = viewText = StringKt.nullize((String)t.view_definition, (boolean)true);
                        $this$apply.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.DECOMPILED_TEXT) : null);
                        String string2 = t.definer;
                        $this$apply.setDefiner(string2 != null ? MysqlBaseIntrospector.access$dbIntern(this.this$0.this$0, string2) : null);
                    }
                }
                {
                    this.this$0 = mysqlSchemaRetriever;
                    this.$schema = mysqlBaseSchema;
                    super(1);
                }
            }));
        }

        private final void retrieveRoutineSources(MysqlBaseSchema schema) {
            block3: {
                block2: {
                    this.progress("routine sources");
                    if (this.this$0.getParametersTableExists()) break block2;
                    ModNamingFamily<? extends MysqlBaseRoutine> modNamingFamily = schema.getRoutines();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.routines");
                    Iterable $this$forEach$iv = modNamingFamily;
                    boolean $i$f$forEach22 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        MysqlBaseRoutine it2 = (MysqlBaseRoutine)element$iv;
                        boolean bl = false;
                        MysqlBaseRoutine mysqlBaseRoutine = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseRoutine, (String)"it");
                        this.retrieveBuggedRoutineSources(mysqlBaseRoutine);
                    }
                    break block3;
                }
                boolean $i$f$forEach22 = false;
                List bugged = new ArrayList();
                MysqlBaseIntroQueries.INSTANCE.processRoutineSources(this.getTransaction(), schema, (Function1<? super MysqlBaseIntroQueries.Routine, Unit>)((Function1)new Function1<MysqlBaseIntroQueries.Routine, Unit>(this, schema, bugged){
                    final /* synthetic */ MysqlSchemaRetriever this$0;
                    final /* synthetic */ MysqlBaseSchema $schema;
                    final /* synthetic */ List $bugged;

                    public final void invoke(@NotNull MysqlBaseIntroQueries.Routine r) {
                        block0: {
                            Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
                            MysqlBaseRoutine mysqlBaseRoutine = (MysqlBaseRoutine)this.$schema.getRoutines().get(r.routine_name);
                            if (mysqlBaseRoutine == null) break block0;
                            MysqlBaseRoutine mysqlBaseRoutine2 = mysqlBaseRoutine;
                            boolean bl = false;
                            boolean bl2 = false;
                            MysqlBaseRoutine $this$apply = mysqlBaseRoutine2;
                            boolean bl3 = false;
                            String routineText = StringKt.nullize((String)r.routine_definition, (boolean)true);
                            MysqlSchemaRetriever.access$setSourceOrMarkBugged(this.this$0, $this$apply, routineText, this.$bugged);
                        }
                    }
                    {
                        this.this$0 = mysqlSchemaRetriever;
                        this.$schema = mysqlBaseSchema;
                        this.$bugged = list;
                        super(1);
                    }
                }));
                Collection $i$f$forEach22 = bugged;
                boolean bl = false;
                if (!(!$i$f$forEach22.isEmpty())) break block3;
                this.progress("routine sources (circumventing MySQL bugs)");
                Iterable $this$forEach$iv = bugged;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MysqlBaseRoutine it3 = (MysqlBaseRoutine)element$iv;
                    boolean bl2 = false;
                    this.retrieveBuggedRoutineSources(it3);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private final <T extends BasicModSourceAware> void setSourceOrMarkBugged(@NotNull T $this$setSourceOrMarkBugged, String text2, List<T> bugged) {
            if (this.this$0.circumventDbe5060 && text2 != null) {
                CharSequence charSequence = text2;
                Regex regex = this.BUG;
                boolean bl = false;
                if (regex.containsMatchIn(charSequence)) {
                    bugged.add($this$setSourceOrMarkBugged);
                    return;
                }
            }
            String string = text2;
            $this$setSourceOrMarkBugged.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT) : null);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutineParametersFromSource(MysqlBaseRoutine routine, String src) {
            Object object;
            SqlCreateProcedureStatement sqlCreateProcedureStatement;
            String string = src;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it2 = string2;
                boolean bl3 = false;
                SqlCreateStatement sqlCreateStatement = this.getCreate(it2);
                if (!(sqlCreateStatement instanceof SqlCreateProcedureStatement)) {
                    sqlCreateStatement = null;
                }
                sqlCreateProcedureStatement = (SqlCreateProcedureStatement)sqlCreateStatement;
            } else {
                sqlCreateProcedureStatement = null;
            }
            SqlCreateProcedureStatement stmt = sqlCreateProcedureStatement;
            boolean $i$f$cleanupFamilies = false;
            Function1 it3 = MysqlSchemaRetriever$retrieveRoutineParametersFromSource$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl = false;
            PositioningNamingFamily positioningNamingFamily = routine.getArguments();
            Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"routine.arguments");
            it3.invoke((Object)positioningNamingFamily);
            boolean bl4 = false;
            if (routine.getRoutineKind() == DasRoutine.Kind.FUNCTION) {
                routine.createOrGetReturnArgument();
            }
            if ((object = stmt) != null && (object = object.getArguments()) != null) {
                Object $this$forEachIndexed$iv = object;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                Iterator iterator = $this$forEachIndexed$iv.iterator();
                while (iterator.hasNext()) {
                    void a;
                    Object item$iv = iterator.next();
                    int n = index$iv++;
                    boolean bl5 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n2 = n;
                    DasArgument dasArgument = (DasArgument)item$iv;
                    int i2 = n2;
                    boolean bl6 = false;
                    SqlObjectBuilder sqlObjectBuilder = this.this$0.getSqlHelper().getBuilder();
                    PositioningNamingFamily positioningNamingFamily2 = routine.getArguments();
                    short s = (short)(i2 + 1);
                    void v8 = a;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"a");
                    sqlObjectBuilder.partialBuild((DasObject)positioningNamingFamily2.renewAt(s, v8.getName()), (DasObject)a);
                }
            }
            it = MysqlSchemaRetriever$retrieveRoutineParametersFromSource$$inlined$cleanupFamilies$2.INSTANCE;
            $i$a$-cleanupFamilies-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveRoutineParametersFromSource$1 = false;
            PositioningNamingFamily positioningNamingFamily3 = routine.getArguments();
            Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily3, (String)"routine.arguments");
            it.invoke((Object)positioningNamingFamily3);
        }

        private final void retrieveTriggerSources(MysqlBaseSchema schema) {
            this.progress("trigger sources");
            boolean bl = false;
            List bugged = new ArrayList();
            NameCache tableCache = new NameCache();
            MysqlBaseIntroQueries.INSTANCE.processTriggerSources(this.getTransaction(), schema, (Function1<? super MysqlBaseIntroQueries.Trigger, Unit>)((Function1)new Function1<MysqlBaseIntroQueries.Trigger, Unit>(this, tableCache, schema, bugged){
                final /* synthetic */ MysqlSchemaRetriever this$0;
                final /* synthetic */ NameCache $tableCache;
                final /* synthetic */ MysqlBaseSchema $schema;
                final /* synthetic */ List $bugged;

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull MysqlBaseIntroQueries.Trigger t) {
                    block4: {
                        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                        var3_2 = this.$tableCache;
                        name$iv = t.event_object_table;
                        $i$f$get = false;
                        var6_6 = this_$iv;
                        create$iv$iv = false;
                        $i$f$get = false;
                        if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                        v0 = this_$iv$iv.getV();
                        if (v0 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                            v1 = this_$iv$iv.getV();
                        } else lbl-1000:
                        // 2 sources

                        {
                            var9_10 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                                final /* synthetic */ boolean $create;
                                final /* synthetic */ String $name;
                                {
                                    this.$create = bl;
                                    this.$name = string;
                                    super(1);
                                }

                                @Nullable
                                public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                    Intrinsics.checkParameterIsNotNull($this$invoke, (String)"$this$invoke");
                                    return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                                }
                            };
                            var10_11 = this_$iv$iv;
                            var12_12 = this_$iv$iv;
                            $i$a$-get-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTriggerSources$1$table$1 = false;
                            v2 = this.$schema.getTables();
                            Intrinsics.checkExpressionValueIsNotNull(v2, (String)"schema.tables");
                            var13_14 = (MysqlBaseTable)it.invoke(v2);
                            var12_12.setV((BasicModNamedElement)var13_14);
                            v1 = this_$iv$iv.getV();
                        }
                        v3 = (MysqlBaseTable)v1;
                        if (v3 == null) {
                            return;
                        }
                        table = v3;
                        v4 = (MysqlBaseTrigger)table.getTriggers().get(t.trigger_name);
                        if (v4 == null) break block4;
                        var3_2 = v4;
                        var4_4 = false;
                        var5_5 = false;
                        $this$apply = var3_2;
                        $i$a$-apply-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTriggerSources$1$1 = false;
                        triggerText = StringKt.nullize((String)t.action_statement, (boolean)true);
                        MysqlSchemaRetriever.access$setSourceOrMarkBugged(this.this$0, (BasicModSourceAware)$this$apply, triggerText, this.$bugged);
                    }
                }
                {
                    this.this$0 = mysqlSchemaRetriever;
                    this.$tableCache = nameCache;
                    this.$schema = mysqlBaseSchema;
                    this.$bugged = list;
                    super(1);
                }
            }));
            Collection collection = bugged;
            boolean bl2 = false;
            if (!collection.isEmpty()) {
                this.progress("trigger sources (circumventing MySQL bugs)");
                Iterable $this$forEach$iv = bugged;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MysqlBaseTrigger it2 = (MysqlBaseTrigger)element$iv;
                    boolean bl3 = false;
                    this.retrieveBuggedTriggerSources(it2);
                }
            }
        }

        private final void retrieveEventSources(MysqlBaseSchema schema) {
            this.progress("event sources");
            boolean bl = false;
            List bugged = new ArrayList();
            MysqlBaseIntroQueries.INSTANCE.processEventSources(this.getTransaction(), schema, (Function1<? super MysqlBaseIntroQueries.Event, Unit>)((Function1)new Function1<MysqlBaseIntroQueries.Event, Unit>(this, schema, bugged){
                final /* synthetic */ MysqlSchemaRetriever this$0;
                final /* synthetic */ MysqlBaseSchema $schema;
                final /* synthetic */ List $bugged;

                public final void invoke(@NotNull MysqlBaseIntroQueries.Event e) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        MysqlBaseEvent mysqlBaseEvent = (MysqlBaseEvent)this.$schema.getEvents().get(e.event_name);
                        if (mysqlBaseEvent == null) break block0;
                        MysqlBaseEvent mysqlBaseEvent2 = mysqlBaseEvent;
                        boolean bl = false;
                        boolean bl2 = false;
                        MysqlBaseEvent $this$apply = mysqlBaseEvent2;
                        boolean bl3 = false;
                        String eventText = StringKt.nullize((String)e.event_definition, (boolean)true);
                        MysqlSchemaRetriever.access$setSourceOrMarkBugged(this.this$0, $this$apply, eventText, this.$bugged);
                    }
                }
                {
                    this.this$0 = mysqlSchemaRetriever;
                    this.$schema = mysqlBaseSchema;
                    this.$bugged = list;
                    super(1);
                }
            }));
            Collection collection = bugged;
            boolean bl2 = false;
            if (!collection.isEmpty()) {
                this.progress("event sources (circumventing MySQL bugs)");
                Iterable $this$forEach$iv = bugged;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MysqlBaseEvent it2 = (MysqlBaseEvent)element$iv;
                    boolean bl3 = false;
                    this.retrieveBuggedEventSources(it2);
                }
            }
        }

        private final void retrieveBuggedRoutineSources(MysqlBaseRoutine routine) {
            String src;
            String string;
            String stmt;
            String string2 = stmt = MysqlBaseIntroQueries.INSTANCE.retrieveOneRoutineSource(this.getTransaction(), routine);
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it2 = string3;
                boolean bl3 = false;
                string = this.getBody(it2);
            } else {
                string = src = null;
            }
            if (!this.this$0.getParametersTableExists()) {
                this.retrieveRoutineParametersFromSource(routine, stmt);
            }
            String string4 = src;
            routine.setSourceText(string4 != null ? BaseIntrospectionFunctions.toCompositeText(string4, CompositeText.Kind.ORIGINAL_TEXT) : null);
        }

        private final void retrieveBuggedTriggerSources(MysqlBaseTrigger trigger) {
            String src;
            String string;
            String string2 = MysqlBaseIntroQueries.INSTANCE.retrieveOneTriggerSource(this.getTransaction(), trigger);
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it2 = string3;
                boolean bl3 = false;
                string = this.getBody(it2);
            } else {
                string = null;
            }
            String string4 = src = string;
            trigger.setSourceText(string4 != null ? BaseIntrospectionFunctions.toCompositeText(string4, CompositeText.Kind.ORIGINAL_TEXT) : null);
        }

        private final void retrieveBuggedEventSources(MysqlBaseEvent event) {
            String src;
            String string;
            String string2 = MysqlBaseIntroQueries.INSTANCE.retrieveOneEventSource(this.getTransaction(), event);
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it2 = string3;
                boolean bl3 = false;
                string = this.getBody(it2);
            } else {
                string = null;
            }
            String string4 = src = string;
            event.setSourceText(string4 != null ? BaseIntrospectionFunctions.toCompositeText(string4, CompositeText.Kind.ORIGINAL_TEXT) : null);
        }

        private final String getBody(String src) {
            SqlCreateStatement sqlCreateStatement = this.getCreate(src);
            if (sqlCreateStatement == null) {
                return null;
            }
            SqlCreateStatement createStatement = sqlCreateStatement;
            SqlStatement body2 = (SqlStatement)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)createStatement), SqlStatement.class);
            if (body2 == null) {
                this.this$0.getLog().warn("No body found in\n" + src);
                return null;
            }
            return body2.getText();
        }

        private final SqlCreateStatement getCreate(String src) {
            try {
                IntrospectorSqlHelper this_$iv = this.this$0.getSqlHelper();
                boolean $i$f$statements = false;
                SqlCreateStatement createStatement = (SqlCreateStatement)this_$iv.statements(src, SqlCreateStatement.class).first();
                if (createStatement == null) {
                    this.this$0.getLog().warn("No create found in\n" + src);
                    return null;
                }
                return createStatement;
            }
            catch (RuntimeException e) {
                this.this$0.getLog().warn("Failed to parse sources", (Throwable)e);
                return null;
            }
        }

        private final String scriptName(BasicNamedElement o) {
            String string = o.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"o.name");
            return MysqlBaseNamingService.INSTANCE.nameToScript(string, o.isNameScripted() && !o.isNameQuoted());
        }

        private final void retrieveTriggers(MysqlBaseSchema schema) {
            boolean bl;
            MysqlBaseTable t;
            this.progress("triggers");
            boolean $i$f$cleanupFamilies = false;
            Function1 it2 = MysqlSchemaRetriever$retrieveTriggers$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl2 = false;
            ModNamingFamily<? extends MysqlBaseTable> modNamingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.tables");
            Iterable $this$forEach$iv = modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (MysqlBaseTable)element$iv;
                bl = false;
                MysqlBaseTable mysqlBaseTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseTable, (String)"t");
                ModNamingFamily<? extends MysqlBaseTrigger> modNamingFamily2 = mysqlBaseTable.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"t.triggers");
                it2.invoke(modNamingFamily2);
            }
            boolean bl3 = false;
            NameCache tableCache = new NameCache();
            MysqlBaseIntroQueries.INSTANCE.processTriggers(this.getTransaction(), schema, (Function1<? super MysqlBaseIntroQueries.Trigger, Unit>)((Function1)new Function1<MysqlBaseIntroQueries.Trigger, Unit>(tableCache, this, schema){
                final /* synthetic */ NameCache $tableCache;
                final /* synthetic */ MysqlSchemaRetriever this$0;
                final /* synthetic */ MysqlBaseSchema $schema$inlined;
                {
                    this.$tableCache = nameCache;
                    this.this$0 = mysqlSchemaRetriever;
                    this.$schema$inlined = mysqlBaseSchema;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull MysqlBaseIntroQueries.Trigger t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    var2_2 = this.$tableCache;
                    name$iv = t.event_object_table;
                    $i$f$get = false;
                    var5_6 = this_$iv;
                    create$iv$iv = false;
                    $i$f$get = false;
                    if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                    v0 = this_$iv$iv.getV();
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                        v1 = this_$iv$iv.getV();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var8_9 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                            final /* synthetic */ boolean $create;
                            final /* synthetic */ String $name;
                            {
                                this.$create = bl;
                                this.$name = string;
                                super(1);
                            }

                            @Nullable
                            public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                Intrinsics.checkParameterIsNotNull($this$invoke, (String)"$this$invoke");
                                return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                            }
                        };
                        var9_10 = this_$iv$iv;
                        var10_11 = this_$iv$iv;
                        $i$a$-get-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTriggers$2$1$table$1 = false;
                        v2 = this.$schema$inlined.getTables();
                        Intrinsics.checkExpressionValueIsNotNull(v2, (String)"schema.tables");
                        var12_13 = (MysqlBaseTable)it.invoke(v2);
                        var10_11.setV((BasicModNamedElement)var12_13);
                        v1 = this_$iv$iv.getV();
                    }
                    v3 = (MysqlBaseTable)v1;
                    if (v3 == null) {
                        return;
                    }
                    table = v3;
                    var2_2 = table.getTriggers().createOrGet(t.trigger_name);
                    var3_4 = false;
                    var4_5 = false;
                    $this$apply = (MysqlBaseTrigger)var2_2;
                    $i$a$-apply-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTriggers$2$1$1 = false;
                    $this$apply.setTurn(StringsKt.equals((String)t.action_timing, (String)"before", (boolean)true) != false ? TrigTurn.BEFORE_ROW : TrigTurn.AFTER_ROW);
                    $this$apply.setEvents(SetsKt.setOf((Object)MysqlBaseIntrospectorKt.access$getEvent(t.event_manipulation)));
                    v4 = t.definer;
                    $this$apply.setDefiner(v4 != null ? MysqlBaseIntrospector.access$dbIntern(this.this$0.this$0, v4) : null);
                }
            }));
            it = MysqlSchemaRetriever$retrieveTriggers$$inlined$cleanupFamilies$2.INSTANCE;
            $i$a$-cleanupFamilies-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTriggers$1 = false;
            ModNamingFamily<? extends MysqlBaseTable> modNamingFamily3 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily3, (String)"schema.tables");
            $this$forEach$iv = modNamingFamily3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (MysqlBaseTable)element$iv;
                bl = false;
                MysqlBaseTable mysqlBaseTable = t;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlBaseTable, (String)"t");
                ModNamingFamily<? extends MysqlBaseTrigger> modNamingFamily4 = mysqlBaseTable.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull(modNamingFamily4, (String)"t.triggers");
                it.invoke(modNamingFamily4);
            }
        }

        private final void retrieveEvents(MysqlBaseSchema schema) {
            this.progress("events");
            boolean $i$f$cleanupFamilies = false;
            Function1 it2 = MysqlSchemaRetriever$retrieveEvents$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl = false;
            ModNamingFamily<? extends MysqlBaseEvent> modNamingFamily = schema.getEvents();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"schema.events");
            it2.invoke(modNamingFamily);
            boolean bl2 = false;
            if (this.this$0.getSchedulerEnabled()) {
                MysqlBaseIntroQueries.INSTANCE.processEvents(this.getTransaction(), schema, (Function1<? super MysqlBaseIntroQueries.Event, Unit>)((Function1)new Function1<MysqlBaseIntroQueries.Event, Unit>(this, schema){
                    final /* synthetic */ MysqlSchemaRetriever this$0;
                    final /* synthetic */ MysqlBaseSchema $schema$inlined;
                    {
                        this.this$0 = mysqlSchemaRetriever;
                        this.$schema$inlined = mysqlBaseSchema;
                        super(1);
                    }

                    public final void invoke(@NotNull MysqlBaseIntroQueries.Event e) {
                        String string;
                        MysqlBaseEvent mysqlBaseEvent;
                        MysqlBaseEvent $this$apply;
                        block10: {
                            block7: {
                                String string2;
                                MysqlBaseEvent mysqlBaseEvent2;
                                block9: {
                                    String it2;
                                    block8: {
                                        String string3;
                                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                                        MysqlBaseEvent mysqlBaseEvent3 = this.$schema$inlined.getEvents().createOrGet(e.event_name);
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        $this$apply = mysqlBaseEvent3;
                                        boolean bl3 = false;
                                        $this$apply.setComment(e.event_comment);
                                        String string4 = e.definer;
                                        $this$apply.setDefiner(string4 != null ? MysqlBaseIntrospector.access$dbIntern(this.this$0.this$0, string4) : null);
                                        if (e.recurring) {
                                            string3 = e.interval_value;
                                            if (string3 == null || (string3 = MysqlBaseIntrospectorKt.access$getSqlString$p(string3)) == null) {
                                                string3 = "";
                                            }
                                        } else {
                                            string3 = null;
                                        }
                                        String ivl = string3;
                                        mysqlBaseEvent = $this$apply;
                                        String string5 = ivl;
                                        if (string5 == null) break block7;
                                        String string6 = string5;
                                        mysqlBaseEvent2 = mysqlBaseEvent;
                                        boolean bl4 = false;
                                        boolean bl5 = false;
                                        it2 = string6;
                                        boolean bl6 = false;
                                        string2 = e.interval_field;
                                        if (string2 == null) break block8;
                                        String string7 = string2;
                                        boolean bl7 = false;
                                        boolean bl8 = false;
                                        String f = string7;
                                        boolean bl9 = false;
                                        string2 = it2 + ' ' + f;
                                        if (string2 != null) break block9;
                                    }
                                    string2 = it2;
                                }
                                String string8 = string2;
                                mysqlBaseEvent = mysqlBaseEvent2;
                                string = string8;
                                break block10;
                            }
                            string = null;
                        }
                        mysqlBaseEvent.setInterval(string);
                        String string9 = e.starts;
                        $this$apply.setStarts(string9 != null ? MysqlBaseIntrospectorKt.access$getSqlString$p(string9) : null);
                        String string10 = e.ends;
                        $this$apply.setEnds(string10 != null ? MysqlBaseIntrospectorKt.access$getSqlString$p(string10) : null);
                        $this$apply.setPreserve(Intrinsics.areEqual((Object)e.preserve, (Object)true));
                        $this$apply.setStatus(MysqlSchemaRetriever.access$getEventStatus(this.this$0, e.status));
                        $this$apply.setLastExecuted(e.last_executed);
                    }
                }));
            }
            it = MysqlSchemaRetriever$retrieveEvents$$inlined$cleanupFamilies$2.INSTANCE;
            bl = false;
            ModNamingFamily<? extends MysqlBaseEvent> modNamingFamily2 = schema.getEvents();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"schema.events");
            it.invoke(modNamingFamily2);
        }

        private final MysqlEventStatus getEventStatus(String status) {
            return StringsKt.equals((String)status, (String)"ENABLED", (boolean)false) ? MysqlEventStatus.ENABLED : (StringsKt.equals((String)status, (String)"DISABLED", (boolean)false) ? MysqlEventStatus.DISABLED : (StringsKt.equals((String)status, (String)"SLAVESIDE_DISABLED", (boolean)false) ? MysqlEventStatus.SLAVESIDE_DISABLED : MysqlEventStatus.ENABLED));
        }

        public MysqlSchemaRetriever(@NotNull DBTransaction tran, S schema) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            this.this$0 = $outer;
            super((BaseIntrospector)$outer, tran, (BasicModSchema)schema);
            this.BUG = new Regex("['\"`]");
        }

        public static final /* synthetic */ void access$retrieveTables(MysqlSchemaRetriever $this, MysqlBaseSchema schema) {
            $this.retrieveTables(schema);
        }

        public static final /* synthetic */ void access$retrieveColumns(MysqlSchemaRetriever $this, MysqlBaseSchema schema) {
            $this.retrieveColumns(schema);
        }

        public static final /* synthetic */ void access$retrieveTriggers(MysqlSchemaRetriever $this, MysqlBaseSchema schema) {
            $this.retrieveTriggers(schema);
        }

        public static final /* synthetic */ void access$retrieveEvents(MysqlSchemaRetriever $this, MysqlBaseSchema schema) {
            $this.retrieveEvents(schema);
        }

        public static final /* synthetic */ void access$retrieveRoutines(MysqlSchemaRetriever $this, MysqlBaseSchema schema) {
            $this.retrieveRoutines(schema);
        }

        public static final /* synthetic */ void access$retrieveRoutineParameters(MysqlSchemaRetriever $this, MysqlBaseSchema schema) {
            $this.retrieveRoutineParameters(schema);
        }

        public static final /* synthetic */ void access$retrieveInfoFromTableSrc(MysqlSchemaRetriever $this, MysqlBaseSchema schema) {
            $this.retrieveInfoFromTableSrc(schema);
        }

        public static final /* synthetic */ void access$retrieveViewSources(MysqlSchemaRetriever $this, MysqlBaseSchema schema) {
            $this.retrieveViewSources(schema);
        }

        public static final /* synthetic */ void access$retrieveRoutineSources(MysqlSchemaRetriever $this, MysqlBaseSchema schema) {
            $this.retrieveRoutineSources(schema);
        }

        public static final /* synthetic */ void access$retrieveTriggerSources(MysqlSchemaRetriever $this, MysqlBaseSchema schema) {
            $this.retrieveTriggerSources(schema);
        }

        public static final /* synthetic */ void access$retrieveEventSources(MysqlSchemaRetriever $this, MysqlBaseSchema schema) {
            $this.retrieveEventSources(schema);
        }

        public static final /* synthetic */ void access$setUpIdx(MysqlSchemaRetriever $this, MysqlBaseIndex index2, List idxCols) {
            $this.setUpIdx(index2, idxCols);
        }

        public static final /* synthetic */ CascadeRule access$asCascadeRule(MysqlSchemaRetriever $this, String s) {
            return $this.asCascadeRule(s);
        }

        public static final /* synthetic */ void access$setUpConstraint(MysqlSchemaRetriever $this, MysqlBaseConstraint con, List cols2) {
            $this.setUpConstraint(con, cols2);
        }

        public static final /* synthetic */ void access$setSourceOrMarkBugged(MysqlSchemaRetriever $this, BasicModSourceAware $this$access_u24setSourceOrMarkBugged, String text2, List bugged) {
            $this.setSourceOrMarkBugged($this$access_u24setSourceOrMarkBugged, text2, bugged);
        }

        public static final /* synthetic */ MysqlEventStatus access$getEventStatus(MysqlSchemaRetriever $this, String status) {
            return $this.getEventStatus(status);
        }
    }
}

