/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.generator;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.oracle.generator.OraRoutineArgumentsAnalyzer;
import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.run.actions.ExecuteRoutineActionBase;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.sql.dialects.SqlLanguageDialect;
import gnu.trove.TIntIntHashMap;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraRoutineExecutionHelper
implements ExecuteRoutineActionBase.RoutineExecutionHelper {
    @Override
    @Nullable
    public DataRequest makeRequest(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DataRequest.OwnerEx owner, @NotNull String script, @NotNull SqlLanguageDialect dialect, @NotNull BasicRoutine routine, @Nullable SearchPath path) {
        if (project == null) {
            OraRoutineExecutionHelper.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            OraRoutineExecutionHelper.$$$reportNull$$$0(1);
        }
        if (owner == null) {
            OraRoutineExecutionHelper.$$$reportNull$$$0(2);
        }
        if (script == null) {
            OraRoutineExecutionHelper.$$$reportNull$$$0(3);
        }
        if (dialect == null) {
            OraRoutineExecutionHelper.$$$reportNull$$$0(4);
        }
        if (routine == null) {
            OraRoutineExecutionHelper.$$$reportNull$$$0(5);
        }
        OraRoutineArgumentsAnalyzer analyzer = new OraRoutineArgumentsAnalyzer((OraRoutine)routine);
        Version version = dataSource.getVersion();
        List<OraArgument> arguments = analyzer.getCursorArguments();
        List<OraRoutineArgumentsAnalyzer.PrimitivesPack> packs = analyzer.getPrimitives(version);
        List<OraArgument> sqlArrays = analyzer.getSqlTypeArrayArguments();
        List<OraArgument> plArrays = analyzer.getPlTypeArrayArguments();
        List<OraArgument> sqlTables = analyzer.getSqlTypeNestedTableArguments();
        List<OraArgument> plTables = analyzer.getPlTypeArrayArguments();
        int primitiveCursors = packs.stream().mapToInt(p2 -> p2.getEnabled() ? 1 : 0).sum();
        int plTypesCursors = OraRoutineArgumentsAnalyzer.supportPlTypesInSql(version) ? plArrays.size() + plTables.size() : 0;
        int count2 = arguments.size() + sqlArrays.size() + sqlTables.size() + plTypesCursors + primitiveCursors;
        TIntIntHashMap outParameters = new TIntIntHashMap();
        for (int i2 = 0; i2 < count2; ++i2) {
            outParameters.put(i2 + 1, -10);
        }
        DataRequest.CallRequest.Statement statement = new DataRequest.CallRequest.Statement(script, outParameters);
        List<DataRequest.CallRequest.Statement> statements2 = Collections.singletonList(statement);
        return DataRequest.newCallRequest(owner, statements2, path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "owner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "script";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "routine";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/oracle/generator/OraRoutineExecutionHelper";
        objectArray[2] = "makeRequest";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

