/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.plan;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.postgresbase.plan.PgBasePlanModelBuilder;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConsumer;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgPlanModelBuilder
extends AbstractPlanModelBuilder<JSONObject> {
    private static final Map<String, PlanModel.NodeType> MODIFICATION_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private final String myStatement;
    private String myJson;

    public PgPlanModelBuilder(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer2, @NotNull String statement) {
        if (owner == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(1);
        }
        if (statement == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(2);
        }
        super(owner, consumer2, EnumSet.noneOf(PlanModel.Feature.class));
        this.myStatement = statement;
    }

    @NotNull
    private String getPlanAsJson(@NotNull DatabaseConnection connection2) throws PlanRetrievalException {
        if (connection2 == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(3);
        }
        final Ref result2 = Ref.create();
        PgPlanModelBuilder.useStatementWithPreserved(connection2, new AbstractPlanModelBuilder.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> statement) throws PlanRetrievalException, SQLException {
                statement.noisy().execute("EXPLAIN (FORMAT JSON) " + PgPlanModelBuilder.this.myStatement, PgPlanModelBuilder.processing((ThrowableConsumer<ResultSet, SQLException>)rs -> {
                    if (!rs.next()) {
                        PgPlanModelBuilder.failWithEmptyResultSetError();
                    }
                    if (rs.getMetaData().getColumnCount() != 1) {
                        throw new PlanRetrievalException("Database returned data in unknown format");
                    }
                    String res2 = rs.getString(1);
                    if (res2 == null) {
                        throw new PlanRetrievalException("Database returned null plan");
                    }
                    if (rs.next()) {
                        throw new PlanRetrievalException("Database returned too many data");
                    }
                    result2.set((Object)res2);
                }));
            }
        }, new AbstractPlanModelBuilder.StateSaver[0]);
        String string = (String)result2.get();
        if (string == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static BigDecimal optBig(@NotNull JSONObject obj2, @NotNull String key2, @Nullable BigDecimal def) {
        if (obj2 == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(5);
        }
        if (key2 == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(6);
        }
        return obj2.opt(key2) == null ? def : new BigDecimal(obj2.optString(key2, "-1"));
    }

    private static Double optDouble(@NotNull JSONObject obj2, @NotNull String key2, @Nullable Double def) {
        if (obj2 == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(7);
        }
        if (key2 == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(8);
        }
        return obj2.opt(key2) == null ? def : Double.valueOf(obj2.optDouble(key2, -1.0));
    }

    private void parseRoot(@NotNull String json) throws PlanRetrievalException {
        JSONArray data;
        if (json == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(9);
        }
        try {
            data = new JSONArray(json);
        }
        catch (JSONException e) {
            throw new PlanRetrievalException("Database returned invalid JSON", e);
        }
        if (data.length() == 0) {
            throw new PlanRetrievalException("Database returned empty plan");
        }
        if (data.length() > 1) {
            throw new PlanRetrievalException("Database returned multiple plans");
        }
        try {
            this.openNode(null);
            this.parseStatement(data.getJSONObject(0).getJSONObject("Plan"));
            this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        }
        catch (JSONException e) {
            throw new PlanRetrievalException("Database returned plan in unknown format", e);
        }
    }

    @Override
    @NotNull
    protected String dump() {
        String string = this.myJson;
        if (string == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public void processRaw(@NotNull DataRequest.Context context, @NotNull DatabaseConnection connection2) {
        if (context == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(11);
        }
        if (connection2 == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(12);
        }
        this.myJson = this.getPlanAsJson(connection2);
        this.showRaw();
        this.parseRoot(this.myJson);
        this.modelReady();
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(13);
        }
        StringBuilder desc = new StringBuilder();
        Iterator it2 = object.keys();
        while (it2.hasNext()) {
            String str;
            String key2 = (String)it2.next();
            if ("Plans".equals(key2) || (str = object.optString(key2, null)) == null) continue;
            desc.append(key2).append(" = ").append(str).append(";\n");
        }
        String string = desc.toString();
        if (string == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull JSONObject object) {
        String rel;
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(15);
        }
        if ((rel = object.optString("Relation Name", null)) == null) {
            rel = object.optString("CTE Name", null);
        }
        return rel;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(16);
        }
        return PgPlanModelBuilder.optBig(object, "Plan Rows", null);
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(17);
        }
        return object.optString("Index Name", null);
    }

    private static int getNumSubPlans(@Nullable JSONObject object) {
        JSONArray plans = PgPlanModelBuilder.getSubPlans(object);
        return plans == null ? 0 : plans.length();
    }

    @Nullable
    private static JSONArray getSubPlans(@Nullable JSONObject object) {
        return object == null ? null : object.optJSONArray("Plans");
    }

    @Nullable
    private static String getNodeType(@Nullable JSONObject object) {
        return object == null ? null : object.optString("Node Type");
    }

    @Override
    protected void parseSubPlans(@NotNull JSONObject object) {
        JSONArray plans;
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(18);
        }
        if ((plans = PgPlanModelBuilder.getSubPlans(object)) != null) {
            JSONObject subPlan;
            if (plans.length() == 1 && "Append".equals(PgPlanModelBuilder.getNodeType(subPlan = plans.optJSONObject(0)))) {
                this.parseSubPlans(subPlan);
                return;
            }
            for (int i2 = 0; i2 < plans.length(); ++i2) {
                JSONObject subPlan2 = plans.optJSONObject(i2);
                if (subPlan2 == null) {
                    this.unsupportedFormat();
                }
                this.parsePlan(subPlan2);
            }
        }
    }

    @Override
    protected void parseStatement(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(19);
        }
        this.openNode(null);
        String nodeType = object.optString("Node Type");
        PlanModel.NodeType type = PlanModel.NodeType.SELECT;
        if (nodeType.equals("ModifyTable")) {
            type = MODIFICATION_MAPPING.get(object.optString("Operation"));
            if (type == null) {
                type = PlanModel.NodeType.STATEMENT;
            }
            this.parseSubPlans(object);
        } else {
            this.parsePlan(object);
        }
        this.closeNode(this.createNode(object, type, type == PlanModel.NodeType.STATEMENT ? nodeType : null));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(20);
        }
        return PgPlanModelBuilder.optDouble(object, "Total Cost", null);
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(21);
        }
        return PgPlanModelBuilder.optDouble(object, "Startup Cost", null);
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(22);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(23);
        }
        return false;
    }

    @Override
    protected void parsePlan(@NotNull JSONObject state2) {
        if (state2 == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(24);
        }
        if (PgPlanModelBuilder.getNumSubPlans(state2) == 1 && "Result".equals(PgPlanModelBuilder.getNodeType(state2))) {
            this.parseSubPlans(state2);
            return;
        }
        this.openNode(null);
        this.parseSubPlans(state2);
        String nodeType = state2.optString("Node Type");
        PlanModel.NodeType type = PgBasePlanModelBuilder.TYPE_MAPPING.get(nodeType);
        if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        if (type == PlanModel.NodeType.SET_OP) {
            String com = state2.optString("Command");
            if ("Intersect".equals(com)) {
                type = PlanModel.NodeType.INTERSECT;
            } else if ("Except".equals(com)) {
                type = PlanModel.NodeType.EXCEPT;
            }
        }
        PlanModel.GenericNode node = this.createNode(state2, type, nodeType);
        this.closeNode(node);
    }

    static {
        MODIFICATION_MAPPING.put("Insert", PlanModel.NodeType.INSERT);
        MODIFICATION_MAPPING.put("Update", PlanModel.NodeType.UPDATE);
        MODIFICATION_MAPPING.put("Delete", PlanModel.NodeType.DELETE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 4: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgres/plan/PgPlanModelBuilder";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgres/plan/PgPlanModelBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlanAsJson";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPlanAsJson";
                break;
            }
            case 4: 
            case 10: 
            case 14: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "optBig";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "optDouble";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseRoot";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processRaw";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

