/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.PgDialectHelper;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcSourceLoader;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.properties.PgVolatilityKind;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import org.jetbrains.annotations.NotNull;

public class PgBaseJdbcSourceLoader
extends JdbcSourceLoader {
    @Override
    protected boolean loadRoutine(@NotNull DatabaseDialectEx dialect, @NotNull BasicModSourceAware object, @NotNull DatabaseConnection connection2) throws Exception {
        if (dialect == null) {
            PgBaseJdbcSourceLoader.$$$reportNull$$$0(0);
        }
        if (object == null) {
            PgBaseJdbcSourceLoader.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            PgBaseJdbcSourceLoader.$$$reportNull$$$0(2);
        }
        if (!dialect.supportsProcedureDefinition() || !(object instanceof DasRoutine)) {
            return false;
        }
        Dbms dbms = connection2.getDbms();
        if (dbms.isPostgres() && object instanceof PgBaseRoutine) {
            DatabaseMetaData md = (DatabaseMetaData)ObjectUtils.assertNotNull((Object)connection2.getMetaData());
            Version curVersion = new Version(md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion(), 0);
            boolean hasUseful = curVersion.isOrGreaterThan(Integer.valueOf(8), Integer.valueOf(4));
            boolean isPre81 = !curVersion.isOrGreaterThan(Integer.valueOf(8), Integer.valueOf(1));
            PgBaseRoutine routine = (PgBaseRoutine)object;
            int limit = Math.max(10, routine.getArguments().size()) + 5;
            Boolean res2 = (Boolean)DbImplUtil.executeAndGetResult(connection2, "select " + (hasUseful ? "       pg_catalog.pg_get_function_arguments(pg_proc.oid) as arguments_def,\n       pg_catalog.pg_get_function_result(pg_proc.oid) as result_def,\n" : "       " + PgDialectHelper.typeArg("tr", "rettype", "prorettype", isPre81) + ", " + PgDialectHelper.select(limit, isPre81) + "       pronargs,\n       proretset,\n") + "       prosrc,\n       lanname\nfrom pg_proc join pg_namespace nsp on nsp.oid = pronamespace left join pg_language l on l.oid = prolang\n" + (hasUseful ? "" : PgDialectHelper.joinType("tr", "prorettype", isPre81) + " " + PgDialectHelper.join(limit, isPre81) + "\n") + "where proname = " + PgDialectHelper.str(object.getName()) + " and nsp.nspname = " + PgDialectHelper.str(DasUtil.getSchema((DasObject)object)) + "\n", rs -> {
                if (!rs.next()) {
                    return false;
                }
                if (hasUseful) {
                    routine.setArgumentsDefinition(StringUtil.nullize((String)rs.getString("arguments_def")));
                    routine.setResultsDefinition(StringUtil.nullize((String)rs.getString("result_def")));
                } else {
                    PgDialectHelper.SignatureBuilder sigBuilder = new PgDialectHelper.SignatureBuilder(isPre81, (ResultSet)rs);
                    DdlBuilder builder = new DdlBuilder().withDialect(DbImplUtil.getDatabaseDialect(Dbms.POSTGRES));
                    routine.setArgumentsDefinition(StringUtil.nullize((String)sigBuilder.buildArguments(builder).getStatement()));
                    builder.clear();
                    routine.setResultsDefinition(StringUtil.nullize((String)sigBuilder.buildReturn(builder).getStatement()));
                }
                routine.setSourceText(new SimpleCompositeText(rs.getString("prosrc"), CompositeText.Kind.ORIGINAL_TEXT));
                routine.setLanguageName(StringUtil.nullize((String)rs.getString("lanname")));
                if (dbms.isRedshift()) {
                    routine.setVolatilityKind(PgVolatilityKind.VOLATILE);
                }
                return true;
            });
            return res2 == Boolean.TRUE;
        }
        return super.loadRoutine(dialect, object, connection2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "object";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/postgresbase/introspector/PgBaseJdbcSourceLoader";
        objectArray[2] = "loadRoutine";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

