/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefType;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTableColumn;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH$J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J&\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J2\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\r\u0018\u00010\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010 \u001a\u00020!H\u0002J0\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\r\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J>\u0010\"\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\"\u0010&\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001c\u0010\f\u001a\u0004\u0018\u00010\r*\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\r\u0018\u00010\u001dH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006)"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBasePredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "formatTypes", "", "Lcom/intellij/database/data/types/LogicalType;", "getFormatTypes", "()Ljava/util/Set;", "canCastToText", "", "typeName", "", "version", "Lcom/intellij/database/util/Version;", "findDefType", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseDefType;", "typeId", "", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "ftsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/model/DasColumn;", "value", "", "getInnerDomain", "Lcom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBasePredicatesHelper$Either;", "Lcom/intellij/database/data/types/domain/Domain;", "defType", "registry", "Lcom/intellij/database/data/types/DomainRegistry;", "likePredicate", "likeType", "Lcom/intellij/database/data/types/domain/LikeOpType;", "matchCase", "supportsFts", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeColumn;", "Either", "intellij.database.dialects.postgresgreenplumbase"})
public abstract class PgGPlumBasePredicatesHelper
extends BasePredicatesHelper {
    @NotNull
    private final Set<LogicalType> formatTypes;

    @Override
    @NotNull
    protected Set<LogicalType> getFormatTypes() {
        return this.formatTypes;
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer ftsPredicate(@NotNull DasColumn column2, @Nullable Object value, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        if (!(column2 instanceof PgBaseLikeColumn) || !(value instanceof String)) {
            return null;
        }
        if (!this.supportsFts((PgBaseLikeColumn)column2, this.getDbms(), version)) {
            return null;
        }
        String query = "plainto_tsquery(" + DbImplUtil.StringLiteralDecorator.MATCHES.decorate((String)value, this.getDbms()) + ")";
        return new PredicatesHelper.PredicateProducer(column2, query){
            final /* synthetic */ DasColumn $column;
            final /* synthetic */ String $query;

            public final void produce(@NotNull DdlBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                builder.identifier((DasObject)this.$column).space().symbol("@@").space().literal(this.$query);
            }
            {
                this.$column = dasColumn;
                this.$query = string;
            }
        };
    }

    private final boolean supportsFts(PgBaseLikeColumn column2, Dbms dbms, Version version) {
        boolean bl;
        block9: {
            if (!PredicatesUtilKt.supportsOperation(OperationKt.FULL_TEXT_SEARCH_OPERATION, column2, dbms, version)) {
                return false;
            }
            Either<Domain, String> domain = this.getInnerDomain(column2, dbms, version);
            if (Intrinsics.areEqual((Object)this.typeName(domain), (Object)"tsvector")) {
                return true;
            }
            BasicLikeTable basicLikeTable = column2.getLikeTable();
            if (!(basicLikeTable instanceof PgBaseLikeTable)) {
                basicLikeTable = null;
            }
            PgBaseLikeTable pgBaseLikeTable = (PgBaseLikeTable)basicLikeTable;
            if (pgBaseLikeTable == null) {
                return false;
            }
            PgBaseLikeTable table = pgBaseLikeTable;
            Family family = table.getIndices();
            Intrinsics.checkExpressionValueIsNotNull((Object)family, (String)"table.indices");
            Iterable $this$any$iv = family;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    BasicIndex i2 = (BasicIndex)element$iv;
                    boolean bl3 = false;
                    BasicIndex basicIndex = i2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicIndex, (String)"i");
                    if (basicIndex.getColNames().size() != 1) {
                        bl2 = false;
                    } else {
                        String expression;
                        String string = expression = StringUtil.trim((String)i2.getColNames().get(0));
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expression");
                        bl2 = StringsKt.startsWith$default((String)string, (String)"to_tsvector(", (boolean)false, (int)2, null) && (StringsKt.endsWith$default((String)expression, (String)(column2.getName() + "::text)"), (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)expression, (String)("\"" + column2.getName() + "\"::text)"), (boolean)false, (int)2, null));
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String typeName(@Nullable Either<Domain, String> $this$typeName) {
        String string;
        Either<Domain, String> either = $this$typeName;
        if (either == null || (either = either.getLeft()) == null || (either = ((Domain)((Object)either)).simpleName()) == null) {
            Either<Domain, String> either2 = $this$typeName;
            either = either2 != null ? either2.getRight() : null;
        }
        if (either != null) {
            Either<Domain, String> either3 = either;
            boolean bl = false;
            Either<Domain, String> either4 = either3;
            if (either4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)((Object)either4)).toLowerCase();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull DasColumn column2, @Nullable Object value, @NotNull LikeOpType likeType, boolean matchCase, boolean canCastToText, @Nullable Version version) {
        boolean canCast;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)((Object)likeType), (String)"likeType");
        if (!(value instanceof String)) {
            return null;
        }
        Either<Domain, String> domain = this.getInnerDomain(column2, this.getDbms(), version);
        Either<Domain, String> either = domain;
        boolean typeSupportsOperation = either != null && (either = either.getLeft()) != null && ((Domain)((Object)either)).supportsOperation(OperationKt.LIKE_OPERATION);
        boolean bl = canCast = canCastToText && this.canCastToText(this.typeName(domain), version) && !PredicatesUtilKt.supportsOperation(OperationKt.EQUALS_TO_NUMBER_OPERATION, column2, this.getDbms(), version);
        if (!canCast && !typeSupportsOperation) {
            return null;
        }
        String string = likeType.getDecorator().decorate(StringUtil.notNullize((String)((String)value)), this.getDbms());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"likeType.decorator.decor\u2026.notNullize(value), dbms)");
        String literal = string;
        String likeWord = matchCase ? "LIKE" : "ILIKE";
        return new PredicatesHelper.PredicateProducer(column2, typeSupportsOperation, likeWord, literal){
            final /* synthetic */ DasColumn $column;
            final /* synthetic */ boolean $typeSupportsOperation;
            final /* synthetic */ String $likeWord;
            final /* synthetic */ String $literal;

            public final void produce(@NotNull DdlBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                builder.identifier((DasObject)this.$column);
                if (!this.$typeSupportsOperation) {
                    builder.symbol("::").type("text");
                }
                builder.space().keyword(this.$likeWord).space().literal(this.$literal);
            }
            {
                this.$column = dasColumn;
                this.$typeSupportsOperation = bl;
                this.$likeWord = string;
                this.$literal = string2;
            }
        };
    }

    protected abstract boolean canCastToText(@Nullable String var1, @Nullable Version var2);

    private final Either<Domain, String> getInnerDomain(DasColumn column2, Dbms dbms, Version version) {
        DomainRegistry domainRegistry = DomainRegistry.get(dbms, version);
        if (domainRegistry == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)domainRegistry, (String)"DomainRegistry.get(dbms, version) ?: return null");
        DomainRegistry registry = domainRegistry;
        if (!(column2 instanceof PgGPlumBaseTableColumn)) {
            return null;
        }
        PgGPlumBaseDefType defType = this.findDefType(((PgGPlumBaseTableColumn)column2).getTypeId(), ((PgGPlumBaseTableColumn)column2).getDatabase());
        if (defType != null) {
            return this.getInnerDomain(defType, ((PgGPlumBaseTableColumn)column2).getDatabase(), registry);
        }
        String string = ((PgGPlumBaseTableColumn)column2).getDataType().typeName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"column.dataType.typeName");
        String typeName = string;
        Domain domain = registry.getDomain(new TypeNameColumnDescriptor(typeName));
        return domain != null ? new Either<Domain, Object>(domain, null) : new Either<Object, String>(null, typeName);
    }

    private final Either<Domain, String> getInnerDomain(PgGPlumBaseDefType defType, BasicDatabase database, DomainRegistry registry) {
        if (database == null || defType == null) {
            return null;
        }
        Domain domain = registry.getDomain(new TypeNameColumnDescriptor(defType.getName()));
        if (domain != null) {
            return new Either<Domain, Object>(domain, null);
        }
        PgGPlumBaseDefType innerDefType = this.findDefType(defType.getBaseTypeId(), database);
        if (innerDefType != null) {
            return this.getInnerDomain(innerDefType, database, registry);
        }
        String definition = defType.getDefinition();
        if (definition == null || Intrinsics.areEqual((Object)definition, (Object)"-")) {
            return new Either<Object, String>(null, defType.getName());
        }
        domain = registry.getDomain(new TypeNameColumnDescriptor(definition));
        return domain != null ? new Either<Domain, Object>(domain, null) : new Either<Object, String>(null, definition);
    }

    private final PgGPlumBaseDefType findDefType(long typeId, BasicDatabase database) {
        BasicDatabase basicDatabase = database;
        BasicIdentifiedElement basicIdentifiedElement = basicDatabase != null ? basicDatabase.findIdentifiedElement(typeId) : null;
        if (!(basicIdentifiedElement instanceof PgGPlumBaseDefType)) {
            basicIdentifiedElement = null;
        }
        return (PgGPlumBaseDefType)basicIdentifiedElement;
    }

    public PgGPlumBasePredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        super(dbms);
        this.formatTypes = SetsKt.setOf((Object[])new LogicalType[]{LogicalType.TIME_WITH_TIMEZONE, LogicalType.TIMESTAMP_WITH_TIMEZONE, LogicalType.TIMESTAMP, LogicalType.TIME, LogicalType.DATE, LogicalType.UUID, LogicalType.BOOLEAN});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\b\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0019\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u0006R\u0015\u0010\u0004\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBasePredicatesHelper$Either;", "A", "B", "", "left", "right", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getLeft", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getRight", "intellij.database.dialects.postgresgreenplumbase"})
    private static final class Either<A, B> {
        @Nullable
        private final A left;
        @Nullable
        private final B right;

        @Nullable
        public final A getLeft() {
            return this.left;
        }

        @Nullable
        public final B getRight() {
            return this.right;
        }

        public Either(@Nullable A left, @Nullable B right) {
            this.left = left;
            this.right = right;
        }
    }
}

