/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.util.EventDispatcher;
import java.awt.Rectangle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

class GridScrollingModel
implements ScrollingModel {
    private final JTable myView;
    private final JScrollPane myScrollPane;
    private final Editor myFakeEditor;
    private final EventDispatcher<VisibleAreaListener> myEventDispatcher;

    GridScrollingModel(@NotNull DataGrid grid) {
        if (grid == null) {
            GridScrollingModel.$$$reportNull$$$0(0);
        }
        this.myEventDispatcher = EventDispatcher.create(VisibleAreaListener.class);
        this.myView = (JTable)grid.getPreferredFocusedComponent();
        this.myFakeEditor = (Editor)Proxy.newProxyInstance(GridScrollingModel.class.getClassLoader(), new Class[]{Editor.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args2) {
                throw new UnsupportedOperationException("Should not be called");
            }
        });
        this.myScrollPane = grid.getScrollPane();
        this.myScrollPane.getViewport().addChangeListener(new ChangeListener(){
            private Rectangle myLastViewRect;

            @Override
            public void stateChanged(ChangeEvent event) {
                Rectangle viewRect = GridScrollingModel.this.getVisibleArea();
                VisibleAreaEvent visibleAreaEvent = new VisibleAreaEvent(GridScrollingModel.this.myFakeEditor, this.myLastViewRect, viewRect);
                this.myLastViewRect = viewRect;
                ((VisibleAreaListener)GridScrollingModel.this.myEventDispatcher.getMulticaster()).visibleAreaChanged(visibleAreaEvent);
            }
        });
    }

    @NotNull
    public Editor getFakeEditor() {
        Editor editor = this.myFakeEditor;
        if (editor == null) {
            GridScrollingModel.$$$reportNull$$$0(1);
        }
        return editor;
    }

    @NotNull
    public Rectangle getVisibleArea() {
        Rectangle rectangle = this.myView.getVisibleRect();
        if (rectangle == null) {
            GridScrollingModel.$$$reportNull$$$0(2);
        }
        return rectangle;
    }

    @NotNull
    public Rectangle getVisibleAreaOnScrollingFinished() {
        throw new UnsupportedOperationException("Implement me");
    }

    public void scrollToCaret(@NotNull ScrollType scrollType) {
        if (scrollType == null) {
            GridScrollingModel.$$$reportNull$$$0(3);
        }
        Rectangle rect = this.myView.getCellRect(this.myView.getSelectedRow(), this.myView.getSelectedColumn(), true);
        this.myView.scrollRectToVisible(rect);
    }

    public void scrollTo(@NotNull LogicalPosition pos, @NotNull ScrollType scrollType) {
        if (pos == null) {
            GridScrollingModel.$$$reportNull$$$0(4);
        }
        if (scrollType == null) {
            GridScrollingModel.$$$reportNull$$$0(5);
        }
        Rectangle rect = this.myView.getCellRect(pos.line, pos.column, true);
        this.myView.scrollRectToVisible(rect);
    }

    public void runActionOnScrollingFinished(@NotNull Runnable action2) {
        if (action2 == null) {
            GridScrollingModel.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException("Implement me");
    }

    public void disableAnimation() {
    }

    public void enableAnimation() {
    }

    public int getVerticalScrollOffset() {
        return this.myScrollPane.getVerticalScrollBar().getValue();
    }

    public int getHorizontalScrollOffset() {
        return this.myScrollPane.getHorizontalScrollBar().getValue();
    }

    public void scrollVertically(int scrollOffset) {
        this.myScrollPane.getVerticalScrollBar().setValue(scrollOffset);
    }

    public void scrollHorizontally(int scrollOffset) {
        this.myScrollPane.getHorizontalScrollBar().setValue(scrollOffset);
    }

    public void scroll(int horizontalOffset, int verticalOffset) {
        this.scrollHorizontally(horizontalOffset);
        this.scrollVertically(verticalOffset);
    }

    public void addVisibleAreaListener(@NotNull VisibleAreaListener listener) {
        if (listener == null) {
            GridScrollingModel.$$$reportNull$$$0(7);
        }
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeVisibleAreaListener(@NotNull VisibleAreaListener listener) {
        if (listener == null) {
            GridScrollingModel.$$$reportNull$$$0(8);
        }
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diff/GridScrollingModel";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diff/GridScrollingModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFakeEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scrollToCaret";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "scrollTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runActionOnScrollingFinished";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addVisibleAreaListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeVisibleAreaListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

