/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.FormatBasedExtractor;
import com.intellij.database.util.CharOut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpRequest
extends DataRequest.IsolatedQueryRequest {
    private static final Logger LOG = Logger.getInstance(DumpRequest.class);
    @NotNull
    private final DataExtractor myExtractor;
    @NotNull
    private final Dbms myDbms;
    @NotNull
    private final CharOut myOutput;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @Nullable
    private final ModelIndexSet<DataConsumer.Column> mySelectedColumns;
    @Nullable
    private final String myName;
    protected DataConsumer.Column[] myColumns;
    private int myFirstRowNum;
    private DataExtractor.Extraction myExtraction;

    protected DumpRequest(@NotNull DataRequest.Owner owner, @NotNull String query, @NotNull DataRequest.Constraints constraints, @Nullable ModelIndexSet<DataConsumer.Column> columns, @NotNull DataExtractor extractor, @NotNull Dbms dbms, @NotNull CharOut output, @Nullable String name2) {
        if (owner == null) {
            DumpRequest.$$$reportNull$$$0(0);
        }
        if (query == null) {
            DumpRequest.$$$reportNull$$$0(1);
        }
        if (constraints == null) {
            DumpRequest.$$$reportNull$$$0(2);
        }
        if (extractor == null) {
            DumpRequest.$$$reportNull$$$0(3);
        }
        if (dbms == null) {
            DumpRequest.$$$reportNull$$$0(4);
        }
        if (output == null) {
            DumpRequest.$$$reportNull$$$0(5);
        }
        super(owner, query, constraints, null);
        this.mySelectedColumns = columns;
        this.myExtractor = extractor;
        this.myDbms = dbms;
        this.myOutput = output;
        this.myName = name2;
        this.myProgressIndicator = (ProgressIndicator)ObjectUtils.chooseNotNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)new EmptyProgressIndicator());
    }

    @Override
    public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] columns, int firstRowNum) {
        if (context == null) {
            DumpRequest.$$$reportNull$$$0(6);
        }
        LOG.assertTrue(resultSetIndex == this.constraints.resultSetNumber);
        this.myColumns = columns;
        this.myFirstRowNum = firstRowNum;
        this.myExtraction = this.myExtractor.startExtraction(this.myOutput, this.myDbms, false, Arrays.asList(columns), this.mySelectedColumns != null ? this.mySelectedColumns.asArray() : ArrayUtilRt.EMPTY_INT_ARRAY);
        this.myProgressIndicator.setText(this.getSavingText());
    }

    @Override
    public void addRows(@NotNull DataRequest.Context context, @NotNull List<DataConsumer.Row> rows) {
        if (context == null) {
            DumpRequest.$$$reportNull$$$0(7);
        }
        if (rows == null) {
            DumpRequest.$$$reportNull$$$0(8);
        }
        this.myProgressIndicator.checkCanceled();
        if (rows.isEmpty()) {
            return;
        }
        int maxRow = rows.get((int)(rows.size() - 1)).rowNum;
        if (rows.get((int)0).rowNum > this.myFirstRowNum && this.myExtractor instanceof DefaultValuesExtractor && !(this.myExtractor instanceof FormatBasedExtractor)) {
            this.myOutput.append(((DefaultValuesExtractor)this.myExtractor).getLineSeparator());
        }
        this.myExtraction.addData(rows);
        this.myProgressIndicator.setText(this.getSavingText() + " " + maxRow + " rows / " + ExtractorsUtil.getPresentableSize(this.myOutput.length()) + " chars loaded");
    }

    @NotNull
    private String getSavingText() {
        String string = "Saving" + (this.myName == null ? "" : String.format(" \"%s\"", this.myName)) + "...";
        if (string == null) {
            DumpRequest.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
        if (context == null) {
            DumpRequest.$$$reportNull$$$0(10);
        }
        this.myExtraction.complete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dump/DumpRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dump/DumpRequest";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSavingText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setColumns";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addRows";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "afterLastRowAdded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

