/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.run.actions.ChangePageSizeAction;
import com.intellij.database.run.actions.CountRowsAction;
import com.intellij.database.run.actions.SetCustomPageSizeAction;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangePageSizeActionGroup
extends DefaultActionGroup
implements CustomComponentAction,
DumbAware {
    private static final List<Integer> DEFAULT_PAGE_SIZES = Arrays.asList(10, 100, 500, 1000);
    private static final String PAGE_SIZE_KEY = "DATA_GRID_PAGE_SIZE_KEY";
    private static final String SHOW_COUNT_ALL_ACTION_KEY = "DATA_GRID_SHOW_COUNT_ALL_ACTION_KEY";

    public ChangePageSizeActionGroup() {
        this.setPopup(true);
        this.setActions(DEFAULT_PAGE_SIZES, false);
    }

    private void setActions(List<Integer> sizes, boolean isSinglePage) {
        this.removeAll();
        if (isSinglePage) {
            this.add((AnAction)new MyCountRowsAction());
        }
        this.addSeparator("Page Size");
        for (Integer pageSize : sizes) {
            this.add((AnAction)new ChangePageSizeAction(pageSize));
        }
        this.add((AnAction)new ChangePageSizeAction(-1));
        this.add((AnAction)new SetCustomPageSizeAction());
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(0);
        }
        if ((grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        ChangePageSizeActionState state2 = ChangePageSizeActionGroup.getActionState(grid);
        this.updatePresentation(state2, e.getPresentation());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(1);
        }
        JComponent component = ChangePageSizeActionGroup.getComponent(e);
        JBPopup popup = this.getPopup(e);
        if (component == null) {
            DbUIUtil.showPopup(popup, null, e);
            return;
        }
        popup.showUnderneathOf((Component)component);
    }

    @NotNull
    static String format(long num) {
        String string = String.format("%,d", num);
        if (string == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(2);
        }
        return string;
    }

    private JBPopup getPopup(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(3);
        }
        return JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this, e.getDataContext(), null, true, null);
    }

    @Nullable
    private static JComponent getComponent(AnActionEvent e) {
        return (JComponent)e.getPresentation().getClientProperty(COMPONENT_KEY);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(4);
        }
        if (place == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(5);
        }
        ActionButtonWithText c2 = new ActionButtonWithText((AnAction)this, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            public Insets getInsets() {
                return new JBInsets(0, 0, 0, 0);
            }
        };
        JComponent jComponent = AlignedIconWithTextAction.align((JComponent)c2);
        if (jComponent == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    private void updatePresentation(ChangePageSizeActionState state2, Presentation presentation) {
        ChangePageSizeActionState oldState = ChangePageSizeActionGroup.getActionState(presentation);
        if (oldState.equals(state2)) {
            return;
        }
        presentation.setText(state2.text);
        presentation.setDescription(state2.description);
        presentation.setEnabled(state2.enabled);
        presentation.setVisible(true);
        presentation.putClientProperty(PAGE_SIZE_KEY, (Object)state2.pageSize);
        presentation.putClientProperty(SHOW_COUNT_ALL_ACTION_KEY, (Object)state2.showCountAllAction);
        JComponent component = (JComponent)presentation.getClientProperty(COMPONENT_KEY);
        if (component != null) {
            component.setToolTipText(state2.tooltip);
            component.repaint();
        }
        ArrayList<Integer> pageSizes = new ArrayList<Integer>(DEFAULT_PAGE_SIZES);
        pageSizes.add(DbImplUtil.getPageSize());
        if (state2.pageSize > 0) {
            pageSizes.add(state2.pageSize * 2);
            int halfSize = state2.pageSize / 2;
            if (halfSize > 0) {
                pageSizes.add(halfSize);
            }
            ContainerUtil.removeAll(pageSizes, (Object[])new Integer[]{state2.pageSize});
        }
        ContainerUtil.removeDuplicates(pageSizes);
        ContainerUtil.sort(pageSizes);
        this.setActions(pageSizes, state2.showCountAllAction);
    }

    @NotNull
    private static ChangePageSizeActionState getActionState(@NotNull Presentation presentation) {
        Boolean showCountAllAction;
        if (presentation == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(7);
        }
        JComponent component = (JComponent)presentation.getClientProperty(COMPONENT_KEY);
        String text2 = presentation.getText();
        String description = presentation.getDescription();
        String tooltip = component != null ? component.getToolTipText() : null;
        boolean loading = presentation.isEnabled();
        Integer pageSize = (Integer)ObjectUtils.tryCast((Object)presentation.getClientProperty(PAGE_SIZE_KEY), Integer.class);
        if (pageSize == null) {
            pageSize = -2;
        }
        if ((showCountAllAction = (Boolean)ObjectUtils.tryCast((Object)presentation.getClientProperty(SHOW_COUNT_ALL_ACTION_KEY), Boolean.class)) == null) {
            showCountAllAction = false;
        }
        ChangePageSizeActionState changePageSizeActionState = new ChangePageSizeActionState(text2, description, tooltip, loading, pageSize, showCountAllAction);
        if (changePageSizeActionState == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(8);
        }
        return changePageSizeActionState;
    }

    @NotNull
    private static ChangePageSizeActionState getActionState(@NotNull DataGrid grid) {
        boolean isSinglePage;
        if (grid == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(9);
        }
        ChangePageSizeActionGroup.updateIsTotalRowCountUpdateable(grid);
        GridPagingModel pageModel = grid.getDataHookup().getPageModel();
        int pageStartIdx = pageModel.getPageStart();
        int pageEndIdx = pageModel.getPageEnd();
        long totalRowCount = pageModel.getTotalRowCount();
        boolean rowsWereDeleted = totalRowCount < (long)pageEndIdx;
        boolean bl = isSinglePage = pageModel.isFirstPage() && pageModel.isLastPage() && !rowsWereDeleted;
        String text2 = isSinglePage ? ChangePageSizeActionGroup.format(totalRowCount) + " row" + (totalRowCount == 1L ? "" : "s") : (pageEndIdx == 0 ? "0 rows" : ChangePageSizeActionGroup.format(pageStartIdx) + "-" + ChangePageSizeActionGroup.format(pageEndIdx));
        boolean querying = grid.getDataHookup().getBusyCount() > 0;
        boolean enabled = !querying && grid.isReady();
        String description = "Change page size";
        String tooltip = "Change page size";
        if (!enabled) {
            String unavailableText;
            description = unavailableText = querying ? "Querying..." : "";
            tooltip = unavailableText;
        }
        boolean showCountRowsAction = isSinglePage && pageModel.isTotalRowCountUpdateable() && !querying && grid.isReady();
        ChangePageSizeActionState changePageSizeActionState = new ChangePageSizeActionState(text2, description, tooltip, enabled, pageModel.getPageSize(), showCountRowsAction);
        if (changePageSizeActionState == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(10);
        }
        return changePageSizeActionState;
    }

    private static void updateIsTotalRowCountUpdateable(@NotNull DataGrid grid) {
        DataBusGridDataHookUp.DataBusLoader loader;
        if (grid == null) {
            ChangePageSizeActionGroup.$$$reportNull$$$0(11);
        }
        if ((loader = (DataBusGridDataHookUp.DataBusLoader)ObjectUtils.tryCast(grid.getDataHookup().getLoader(), DataBusGridDataHookUp.DataBusLoader.class)) == null) {
            return;
        }
        loader.updateIsTotalRowCountUpdateable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChangePageSizeActionGroup";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChangePageSizeActionGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPopup";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getActionState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateIsTotalRowCountUpdateable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCountRowsAction
    extends DumbAwareAction {
        MyCountRowsAction() {
            super("Count rows", "Click to update (runs SELECT COUNT(*) FROM ...)", null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataGrid grid;
            if (e == null) {
                MyCountRowsAction.$$$reportNull$$$0(0);
            }
            if ((grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            CountRowsAction.countRows(grid);
            ChangePageSizeActionGroup.updateIsTotalRowCountUpdateable(grid);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ChangePageSizeActionGroup$MyCountRowsAction", "actionPerformed"));
        }
    }

    private static class ChangePageSizeActionState {
        final String text;
        final String description;
        final String tooltip;
        final boolean enabled;
        final int pageSize;
        final boolean showCountAllAction;

        ChangePageSizeActionState(String text2, String description, String tooltip, boolean enabled, int pageSize, boolean showCountAllAction) {
            this.text = text2;
            this.description = description;
            this.tooltip = tooltip;
            this.enabled = enabled;
            this.pageSize = pageSize;
            this.showCountAllAction = showCountAllAction;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChangePageSizeActionState state2 = (ChangePageSizeActionState)o;
            return this.enabled == state2.enabled && this.pageSize == state2.pageSize && Objects.equals(this.text, state2.text) && Objects.equals(this.description, state2.description) && Objects.equals(this.tooltip, state2.tooltip);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.description, this.tooltip, this.enabled, this.pageSize);
        }
    }
}

