/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.ui.DatabasePreviewDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExecuteRoutineActionBase
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        boolean isFunction;
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        ActionData actionData = this.getActionData(e);
        boolean available = actionData != ActionData.DISABLED && actionData.routine != null && this.isAvailable(e, actionData);
        presentation.setEnabledAndVisible(available);
        if (!available) {
            return;
        }
        DasRoutine.Kind kind = actionData.routine.getRoutineKind();
        boolean isProcedure = kind == DasRoutine.Kind.PROCEDURE;
        boolean bl = isFunction = kind == DasRoutine.Kind.FUNCTION;
        String text2 = isProcedure ? "Procedure" : (isFunction ? "Function" : "Routine");
        presentation.setText(this.getTemplatePresentation().getText().replace("Routine", text2));
    }

    protected boolean isAvailable(@NotNull AnActionEvent e, @NotNull ActionData data) {
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(1);
        }
        if (data == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(2);
        }
        return data.routine != null && data.dataSource != null && RoutineExecutionHelper.EP.forDbms(data.dataSource.getDbms()) != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(3);
        }
        this.doPerformAction(e, this.getActionData(e));
    }

    @NotNull
    protected RequestRunner getExecutor(@NotNull DataRequest.OwnerEx console, @NotNull ActionData actionData) {
        if (console == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(4);
        }
        if (actionData == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(5);
        }
        PreviewDialogRunner previewDialogRunner = new PreviewDialogRunner((DbDataSource)ObjectUtils.notNull((Object)actionData.dataSource), console);
        if (previewDialogRunner == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(6);
        }
        return previewDialogRunner;
    }

    private void doPerformAction(@NotNull AnActionEvent e, @NotNull ActionData data) {
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(7);
        }
        if (data == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(8);
        }
        if (data.dataSource == null || data.routine == null) {
            return;
        }
        Dbms dbms = data.dataSource.getDbms();
        BasicRoutine routine = data.routine;
        BasicModel model = routine.getModel();
        RoutineExecutionHelper provider = (RoutineExecutionHelper)RoutineExecutionHelper.EP.forDbms(dbms);
        if (provider == null) {
            return;
        }
        ExecuteRoutineActionBase.withOwner(e, data, (Consumer<DataRequest.CustomSearchPathOwner>)((Consumer)owner -> ExecuteRoutineActionBase.perform(routine, model, data.dataSource.getProject(), owner, owner.getSearchPath(), DbImplUtil.getLocalDataSource((DasDataSource)data.dataSource), this.getExecutor((DataRequest.OwnerEx)owner, data), data)));
    }

    public static void perform(@NotNull BasicRoutine routine, @NotNull BasicModel model, @NotNull Project project, @NotNull DataRequest.OwnerEx owner, @Nullable SearchPath searchPath, @NotNull LocalDataSource localDataSource, @NotNull RequestRunner executor, @Nullable ActionData data) {
        RoutineExecutionHelper provider;
        if (routine == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(9);
        }
        if (model == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(11);
        }
        if (owner == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(12);
        }
        if (localDataSource == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(13);
        }
        if (executor == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(14);
        }
        if ((provider = (RoutineExecutionHelper)RoutineExecutionHelper.EP.forDbms(localDataSource.getDbms())) == null) {
            ExecuteRoutineActionBase.finish(owner, data);
            return;
        }
        DbDataSource dataSource = (DbDataSource)ObjectUtils.notNull((Object)DbImplUtil.getDbDataSource(project, localDataSource));
        ScriptingSingleModelTask task = ExecuteRoutineActionBase.makeTask(routine, model, searchPath, localDataSource, dataSource);
        String statements2 = StringUtil.join((String[])ScriptGenerators.INSTANCE.makeScript(project, task).getScriptStatements(), (String)";\n");
        SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect(localDataSource);
        DasNamespace searchPathObject = DbImplUtil.getSearchPathObjectForSwitch(dataSource, routine);
        SearchPath path = ObjectPaths.searchPathOf((DasObject)searchPathObject);
        String script = executor.editScript(statements2, path);
        if (script == null || StringUtil.isEmptyOrSpaces((String)script)) {
            ExecuteRoutineActionBase.finish(owner, data);
            return;
        }
        DataRequest request = provider.makeRequest(project, localDataSource, owner, script, dialect, routine, path);
        if (request != null) {
            request.getPromise().onProcessed(__ -> ExecuteRoutineActionBase.finish(owner, data));
            executor.runRequest(request);
            return;
        }
        ExecuteRoutineActionBase.finish(owner, data);
    }

    private static void finish(@NotNull DataRequest.OwnerEx owner, @Nullable ActionData data) {
        if (owner == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(15);
        }
        if (data != null) {
            data.onFinished(owner);
        }
    }

    @NotNull
    private static ScriptingSingleModelTask makeTask(@NotNull BasicRoutine routine, @NotNull BasicModel model, @Nullable SearchPath searchPath, @NotNull LocalDataSource localDataSource, @NotNull DbDataSource dataSource) {
        if (routine == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(16);
        }
        if (model == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(17);
        }
        if (localDataSource == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(18);
        }
        if (dataSource == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(19);
        }
        ScriptingSingleModelTaskBuilder taskBuilder = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.EXECUTE);
        ObjectPath path = (ObjectPath)ObjectUtils.doIfNotNull((Object)searchPath, p2 -> p2.getCurrent());
        ObjectPath databasePath = path == null ? null : path.findParent(ObjectKind.DATABASE, false);
        ObjectPath schemaPath = path == null ? null : path.findParent(ObjectKind.SCHEMA, false);
        BasicDatabase database = databasePath == null ? null : (BasicDatabase)DbSqlUtil.findObjects(dataSource, databasePath).filter(BasicDatabase.class).first();
        BasicSchema schema = schemaPath == null ? null : (BasicSchema)DbSqlUtil.findObjects(dataSource, schemaPath).filter(BasicSchema.class).first();
        taskBuilder.setCurrentSchema(schema);
        taskBuilder.setCurrentDatabase(database);
        taskBuilder.setVersion(localDataSource.getVersion());
        taskBuilder.setElements(Collections.singletonList(routine));
        taskBuilder.setOptions(new CustomScriptingOptions(ContainerUtil.map2Map(Collections.singletonList(Pair.create(ScriptingOptionStatic.CALL, (Object)true)))));
        ScriptingSingleModelTask scriptingSingleModelTask = taskBuilder.build();
        if (scriptingSingleModelTask == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(20);
        }
        return scriptingSingleModelTask;
    }

    private static void withOwner(@NotNull AnActionEvent e, @NotNull ActionData data, @NotNull Consumer<DataRequest.CustomSearchPathOwner> consumer2) {
        DataRequest.CustomSearchPathOwner owner;
        if (e == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(21);
        }
        if (data == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(22);
        }
        if (consumer2 == null) {
            ExecuteRoutineActionBase.$$$reportNull$$$0(23);
        }
        if ((owner = data.owner()) != null) {
            consumer2.consume((Object)owner);
            return;
        }
        List<PersistenceConsoleProvider.Runner> runners = data.runners(consumer2);
        if (runners.isEmpty()) {
            return;
        }
        RunQueryInConsoleIntentionAction.chooseAndRunRunners(runners, null, e);
    }

    @NotNull
    protected abstract ActionData getActionData(@NotNull AnActionEvent var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionData";
                break;
            }
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ExecuteRoutineActionBase";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDataSource";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "makeTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExecutor";
                break;
            }
            case 6: 
            case 20: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doPerformAction";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "finish";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "makeTask";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "withOwner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class FilledData
    extends ActionData {
        protected FilledData(@NotNull DbDataSource dataSource, @NotNull BasicRoutine routine) {
            if (dataSource == null) {
                FilledData.$$$reportNull$$$0(0);
            }
            if (routine == null) {
                FilledData.$$$reportNull$$$0(1);
            }
            super(dataSource, routine);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "routine";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$FilledData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class ActionData {
        public static final ActionData DISABLED = new ActionData(null, null){};
        public final DbDataSource dataSource;
        public final BasicRoutine routine;

        protected ActionData(@Nullable DbDataSource source, @Nullable BasicRoutine routine) {
            this.dataSource = source;
            this.routine = routine;
        }

        @Nullable
        public DataRequest.CustomSearchPathOwner owner() {
            return null;
        }

        @NotNull
        public List<PersistenceConsoleProvider.Runner> runners(@NotNull Consumer<DataRequest.CustomSearchPathOwner> consumer2) {
            if (consumer2 == null) {
                ActionData.$$$reportNull$$$0(0);
            }
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                ActionData.$$$reportNull$$$0(1);
            }
            return list;
        }

        public void onFinished(@NotNull DataRequest.OwnerEx owner) {
            if (owner == null) {
                ActionData.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$ActionData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$ActionData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runners";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "runners";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "onFinished";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PreviewDialogRunner
    implements RequestRunner {
        private final DbDataSource myDataSource;
        private final DataRequest.OwnerEx myOwner;

        PreviewDialogRunner(@NotNull DbDataSource dataSource, @NotNull DataRequest.OwnerEx owner) {
            if (dataSource == null) {
                PreviewDialogRunner.$$$reportNull$$$0(0);
            }
            if (owner == null) {
                PreviewDialogRunner.$$$reportNull$$$0(1);
            }
            this.myDataSource = dataSource;
            this.myOwner = owner;
        }

        @Override
        @Nullable
        public String editScript(@NotNull String script, @Nullable SearchPath path) {
            DatabasePreviewDialog previewDialog;
            if (script == null) {
                PreviewDialogRunner.$$$reportNull$$$0(2);
            }
            return (previewDialog = new DatabasePreviewDialog(this.myDataSource.getProject(), this.myDataSource, path, "Execute Routine", "", script, ContainerUtil.emptyList())).showAndGet() ? previewDialog.getStatement() : null;
        }

        @Override
        public void runRequest(@NotNull DataRequest request) {
            if (request == null) {
                PreviewDialogRunner.$$$reportNull$$$0(3);
            }
            this.myOwner.getMessageBus().getDataProducer().processRequest(request);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "script";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ExecuteRoutineActionBase$PreviewDialogRunner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editScript";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runRequest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface RequestRunner {
        @Nullable
        public String editScript(@NotNull String var1, @Nullable SearchPath var2);

        public void runRequest(@NotNull DataRequest var1);
    }

    public static interface RoutineExecutionHelper {
        public static final DbmsExtension<RoutineExecutionHelper> EP = new DbmsExtension("com.intellij.database.routineExecutionHelper");

        @Nullable
        public DataRequest makeRequest(@NotNull Project var1, @NotNull LocalDataSource var2, @NotNull DataRequest.OwnerEx var3, @NotNull String var4, @NotNull SqlLanguageDialect var5, @NotNull BasicRoutine var6, @Nullable SearchPath var7);
    }
}

