/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataGridDocumentationProvider;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigateAction
extends DumbAwareAction
implements GridAction {
    protected boolean hasKeysToNavigate(DbDataSource databaseSystem, DasTable table) {
        return DataGridDocumentationProvider.hasNavigatableKeys((DasDataSource)databaseSystem, table);
    }

    @NotNull
    protected EnumSet<DataGridDocumentationProvider.KeyType> getKeyTypes() {
        EnumSet<DataGridDocumentationProvider.KeyType> enumSet = EnumSet.of(DataGridDocumentationProvider.KeyType.FOREIGN, DataGridDocumentationProvider.KeyType.EXPORTED, DataGridDocumentationProvider.KeyType.SELECTED);
        if (enumSet == null) {
            NavigateAction.$$$reportNull$$$0(0);
        }
        return enumSet;
    }

    private static List<DataGridDocumentationProvider.QueryInfo> getQueries(@NotNull DasDataSource dataSource, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull EnumSet<DataGridDocumentationProvider.KeyType> types) {
        List<DataGridDocumentationProvider.QueryInfo> queries;
        if (dataSource == null) {
            NavigateAction.$$$reportNull$$$0(1);
        }
        if (dataGrid == null) {
            NavigateAction.$$$reportNull$$$0(2);
        }
        if (selectedRow == null) {
            NavigateAction.$$$reportNull$$$0(3);
        }
        if (types == null) {
            NavigateAction.$$$reportNull$$$0(4);
        }
        return (queries = DataGridDocumentationProvider.buildQueries(dataSource, dataGrid, selectedRow, types)).isEmpty() && types.remove((Object)DataGridDocumentationProvider.KeyType.SELECTED) ? DataGridDocumentationProvider.buildQueries(dataSource, dataGrid, selectedRow, types) : queries;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            NavigateAction.$$$reportNull$$$0(5);
        }
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        DbDataSource dataSource = DataGridUtil.getDatabaseSystem(dataGrid);
        DasTable table = DataGridUtil.getDatabaseTable(dataGrid);
        boolean visible = e.getProject() != null && table != null && dataSource != null;
        boolean enabled = visible && dataGrid.getSelectionModel().getSelectedRowCount() == 1 && this.hasKeysToNavigate(dataSource, table);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            NavigateAction.$$$reportNull$$$0(6);
        }
        Project project = e.getProject();
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        DbDataSource dataSource = DataGridUtil.getDatabaseSystem(dataGrid);
        if (dataGrid == null || dataSource == null || project == null) {
            return;
        }
        ModelIndex selectedRow = dataGrid.getSelectionModel().getSelectedRow();
        if (!selectedRow.isValid(dataGrid) || dataGrid.getSelectionModel().getSelectedRowCount() != 1) {
            return;
        }
        List<DescriptorData> descriptorData = NavigateAction.createDescriptorData(project, dataGrid, (DasDataSource)dataSource, this.getKeyTypes());
        final List descriptors = ContainerUtil.map(descriptorData, data -> new OpenDataFileDescriptor(project, data.file, data.columnNames, data.description, data.values, data.condition));
        if (descriptors.size() == 1) {
            ((OpenDataFileDescriptor)((Object)descriptors.get(0))).navigate(true);
        } else {
            DasTable table = DataGridUtil.getDatabaseTable(dataGrid);
            final Ref navigateToOnlyRowsSeparator = new Ref();
            final Ref navigateToFirstRowSeparator = new Ref();
            if (table != null && !DasUtil.getForeignKeys((DasTable)table).isEmpty()) {
                navigateToOnlyRowsSeparator.set((Object)"Referenced Rows Only");
                navigateToFirstRowSeparator.set((Object)"First Referenced Row");
            } else {
                navigateToOnlyRowsSeparator.set((Object)"Referencing Rows Only");
                navigateToFirstRowSeparator.set((Object)"First Referencing Row");
            }
            BaseListPopupStep<OpenDataFileDescriptor> step = new BaseListPopupStep<OpenDataFileDescriptor>("Choose target", descriptors){

                public PopupStep onChosen(OpenDataFileDescriptor selectedValue, boolean finalChoice) {
                    selectedValue.navigate(true);
                    return FINAL_CHOICE;
                }

                @Nullable
                public ListSeparator getSeparatorAbove(OpenDataFileDescriptor value) {
                    int idx = descriptors.indexOf((Object)value);
                    if (idx == 0) {
                        return new ListSeparator((String)navigateToOnlyRowsSeparator.get());
                    }
                    if (idx == descriptors.size() / 2) {
                        return new ListSeparator((String)navigateToFirstRowSeparator.get());
                    }
                    return super.getSeparatorAbove((Object)value);
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(OpenDataFileDescriptor value) {
                    String string = value.getFile().getName() + ": " + value.getDescription();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$1", "getTextFor"));
                }
            };
            step.setDefaultOptionIndex(0);
            ColoredListCellRenderer<OpenDataFileDescriptor> wrapper = new ColoredListCellRenderer<OpenDataFileDescriptor>(){

                protected void customizeCellRenderer(@NotNull JList<? extends OpenDataFileDescriptor> list, OpenDataFileDescriptor value, int index2, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.clear();
                    this.setIcon(DatabaseIcons.Table);
                    this.append(value.getFile().getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.append(": ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    this.append(value.getDescription(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/run/actions/NavigateAction$2", "customizeCellRenderer"));
                }
            };
            ListPopupImpl popup = new ListPopupImpl(project, (ListPopupStep)step, (ColoredListCellRenderer)wrapper, descriptors){
                final /* synthetic */ ColoredListCellRenderer val$wrapper;
                final /* synthetic */ List val$descriptors;
                {
                    this.val$wrapper = coloredListCellRenderer;
                    this.val$descriptors = list;
                    super(arg0, arg1);
                }

                protected ListCellRenderer getListElementRenderer() {
                    return new PopupListElementRenderer<OpenDataFileDescriptor>((ListPopupImpl)this){

                        protected JComponent createItemComponent() {
                            this.myTextLabel = new ErrorLabel();
                            return val$wrapper;
                        }

                        protected void customizeComponent(JList<? extends OpenDataFileDescriptor> list, OpenDataFileDescriptor value, boolean isSelected) {
                            val$wrapper.getListCellRendererComponent(list, (Object)value, val$descriptors.indexOf((Object)value), isSelected, true);
                        }
                    };
                }
            };
            ActionManager actionManager = ActionManager.getInstance();
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)actionManager.getAction("QuickJavaDoc"));
            if (StringUtil.isEmpty((String)shortcutText)) {
                popup.setAdText("Use " + shortcutText + " in table to quickly view related data for selected row");
            }
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    @NotNull
    public static List<DescriptorData> createDescriptorData(@NotNull Project project, @NotNull DataGrid dataGrid, @NotNull DasDataSource dataSource, @NotNull EnumSet<DataGridDocumentationProvider.KeyType> keyTypes) {
        if (project == null) {
            NavigateAction.$$$reportNull$$$0(7);
        }
        if (dataGrid == null) {
            NavigateAction.$$$reportNull$$$0(8);
        }
        if (dataSource == null) {
            NavigateAction.$$$reportNull$$$0(9);
        }
        if (keyTypes == null) {
            NavigateAction.$$$reportNull$$$0(10);
        }
        ModelIndex<DataConsumer.Row> selectedRow = dataGrid.getSelectionModel().getSelectedRow();
        ArrayList<DescriptorData> descriptorData = new ArrayList<DescriptorData>();
        List<DataGridDocumentationProvider.QueryInfo> queries = NavigateAction.getQueries(dataSource, dataGrid, selectedRow, keyTypes);
        for (DataGridDocumentationProvider.QueryInfo info : queries) {
            String path = DatabaseElementVirtualFileImpl.getPath(project, dataSource, (DasObject)info.table, false);
            VirtualFile file = DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(path);
            if (file == null) continue;
            Object[] formattedValues = DbImplUtil.formatValues(dataGrid, info.columnNames, info.values);
            DescriptorData descriptor = new DescriptorData(file, null, null, info.keysAndColumns, DbImplUtil.defaultWhereCondition(info.columnNames, formattedValues, dataSource.getVersion()));
            descriptorData.add(descriptorData.size() / 2, descriptor);
            descriptorData.add(new DescriptorData(file, info.columnNames, info.values, info.keysAndColumns, null));
        }
        ArrayList<DescriptorData> arrayList = descriptorData;
        if (arrayList == null) {
            NavigateAction.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/NavigateAction";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRow";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/NavigateAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptorData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptorData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DescriptorData {
        public final VirtualFile file;
        public final String[] columnNames;
        public final Object[] values;
        public final String description;
        public final DbImplUtil.TriConsumer<DdlBuilder, List<DasColumn>, Dbms> condition;

        public DescriptorData(@NotNull VirtualFile file, @Nullable String[] names, @Nullable Object[] values2, @Nullable String description, @Nullable DbImplUtil.TriConsumer<DdlBuilder, List<DasColumn>, Dbms> condition) {
            if (file == null) {
                DescriptorData.$$$reportNull$$$0(0);
            }
            this.file = file;
            this.columnNames = names;
            this.values = values2;
            this.description = description;
            this.condition = condition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/run/actions/NavigateAction$DescriptorData", "<init>"));
        }
    }

    public static class ExportedAction
    extends NavigateAction {
        @Override
        protected boolean hasKeysToNavigate(DbDataSource dataSource, DasTable table) {
            return !dataSource.getModel().getExportedKeys(table).isEmpty();
        }

        @Override
        @NotNull
        protected EnumSet<DataGridDocumentationProvider.KeyType> getKeyTypes() {
            EnumSet<DataGridDocumentationProvider.KeyType> enumSet = EnumSet.of(DataGridDocumentationProvider.KeyType.EXPORTED, DataGridDocumentationProvider.KeyType.SELECTED);
            if (enumSet == null) {
                ExportedAction.$$$reportNull$$$0(0);
            }
            return enumSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$ExportedAction", "getKeyTypes"));
        }
    }

    public static class ForeignAction
    extends NavigateAction {
        @Override
        protected boolean hasKeysToNavigate(DbDataSource dataSource, DasTable table) {
            return !DasUtil.getForeignKeys((DasTable)table).isEmpty();
        }

        @Override
        @NotNull
        protected EnumSet<DataGridDocumentationProvider.KeyType> getKeyTypes() {
            EnumSet<DataGridDocumentationProvider.KeyType> enumSet = EnumSet.of(DataGridDocumentationProvider.KeyType.FOREIGN, DataGridDocumentationProvider.KeyType.SELECTED);
            if (enumSet == null) {
                ForeignAction.$$$reportNull$$$0(0);
            }
            return enumSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$ForeignAction", "getKeyTypes"));
        }
    }
}

