/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.ResultConsumer;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.CountRowsAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.script.generator.dml.DmlGenerator;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.SameThreadExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntHashSet;
import java.awt.Component;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridDocumentationProvider
extends AbstractDocumentationProvider
implements ExternalDocumentationHandler {
    private static final String URL_PREFIX = "db-doc://";
    private static final String VIEW_MODE_PROPERTY = "DataGrid.QuickDoc.View";
    private static final Key<State> GRID_HINT_STATE_KEY = Key.create((String)"GRID_HINT_STATE_KEY");
    private static final AtomicLong ourImageCounter = new AtomicLong();
    private static final Map<String, ObjectFormatter.ImageInfo> ourImageMap = ContainerUtil.createConcurrentSoftMap();

    @Nullable
    public static Image resolveImageRef(@NotNull String imageSpec) {
        ObjectFormatter.ImageInfo info;
        if (imageSpec == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(0);
        }
        return (info = ourImageMap.remove(imageSpec)) == null ? null : info.createImage();
    }

    @NotNull
    public static String createImageRefTag(@NotNull ObjectFormatter.ImageInfo info, @Nullable String altStr) {
        if (info == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(1);
        }
        long id = ourImageCounter.incrementAndGet();
        String imageSpec = "http://img" + id;
        ourImageMap.put(imageSpec, info);
        String string = "<img src=\"" + imageSpec + "\" alt=\"" + altStr + "\" height=\"" + info.height + "\" width=\"" + info.width + "\" />";
        if (string == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static String buildAndRunQueries(@NotNull DataGrid dataGrid, CharSequence initialValue) {
        boolean noRelationships;
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(3);
        }
        DasTable databaseTable = DataGridUtil.getDatabaseTable(dataGrid);
        DbDataSource dataSource = DataGridUtil.getDatabaseSystem(dataGrid);
        if (dataSource == null || databaseTable == null) {
            return null;
        }
        ModelIndex<DataConsumer.Row> selectedRow = dataGrid.getSelectionModel().getSelectedRow();
        boolean badSelection = !selectedRow.isValid(dataGrid) || dataGrid.getSelectionModel().getSelectedRowCount() != 1;
        boolean bl = noRelationships = !DataGridDocumentationProvider.hasNavigatableKeys((DasDataSource)dataSource, databaseTable);
        if (badSelection || noRelationships) {
            DataGridDocumentationProvider.setHint(dataGrid, null);
            return null;
        }
        State state2 = (State)dataGrid.getUserData(GRID_HINT_STATE_KEY);
        List<QueryInfo> newQueries = DataGridDocumentationProvider.buildQueries((DasDataSource)dataSource, dataGrid, selectedRow, EnumSet.of(KeyType.FOREIGN, KeyType.EXPORTED));
        if (state2 != null && state2.queries.equals(newQueries) && selectedRow.equals(state2.row) && System.currentTimeMillis() - state2.timestamp <= 5000L) {
            return state2.current;
        }
        state2 = new State(newQueries, selectedRow, null);
        DataGridDocumentationProvider.setHint(dataGrid, state2);
        DataGridDocumentationProvider.runQueries(dataGrid, state2, initialValue.toString());
        return null;
    }

    public static boolean hasNavigatableKeys(@NotNull DasDataSource dataSource, @NotNull DasTable databaseTable) {
        if (dataSource == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (databaseTable == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(5);
        }
        return !Iterables.isEmpty((Iterable)dataSource.getModel().getExportedKeys(databaseTable)) || !Iterables.isEmpty((Iterable)DasUtil.getForeignKeys((DasTable)databaseTable));
    }

    public static List<QueryInfo> buildQueries(@NotNull DasDataSource dataSource, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull EnumSet<KeyType> keyTypes) {
        if (dataSource == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(6);
        }
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (selectedRow == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(8);
        }
        if (keyTypes == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(9);
        }
        GridModel model = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        TIntHashSet selectedColumnIndices = new TIntHashSet((keyTypes.contains((Object)KeyType.SELECTED) ? dataGrid.getSelectionModel().getSelectedColumns() : model.getColumnIndices()).asArray());
        DasTable databaseTable = DataGridUtil.getDatabaseTable(dataGrid);
        LinkedHashMap<String, QueryInfo> queries = new LinkedHashMap<String, QueryInfo>();
        if (keyTypes.contains((Object)KeyType.FOREIGN)) {
            DataGridDocumentationProvider.collectForeignKeyQueries(queries, databaseTable, dataSource.getDbms(), dataGrid, selectedRow, selectedColumnIndices);
        }
        if (keyTypes.contains((Object)KeyType.EXPORTED)) {
            DataGridDocumentationProvider.collectExportedKeyQueries(queries, dataSource, databaseTable, dataSource.getDbms(), dataGrid, selectedRow, selectedColumnIndices);
        }
        return new ArrayList<QueryInfo>(queries.values());
    }

    private static void collectForeignKeyQueries(@NotNull Map<String, QueryInfo> queries, @NotNull DasTable databaseTable, @NotNull Dbms dbms, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull TIntHashSet selectedColumns) {
        if (queries == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (databaseTable == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(11);
        }
        if (dbms == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(12);
        }
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (selectedRow == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(14);
        }
        if (selectedColumns == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(15);
        }
        ArrayList<String> values2 = new ArrayList<String>();
        for (DasForeignKey key2 : DasUtil.getForeignKeys((DasTable)databaseTable)) {
            DasTable table = key2.getRefTable();
            if (table == null || !DataGridDocumentationProvider.tryCollectValues(dataGrid, selectedRow, selectedColumns, values2, key2.getColumnsRef().names())) continue;
            Iterable refColumns = key2.getRefColumns().names();
            ArrayList<Pair> whereColumns = new ArrayList<Pair>();
            int i2 = 0;
            for (String name2 : refColumns) {
                whereColumns.add(new Pair((Object)name2, values2.get(i2)));
                ++i2;
            }
            DbDataSource system = DataGridUtil.getDatabaseSystem(dataGrid);
            SelectTask task = DmlTaskKt.allColumns(table).system((DasDataSource)system).limit(2).whereClause(new ValuesWhereClause(whereColumns)).build();
            DmlGenerator generator = DmlUtilKt.dmlGenerator(dbms);
            String query = generator.generate(DbImplUtil.createBuilderForUIExec(dbms, (DasObject)databaseTable), task).getStatement();
            DataGridDocumentationProvider.collectQuery(queries, new QueryInfo(query, table, false, (String[])Iterables.toArray((Iterable)refColumns, String.class), values2.toArray()), (DasConstraint)key2);
        }
    }

    private static void collectExportedKeyQueries(@NotNull Map<String, QueryInfo> queries, @NotNull DasDataSource dataSource, @NotNull DasTable databaseTable, @NotNull Dbms dbms, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull TIntHashSet selectedColumns) {
        if (queries == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(16);
        }
        if (dataSource == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(17);
        }
        if (databaseTable == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(18);
        }
        if (dbms == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(19);
        }
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(20);
        }
        if (selectedRow == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(21);
        }
        if (selectedColumns == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(22);
        }
        JBIterable referencingKeys = dataSource.getModel().getExportedKeys(databaseTable).filter(DasForeignKey.class);
        ArrayList<String> values2 = new ArrayList<String>();
        for (DasForeignKey key2 : referencingKeys) {
            DasTable table;
            if (!DataGridDocumentationProvider.tryCollectValues(dataGrid, selectedRow, selectedColumns, values2, key2.getRefColumns().names()) || (table = key2.getTable()) == null) continue;
            Iterable columnsRef = key2.getColumnsRef().names();
            DbDataSource system = DataGridUtil.getDatabaseSystem(dataGrid);
            ArrayList<Pair> whereColumns = new ArrayList<Pair>();
            int i2 = 0;
            for (String name2 : columnsRef) {
                whereColumns.add(new Pair((Object)name2, values2.get(i2)));
                ++i2;
            }
            SelectTask task = DmlTaskKt.allColumns(table).system((DasDataSource)system).limit(1).whereClause(new ValuesWhereClause(whereColumns)).build();
            DmlGenerator generator = DmlUtilKt.dmlGenerator(dbms);
            String query = generator.generate(DbImplUtil.createBuilderForUIExec(dbms, (DasObject)databaseTable), task).getStatement();
            DataGridDocumentationProvider.collectQuery(queries, new QueryInfo(query, table, true, (String[])Iterables.toArray((Iterable)columnsRef, String.class), values2.toArray()), (DasConstraint)key2);
        }
    }

    private static void collectQuery(@NotNull Map<String, QueryInfo> queries, @NotNull QueryInfo newQueryInfo, @NotNull DasConstraint key2) {
        String keyText;
        String query;
        QueryInfo info;
        if (queries == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(23);
        }
        if (newQueryInfo == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(24);
        }
        if (key2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(25);
        }
        if ((info = queries.get(query = newQueryInfo.query)) == null) {
            info = newQueryInfo;
            queries.put(query, info);
        }
        if (!info.keysAndColumns.contains(keyText = key2.getName() + "(" + StringUtil.join((Iterable)key2.getColumnsRef().names(), (String)", ") + ")")) {
            if (!info.keysAndColumns.isEmpty()) {
                info.keysAndColumns = info.keysAndColumns + ", ";
            }
            info.keysAndColumns = info.keysAndColumns + keyText;
        }
    }

    protected static boolean tryCollectValues(@NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull TIntHashSet selectedColumns, @NotNull List<String> values2, @NotNull Iterable<String> columnNames) {
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(26);
        }
        if (selectedRow == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(27);
        }
        if (selectedColumns == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(28);
        }
        if (values2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(29);
        }
        if (columnNames == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(30);
        }
        values2.clear();
        ArrayList<Object> rawValues = new ArrayList<Object>();
        ArrayList<String> actualColumnNames = new ArrayList<String>();
        boolean noIndexColumnSelected = JBIterable.from(columnNames).filter(columnName -> {
            ModelIndex<DataConsumer.Column> c2 = DataGridUtil.findColumn(dataGrid, columnName);
            return c2.isValid(dataGrid) && selectedColumns.contains(c2.asInteger());
        }).isEmpty();
        if (noIndexColumnSelected) {
            return false;
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> dataModel = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        for (String name2 : columnNames) {
            ModelIndex<DataConsumer.Column> c2 = DataGridUtil.findColumn(dataGrid, name2);
            if (!c2.isValid(dataGrid)) {
                return false;
            }
            rawValues.add(dataModel.getValueAt(selectedRow, c2));
            actualColumnNames.add(name2);
        }
        String[] formatted = DbImplUtil.formatValues(dataGrid, ArrayUtil.toStringArray(actualColumnNames), rawValues.toArray());
        values2.addAll(Arrays.asList(formatted));
        return true;
    }

    private static void runQueries(final DataGrid dataGrid, final State state2, final String initialValue) {
        if (state2.queries.isEmpty()) {
            return;
        }
        final PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(DataManager.getInstance().getDataContext((Component)dataGrid.getComponent()));
        if (element2 == null || DataGridPomTarget.unwrapCell(element2) == null) {
            return;
        }
        final Project project = element2.getProject();
        DatabaseGridDataHookUp ownerEx = DataGridUtil.getDatabaseHookUp(dataGrid);
        if (ownerEx == null) {
            return;
        }
        ownerEx.getMessageBus().getDataProducer().processRequest(new DataRequest.RawRequest(ownerEx){

            @Override
            public void processRaw(DataRequest.Context context, DatabaseConnection connection2) {
                String doc = DataGridDocumentationProvider.getQuickDocFooter(state2, dataGrid, connection2);
                if (doc != null) {
                    QuickDocUtil.updateQuickDoc((Project)project, (PsiElement)element2, (String)(initialValue + doc));
                }
            }
        });
    }

    @Nullable
    public static String getQuickDocFooter(@NotNull State state2, @NotNull DataGrid dataGrid, @NotNull DatabaseConnection connection2) {
        if (state2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(31);
        }
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(32);
        }
        if (connection2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(33);
        }
        StringBuilder sb = new StringBuilder();
        for (QueryInfo info : state2.queries) {
            DataGridDocumentationProvider.checkCancelled(state2, dataGrid);
            int length = sb.length();
            DbImplUtil.tryLoadFirstNRows(connection2, info.query, sb, 1);
            DataGridDocumentationProvider.checkCancelled(state2, dataGrid);
            if (sb.length() == length) continue;
            String title = !info.exported ? "Referenced " + info.table.getName() : "First referencing " + info.table.getName();
            sb.insert(length, "<br><b>" + title + ":</b><br>" + info.keysAndColumns);
        }
        if (sb.length() == 0) {
            return null;
        }
        sb.insert(0, "<br>");
        DataGridDocumentationProvider.setHint(dataGrid, new State(state2.queries, state2.row, sb.toString()));
        return sb.toString();
    }

    private static void checkCancelled(State state2, DataGrid dataGrid) {
        if (dataGrid.getUserData(GRID_HINT_STATE_KEY) != state2) {
            throw new ProcessCanceledException();
        }
    }

    public static void setHint(@NotNull DataGrid dataGrid, @Nullable State state2) {
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(34);
        }
        dataGrid.putUserData(GRID_HINT_STATE_KEY, state2);
    }

    @NotNull
    public static String getCellDocumentation(@NotNull DataGrid dataGrid, final Command mode) {
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(35);
        }
        StringBuilder sb = new StringBuilder(DisplayHtmlValuesExtractor.getHeader());
        SelectionModel selectionModel = dataGrid.getSelectionModel();
        boolean singleValue = selectionModel.getSelectedColumnCount() + selectionModel.getSelectedRowCount() == 2;
        final boolean plainMode = singleValue && mode != Command.transposed;
        CharOut.Wrapper out = new CharOut.Wrapper(CharOut.Util.newSink(sb)){
            final int max = 10240;
            {
                super(delegate);
                this.max = 10240;
            }

            @Override
            @NotNull
            public CharOut append(@NotNull CharSequence seq) {
                CharSequence trimmedSeq;
                if (seq == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (seq.length() == 0) {
                    2 v0 = this;
                    if (v0 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return v0;
                }
                boolean truncate = mode != Command.full && (double)seq.length() > 11264.0;
                CharSequence charSequence = trimmedSeq = truncate ? seq.subSequence(0, 10240) : seq;
                if (plainMode) {
                    DataGridDocumentationProvider.appendHyperLinkCommand(this.getDelegate(), Command.transposed, null);
                    if (truncate) {
                        DataGridDocumentationProvider.appendHyperLinkCommand(this.getDelegate().append("&nbsp;&nbsp;&nbsp;"), Command.full, "All " + ExtractorsUtil.getPresentableSize(seq.length()));
                    }
                    super.append("<br><br><pre><code>");
                    this.appendInner(trimmedSeq);
                    super.append("</code>");
                    if (truncate) {
                        DataGridDocumentationProvider.appendHyperLinkCommand(this.getDelegate().append("&nbsp;"), Command.full, ExtractorsUtil.getPresentableSize(seq.length() - 10240) + " more...");
                    }
                    super.append("</pre>");
                } else if (truncate) {
                    this.appendInner(trimmedSeq);
                    super.append(" " + ExtractorsUtil.getPresentableSize(seq.length() - 10240) + " more...");
                } else {
                    this.appendInner(seq);
                }
                2 v2 = this;
                if (v2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return v2;
            }

            void appendInner(CharSequence trimmedSeq) {
                int cur = 0;
                int len = trimmedSeq.length();
                while (cur < len) {
                    int next = StringUtil.indexOf((CharSequence)trimmedSeq, (char)'\n', (int)cur);
                    next = next < 0 ? len : next;
                    super.append(trimmedSeq.subSequence(cur, next));
                    if (next != len) {
                        super.append(" \n");
                    }
                    cur = next + 1;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "seq";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/DataGridDocumentationProvider$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/DataGridDocumentationProvider$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "append";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "append";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        final ObjectFormatter delegateFormatter = dataGrid.getObjectFormatter();
        ObjectFormatter converter = new ObjectFormatter(){

            @Override
            @Nullable
            public String objectToString(@Nullable Object o, DataConsumer.Column column2, Dbms dbms, boolean forDisplay) {
                if (o instanceof ObjectFormatter.ImageInfo) {
                    ObjectFormatter.ImageInfo oo = (ObjectFormatter.ImageInfo)o;
                    String s = delegateFormatter.objectToString(oo.stripBytes(), column2, dbms, true);
                    return DataGridDocumentationProvider.createImageRefTag(oo, s);
                }
                String s = delegateFormatter.objectToString(o, column2, dbms, true);
                return HtmlValuesExtractor.escapeChars(s);
            }
        };
        if (singleValue && mode != Command.transposed) {
            DataGridUtil.extractSelectedValues(dataGrid, ExtractorsUtil.getSingleValueExtractor(converter), out);
        } else {
            int[] columns = (mode == Command.transposed ? dataGrid.getVisibleColumns() : selectionModel.getSelectedColumns()).asArray();
            DisplayHtmlValuesExtractor extractor = new DisplayHtmlValuesExtractor(DocumentationComponent.COLOR_KEY.getDefaultColor(), converter);
            extractor.setTransposedMode(mode == Command.transposed);
            extractor.setIncludeRowNumbers(mode == Command.transposed);
            DataGridDocumentationProvider.appendHyperLinkCommand(out.getDelegate(), mode == Command.transposed ? Command.regular : Command.transposed, null).append("<br><br>");
            Dbms dbms = DataGridUtil.getDbms(dataGrid);
            List<DataConsumer.Column> allColumns = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumns();
            List<DataConsumer.Row> selectedRows = DataGridUtil.getSelectedRows(dataGrid);
            ExtractorsUtil.extract(out, dbms, false, allColumns, extractor, selectedRows, columns);
        }
        String result2 = DataGridDocumentationProvider.buildAndRunQueries(dataGrid, sb);
        String string = (result2 == null ? sb : sb.append(result2)).append("<br><br><br>").toString();
        if (string == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(36);
        }
        return string;
    }

    @Nullable
    public Image getLocalImageForElement(@NotNull PsiElement element2, @NotNull String imageSpec) {
        if (element2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(37);
        }
        if (imageSpec == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(38);
        }
        return DataGridDocumentationProvider.resolveImageRef(imageSpec);
    }

    @Nullable
    public String generateDoc(PsiElement element2, @Nullable PsiElement originalElement) {
        DataGridPomTarget.Cell cell = DataGridPomTarget.unwrapCell(element2);
        if (cell != null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)element2.getProject());
            Command command = Command.getCommand(propertiesComponent.getValue(VIEW_MODE_PROPERTY), Command.regular);
            return DataGridDocumentationProvider.getCellDocumentation(cell.dataGrid, command);
        }
        DataGrid dataGrid = DataGridPomTarget.unwrapDataGrid(element2);
        if (DataGridUtil.getQueryText(dataGrid) != null) {
            return DataGridDocumentationProvider.getGridDocumentation(element2.getProject(), dataGrid);
        }
        return null;
    }

    @Nullable
    private static String getGridDocumentation(Project project, @NotNull DataGrid dataGrid) {
        String queryText;
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(39);
        }
        if ((queryText = DataGridUtil.getQueryText(dataGrid)) == null) {
            return null;
        }
        GridPagingModel pageModel = dataGrid.getDataHookup().getPageModel();
        String curCount = pageModel.getTotalRowCount() + (!pageModel.isTotalRowCountPrecise() ? "+" : "");
        return "<b>rows:</b> " + curCount + (pageModel.isTotalRowCountUpdateable() ? DataGridDocumentationProvider.getCountCommand(pageModel.isTotalRowCountPrecise()) : "") + "<br><br><pre><code>" + DbSqlUtil.sql2Html(project, (Language)DataGridUtil.getSqlDialect(dataGrid), queryText) + "</code></pre>";
    }

    public boolean handleExternal(PsiElement element2, PsiElement originalElement) {
        return false;
    }

    public boolean handleExternalLink(PsiManager psiManager, String link, PsiElement context) {
        return false;
    }

    public boolean canFetchDocumentationLink(String link) {
        return link.startsWith(URL_PREFIX);
    }

    @Nullable
    public String extractRefFromLink(@NotNull String link) {
        if (link == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(40);
        }
        return link.endsWith(Command.count.name()) ? "$keepScrollingPosition$" : null;
    }

    @NotNull
    public String fetchExternalDocumentation(@NotNull String link, @Nullable PsiElement element2) {
        if (link == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(41);
        }
        if (element2 == null) {
            if ("" == null) {
                DataGridDocumentationProvider.$$$reportNull$$$0(42);
            }
            return "";
        }
        int paramStart = link.indexOf(63);
        String substring = link.substring(URL_PREFIX.length() + 1, paramStart == -1 ? link.length() : paramStart);
        Command command = Command.getCommand(substring, null);
        Project project = element2.getProject();
        if (command == Command.count) {
            int queryIdx;
            Long rowCount = DataGridDocumentationProvider.getUpdatedRowCount(project, element2);
            if (rowCount == null || !project.isOpen()) {
                if ("" == null) {
                    DataGridDocumentationProvider.$$$reportNull$$$0(43);
                }
                return "";
            }
            DocumentationComponent component = QuickDocUtil.getActiveDocComponent((Project)project);
            String text2 = component == null ? null : component.getText();
            int n = queryIdx = text2 == null ? -1 : text2.indexOf(link);
            if (queryIdx < 0) {
                if ("" == null) {
                    DataGridDocumentationProvider.$$$reportNull$$$0(44);
                }
                return "";
            }
            int idx0 = text2.lastIndexOf("</b>", queryIdx) + "</b>".length() + 1;
            int idx1 = text2.indexOf("</a>", queryIdx + link.length()) + "</a>".length();
            if (idx0 < 0 || idx1 < 0) {
                if ("" == null) {
                    DataGridDocumentationProvider.$$$reportNull$$$0(45);
                }
                return "";
            }
            String string = text2.substring(0, idx0) + rowCount.toString() + DataGridDocumentationProvider.getCountCommand(true) + text2.substring(idx1);
            if (string == null) {
                DataGridDocumentationProvider.$$$reportNull$$$0(46);
            }
            return string;
        }
        if (command == Command.transposed || command == Command.regular) {
            PropertiesComponent.getInstance((Project)project).setValue(VIEW_MODE_PROPERTY, command.name());
        }
        String string = DataGridDocumentationProvider.getCellDocumentation((DataGrid)ObjectUtils.assertNotNull((Object)DataGridPomTarget.unwrapDataGrid(element2)), command);
        if (string == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(47);
        }
        return string;
    }

    public boolean canHandleExternal(@Nullable PsiElement element2, @Nullable PsiElement originalElement) {
        return false;
    }

    @Nullable
    private static Long getUpdatedRowCount(@NotNull Project project, @Nullable PsiElement element2) {
        AsyncFutureResult<Long> rowCountResult;
        if (project == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(48);
        }
        if (element2 instanceof DbTable) {
            VirtualFile file = ((DbTable)element2).getVirtualFile();
            if (file == null) {
                return null;
            }
            final Disposable disposable = Disposer.newDisposable();
            Disposer.register((Disposable)project, (Disposable)disposable);
            GridDataHookUp hookUp = (GridDataHookUp)UIUtil.invokeAndWaitIfNeeded(() -> GridDataHookUpManager.getInstance(project).getOrCreateLightweight(file, disposable, DGDepartment.QUICK_DOCUMENTATION));
            rowCountResult = CountRowsAction.countRows(hookUp);
            rowCountResult.addConsumer(SameThreadExecutor.INSTANCE, (ResultConsumer)new ResultConsumer<Long>(){

                public void onSuccess(Long value) {
                    Disposer.dispose((Disposable)disposable);
                }

                public void onFailure(@NotNull Throwable t) {
                    if (t == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    Disposer.dispose((Disposable)disposable);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/database/run/ui/DataGridDocumentationProvider$4", "onFailure"));
                }
            });
        } else {
            DataGrid grid = DataGridPomTarget.unwrapDataGrid(element2);
            if (grid == null) {
                return null;
            }
            rowCountResult = CountRowsAction.countRows(grid);
        }
        try {
            return (Long)rowCountResult.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getCountCommand(boolean refresh) {
        return "&nbsp&nbsp<a href=\"db-doc:///" + Command.count.name() + "\">click to " + (refresh ? "refresh" : "count(*)") + "</a>";
    }

    @NotNull
    private static CharOut appendHyperLinkCommand(@NotNull CharOut sb, @NotNull Command command, @Nullable String text2) {
        if (sb == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(49);
        }
        if (command == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(50);
        }
        CharOut charOut = sb.append("<a href=\"db-doc:///" + command.name() + "\">" + StringUtil.capitalize((String)StringUtil.notNullize((String)text2, (String)(command.name() + " View"))) + "</a>");
        if (charOut == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(51);
        }
        return charOut;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSpec";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/DataGridDocumentationProvider";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 20: 
            case 26: 
            case 32: 
            case 34: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 4: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseTable";
                break;
            }
            case 8: 
            case 14: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRow";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyTypes";
                break;
            }
            case 10: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queries";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 15: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedColumns";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newQueryInfo";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/DataGridDocumentationProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createImageRefTag";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellDocumentation";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchExternalDocumentation";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "appendHyperLinkCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveImageRef";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createImageRefTag";
                break;
            }
            case 2: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildAndRunQueries";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasNavigatableKeys";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildQueries";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectForeignKeyQueries";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectExportedKeyQueries";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectQuery";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "tryCollectValues";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getQuickDocFooter";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setHint";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getCellDocumentation";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getLocalImageForElement";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getGridDocumentation";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "extractRefFromLink";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "fetchExternalDocumentation";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedRowCount";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "appendHyperLinkCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class QueryInfo {
        public final String query;
        public final DasTable table;
        public final boolean exported;
        public final String[] columnNames;
        public final Object[] values;
        public String keysAndColumns = "";

        QueryInfo(String query, DasTable table, boolean exported, String[] columnNames, Object[] values2) {
            this.query = query;
            this.table = table;
            this.exported = exported;
            this.columnNames = columnNames;
            this.values = values2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryInfo info = (QueryInfo)o;
            return this.query.equals(info.query);
        }

        public int hashCode() {
            return this.query.hashCode();
        }
    }

    public static class State {
        final List<QueryInfo> queries;
        final ModelIndex<DataConsumer.Row> row;
        final String current;
        final long timestamp = System.currentTimeMillis();

        public State(List<QueryInfo> queries, ModelIndex<DataConsumer.Row> row, String current) {
            this.queries = queries;
            this.row = row;
            this.current = current;
        }
    }

    public static enum KeyType {
        EXPORTED,
        FOREIGN,
        SELECTED;

    }

    private static enum Command {
        transposed,
        regular,
        full,
        count;


        static Command getCommand(String name2, Command def) {
            try {
                return Enum.valueOf(Command.class, name2);
            }
            catch (Exception e) {
                return def;
            }
        }
    }
}

