/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.SchemaApplyHelper;
import com.intellij.database.schemaEditor.SchemaExportHelperImpl;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.editors.DatabaseEditorContext;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaExporters {
    private final SortedSet<Exporter<? extends DeObject, ? extends BasicElement>> myExporters = new TreeSet<Exporter<? extends DeObject, ? extends BasicElement>>((o1, o2) -> {
        boolean de2;
        Class e2;
        Class e1 = o1.getExportableClass();
        if (e1 == (e2 = o2.getExportableClass())) {
            return o1.compareTo(o2);
        }
        boolean de1 = e1.isAssignableFrom(DeObject.class);
        if (de1 != (de2 = e2.isAssignableFrom(DeObject.class))) {
            return de1 ? -1 : 1;
        }
        return e1.isAssignableFrom(e2) ? 1 : -1;
    });

    public void add(Exporter<? extends DeObject, ? extends BasicElement> exporter) {
        this.myExporters.add(exporter);
    }

    @Nullable
    public <Das extends BasicElement> Exporter<? extends DeObject, Das> get(@Nullable Das object) {
        if (object == null) {
            return null;
        }
        for (Exporter exporter : this.myExporters) {
            Exporter tmp;
            if (!exporter.getExportableClass().isAssignableFrom(object.getClass()) || !(tmp = exporter).canExport(object)) continue;
            return tmp;
        }
        return null;
    }

    @Nullable
    public Exporter<? extends DeObject, ? extends BasicElement> getApplier(@Nullable DeObject object) {
        if (object == null) {
            return null;
        }
        Exporter found = null;
        for (Exporter exporter : this.myExporters) {
            if (!exporter.getExportedClass().isAssignableFrom(object.getClass()) || found != null && !found.getExportedClass().isAssignableFrom(exporter.getExportedClass())) continue;
            found = exporter;
        }
        return found;
    }

    public BasicSchemaExportHelper createHelper(@NotNull DatabaseEditorContext context, @Nullable DeModel model) {
        if (context == null) {
            SchemaExporters.$$$reportNull$$$0(0);
        }
        return new BasicSchemaExportHelper(this, context, model);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/SchemaExporters", "createHelper"));
    }

    public static class BasicSchemaExportHelper
    extends SchemaExportHelperImpl<BasicElement> {
        protected final SchemaExporters myExporter;

        private BasicSchemaExportHelper(@NotNull SchemaExporters exporter, @NotNull DatabaseEditorContext context, @Nullable DeModel model) {
            if (exporter == null) {
                BasicSchemaExportHelper.$$$reportNull$$$0(0);
            }
            if (context == null) {
                BasicSchemaExportHelper.$$$reportNull$$$0(1);
            }
            super(context, model);
            this.myExporter = exporter;
        }

        @Override
        public <De extends DeObject> De exportDeep(@Nullable DasModel model, @NotNull BasicElement object, boolean withChildren) {
            DasModel subModel;
            if (object == null) {
                BasicSchemaExportHelper.$$$reportNull$$$0(2);
            }
            BasicElement unexported = (subModel = this.myModel.getDasModel()) != model ? null : object;
            return this.export(unexported, withChildren);
        }

        @Override
        protected SchemaExportHelperImpl.BaseExporter<? extends DeObject, BasicElement, ?> getExporter(@NotNull BasicElement object) {
            if (object == null) {
                BasicSchemaExportHelper.$$$reportNull$$$0(3);
            }
            return this.myExporter.get(object);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exporter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/SchemaExporters$BasicSchemaExportHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exportDeep";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getExporter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static interface Exporter<De extends DeObject, Das extends BasicElement>
    extends SchemaExportHelperImpl.BaseExporter<De, Das, BasicSchemaExportHelper>,
    Comparable<Exporter<?, ?>> {
        @NotNull
        public Class<De> getExportedClass();

        @NotNull
        public Class<Das> getExportableClass();

        public boolean canExport(@NotNull Das var1);

        public void apply(@NotNull SchemaApplyHelper var1, @NotNull De var2, @NotNull Das var3);

        public void applyChildren(@NotNull SchemaApplyHelper var1, @NotNull De var2, @NotNull Das var3);
    }
}

