/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoaderContext {
    private static final Logger LOG = Logger.getInstance(LoaderContext.class);
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private ErrorHandler myErrorHandler;
    private final THashSet<Object> mySelection;
    private ObjectPath mySelectedElement;
    private boolean myNamespacesOnly;
    private boolean myOutdatedCheck;
    private final IntrospectionScopeUpdater myScopeUpdater;
    private DatabaseCredentials myCredentialsStore;

    public static LoaderContext loadAll(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            LoaderContext.$$$reportNull$$$0(1);
        }
        return new LoaderContext(project, dataSource).includeAllSchemas();
    }

    public LoaderContext(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(2);
        }
        if (dataSource == null) {
            LoaderContext.$$$reportNull$$$0(3);
        }
        this.myErrorHandler = new ErrorHandler();
        this.mySelection = new THashSet();
        this.myNamespacesOnly = false;
        this.myOutdatedCheck = false;
        this.myScopeUpdater = new IntrospectionScopeUpdater();
        this.myProject = project;
        this.myDataSource = dataSource;
    }

    @NotNull
    public LoaderContext merge(@NotNull LoaderContext context) {
        if (context == null) {
            LoaderContext.$$$reportNull$$$0(4);
        }
        if (this.myProject != context.myProject || this.myDataSource != context.myDataSource) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error("Merging different contexts");
            } else {
                LOG.warn("Merging different contexts");
            }
        }
        LoaderContext result2 = new LoaderContext(this.myProject, this.myDataSource);
        result2.mySelection.addAll(this.mySelection);
        result2.mySelection.addAll(context.mySelection);
        result2.mySelectedElement = (ObjectPath)ObjectUtils.chooseNotNull((Object)this.mySelectedElement, (Object)context.mySelectedElement);
        result2.myNamespacesOnly = this.myNamespacesOnly && context.myNamespacesOnly;
        result2.myOutdatedCheck = this.myOutdatedCheck && context.myOutdatedCheck;
        result2.myScopeUpdater.addAll(this.myScopeUpdater).addAll(context.myScopeUpdater);
        LoaderContext loaderContext = result2;
        if (loaderContext == null) {
            LoaderContext.$$$reportNull$$$0(5);
        }
        return loaderContext;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            LoaderContext.$$$reportNull$$$0(6);
        }
        return project;
    }

    @NotNull
    public IntrospectionScopeUpdater getScopeUpdater() {
        IntrospectionScopeUpdater introspectionScopeUpdater = this.myScopeUpdater;
        if (introspectionScopeUpdater == null) {
            LoaderContext.$$$reportNull$$$0(7);
        }
        return introspectionScopeUpdater;
    }

    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = this.myDataSource;
        if (localDataSource == null) {
            LoaderContext.$$$reportNull$$$0(8);
        }
        return localDataSource;
    }

    public Dbms getDbms() {
        return this.myDataSource.getDbms();
    }

    public Iterable<Object> getSelection() {
        return this.mySelection;
    }

    public boolean isEverythingSelected() {
        return this.mySelection.contains((Object)"*");
    }

    public boolean hasSelection() {
        return !this.mySelection.isEmpty();
    }

    public LoaderContext setErrorHandler(ErrorHandler handler) {
        this.myErrorHandler = handler;
        return this;
    }

    public LoaderContext setNamespacesOnly(boolean namespacesOnly) {
        this.myNamespacesOnly = namespacesOnly;
        return this;
    }

    public boolean isSchemaListOnly() {
        return this.myNamespacesOnly;
    }

    public LoaderContext setOutdatedCheck(boolean outdatedCheck) {
        this.myOutdatedCheck = outdatedCheck;
        return this;
    }

    public boolean isOutdatedCheck() {
        return this.myOutdatedCheck;
    }

    public LoaderContext include(@Nullable ObjectPath o) {
        if (o != null) {
            this.mySelection.add((Object)LoaderContext.getScope(JdbcUrlParserUtil.getObjectItem(o, ObjectKind.DATABASE), JdbcUrlParserUtil.getObjectItem(o, ObjectKind.SCHEMA)));
        }
        return this;
    }

    public LoaderContext include(@Nullable BasicElement o) {
        if (o == null) {
            return this;
        }
        this.mySelection.add((Object)o);
        return this;
    }

    public LoaderContext include(@Nullable DbElement o) {
        if (o == null) {
            return this;
        }
        this.mySelection.add(o.getDelegate());
        return this;
    }

    public LoaderContext include(@Nullable TreePattern o) {
        if (o == null) {
            return this;
        }
        this.mySelection.add((Object)TreePatternUtils.exportScope(DbImplUtil.getMetaModel(this.getDbms()), o));
        return this;
    }

    public LoaderContext include(@Nullable DasObject o) {
        if (o == null) {
            return this;
        }
        if (o instanceof DbElement) {
            this.include((DbElement)o);
        } else {
            this.mySelection.add((Object)o);
        }
        return this;
    }

    public LoaderContext withCredentials(@Nullable DatabaseCredentials credentialsStore) {
        this.myCredentialsStore = credentialsStore;
        return this;
    }

    @Nullable
    public DatabaseCredentials getCredentialsStore() {
        return this.myCredentialsStore;
    }

    public LoaderContext includeAllSchemas() {
        this.mySelection.add((Object)"*");
        return this;
    }

    public boolean loadNothing() {
        return this.mySelection.isEmpty() && !this.myNamespacesOnly;
    }

    public ErrorHandler getErrorHandler() {
        return this.myErrorHandler;
    }

    public ObjectPath getElementToFocus() {
        return this.mySelectedElement;
    }

    public void setElementToFocus(@Nullable ObjectPath selectedElement) {
        this.mySelectedElement = selectedElement;
    }

    @NotNull
    public static String getScope(@Nullable String catalog, @Nullable String schema) {
        if (StringUtil.isNotEmpty((String)catalog)) {
            if (StringUtil.isNotEmpty((String)schema)) {
                String string = catalog + ":" + schema;
                if (string == null) {
                    LoaderContext.$$$reportNull$$$0(9);
                }
                return string;
            }
            String string = catalog + ":*";
            if (string == null) {
                LoaderContext.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (StringUtil.isNotEmpty((String)schema)) {
            String string = "*:" + schema;
            if (string == null) {
                LoaderContext.$$$reportNull$$$0(11);
            }
            return string;
        }
        if ("*" == null) {
            LoaderContext.$$$reportNull$$$0(12);
        }
        return "*";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/LoaderContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/LoaderContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeUpdater";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadAll";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

