/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.db2;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ObjectKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.db2.Db2ElementTypes;
import com.intellij.sql.dialects.db2.Db2LUWDialect;
import com.intellij.sql.dialects.db2.Db2OptionalKeywords;
import com.intellij.sql.dialects.db2.Db2Tokens;
import com.intellij.sql.dialects.db2.Db2Types;
import com.intellij.sql.dialects.db2.refactoring.Db2ExtractFunctionHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Db2DialectBase
extends SqlLanguageDialectEx {
    public Db2DialectBase(String id) {
        super(id);
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            Db2DialectBase.$$$reportNull$$$0(0);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            Db2DialectBase.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            Db2DialectBase.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            Db2DialectBase.$$$reportNull$$$0(3);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable PsiElement element2, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            Db2DialectBase.$$$reportNull$$$0(4);
        }
        if (element2 instanceof SqlFileImpl.FakeDefinition && type == ObjectKind.OBJECT_TYPE && expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        return super.isResolveTargetAccepted(element2, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            Db2DialectBase.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element2 == null) {
            Db2DialectBase.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            Db2DialectBase.$$$reportNull$$$0(7);
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_PREVVAL.name, resolve) && SqlImplUtil.getQualifierKind(element2) == ObjectKind.SEQUENCE && !processor.executeTarget(LazyData.RE_PREVVAL, element2, this.integerType(), false, ResolveState.initial())) {
            return false;
        }
        return super.processReservedEntitiesWithType(name2, element2, resolve, processor);
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            Db2DialectBase.$$$reportNull$$$0(8);
        }
        switch (cat) {
            case INTEGER: {
                return "int";
            }
            case REAL: {
                return "decimal";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "date";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "int";
            }
            case BYTES: {
                return "blob";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            Db2DialectBase.$$$reportNull$$$0(9);
        }
        if ((name2 = super.getNormalizedTypeName(name2)).equals("INT")) {
            if ("INTEGER" == null) {
                Db2DialectBase.$$$reportNull$$$0(10);
            }
            return "INTEGER";
        }
        if (name2.equals("DEC")) {
            if ("DECIMAL" == null) {
                Db2DialectBase.$$$reportNull$$$0(11);
            }
            return "DECIMAL";
        }
        if (name2.equals("NUMERIC")) {
            if ("DECIMAL" == null) {
                Db2DialectBase.$$$reportNull$$$0(12);
            }
            return "DECIMAL";
        }
        if (name2.equals("NUM")) {
            if ("DECIMAL" == null) {
                Db2DialectBase.$$$reportNull$$$0(13);
            }
            return "DECIMAL";
        }
        if (name2.equals("FLOAT")) {
            if ("DOUBLE" == null) {
                Db2DialectBase.$$$reportNull$$$0(14);
            }
            return "DOUBLE";
        }
        if (name2.equals("DOUBLE PRECISION")) {
            if ("DOUBLE" == null) {
                Db2DialectBase.$$$reportNull$$$0(15);
            }
            return "DOUBLE";
        }
        if (name2.equals("CHARACTER")) {
            if ("CHAR" == null) {
                Db2DialectBase.$$$reportNull$$$0(16);
            }
            return "CHAR";
        }
        if (name2.equals("CHAR LARGE OBJECT")) {
            if ("CLOB" == null) {
                Db2DialectBase.$$$reportNull$$$0(17);
            }
            return "CLOB";
        }
        if (name2.equals("CHARACTER LARGE OBJECT")) {
            if ("CLOB" == null) {
                Db2DialectBase.$$$reportNull$$$0(18);
            }
            return "CLOB";
        }
        if (name2.equals("CHAR VARYING")) {
            if ("VARCHAR" == null) {
                Db2DialectBase.$$$reportNull$$$0(19);
            }
            return "VARCHAR";
        }
        if (name2.equals("CHARACTER VARYING")) {
            if ("VARCHAR" == null) {
                Db2DialectBase.$$$reportNull$$$0(20);
            }
            return "VARCHAR";
        }
        if (name2.equals("NCHAR")) {
            if ("GRAPHIC" == null) {
                Db2DialectBase.$$$reportNull$$$0(21);
            }
            return "GRAPHIC";
        }
        if (name2.equals("NATIONAL CHAR")) {
            if ("GRAPHIC" == null) {
                Db2DialectBase.$$$reportNull$$$0(22);
            }
            return "GRAPHIC";
        }
        if (name2.equals("NATIONAL CHARACTER")) {
            if ("GRAPHIC" == null) {
                Db2DialectBase.$$$reportNull$$$0(23);
            }
            return "GRAPHIC";
        }
        if (name2.equals("NVARCHAR")) {
            if ("VARGRAPHIC" == null) {
                Db2DialectBase.$$$reportNull$$$0(24);
            }
            return "VARGRAPHIC";
        }
        if (name2.equals("NATIONAL CHAR VARYING")) {
            if ("VARGRAPHIC" == null) {
                Db2DialectBase.$$$reportNull$$$0(25);
            }
            return "VARGRAPHIC";
        }
        if (name2.equals("NATIONAL CHARACTER VARYING")) {
            if ("VARGRAPHIC" == null) {
                Db2DialectBase.$$$reportNull$$$0(26);
            }
            return "VARGRAPHIC";
        }
        if (name2.equals("NCLOB")) {
            if ("DBCLOB" == null) {
                Db2DialectBase.$$$reportNull$$$0(27);
            }
            return "DBCLOB";
        }
        if (name2.equals("BINARY LARGE OBJECT")) {
            if ("BLOB" == null) {
                Db2DialectBase.$$$reportNull$$$0(28);
            }
            return "BLOB";
        }
        String string = name2;
        if (string == null) {
            Db2DialectBase.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            Db2DialectBase.$$$reportNull$$$0(30);
        }
        if ("GRAPHIC".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                Db2DialectBase.$$$reportNull$$$0(31);
            }
            return category;
        }
        if ("VARGRAPHIC".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                Db2DialectBase.$$$reportNull$$$0(32);
            }
            return category;
        }
        if ("DBCLOB".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                Db2DialectBase.$$$reportNull$$$0(33);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            Db2DialectBase.$$$reportNull$$$0(34);
        }
        return category;
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        super.getParentDbTypes(result2, type);
        if (type == ObjectKind.ROUTINE || type == ObjectKind.METHOD) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return result2;
    }

    private static boolean isMethodReference(PsiElement element2) {
        if (!(element2 instanceof SqlReferenceExpression)) {
            return false;
        }
        for (PsiElement child : element2.getChildren()) {
            if (PsiUtilCore.getElementType((PsiElement)child) != Db2Types.DB2_DOUBLE_DOT) continue;
            return true;
        }
        return false;
    }

    public boolean isResolveTargetNotAccepted(@Nullable Object element2, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            Db2DialectBase.$$$reportNull$$$0(35);
        }
        if (type == ObjectKind.ROUTINE && element2 instanceof DasRoutine && ((DasRoutine)element2).getDasParent() instanceof DasUserDefinedType && !Db2DialectBase.isMethodReference(place)) {
            return true;
        }
        return super.isResolveTargetNotAccepted(element2, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return Db2ExtractFunctionHelper.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 30: 
            case 35: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 30: 
            case 35: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/db2/Db2DialectBase";
                break;
            }
            case 4: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 30: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/db2/Db2DialectBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetNotAccepted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 30: 
            case 35: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final Db2DialectBase INSTANCE = Db2LUWDialect.INSTANCE;
        static final ReservedEntity RE_PREVVAL = new ReservedEntity("prevval", ObjectKind.COLUMN);
        static final TokenClasses ourClasses = new TokenClasses(Db2Tokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;
        private static final EnterHandlerDelegate ENTER_HANDLER;
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_OP_CONCAT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_BITWISE_NOT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT_LT, SqlElementTypes.SQL_OP_NOT_GT, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_PLUS_EQ, SqlElementTypes.SQL_OP_MINUS_EQ, SqlElementTypes.SQL_OP_MUL_EQ, SqlElementTypes.SQL_OP_DIV_EQ, SqlElementTypes.SQL_OP_MODULO_EQ, SqlElementTypes.SQL_OP_BITWISE_AND_EQ, SqlElementTypes.SQL_OP_BITWISE_OR_EQ, SqlElementTypes.SQL_OP_BITWISE_XOR_EQ, Db2OptionalKeywords.DB2_CONCAT, SqlElementTypes.SQL_LEFT_BRACKET});
            ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_DO, SqlElementTypes.SQL_FOR_LOOP_STATEMENT}, "", "end for;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_FOR, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_ATOMIC, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_STATIC, Db2Types.DB2_SQL_EMBEDDED_STATEMENT}, "", "end compound;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, Db2Types.DB2_COMPOUND, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false)), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_STATEMENTS, Db2Types.DB2_SQL_EMBEDDED_STATEMENT}, "", "end compound;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, Db2Types.DB2_COMPOUND, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_LOOP, SqlElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_LOOP, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_REPEAT, SqlElementTypes.SQL_REPEAT_LOOP_STATEMENT}, "", "until  end repeat;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_REPEAT, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{Db2Types.DB2_DO, SqlElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end while;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, Db2Types.DB2_WHILE, SqlElementTypes.SQL_LABEL_BACK_REFERENCE, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_THEN, SqlElementTypes.SQL_THEN_CLAUSE, SqlElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_IF, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false))));
            MAJOR_CHILD_KINDS = Arrays.asList(ObjectKind.TRIGGER, ObjectKind.INDEX, Db2ElementTypes.Kinds.MASK, Db2ElementTypes.Kinds.PERMISSION);
        }
    }
}

